/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor.profiler;

import com.rapidminer.gui.processeditor.profiler.data.ProfilerData;
import com.rapidminer.gui.processeditor.profiler.data.ProfilerDataManager;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.I18N;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OperatorProfilePanel
extends JPanel {
    private JLabel label_operatorIcon;
    private JLabel label_operatorName;
    private JLabel label_operatorRunCountDescription;
    private JLabel label_operatorAverageTimeRunningDescription;
    private JLabel label_operatorLastTimeRunningDescription;
    private JLabel label_operatorAverageCpuTimeRunningDescription;
    private JLabel label_operatorLastCpuTimeRunningDescription;
    private JLabel label_operatorRunCountValue;
    private JLabel label_operatorAverageTimeRunningValue;
    private JLabel label_operatorLastTimeRunningValue;
    private JLabel label_operatorAverageCpuTimeRunningValue;
    private JLabel label_operatorLastCpuTimeRunningValue;
    private JLabel label_operatorCpuResourceConsumptionEstimationDescription;
    private JLabel label_operatorCpuResourceConsumptionEstimationValue;
    private JLabel label_operatorMemoryResourceConsumptionEstimationDescription;
    private JLabel label_operatorMemoryResourceConsumptionEstimationValue;
    private static final long serialVersionUID = 8830933821400357100L;

    public OperatorProfilePanel(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException("operator must not be null!");
        }
        this.label_operatorName = new JLabel();
        this.label_operatorIcon = new JLabel();
        this.label_operatorRunCountDescription = new JLabel();
        this.label_operatorLastTimeRunningDescription = new JLabel();
        this.label_operatorAverageTimeRunningDescription = new JLabel();
        this.label_operatorAverageCpuTimeRunningDescription = new JLabel();
        this.label_operatorLastCpuTimeRunningDescription = new JLabel();
        this.label_operatorRunCountValue = new JLabel();
        this.label_operatorLastTimeRunningValue = new JLabel();
        this.label_operatorAverageTimeRunningValue = new JLabel();
        this.label_operatorAverageCpuTimeRunningValue = new JLabel();
        this.label_operatorLastCpuTimeRunningValue = new JLabel();
        this.label_operatorCpuResourceConsumptionEstimationDescription = new JLabel();
        this.label_operatorCpuResourceConsumptionEstimationValue = new JLabel();
        this.label_operatorMemoryResourceConsumptionEstimationDescription = new JLabel();
        this.label_operatorMemoryResourceConsumptionEstimationValue = new JLabel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        ProfilerData data = !ProfilerDataManager.getInstance().isOperatorDataAvailable(operator.getName()) ? ProfilerDataManager.getInstance().addOperatorData(operator.getProcess(), operator.getName(), new ProfilerData()) : ProfilerDataManager.getInstance().getOperatorData(operator.getName());
        DecimalFormat formatter = new DecimalFormat("#.##");
        this.label_operatorName.setText("<html><b>" + operator.getName() + "</b></html>");
        this.label_operatorIcon.setIcon(operator.getOperatorDescription().getIcon());
        this.label_operatorRunCountDescription.setText(I18N.getMessage(I18N.getGUIBundle(), "gui.label.profiler_operator_panel.run_count.text", new Object[0]));
        String runValue = String.valueOf(data.getRunCount());
        this.label_operatorRunCountValue.setText(runValue);
        this.label_operatorLastTimeRunningDescription.setText(I18N.getMessage(I18N.getGUIBundle(), "gui.label.profiler_operator_panel.last_exec_real.text", new Object[0]));
        String lastTimeRunningValue = data.hasRun() ? (data.getLastRunTimeReal() < 1000.0 ? (data.getLastRunTimeReal() == 0.0 ? "<1ms" : String.valueOf(formatter.format(data.getLastRunTimeReal()) + "ms")) : (data.getLastRunTimeReal() < 600000.0 ? String.valueOf(formatter.format(data.getLastRunTimeReal() / 1000.0) + "s") : String.valueOf(formatter.format(data.getLastRunTimeReal() / 60000.0) + "min"))) : "-";
        this.label_operatorLastTimeRunningValue.setText(lastTimeRunningValue);
        this.label_operatorAverageTimeRunningDescription.setText(I18N.getMessage(I18N.getGUIBundle(), "gui.label.profiler_operator_panel.average_exec_real.text", new Object[0]));
        String averageTimeRunningValue = data.hasRun() ? (data.getAverageRunTimeReal() < 1000.0 ? (data.getAverageRunTimeReal() == 0.0 ? "<1ms" : String.valueOf(formatter.format(data.getAverageRunTimeReal()) + "ms")) : (data.getAverageRunTimeReal() < 600000.0 ? String.valueOf(formatter.format(data.getAverageRunTimeReal() / 1000.0) + "s") : String.valueOf(formatter.format(data.getAverageRunTimeReal() / 60000.0) + "min"))) : "-";
        this.label_operatorAverageTimeRunningValue.setText(averageTimeRunningValue);
        this.label_operatorLastCpuTimeRunningDescription.setText(I18N.getMessage(I18N.getGUIBundle(), "gui.label.profiler_operator_panel.last_exec_cpu.text", new Object[0]));
        String lastCpuTimeRunningValue = data.hasRun() ? (data.getLastRunTimeCpu() < 1000.0 ? (data.getLastRunTimeCpu() == 0.0 ? "<1ns" : String.valueOf(formatter.format(data.getLastRunTimeCpu()) + "ns")) : (data.getLastRunTimeCpu() < 1000000.0 ? String.valueOf(formatter.format(data.getLastRunTimeCpu() / 1000.0) + "\ufffds") : (data.getLastRunTimeCpu() < 1.0E9 ? String.valueOf(formatter.format(data.getLastRunTimeCpu() / 1000000.0) + "ms") : (data.getLastRunTimeCpu() < (double)Long.parseLong("600000000000") ? String.valueOf(formatter.format(data.getLastRunTimeCpu() / 1.0E9) + "s") : String.valueOf(formatter.format(data.getLastRunTimeCpu() / Double.parseDouble("60000000000")) + "min"))))) : "-";
        this.label_operatorLastCpuTimeRunningValue.setText(lastCpuTimeRunningValue);
        this.label_operatorAverageCpuTimeRunningDescription.setText(I18N.getMessage(I18N.getGUIBundle(), "gui.label.profiler_operator_panel.average_exec_cpu.text", new Object[0]));
        String averageCpuTimeRunningValue = data.hasRun() ? (data.getAverageRunTimeCpu() < 1000.0 ? (data.getAverageRunTimeCpu() == 0.0 ? "<1ns" : String.valueOf(formatter.format(data.getAverageRunTimeCpu()) + "ns")) : (data.getAverageRunTimeCpu() < 1000000.0 ? String.valueOf(formatter.format(data.getAverageRunTimeCpu() / 1000.0) + "\ufffds") : (data.getAverageRunTimeCpu() < 1.0E9 ? String.valueOf(formatter.format(data.getAverageRunTimeCpu() / 1000000.0) + "ms") : (data.getAverageRunTimeCpu() < Double.parseDouble("600000000000") ? String.valueOf(formatter.format(data.getAverageRunTimeCpu() / 1.0E9) + "s") : String.valueOf(formatter.format(data.getAverageRunTimeCpu() / Double.parseDouble("60000000000")) + "min"))))) : "-";
        this.label_operatorAverageCpuTimeRunningValue.setText(averageCpuTimeRunningValue);
        this.label_operatorCpuResourceConsumptionEstimationDescription.setText(I18N.getMessage(I18N.getGUIBundle(), "gui.label.profiler_operator_panel.resource_consumption_cpu.text", new Object[0]));
        if (operator.getResourceConsumptionEstimator() == null) {
            this.label_operatorCpuResourceConsumptionEstimationValue.setText(I18N.getMessage(I18N.getGUIBundle(), "gui.label.profiler_operator_panel.resource_consumption.text_null", new Object[0]));
        } else {
            this.label_operatorCpuResourceConsumptionEstimationValue.setText("" + operator.getResourceConsumptionEstimator().getCpuFunction());
        }
        this.label_operatorMemoryResourceConsumptionEstimationDescription.setText(I18N.getMessage(I18N.getGUIBundle(), "gui.label.profiler_operator_panel.resource_consumption_memory.text", new Object[0]));
        if (operator.getResourceConsumptionEstimator() == null) {
            this.label_operatorMemoryResourceConsumptionEstimationValue.setText(I18N.getMessage(I18N.getGUIBundle(), "gui.label.profiler_operator_panel.resource_consumption.text_null", new Object[0]));
        } else {
            this.label_operatorMemoryResourceConsumptionEstimationValue.setText("" + operator.getResourceConsumptionEstimator().getMemoryFunction());
        }
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 2;
        this.label_operatorName.setFont(this.label_operatorName.getFont().deriveFont(this.label_operatorName.getFont().getStyle() ^ 1));
        this.add((Component)this.label_operatorName, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        this.add((Component)this.label_operatorIcon, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.gridwidth = 2;
        gbc.ipadx = 2;
        gbc.ipady = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.label_operatorCpuResourceConsumptionEstimationDescription, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.add((Component)this.label_operatorMemoryResourceConsumptionEstimationDescription, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.add((Component)this.label_operatorRunCountDescription, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        this.add((Component)this.label_operatorLastTimeRunningDescription, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        this.add((Component)this.label_operatorLastCpuTimeRunningDescription, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        this.add((Component)this.label_operatorAverageTimeRunningDescription, gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        this.add((Component)this.label_operatorAverageCpuTimeRunningDescription, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        this.add((Component)this.label_operatorCpuResourceConsumptionEstimationValue, gbc);
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.add((Component)this.label_operatorMemoryResourceConsumptionEstimationValue, gbc);
        gbc.gridx = 2;
        gbc.gridy = 3;
        this.add((Component)this.label_operatorRunCountValue, gbc);
        gbc.gridx = 2;
        gbc.gridy = 4;
        this.add((Component)this.label_operatorLastTimeRunningValue, gbc);
        gbc.gridx = 2;
        gbc.gridy = 5;
        this.add((Component)this.label_operatorLastCpuTimeRunningValue, gbc);
        gbc.gridx = 2;
        gbc.gridy = 6;
        this.add((Component)this.label_operatorAverageTimeRunningValue, gbc);
        gbc.gridx = 2;
        gbc.gridy = 7;
        this.add((Component)this.label_operatorAverageCpuTimeRunningValue, gbc);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }
}

