/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.Process;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceActionTransmitter;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.XMLException;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;
import org.fife.ui.rtextarea.RTextScrollPane;

public class XMLEditor
extends JPanel
implements ProcessEditor,
Dockable {
    private static final long serialVersionUID = 4172143138689034659L;
    private final RSyntaxTextArea editor;
    private final MainFrame mainFrame;
    public static final String XML_EDITOR_DOCK_KEY = "xml_editor";
    private final DockKey DOCK_KEY = new ResourceDockKey("xml_editor");

    public XMLEditor(MainFrame mainFrame) {
        super(new BorderLayout());
        this.DOCK_KEY.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
        this.mainFrame = mainFrame;
        this.editor = new RSyntaxTextArea(new RSyntaxDocument("text/xml"));
        this.editor.setAnimateBracketMatching(true);
        this.editor.setAutoIndentEnabled(true);
        this.editor.setBorder(null);
        ExtendedJToolBar toolBar = new ExtendedJToolBar();
        toolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        toolBar.add(new ResourceAction(true, "xml_editor.apply_changes", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    XMLEditor.this.validateProcess();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (XMLException e1) {
                    e1.printStackTrace();
                }
            }
        });
        toolBar.addSeparator();
        toolBar.add(new ResourceActionTransmitter(true, "editor.copy", (Action)new RTextAreaEditorKit.CopyAction(), this, new Object[0]));
        toolBar.add(new ResourceActionTransmitter(true, "editor.cut", (Action)new RTextAreaEditorKit.CutAction(), this, new Object[0]));
        toolBar.add(new ResourceActionTransmitter(true, "editor.paste", (Action)new RTextAreaEditorKit.PasteAction(), this, new Object[0]));
        toolBar.addSeparator();
        this.add((Component)toolBar, "North");
        this.add((Component)new RTextScrollPane((RTextArea)this.editor), "Center");
    }

    public void setText(String text) {
        this.editor.setText(text);
    }

    @Override
    public void processUpdated(Process process) {
        this.setText(process.getRootOperator().getXML(true));
    }

    @Override
    public void processChanged(Process process) {
        this.processUpdated(process);
    }

    @Override
    public void setSelection(List<Operator> selection) {
        if (!selection.isEmpty()) {
            Operator currentOperator = selection.get(0);
            this.editor.requestFocus();
            this.editor.setCaretPosition(0);
            String name = currentOperator.getName();
            String text = this.editor.getText();
            int result = text.indexOf("\"" + name + "\"");
            if (result >= 0) {
                this.editor.select(result + 1, result + name.length() + 1);
            }
        }
    }

    public synchronized void validateProcess() throws IOException, XMLException {
        Process newExp = new Process(this.editor.getText());
        if (!newExp.getRootOperator().getXML(true).equals(RapidMinerGUI.getMainFrame().getProcess().getRootOperator().getXML(true))) {
            Process old = RapidMinerGUI.getMainFrame().getProcess();
            newExp.setProcessLocation(old.getProcessLocation());
            this.mainFrame.setProcess(newExp, true);
        }
    }

    public String getXMLFromEditor() {
        return this.editor.getText();
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }
}

