/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.ProcessContext;
import com.rapidminer.gui.properties.celleditors.value.RepositoryLocationValueCellEditor;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.ViewToolBar;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class RepositoryLocationsEditor<T extends Ports>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final String prefix;
    private final RepositoryLocationTableModel model;
    private final JTable table;
    private transient Observer<Port> portObserver = new Observer<Port>(){

        @Override
        public void update(Observable<Port> observable, Port arg) {
            RepositoryLocationsEditor.this.adaptModelToPorts();
        }
    };
    private T ports;

    RepositoryLocationsEditor(boolean input, String i18nKey, String prefix) {
        this.prefix = prefix;
        this.model = new RepositoryLocationTableModel(input);
        this.table = new RepositoryLocationTable(this.model);
        this.setLayout(new BorderLayout());
        ExtendedJScrollPane tablePane = new ExtendedJScrollPane(this.table);
        tablePane.getViewport().setBackground(Color.WHITE);
        this.add((Component)tablePane, "Center");
        ResourceLabel label = new ResourceLabel(i18nKey, new Object[0]);
        label.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        ViewToolBar toolBar = new ViewToolBar();
        toolBar.add(label);
        toolBar.add(new ResourceAction(true, i18nKey + ".add_row", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryLocationsEditor.this.model.add();
            }
        }, 1);
        toolBar.add(new ResourceAction(true, i18nKey + ".delete_row", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = RepositoryLocationsEditor.this.table.getSelectedRows();
                for (int i = selected.length - 1; i >= 0; --i) {
                    RepositoryLocationsEditor.this.model.remove(selected[i]);
                }
            }
        }, 1);
        toolBar.setBorder(null);
        this.add((Component)toolBar, "North");
    }

    private RepositoryLocationValueCellEditor createEditor(int index) {
        return new RepositoryLocationValueCellEditor(new ParameterTypeRepositoryLocation(this.prefix + " " + (index + 1), this.prefix + " " + (index + 1), true));
    }

    void setData(ProcessContext context, T ports) {
        if (this.ports != null) {
            this.ports.removeObserver(this.portObserver);
        }
        this.ports = ports;
        if (this.ports != null) {
            this.ports.addObserver(this.portObserver, true);
        }
        this.model.setContext(context);
        this.adaptModelToPorts();
    }

    private void adaptModelToPorts() {
        while (this.model.getRowCount() < this.ports.getNumberOfPorts()) {
            this.model.add("");
        }
        for (int i = this.model.getRowCount() - 1; i >= this.ports.getNumberOfPorts(); --i) {
            String loc = (String)this.model.getLocations().get(i);
            if (loc != null && !loc.isEmpty()) continue;
            this.model.remove(i);
        }
    }

    private class RepositoryLocationTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final boolean input;
        private ProcessContext context;
        private Observer<ProcessContext> contextObserver = new Observer<ProcessContext>(){

            @Override
            public void update(Observable<ProcessContext> observable, ProcessContext arg) {
                RepositoryLocationTableModel.this.fireTableStructureChanged();
            }
        };

        private RepositoryLocationTableModel(boolean input) {
            this.input = input;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.context == null) {
                return 0;
            }
            return this.getLocations().size();
        }

        private List<String> getLocations() {
            return this.input ? this.context.getInputRepositoryLocations() : this.context.getOutputRepositoryLocations();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Location";
                }
            }
            throw new IndexOutOfBoundsException(col + " > 1");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    String value = RepositoryLocationsEditor.this.prefix + " " + (rowIndex + 1);
                    if (rowIndex < RepositoryLocationsEditor.this.ports.getNumberOfPorts()) {
                        Object correspondingPort = RepositoryLocationsEditor.this.ports.getPortByIndex(rowIndex);
                        if (correspondingPort.isConnected()) {
                            if (correspondingPort instanceof OutputPort) {
                                return value + " (" + ((OutputPort)correspondingPort).getDestination() + ")";
                            }
                            return value + " (" + ((InputPort)correspondingPort).getSource() + ")";
                        }
                        return value + " (disconnected)";
                    }
                    return value;
                }
                case 1: {
                    return this.getLocations().get(rowIndex);
                }
            }
            throw new IndexOutOfBoundsException(columnIndex + " > 1");
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    if (value == null) {
                        value = "";
                    }
                    if (this.input) {
                        this.context.setInputRepositoryLocation(rowIndex, (String)value);
                        break;
                    }
                    this.context.setOutputRepositoryLocation(rowIndex, (String)value);
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(columnIndex + " > 1");
                }
            }
        }

        public void remove(int rowIndex) {
            if (this.input) {
                this.context.removeInputLocation(rowIndex);
            } else {
                this.context.removeOutputLocation(rowIndex);
            }
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }

        public void add() {
            this.add("");
        }

        public void add(String location) {
            if (this.input) {
                this.context.addInputLocation(location);
            } else {
                this.context.addOutputLocation(location);
            }
            this.fireTableRowsInserted(this.getLocations().size() - 1, this.getLocations().size() - 1);
        }

        public void setContext(ProcessContext context2) {
            if (this.context != null) {
                this.context.removeObserver(this.contextObserver);
            }
            this.context = context2;
            if (this.context != null) {
                this.context.addObserver(this.contextObserver, true);
            }
            this.fireTableStructureChanged();
        }
    }

    private final class RepositoryLocationTable
    extends JTable {
        private static final long serialVersionUID = -8662024609772376145L;
        private final LinkedList<RepositoryLocationValueCellEditor> editors;

        private RepositoryLocationTable(TableModel dm) {
            super(dm);
            this.editors = new LinkedList();
            this.setRowHeight(26);
            this.setBackground(Color.WHITE);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 0) {
                return super.getCellEditor(row, column);
            }
            return this.editors.get(row);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 0) {
                return super.getCellRenderer(row, column);
            }
            return this.editors.get(row);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.updateEditorsAndRenderers();
            super.tableChanged(e);
        }

        private void updateEditorsAndRenderers() {
            if (this.editors != null) {
                this.editors.clear();
                int numberOfRows = RepositoryLocationsEditor.this.table.getModel().getRowCount();
                for (int i = 0; i < numberOfRows; ++i) {
                    this.editors.add(RepositoryLocationsEditor.this.createEditor(i));
                }
            }
        }
    }
}

