/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.viewer.DataTableViewer;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;

public class ProcessLogTab
extends JPanel
implements Dockable {
    private static final long serialVersionUID = 1L;
    private static Icon DATA_TABLE_ICON = SwingTools.createIcon("16/table.png");
    public static final String DOCKKEY_PREFIX = "datatable_";
    private Component viewer;
    private final DockKey dockKey;

    public ProcessLogTab(String key) {
        this.setLayout(new BorderLayout());
        this.dockKey = new DockKey(key);
        this.dockKey.setIcon(DATA_TABLE_ICON);
        this.dockKey.setDockGroup(MainFrame.DOCK_GROUP_RESULTS);
    }

    public void setDataTableViewer(DataTableViewer viewer) {
        if (viewer == this.viewer) {
            return;
        }
        if (this.viewer != null) {
            this.remove(this.viewer);
        }
        if (viewer != null) {
            this.viewer = viewer;
            this.dockKey.setName(viewer.getDataTable().getName());
        } else {
            this.viewer = ProcessLogTab.makeTableNotRestoredLabel();
        }
        this.add(this.viewer, "Center");
    }

    private static ResourceLabel makeTableNotRestoredLabel() {
        ResourceLabel label = new ResourceLabel("resulttab.table_cannot_be_restored", new Object[0]);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return label;
    }

    public void freeResources() {
        if (this.viewer != null) {
            this.remove(this.viewer);
        }
        this.viewer = null;
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.dockKey;
    }

    public DataTable getDataTable() {
        if (this.viewer != null && this.viewer instanceof DataTableViewer) {
            return ((DataTableViewer)this.viewer).getDataTable();
        }
        return null;
    }
}

