/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.Process;
import com.rapidminer.ProcessContext;
import com.rapidminer.gui.processeditor.MacroEditor;
import com.rapidminer.gui.processeditor.RepositoryLocationsEditor;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPorts;
import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ProcessContextEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final RepositoryLocationsEditor<OutputPorts> inputEditor = new RepositoryLocationsEditor(true, "context.input", "input");
    private final RepositoryLocationsEditor<InputPorts> outputEditor = new RepositoryLocationsEditor(false, "context.output", "result");
    private final MacroEditor macroEditor = new MacroEditor(true);

    public ProcessContextEditor(Process process, ProcessContext alternativeContext) {
        this.setLayout(new GridLayout(3, 1));
        ((GridLayout)this.getLayout()).setHgap(0);
        ((GridLayout)this.getLayout()).setVgap(10);
        this.inputEditor.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        this.outputEditor.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        this.add(this.inputEditor);
        this.add(this.outputEditor);
        this.add(this.macroEditor);
        this.setProcess(process, alternativeContext);
    }

    protected void setProcess(Process process, ProcessContext context) {
        if (context == null) {
            context = process != null ? process.getContext() : null;
        }
        this.macroEditor.setContext(context);
        if (context != null) {
            this.inputEditor.setData(context, process.getRootOperator().getSubprocess(0).getInnerSources());
            this.outputEditor.setData(context, process.getRootOperator().getSubprocess(0).getInnerSinks());
        }
    }
}

