/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.usagestats.OperatorStatisticsValue;
import com.rapidminer.tools.usagestats.OperatorUsageStatistics;
import com.rapidminer.tools.usagestats.UsageStatistics;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class NewOperatorGroupTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -6092290820461444236L;
    private int maxVisibleUsage;

    public NewOperatorGroupTreeRenderer() {
        this.setLeafIcon(this.getDefaultClosedIcon());
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        int grayLevel;
        if (value instanceof GroupTree) {
            GroupTree groupTree = (GroupTree)value;
            this.setToolTipText("This group contains all operators of the group '" + groupTree.getName() + "'.");
            return super.getTreeCellRendererComponent(tree, groupTree.toString(), isSelected, expanded, leaf, row, hasFocus);
        }
        OperatorDescription op = (OperatorDescription)value;
        OperatorUsageStatistics operatorStatistics = UsageStatistics.getInstance().getOperatorStatistics(UsageStatistics.StatisticsScope.ALL_TIME, op);
        int usageCount = operatorStatistics.getStatistics(OperatorStatisticsValue.EXECUTION);
        this.setToolTipText(null);
        String labelText = op.getName();
        if (hasFocus || this.maxVisibleUsage == 0) {
            grayLevel = 0;
        } else {
            int colorOffset = 100;
            grayLevel = (int)((255.0 - (double)colorOffset) * ((double)(usageCount + 1) / ((double)this.maxVisibleUsage + 1.0)) + (double)colorOffset);
            grayLevel = 255 - Math.min(255, grayLevel);
        }
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, labelText, isSelected, expanded, leaf, row, hasFocus);
        label.setIcon(op.getSmallIcon());
        if (isSelected) {
            label.setForeground(Color.WHITE);
        } else {
            label.setForeground(new Color(grayLevel, grayLevel, grayLevel));
        }
        if (op.getDeprecationInfo() != null) {
            label.setEnabled(false);
        }
        return label;
    }

    public void setMaxVisibleUsageCount(int count) {
        this.maxVisibleUsage = count;
    }
}

