/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.gui.tools.CamelCaseFilter;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.usagestats.OperatorStatisticsValue;
import com.rapidminer.tools.usagestats.OperatorUsageStatistics;
import com.rapidminer.tools.usagestats.UsageStatistics;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class NewOperatorGroupTreeModel
implements TreeModel {
    private final GroupTree completeTree;
    private GroupTree displayedTree;
    private boolean filterDeprecated = true;
    private String filter = null;
    private final List<TreeModelListener> treeModelListeners = new LinkedList<TreeModelListener>();
    private boolean sortByUsage = false;

    public NewOperatorGroupTreeModel(GroupTree root) {
        this.completeTree = root;
        this.removeHidden(this.completeTree);
        this.displayedTree = this.completeTree;
        this.filterDeprecated = true;
        this.updateTree();
    }

    public void setFilterDeprecated(boolean filterDeprecated) {
        this.filterDeprecated = filterDeprecated;
        this.updateTree();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    public boolean contains(Object o) {
        return this.contains(this.getRoot(), o);
    }

    private boolean contains(Object start, Object o) {
        if (o.equals(start)) {
            return true;
        }
        for (int i = 0; i < this.getChildCount(start); ++i) {
            if (!this.contains(this.getChild(start, i), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof GroupTree) {
            GroupTree tree = (GroupTree)parent;
            int numSubGroups = tree.getSubGroups().size();
            if (index < numSubGroups) {
                return tree.getSubGroup(index);
            }
            return tree.getOperatorDescriptions().get(index - numSubGroups);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof GroupTree) {
            GroupTree tree = (GroupTree)parent;
            return tree.getSubGroups().size() + tree.getOperatorDescriptions().size();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        GroupTree tree = (GroupTree)parent;
        if (child instanceof GroupTree) {
            return tree.getIndexOfSubGroup((GroupTree)child);
        }
        return tree.getOperatorDescriptions().indexOf(child) + tree.getSubGroups().size();
    }

    @Override
    public Object getRoot() {
        return this.displayedTree;
    }

    @Override
    public boolean isLeaf(Object node) {
        return !(node instanceof GroupTree);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object node) {
        this.fireTreeChanged(node, path);
    }

    private void fireTreeChanged(Object source, TreePath path) {
        Iterator<TreeModelListener> i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            i.next().treeStructureChanged(new TreeModelEvent(source, path));
        }
    }

    private void fireCompleteTreeChanged(Object source) {
        Iterator<TreeModelListener> i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            i.next().treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.getRoot())));
        }
    }

    public int applyFilter(String filter) {
        this.filter = filter;
        return this.updateTree();
    }

    public int updateTree() {
        int hits = Integer.MAX_VALUE;
        GroupTree filteredTree = (GroupTree)this.completeTree.clone();
        if (!"true".equals(System.getProperty("rapidminer.developermode"))) {
            this.removeDeprecatedGroup(filteredTree);
        }
        if (this.filter != null && this.filter.trim().length() > 0) {
            CamelCaseFilter ccFilter = new CamelCaseFilter(this.filter);
            hits = this.removeFilteredInstances(ccFilter, filteredTree);
        }
        if (this.filterDeprecated) {
            hits = this.removeDeprecated(filteredTree);
        }
        this.displayedTree = filteredTree;
        if (this.sortByUsage) {
            filteredTree.sort(new UsageStatsComparator());
        }
        this.fireCompleteTreeChanged(this);
        return hits;
    }

    public GroupTree getNonDeprecatedGroupTree(GroupTree tree) {
        GroupTree filteredTree = (GroupTree)tree.clone();
        this.removeDeprecated(filteredTree);
        return filteredTree;
    }

    private void removeHidden(GroupTree tree) {
        Iterator<GroupTree> g = tree.getSubGroups().iterator();
        while (g.hasNext()) {
            GroupTree child = g.next();
            this.removeHidden(child);
            if (child.getAllOperatorDescriptions().size() != 0) continue;
            g.remove();
        }
        Iterator<OperatorDescription> o = tree.getOperatorDescriptions().iterator();
        while (o.hasNext()) {
            OperatorDescription description = o.next();
            if (!description.getOperatorClass().equals(ProcessRootOperator.class)) continue;
            o.remove();
        }
    }

    private void removeDeprecatedGroup(GroupTree tree) {
        Iterator<GroupTree> g = tree.getSubGroups().iterator();
        while (g.hasNext()) {
            GroupTree child = g.next();
            if (child.getKey().equals("deprecated")) {
                g.remove();
                continue;
            }
            this.removeDeprecatedGroup(child);
        }
    }

    private int removeDeprecated(GroupTree tree) {
        int hits = 0;
        Iterator<GroupTree> g = tree.getSubGroups().iterator();
        while (g.hasNext()) {
            GroupTree child = g.next();
            hits += this.removeDeprecated(child);
            if (child.getAllOperatorDescriptions().size() != 0) continue;
            g.remove();
        }
        Iterator<OperatorDescription> o = tree.getOperatorDescriptions().iterator();
        while (o.hasNext()) {
            OperatorDescription description = o.next();
            if (description.isDeprecated()) {
                o.remove();
                continue;
            }
            ++hits;
        }
        return hits;
    }

    private int removeFilteredInstances(CamelCaseFilter filter, GroupTree filteredTree) {
        int hits = 0;
        Iterator<GroupTree> g = filteredTree.getSubGroups().iterator();
        while (g.hasNext()) {
            GroupTree child = g.next();
            boolean matches = filter.matches(child.getName());
            if (matches) continue;
            hits += this.removeFilteredInstances(filter, child);
            if (child.getAllOperatorDescriptions().size() != 0) continue;
            g.remove();
        }
        boolean groupMatches = filter.matches(filteredTree.getName());
        if (!groupMatches) {
            Iterator<OperatorDescription> o = filteredTree.getOperatorDescriptions().iterator();
            while (o.hasNext()) {
                boolean matches;
                OperatorDescription description = o.next();
                boolean bl = matches = filter.matches(description.getName()) || filter.matches(description.getShortName());
                if (!this.filterDeprecated) {
                    for (String replaces : description.getReplacedKeys()) {
                        matches |= filter.matches(replaces);
                    }
                }
                if (!matches) {
                    o.remove();
                    continue;
                }
                ++hits;
            }
        }
        return hits;
    }

    public void setSortByUsage(boolean sort) {
        if (sort != this.sortByUsage) {
            this.sortByUsage = sort;
            this.updateTree();
        }
    }

    private static final class UsageStatsComparator
    implements Comparator<OperatorDescription> {
        private UsageStatsComparator() {
        }

        @Override
        public int compare(OperatorDescription op1, OperatorDescription op2) {
            OperatorUsageStatistics operatorStatistics1 = UsageStatistics.getInstance().getOperatorStatistics(UsageStatistics.StatisticsScope.ALL_TIME, op1);
            int usageCount1 = operatorStatistics1 == null ? 0 : operatorStatistics1.getStatistics(OperatorStatisticsValue.EXECUTION);
            OperatorUsageStatistics operatorStatistics2 = UsageStatistics.getInstance().getOperatorStatistics(UsageStatistics.StatisticsScope.ALL_TIME, op2);
            int usageCount2 = operatorStatistics2 == null ? 0 : operatorStatistics2.getStatistics(OperatorStatisticsValue.EXECUTION);
            return usageCount2 - usageCount1;
        }
    }
}

