/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.ToggleAction;
import com.rapidminer.gui.dnd.OperatorTransferHandler;
import com.rapidminer.gui.operatortree.actions.InfoOperatorAction;
import com.rapidminer.gui.processeditor.NewOperatorEditor;
import com.rapidminer.gui.processeditor.NewOperatorGroupTreeModel;
import com.rapidminer.gui.processeditor.NewOperatorGroupTreeRenderer;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.FilterListener;
import com.rapidminer.gui.tools.FilterTextField;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceActionAdapter;
import com.rapidminer.gui.tools.SelectionNavigationListener;
import com.rapidminer.gui.tools.components.DropDownButton;
import com.rapidminer.gui.tools.components.ToolTipWindow;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.usagestats.OperatorStatisticsValue;
import com.rapidminer.tools.usagestats.OperatorUsageStatistics;
import com.rapidminer.tools.usagestats.UsageStatistics;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class NewOperatorGroupTree
extends JPanel
implements FilterListener,
SelectionNavigationListener {
    private static final long serialVersionUID = 133086849304885475L;
    private final FilterTextField filterField = new FilterTextField(12);
    private final transient NewOperatorGroupTreeModel model = new NewOperatorGroupTreeModel(OperatorService.getGroups());
    private final JTree operatorGroupTree = new JTree(this.model);
    private final NewOperatorEditor editor;
    private final transient Action CLEAR_FILTER_ACTION = new ResourceAction(true, "clear_filter", new Object[0]){
        private static final long serialVersionUID = 3236281211064051583L;

        @Override
        public void actionPerformed(ActionEvent e) {
            NewOperatorGroupTree.this.filterField.clearFilter();
        }
    };
    private final transient ToggleAction FILTER_DEPRECATED_ACTION = new ToggleAction(true, "filter_deprecated", new Object[0]){
        private static final long serialVersionUID = -35181409559416043L;
        {
            this.setSelected(true);
            this.actionToggled(null);
        }

        @Override
        public void actionToggled(ActionEvent e) {
            Enumeration<TreePath> expandedPaths = NewOperatorGroupTree.this.operatorGroupTree.getExpandedDescendants(new TreePath(NewOperatorGroupTree.this.operatorGroupTree.getModel().getRoot()));
            TreePath selectedPath = NewOperatorGroupTree.this.operatorGroupTree.getSelectionPath();
            NewOperatorGroupTree.this.model.setFilterDeprecated(this.isSelected());
            while (expandedPaths.hasMoreElements()) {
                NewOperatorGroupTree.this.operatorGroupTree.expandPath(expandedPaths.nextElement());
            }
            NewOperatorGroupTree.this.operatorGroupTree.setSelectionPath(selectedPath);
        }
    };
    private final transient ToggleAction SORT_BY_USAGE_ACTION = new ToggleAction(true, "sort_by_usage", new Object[0]){
        private static final long serialVersionUID = 1L;
        {
            this.setSelected(true);
            this.actionToggled(null);
        }

        @Override
        public void actionToggled(ActionEvent e) {
            NewOperatorGroupTree.this.model.setSortByUsage(this.isSelected());
        }
    };
    public final transient Action INFO_OPERATOR_ACTION = new InfoOperatorAction(){
        private static final long serialVersionUID = 7157100643209732656L;

        @Override
        protected Operator getOperator() {
            return NewOperatorGroupTree.this.getSelectedOperator();
        }
    };
    private final JCheckBoxMenuItem autoWireInputsItem = new JCheckBoxMenuItem(new ResourceAction("auto_wire_inputs_on_add", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            System.setProperty("rapidminer.gui.autowire_input", Boolean.toString(NewOperatorGroupTree.this.autoWireInputsItem.isSelected()));
            ParameterService.writePropertyIntoMainUserConfigFile("rapidminer.gui.autowire_input", Boolean.toString(NewOperatorGroupTree.this.autoWireInputsItem.isSelected()));
        }
    });
    private final JCheckBoxMenuItem autoWireOutputsItem = new JCheckBoxMenuItem(new ResourceAction("auto_wire_outputs_on_add", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            System.setProperty("rapidminer.gui.autowire_output", Boolean.toString(NewOperatorGroupTree.this.autoWireOutputsItem.isSelected()));
            ParameterService.writePropertyIntoMainUserConfigFile("rapidminer.gui.autowire_output", Boolean.toString(NewOperatorGroupTree.this.autoWireOutputsItem.isSelected()));
        }
    });
    private NewOperatorGroupTreeRenderer renderer;

    public NewOperatorGroupTree(NewOperatorEditor editor) {
        this.editor = editor;
        this.setLayout(new BorderLayout());
        this.autoWireInputsItem.setSelected("true".equals(System.getProperty("rapidminer.gui.autowire_input")));
        this.autoWireOutputsItem.setSelected("true".equals(System.getProperty("rapidminer.gui.autowire_output")));
        this.operatorGroupTree.setShowsRootHandles(true);
        this.renderer = new NewOperatorGroupTreeRenderer();
        this.operatorGroupTree.setCellRenderer(this.renderer);
        this.operatorGroupTree.expandRow(0);
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.operatorGroupTree);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
        this.filterField.setToolTipText(I18N.getMessage(I18N.getGUIBundle(), "gui.field.filter_deprecated.tip", new Object[0]));
        this.filterField.addFilterListener(this);
        this.filterField.addSelectionNavigationListener(this);
        ExtendedJToolBar toolBar = new ExtendedJToolBar();
        toolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        toolBar.setFloatable(false);
        DropDownButton autoWireMenuButton = DropDownButton.makeDropDownButton(new ResourceActionAdapter(true, "auto_wire_on_add"));
        autoWireMenuButton.add(this.autoWireInputsItem);
        autoWireMenuButton.add(this.autoWireOutputsItem);
        autoWireMenuButton.addToToolBar(toolBar);
        toolBar.addSeparator();
        toolBar.add(this.filterField);
        toolBar.add(this.CLEAR_FILTER_ACTION);
        JToggleButton filterDeprecatedButton = this.FILTER_DEPRECATED_ACTION.createToggleButton();
        filterDeprecatedButton.setText("");
        toolBar.add(filterDeprecatedButton);
        JToggleButton sortButton = this.SORT_BY_USAGE_ACTION.createToggleButton();
        sortButton.setText("");
        toolBar.add(sortButton);
        this.add((Component)toolBar, "North");
        this.operatorGroupTree.setRootVisible(false);
        this.operatorGroupTree.getSelectionModel().setSelectionMode(1);
        this.operatorGroupTree.setDragEnabled(true);
        this.operatorGroupTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Operator op = NewOperatorGroupTree.this.getSelectedOperator();
                if (op != null) {
                    RapidMinerGUI.getMainFrame().getOperatorDocViewer().setDisplayedOperator(op);
                }
            }
        });
        this.operatorGroupTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                NewOperatorGroupTree.this.updateMaxUsageCount();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                NewOperatorGroupTree.this.updateMaxUsageCount();
            }
        });
        this.operatorGroupTree.setTransferHandler(new OperatorTransferHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<Operator> getDraggedOperators() {
                Operator selectedOperator = NewOperatorGroupTree.this.getSelectedOperator();
                if (selectedOperator == null) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(selectedOperator);
            }
        });
        this.operatorGroupTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NewOperatorGroupTree.this.insertSelected();
                } else {
                    TreePath selPath = NewOperatorGroupTree.this.operatorGroupTree.getPathForLocation(e.getX(), e.getY());
                    if (selPath != null) {
                        NewOperatorGroupTree.this.operatorGroupTree.setSelectionPath(selPath);
                    }
                    NewOperatorGroupTree.this.evaluatePopup(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath selPath = NewOperatorGroupTree.this.operatorGroupTree.getPathForLocation(e.getX(), e.getY());
                if (selPath != null) {
                    NewOperatorGroupTree.this.operatorGroupTree.setSelectionPath(selPath);
                }
                NewOperatorGroupTree.this.evaluatePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TreePath selPath = NewOperatorGroupTree.this.operatorGroupTree.getPathForLocation(e.getX(), e.getY());
                if (selPath != null) {
                    NewOperatorGroupTree.this.operatorGroupTree.setSelectionPath(selPath);
                }
                NewOperatorGroupTree.this.evaluatePopup(e);
            }
        });
        this.operatorGroupTree.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: 
                    case 32: {
                        NewOperatorGroupTree.this.insertSelected();
                        e.consume();
                        return;
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        new ToolTipWindow(new ToolTipWindow.TipProvider(){

            @Override
            public String getTip(Object o) {
                if (!(o instanceof OperatorDescription)) {
                    if (o instanceof GroupTree) {
                        GroupTree groupTree = (GroupTree)o;
                        return "<h3>" + groupTree.getName() + "</h3><p>" + groupTree.getDescription() + "</p>";
                    }
                    return null;
                }
                OperatorDescription opDesc = (OperatorDescription)o;
                StringBuilder b = new StringBuilder();
                b.append("<h3>").append(opDesc.getName()).append("</h3><p>");
                b.append(opDesc.getLongDescriptionHTML()).append("</p>");
                return b.toString();
            }

            @Override
            public Object getIdUnder(Point point) {
                TreePath path = NewOperatorGroupTree.this.operatorGroupTree.getPathForLocation((int)point.getX(), (int)point.getY());
                if (path != null) {
                    return path.getLastPathComponent();
                }
                return null;
            }

            @Override
            public Component getCustomComponent(Object id) {
                return null;
            }
        }, this.operatorGroupTree);
    }

    @Override
    public void valueChanged(String value) {
        int i;
        TreePath[] selectionPaths = this.operatorGroupTree.getSelectionPaths();
        this.model.applyFilter(value);
        if (value != null && value.length() > 0) {
            for (i = 0; i < this.operatorGroupTree.getRowCount(); ++i) {
                this.operatorGroupTree.expandRow(i);
            }
        }
        if (this.operatorGroupTree.getRowCount() > this.getHeight() / (this.operatorGroupTree.getRowHeight() + 2)) {
            for (i = this.operatorGroupTree.getRowCount(); i >= 0; --i) {
                this.operatorGroupTree.collapseRow(i);
            }
        }
        GroupTree root = (GroupTree)this.operatorGroupTree.getModel().getRoot();
        TreePath path = new TreePath(root);
        this.showNodes(root, path);
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                Object lastPathComponent = selectionPath.getLastPathComponent();
                if (!this.model.contains(lastPathComponent)) continue;
                this.operatorGroupTree.addSelectionPath(selectionPath);
            }
        }
    }

    private void showNodes(GroupTree tree, TreePath path) {
        if (tree.getSubGroups().size() == 0) {
            int row = this.operatorGroupTree.getRowForPath(path);
            this.operatorGroupTree.expandRow(row);
            this.editor.setOperatorList(tree);
        } else if (tree.getSubGroups().size() == 1 && tree.getOperatorDescriptions().size() == 0) {
            int row = this.operatorGroupTree.getRowForPath(path);
            this.operatorGroupTree.expandRow(row);
            GroupTree child = tree.getSubGroup(0);
            path = path.pathByAddingChild(child);
            this.showNodes(child, path);
        } else {
            int row = this.operatorGroupTree.getRowForPath(path);
            this.operatorGroupTree.expandRow(row);
            this.editor.setOperatorList(null);
        }
    }

    public boolean shouldAutoConnectNewOperatorsInputs() {
        return this.autoWireInputsItem.isSelected();
    }

    public boolean shouldAutoConnectNewOperatorsOutputs() {
        return this.autoWireOutputsItem.isSelected();
    }

    public JTree getTree() {
        return this.operatorGroupTree;
    }

    private JPopupMenu createOperatorPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.INFO_OPERATOR_ACTION);
        menu.addSeparator();
        menu.add(new ResourceAction(true, "add_operator_now", new Object[0]){
            private static final long serialVersionUID = 4363124048356045034L;

            @Override
            public void actionPerformed(ActionEvent e) {
                NewOperatorGroupTree.this.insertSelected();
            }
        });
        return menu;
    }

    private void evaluatePopup(MouseEvent e) {
        if (e.isPopupTrigger() && this.getSelectedOperator() != null) {
            this.createOperatorPopupMenu().show(this.operatorGroupTree, e.getX(), e.getY());
        }
    }

    private Operator getSelectedOperator() {
        if (this.operatorGroupTree.getSelectionPath() == null) {
            return null;
        }
        Object selectedOperator = this.operatorGroupTree.getSelectionPath().getLastPathComponent();
        if (selectedOperator != null && selectedOperator instanceof OperatorDescription) {
            try {
                return ((OperatorDescription)selectedOperator).createOperatorInstance();
            }
            catch (OperatorCreationException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private void insertSelected() {
        Operator operator = this.getSelectedOperator();
        if (operator == null) {
            return;
        }
        MainFrame mainFrame = RapidMinerGUI.getMainFrame();
        mainFrame.getActions().insert(Collections.singletonList(operator));
    }

    @Override
    public void down() {
        int[] selectionRows = this.operatorGroupTree.getSelectionRows();
        if (selectionRows != null) {
            if (selectionRows.length > 0 && selectionRows[0] < this.operatorGroupTree.getRowCount() - 1) {
                this.operatorGroupTree.setSelectionRow(selectionRows[0] + 1);
            }
        } else if (this.operatorGroupTree.getRowCount() > 0) {
            this.operatorGroupTree.setSelectionRow(0);
        }
    }

    @Override
    public void left() {
    }

    @Override
    public void right() {
    }

    @Override
    public void up() {
        int[] selectionRows = this.operatorGroupTree.getSelectionRows();
        if (selectionRows != null) {
            if (selectionRows.length > 0 && selectionRows[0] > 0) {
                this.operatorGroupTree.setSelectionRow(selectionRows[0] - 1);
            }
        } else if (this.operatorGroupTree.getRowCount() > 0) {
            this.operatorGroupTree.setSelectionRow(this.operatorGroupTree.getRowCount());
        }
    }

    @Override
    public void selected() {
        this.insertSelected();
    }

    private void updateMaxUsageCount() {
        if (this.SORT_BY_USAGE_ACTION.isSelected()) {
            this.renderer.setMaxVisibleUsageCount(this.getMaxVisibleUsage());
        } else {
            this.renderer.setMaxVisibleUsageCount(0);
        }
    }

    private int getMaxVisibleUsage() {
        int max = 0;
        for (int i = 0; i < this.operatorGroupTree.getRowCount(); ++i) {
            TreePath path = this.operatorGroupTree.getPathForRow(i);
            Object leaf = path.getLastPathComponent();
            if (!(leaf instanceof OperatorDescription)) continue;
            OperatorUsageStatistics operatorStatistics1 = UsageStatistics.getInstance().getOperatorStatistics(UsageStatistics.StatisticsScope.ALL_TIME, (OperatorDescription)leaf);
            int usageCount1 = operatorStatistics1 == null ? 0 : operatorStatistics1.getStatistics(OperatorStatisticsValue.EXECUTION);
            max = Math.max(max, usageCount1);
        }
        return max;
    }
}

