/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.ProcessContext;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.ViewToolBar;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.container.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class MacroEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Action ADD_MACRO_ACTION;
    private final Action REMOVE_MACRO_ACTION;
    private ProcessContext context;
    private final MacroTableModel macroModel = new MacroTableModel();
    private final JTable macroTable = new JTable(this.macroModel);

    public MacroEditor(boolean embedded) {
        this.macroTable.setRowHeight(26);
        this.setLayout(new BorderLayout());
        this.ADD_MACRO_ACTION = new ResourceAction(embedded, "macros.add_macro", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MacroEditor.this.addMacro();
            }
        };
        this.REMOVE_MACRO_ACTION = new ResourceAction(embedded, "macros.delete_macro", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MacroEditor.this.removeMacros();
            }
        };
        if (embedded) {
            ViewToolBar toolBar = new ViewToolBar();
            ResourceLabel label = new ResourceLabel("macros", new Object[0]);
            label.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            toolBar.add(label);
            toolBar.add(this.ADD_MACRO_ACTION, 1);
            toolBar.add(this.REMOVE_MACRO_ACTION, 1);
            toolBar.setBorder(null);
            this.add((Component)toolBar, "North");
        }
        ExtendedJScrollPane tablePane = new ExtendedJScrollPane(this.macroTable);
        tablePane.getViewport().setBackground(Color.WHITE);
        tablePane.setBorder(null);
        this.add((Component)tablePane, "Center");
    }

    private void addMacro() {
        this.context.addMacro(new Pair<String, String>("", ""));
        this.macroModel.fireAdd();
    }

    private void removeMacros() {
        int[] selected = this.macroTable.getSelectedRows();
        for (int i = selected.length - 1; i >= 0; --i) {
            this.context.getMacros().remove(selected[i]);
            this.macroModel.fireRemoved(selected[i]);
        }
    }

    public void setContext(ProcessContext context) {
        this.context = context;
        this.macroModel.reset();
    }

    public static void showMacroEditorDialog(ProcessContext context) {
        ButtonDialog dialog = new ButtonDialog("define_macros", true, new Object[0]){
            private static final long serialVersionUID = 2874661432345426452L;
            {
                MacroEditor editor = new MacroEditor(false);
                editor.setBorder(3.createBorder());
                JButton addMacroButton = new JButton(editor.ADD_MACRO_ACTION);
                JButton removeMacroButton = new JButton(editor.REMOVE_MACRO_ACTION);
                this.layoutDefault((JComponent)editor, 1, addMacroButton, removeMacroButton, this.makeOkButton());
            }

            @Override
            protected void ok() {
                super.ok();
            }
        };
        dialog.setVisible(true);
    }

    private class MacroTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private MacroTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (MacroEditor.this.context == null) {
                return 0;
            }
            return MacroEditor.this.context.getMacros().size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Macro";
                }
                case 1: {
                    return "Value";
                }
            }
            throw new IndexOutOfBoundsException(col + " > 1");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return MacroEditor.this.context.getMacros().get(rowIndex).getFirst();
                }
                case 1: {
                    return MacroEditor.this.context.getMacros().get(rowIndex).getSecond();
                }
            }
            throw new IndexOutOfBoundsException(columnIndex + " > 1");
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    MacroEditor.this.context.getMacros().get(rowIndex).setFirst(aValue.toString());
                    break;
                }
                case 1: {
                    MacroEditor.this.context.getMacros().get(rowIndex).setSecond(aValue.toString());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(columnIndex + " > 1");
                }
            }
        }

        private void fireAdd() {
            this.fireTableRowsInserted(MacroEditor.this.context.getMacros().size() - 1, MacroEditor.this.context.getMacros().size() - 1);
        }

        private void fireRemoved(int row) {
            this.fireTableRowsDeleted(row, row);
        }

        private void reset() {
            this.fireTableStructureChanged();
        }
    }
}

