/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.Process;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.syntax.TextAreaDefaults;
import com.rapidminer.operator.Operator;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class CommentEditor
extends JPanel
implements ProcessEditor,
Dockable {
    private static final long serialVersionUID = -2661346182983330754L;
    private transient Operator currentOperator;
    private JTextArea editor = new JTextArea(20, 80);
    public static final String COMMENT_EDITOR_DOCK_KEY = "comment_editor";
    private final DockKey DOCK_KEY = new ResourceDockKey("comment_editor");

    public CommentEditor() {
        super(new BorderLayout());
        this.DOCK_KEY.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
        TextAreaDefaults textAreaDefaults = SwingTools.getTextAreaDefaults();
        textAreaDefaults.eolMarkers = false;
        textAreaDefaults.paintInvalid = false;
        this.editor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                CommentEditor.this.saveComment();
            }
        });
        this.editor.setLineWrap(true);
        this.editor.setWrapStyleWord(true);
        this.editor.setBorder(null);
        this.add((Component)new ExtendedJScrollPane(this.editor), "Center");
    }

    @Override
    public void setSelection(List<Operator> selection) {
        Operator operator;
        Operator operator2 = operator = selection.isEmpty() ? null : selection.get(0);
        if (operator == this.currentOperator) {
            return;
        }
        this.saveComment();
        this.currentOperator = operator;
        if (this.currentOperator != null) {
            String description = this.currentOperator.getUserDescription();
            if (description != null) {
                String text = description;
                this.editor.setText(text);
            } else {
                this.editor.setText(null);
            }
        } else {
            this.editor.setText(null);
        }
    }

    @Override
    public void processChanged(Process proc) {
    }

    @Override
    public void processUpdated(Process proc) {
    }

    private void saveComment() {
        if (this.currentOperator != null) {
            this.currentOperator.setUserDescription(this.editor.getText());
        }
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }
}

