/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.som;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.ColorProvider;
import com.rapidminer.gui.plotter.ExamplePlotterPoint;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.conditions.BasicPlotterCondition;
import com.rapidminer.gui.plotter.conditions.PlotterCondition;
import com.rapidminer.gui.plotter.som.SOMFireColorizer;
import com.rapidminer.gui.plotter.som.SOMGreyColorizer;
import com.rapidminer.gui.plotter.som.SOMLandscapeColorizer;
import com.rapidminer.gui.plotter.som.SOMMatrixColorizer;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.MathFunctions;
import com.rapidminer.tools.math.som.KohonenNet;
import com.rapidminer.tools.math.som.ProgressListener;
import com.rapidminer.tools.math.som.RandomDataContainer;
import com.rapidminer.tools.math.som.RitterAdaptation;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class SOMPlotter
extends PlotterAdapter
implements ProgressListener {
    private static final long serialVersionUID = -1936359032703929998L;
    private static final String[] MATRIX_TYPES = new String[]{"U-Matrix", "P-Matrix", "U*-Matrix"};
    public static final int MATRIX_U = 0;
    public static final int MATRIX_P = 1;
    public static final int MATRIX_U_STAR = 2;
    protected static final int IMAGE_WIDTH = 400;
    protected static final int IMAGE_HEIGHT = 300;
    protected int[] dimensions = new int[]{40, 30};
    private ArrayList<ExamplePlotterPoint> exampleCoordinates = new ArrayList();
    private boolean examplesApplied = false;
    private double[][] uMatrix;
    private double maxU;
    private double[][] pMatrix;
    private double maxP;
    private double[][] uStarMatrix;
    private double maxUStar;
    protected transient DataTable dataTable;
    protected boolean show = false;
    private String currentToolTip = null;
    private double toolTipX = 0.0;
    private double toolTipY = 0.0;
    private int showMatrix = 0;
    private int showColor = 0;
    protected int colorColumn = -1;
    private transient RandomDataContainer data = new RandomDataContainer();
    protected transient KohonenNet net;
    private JButton approveButton = new JButton("Calculate");
    private JComboBox matrixSelection = new JComboBox<String>(MATRIX_TYPES);
    private JComboBox colorSelection = new JComboBox<String>(new String[]{"Landscape", "GrayScale", "Fire and Ice"});
    private JTextField roundSelection = new JTextField("25");
    private JTextField radiusSelection = new JTextField("15");
    private JTextField dimensionX = new JTextField("40");
    private JTextField dimensionY = new JTextField("30");
    private JProgressBar progressBar = new JProgressBar();
    private boolean coloredPoints = true;
    private transient SOMMatrixColorizer[] colorizer = new SOMMatrixColorizer[]{new SOMLandscapeColorizer(), new SOMGreyColorizer(), new SOMFireColorizer()};
    private int jitterAmount = 0;
    protected transient BufferedImage image = null;

    public SOMPlotter(PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.WHITE);
        this.approveButton.setToolTipText("Start the calculation of the SOM (may take a while).");
        this.approveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SOMPlotter.this.startCalculation(true);
            }
        });
        this.matrixSelection.setToolTipText("Select the matrix type which should be visualized.");
        this.matrixSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                SOMPlotter.this.showMatrix = SOMPlotter.this.matrixSelection.getSelectedIndex();
                if (SOMPlotter.this.showMatrix < 0) {
                    SOMPlotter.this.showMatrix = 0;
                }
                SOMPlotter.this.recalculateBackgroundImage();
                SOMPlotter.this.repaint();
            }
        });
        this.colorSelection.setToolTipText("Select the color scheme used for the visualization of the matrix values.");
        this.colorSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                SOMPlotter.this.showColor = SOMPlotter.this.colorSelection.getSelectedIndex();
                if (SOMPlotter.this.showColor < 0) {
                    SOMPlotter.this.showColor = 0;
                }
                SOMPlotter.this.recalculateBackgroundImage();
                SOMPlotter.this.repaint();
            }
        });
        this.progressBar.setToolTipText("Shows the progress of the SOM calculation.");
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.setDoubleBuffered(true);
    }

    @Override
    public void forcePlotGeneration() {
        this.startCalculation(false);
    }

    protected Object readResolve() {
        this.data = new RandomDataContainer();
        this.colorizer = new SOMMatrixColorizer[]{new SOMLandscapeColorizer(), new SOMGreyColorizer(), new SOMFireColorizer()};
        return this;
    }

    public void setColoredPoints(boolean coloredPoints) {
        this.coloredPoints = coloredPoints;
    }

    public void setMatrixType(int matrixType) {
        this.showMatrix = matrixType;
    }

    public void startCalculation(boolean threadMode) {
        this.show = false;
        try {
            this.dimensions[0] = Integer.parseInt(this.dimensionX.getText());
        }
        catch (NumberFormatException ex) {
            SwingTools.showVerySimpleErrorMessage("som.only_nr_width", new Object[0]);
            return;
        }
        try {
            this.dimensions[1] = Integer.parseInt(this.dimensionY.getText());
        }
        catch (NumberFormatException ex) {
            SwingTools.showVerySimpleErrorMessage("som.only_nr_height", new Object[0]);
            return;
        }
        int adaptationRadius = 15;
        try {
            adaptationRadius = Integer.parseInt(this.radiusSelection.getText());
        }
        catch (NumberFormatException ex) {
            SwingTools.showVerySimpleErrorMessage("som.only_nr_radius", new Object[0]);
            return;
        }
        int trainRounds = 25;
        try {
            trainRounds = Integer.parseInt(this.roundSelection.getText());
        }
        catch (NumberFormatException ex) {
            SwingTools.showVerySimpleErrorMessage("som.only_nr_rounds", new Object[0]);
            return;
        }
        this.prepareSOM(this.dataTable, adaptationRadius, trainRounds, threadMode);
    }

    @Override
    public PlotterCondition getPlotterCondition() {
        return new BasicPlotterCondition();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.show) {
            this.paintSom(graphics);
        }
    }

    public void paintSom(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        int pixWidth = this.getWidth() - 40;
        int pixHeight = this.getHeight() - 40;
        g.drawImage(this.image, 20, 20, pixWidth, pixHeight, Color.WHITE, null);
        this.drawPoints(g);
        this.drawLegend(graphics, this.dataTable, this.colorColumn);
        this.drawToolTip((Graphics2D)graphics);
    }

    protected void drawPoints(Graphics2D g) {
        int pixWidth = this.getWidth() - 40;
        int pixHeight = this.getHeight() - 40;
        if (this.colorColumn >= 0) {
            Iterator<DataTableRow> iterator = this.dataTable.iterator();
            double minColorValue = Double.POSITIVE_INFINITY;
            double maxColorValue = Double.NEGATIVE_INFINITY;
            while (iterator.hasNext()) {
                double value = iterator.next().getValue(this.colorColumn);
                minColorValue = MathFunctions.robustMin(minColorValue, value);
                maxColorValue = MathFunctions.robustMax(maxColorValue, value);
            }
            if (!this.examplesApplied) {
                int[][] exampleCount = new int[this.dimensions[0]][this.dimensions[1]];
                this.exampleCoordinates.clear();
                iterator = this.dataTable.iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    DataTableRow row = iterator.next();
                    double[] example = this.getDoubleArrayFromRow(row, this.dataTable);
                    int[] coords = this.net.apply(example);
                    this.exampleCoordinates.add(new ExamplePlotterPoint(index, coords[0], coords[1]));
                    int[] nArray = exampleCount[coords[0]];
                    int n = coords[1];
                    nArray[n] = nArray[n] + 1;
                    ++index;
                }
                this.examplesApplied = true;
            }
            double fieldWidth = (double)pixWidth / (double)this.dimensions[0];
            double fieldHeight = (double)pixHeight / (double)this.dimensions[1];
            Iterator<ExamplePlotterPoint> exampleIterator = this.exampleCoordinates.iterator();
            RandomGenerator random = RandomGenerator.getRandomGenerator(true, 2001);
            ColorProvider colorProvider = this.getColorProvider();
            while (exampleIterator.hasNext()) {
                ExamplePlotterPoint point = exampleIterator.next();
                double color = 1.0;
                Color borderColor = Color.BLACK;
                if (this.coloredPoints) {
                    color = colorProvider.getPointColorValue(this.dataTable, this.dataTable.getRow(point.getDataTableIndex()), this.colorColumn, minColorValue, maxColorValue);
                    borderColor = colorProvider.getPointBorderColor(this.dataTable, this.dataTable.getRow(point.getDataTableIndex()), this.colorColumn);
                }
                double pertX = 0.0;
                double pertY = 0.0;
                if (this.jitterAmount > 0) {
                    pertX = random.nextDoubleInRange(-fieldWidth / 2.0, fieldWidth / 2.0) * ((double)this.jitterAmount / 50.0);
                    pertY = random.nextDoubleInRange(-fieldHeight / 2.0, fieldHeight / 2.0) * ((double)this.jitterAmount / 50.0);
                }
                point.setCurrentPertubatedX((int)(20.0 + pertX + (double)point.getX() * fieldWidth + fieldWidth / 2.0));
                point.setCurrentPertubatedY((int)(20.0 + pertY + (double)point.getY() * fieldHeight + fieldHeight / 2.0));
                this.drawPoint(g, point.getCurrentPertubatedX(), point.getCurrentPertubatedY(), colorProvider.getPointColor(color), borderColor);
            }
        }
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
    }

    @Override
    public boolean canHandleJitter() {
        return true;
    }

    @Override
    public void setJitter(int jitter) {
        this.jitterAmount = jitter;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareSOM(DataTable dataTable, double adaptationRadius, int trainRounds, boolean threadMode) {
        this.examplesApplied = false;
        int dataDimension = 0;
        DataTable dataTable2 = dataTable;
        synchronized (dataTable2) {
            Iterator<DataTableRow> iterator = dataTable.iterator();
            dataDimension = dataTable.getNumberOfColumns() - dataTable.getNumberOfSpecialColumns();
            iterator = dataTable.iterator();
            while (iterator.hasNext()) {
                this.data.addData(this.getDoubleArrayFromRow(iterator.next(), dataTable));
            }
        }
        this.net = new KohonenNet(this.data);
        RitterAdaptation adaptationFunction = new RitterAdaptation();
        adaptationFunction.setAdaptationRadiusStart(adaptationRadius);
        adaptationFunction.setLearnRateStart(0.8);
        this.net.setAdaptationFunction(adaptationFunction);
        this.net.init(dataDimension, this.dimensions, false);
        this.net.setTrainingRounds(trainRounds);
        if (threadMode) {
            this.net.addProgressListener(this);
            Thread trainThread = new Thread(){

                @Override
                public void run() {
                    SOMPlotter.this.net.train();
                }
            };
            trainThread.start();
        } else {
            this.net.train();
            this.createMatrices();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    protected void createMatrices() {
        int j;
        int i;
        this.uMatrix = this.getUMatrix(this.net, this.dimensions);
        this.pMatrix = this.getPMatrix(this.net, this.data, this.dimensions);
        this.maxU = 0.0;
        for (int i2 = 0; i2 < this.dimensions[0]; ++i2) {
            for (int j2 = 0; j2 < this.dimensions[1]; ++j2) {
                this.maxU = Math.max(this.maxU, this.uMatrix[i2][j2]);
            }
        }
        this.maxP = 0.0;
        double meanP = 0.0;
        for (i = 0; i < this.dimensions[0]; ++i) {
            for (j = 0; j < this.dimensions[1]; ++j) {
                this.maxP = this.maxP < this.pMatrix[i][j] ? this.pMatrix[i][j] : this.maxP;
                meanP += this.pMatrix[i][j];
            }
        }
        this.uStarMatrix = this.getUStarMatrix(this.uMatrix, this.pMatrix, meanP /= (double)(this.dimensions[0] * this.dimensions[1]), this.maxP, this.dimensions);
        this.maxUStar = 0.0;
        for (i = 0; i < this.dimensions[0]; ++i) {
            for (j = 0; j < this.dimensions[1]; ++j) {
                this.maxUStar = Math.max(this.maxUStar, this.uStarMatrix[i][j]);
            }
        }
        this.recalculateBackgroundImage();
        this.show = true;
    }

    protected void recalculateBackgroundImage() {
        Vector<double[][]> printMatrix = new Vector<double[][]>();
        double[] printScale = new double[]{this.maxU, this.maxP, this.maxUStar};
        printMatrix.add(this.uMatrix);
        printMatrix.add(this.pMatrix);
        printMatrix.add(this.uStarMatrix);
        int image_width = 400 / this.dimensions[0] * this.dimensions[0];
        int image_height = 300 / this.dimensions[1] * this.dimensions[1];
        this.image = new BufferedImage(image_width, image_height, 1);
        int width = image_width / this.dimensions[0];
        int height = image_height / this.dimensions[1];
        for (int i = 0; i < this.dimensions[0]; ++i) {
            for (int j = 0; j < this.dimensions[1]; ++j) {
                this.interpolateRect(this.image, width * i, height * j, width, height, (double[][])printMatrix.elementAt(this.showMatrix), i, j, printScale[this.showMatrix], this.colorizer[this.showColor]);
            }
        }
    }

    protected void interpolateRect(BufferedImage image, int posX, int posY, double width, double height, double[][] matrix, int matrixX, int matrixY, double colorScale, SOMMatrixColorizer colorizer) {
        if (matrix != null) {
            double p11 = matrix[matrixX][matrixY];
            double p21 = matrix[(matrixX + 1) % this.dimensions[0]][matrixY];
            double p12 = matrix[matrixX][(matrixY + 1) % this.dimensions[1]];
            double p22 = matrix[(matrixX + 1) % this.dimensions[0]][(matrixY + 1) % this.dimensions[1]];
            int i = 0;
            while ((double)i < width) {
                int j = 0;
                while ((double)j < height) {
                    double interpolatedValue = (p11 * (width - (double)i) * (height - (double)j) + p21 * (double)i * (height - (double)j) + p12 * (width - (double)i) * (double)j + p22 * (double)i * (double)j) / (height * width);
                    double colorValue = interpolatedValue / colorScale;
                    int rgbColor = colorizer.getPointColor(colorValue).getRGB();
                    image.setRGB(posX + i, posY + j, rgbColor);
                    ++j;
                }
                ++i;
            }
        }
    }

    private double[] getDoubleArrayFromRow(DataTableRow row, DataTable table) {
        double[] doubleRow = new double[table.getNumberOfColumns() - table.getNumberOfSpecialColumns()];
        int index = 0;
        for (int i = 0; i < row.getNumberOfValues(); ++i) {
            if (table.isSpecial(i)) continue;
            doubleRow[index] = row.getValue(i);
            ++index;
        }
        return doubleRow;
    }

    private double[][] getUMatrix(KohonenNet net, int[] dimensions) {
        double[][] uMatrix = new double[dimensions[0]][dimensions[1]];
        for (int i = 0; i < dimensions[0]; ++i) {
            for (int j = 0; j < dimensions[1]; ++j) {
                uMatrix[i][j] = net.getNodeDistance(net.getIndexOfCoordinates(new int[]{i, j}));
            }
        }
        return uMatrix;
    }

    private double[][] getPMatrix(KohonenNet net, RandomDataContainer data, int[] dimensions) {
        int n = data.countData();
        double optimalMedian = 0.2013 * (double)n;
        double estimatedRadius = 0.0;
        double[] distances = new double[n * n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                distances[i * n + j] = net.getDistance(data.get(i), data.get(j));
            }
        }
        Arrays.sort(distances);
        double percentilSetDifference = Double.POSITIVE_INFINITY;
        for (int percentil = 0; percentil < 100; ++percentil) {
            int[] nn = new int[n];
            double radius = distances[(int)Math.round((double)(percentil * n * n) / 100.0)];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (!(net.getDistance(data.get(i), data.get(j)) <= radius)) continue;
                    int n2 = i;
                    nn[n2] = nn[n2] + 1;
                }
            }
            Arrays.sort(nn);
            int currentMedian = nn[n / 2] - 1;
            if (!(Math.abs((double)currentMedian - optimalMedian) <= percentilSetDifference)) {
                estimatedRadius = radius;
                break;
            }
            percentilSetDifference = Math.abs((double)currentMedian - optimalMedian);
        }
        double[][] pMatrix = new double[dimensions[0]][dimensions[1]];
        for (int i = 0; i < dimensions[0]; ++i) {
            for (int j = 0; j < dimensions[1]; ++j) {
                double[] nodeWeight = net.getNodeWeights(new int[]{i, j});
                int neighbours = 0;
                for (int x = 0; x < n; ++x) {
                    if (!(net.getDistance(data.get(x), nodeWeight) < estimatedRadius)) continue;
                    ++neighbours;
                }
                pMatrix[i][j] = (double)neighbours / (double)n;
            }
        }
        return pMatrix;
    }

    private double[][] getUStarMatrix(double[][] uMatrix, double[][] pMatrix, double meanP, double maxP, int[] dimensions) {
        double[][] uStarMatrix = new double[dimensions[0]][dimensions[1]];
        for (int i = 0; i < dimensions[0]; ++i) {
            for (int j = 0; j < dimensions[1]; ++j) {
                uStarMatrix[i][j] = uMatrix[i][j] * ((pMatrix[i][j] - meanP) / (meanP - maxP) + 1.0);
            }
        }
        return uStarMatrix;
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        switch (index) {
            case 0: {
                JLabel label = new JLabel("Matrix");
                label.setToolTipText("Select the matrix type which should be visualized.");
                return label;
            }
            case 1: {
                return this.matrixSelection;
            }
            case 2: {
                JLabel label = new JLabel("Style");
                label.setToolTipText("Select the color scheme used for the visualization of the matrix values.");
                return label;
            }
            case 3: {
                return this.colorSelection;
            }
            case 4: {
                JPanel dimensionLabelPanel = new JPanel();
                dimensionLabelPanel.setToolTipText("Set the dimensions of the Kohonen net.");
                dimensionLabelPanel.setLayout(new GridLayout());
                dimensionLabelPanel.add(new JLabel("Net Width"));
                dimensionLabelPanel.add(new JLabel("Net Height"));
                return dimensionLabelPanel;
            }
            case 5: {
                JPanel dimensionPanel = new JPanel();
                dimensionPanel.setLayout(new GridLayout());
                this.dimensionX.setToolTipText("Set the dimensions of the Kohonen net.");
                this.dimensionY.setToolTipText("Set the dimensions of the Kohonen net.");
                dimensionPanel.add(this.dimensionX);
                dimensionPanel.add(this.dimensionY);
                return dimensionPanel;
            }
            case 6: {
                JPanel roundPanel = new JPanel();
                roundPanel.setToolTipText("Set the number of training rounds of the Kohonen net.");
                this.roundSelection.setToolTipText("Set the number of training rounds of the Kohonen net.");
                roundPanel.setLayout(new GridLayout());
                roundPanel.add(new JLabel("Training Rounds"));
                roundPanel.add(this.roundSelection);
                return roundPanel;
            }
            case 7: {
                JPanel radiusPanel = new JPanel();
                radiusPanel.setToolTipText("Set the adaptation radius of the Kohonen net.");
                this.radiusSelection.setToolTipText("Set the adaptation radius of the Kohonen net.");
                radiusPanel.setLayout(new GridLayout());
                radiusPanel.add(new JLabel("Adaptation Radius"));
                radiusPanel.add(this.radiusSelection);
                return radiusPanel;
            }
            case 8: {
                return this.progressBar;
            }
            case 9: {
                return this.approveButton;
            }
        }
        return null;
    }

    @Override
    public void setPlotColumn(int column, boolean plot) {
        if (plot) {
            this.colorColumn = column;
            this.repaint();
        }
    }

    @Override
    public boolean getPlotColumn(int dimension) {
        return dimension == this.colorColumn;
    }

    @Override
    public String getPlotName() {
        return "Point Color";
    }

    @Override
    public void setProgress(int value) {
        this.progressBar.setValue(value);
    }

    @Override
    public void progressFinished() {
        this.createMatrices();
        this.setProgress(100);
        this.repaint();
    }

    @Override
    public String getIdForPos(int x, int y) {
        ExamplePlotterPoint point;
        if (this.show && (point = this.getPlotterPointForPos(x, y)) != null) {
            return this.dataTable.getRow(point.getDataTableIndex()).getId();
        }
        return null;
    }

    private ExamplePlotterPoint getPlotterPointForPos(int x, int y) {
        for (ExamplePlotterPoint point : this.exampleCoordinates) {
            if (!point.contains(x, y)) continue;
            return point;
        }
        return null;
    }

    @Override
    public void setMousePosInDataSpace(int x, int y) {
        if (this.show) {
            ExamplePlotterPoint point = this.getPlotterPointForPos(x, y);
            if (point != null) {
                String id = this.dataTable.getRow(point.getDataTableIndex()).getId();
                if (id != null) {
                    this.setToolTip(id, point.getCurrentPertubatedX(), point.getCurrentPertubatedY());
                } else {
                    this.setToolTip(null, 0.0, 0.0);
                }
            } else {
                this.setToolTip(null, 0.0, 0.0);
            }
        }
    }

    private void setToolTip(String toolTip, double x, double y) {
        this.currentToolTip = toolTip;
        this.toolTipX = x;
        this.toolTipY = y;
        this.repaint();
    }

    protected void drawToolTip(Graphics2D g) {
        if (this.currentToolTip != null) {
            g.setFont(LABEL_FONT);
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(this.currentToolTip, g.getFontRenderContext());
            g.setColor(TOOLTIP_COLOR);
            Rectangle2D.Double bg = new Rectangle2D.Double(this.toolTipX - stringBounds.getWidth() - 15.0, this.toolTipY - stringBounds.getHeight() / 2.0, stringBounds.getWidth() + 6.0, Math.abs(stringBounds.getHeight()) + 4.0);
            g.fill(bg);
            g.setColor(Color.black);
            g.draw(bg);
            g.drawString(this.currentToolTip, (float)(this.toolTipX - stringBounds.getWidth() - 12.0), (float)(this.toolTipY + stringBounds.getHeight() * 0.5 + 1.0));
        }
    }

    @Override
    public String getPlotterName() {
        return "SOM";
    }
}

