/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.som;

import com.rapidminer.gui.plotter.som.SOMMatrixColorizer;
import java.awt.Color;

public class SOMLandscapeColorizer
implements SOMMatrixColorizer {
    private Color[] colors = new Color[]{new Color(0, 0, 255), new Color(0, 255, 255), new Color(255, 255, 185), new Color(255, 255, 100), new Color(110, 255, 110), new Color(0, 170, 0), new Color(255, 195, 105), new Color(155, 95, 0), new Color(195, 195, 195), new Color(255, 255, 255)};
    private double[] intervalls = new double[]{0.0, 0.2, 0.25, 0.6, 0.85, 1.0};

    @Override
    public Color getPointColor(double value) {
        int intervall;
        double intervallPosition = 0.0;
        for (intervall = 0; intervall < 5; ++intervall) {
            double lowerBound = this.intervalls[intervall];
            double upperBound = this.intervalls[intervall + 1];
            if (!(value >= lowerBound) || !(value <= upperBound)) continue;
            intervallPosition = (value - lowerBound) / (upperBound - lowerBound);
            break;
        }
        if (intervall >= 5) {
            return Color.BLACK;
        }
        int redLow = this.colors[intervall *= 2].getRed();
        int redHigh = this.colors[intervall + 1].getRed();
        int red = (int)((double)redLow + (double)(redHigh - redLow) * intervallPosition);
        int greenLow = this.colors[intervall].getGreen();
        int greenHigh = this.colors[intervall + 1].getGreen();
        int green = (int)((double)greenLow + (double)(greenHigh - greenLow) * intervallPosition);
        int blueLow = this.colors[intervall].getBlue();
        int blueHigh = this.colors[intervall + 1].getBlue();
        int blue = (int)((double)blueLow + (double)(blueHigh - blueLow) * intervallPosition);
        return new Color(red, green, blue);
    }
}

