/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.som;

import com.rapidminer.gui.plotter.som.SOMMatrixColorizer;
import java.awt.Color;

public class SOMFireColorizer
implements SOMMatrixColorizer {
    private Color[] colors = new Color[]{new Color(0, 0, 255), new Color(40, 40, 255), new Color(40, 40, 255), new Color(168, 100, 255), new Color(168, 100, 255), new Color(255, 100, 168), new Color(255, 100, 168), new Color(255, 40, 40), new Color(255, 40, 40), new Color(255, 0, 0)};
    private double[] intervalls = new double[]{0.0, 0.2, 0.4, 0.6, 0.8, 1.0};

    @Override
    public Color getPointColor(double value) {
        int intervall;
        double intervallPosition = 0.0;
        for (intervall = 0; intervall < 5; ++intervall) {
            double lowerBound = this.intervalls[intervall];
            double upperBound = this.intervalls[intervall + 1];
            if (!(value >= lowerBound) || !(value <= upperBound)) continue;
            intervallPosition = (value - lowerBound) / (upperBound - lowerBound);
            break;
        }
        if (intervall >= 5) {
            return Color.BLACK;
        }
        int redLow = this.colors[intervall *= 2].getRed();
        int redHigh = this.colors[intervall + 1].getRed();
        int red = (int)((double)redLow + (double)(redHigh - redLow) * intervallPosition);
        int greenLow = this.colors[intervall].getGreen();
        int greenHigh = this.colors[intervall + 1].getGreen();
        int green = (int)((double)greenLow + (double)(greenHigh - greenLow) * intervallPosition);
        int blueLow = this.colors[intervall].getBlue();
        int blueHigh = this.colors[intervall + 1].getBlue();
        int blue = (int)((double)blueLow + (double)(blueHigh - blueLow) * intervallPosition);
        return new Color(red, green, blue);
    }
}

