/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.settings;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.PlotterConfigurationSettings;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ports.ProcessingStep;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;

public final class PlotterSettingsHistory {
    private static final HashMap<ProcessingStep, PlotterConfigurationSettings> settingsHistory = new HashMap();

    public static PlotterConfigurationModel getPlotterSettingsFromHistory(IOObject object, DataTable dataTable, LinkedHashMap<String, Class<? extends Plotter>> plotterSelections) {
        List<ProcessingStep> steps = object.getProcessingHistory();
        ListIterator<ProcessingStep> iterator = steps.listIterator(steps.size());
        PlotterConfigurationModel configurationModel = null;
        boolean isFirst = true;
        while (iterator.hasPrevious()) {
            ProcessingStep step = iterator.previous();
            PlotterConfigurationSettings settings = settingsHistory.get(step);
            if (settings != null) {
                if (!isFirst) {
                    settings = settings.clone();
                    settingsHistory.put(steps.get(steps.size() - 1), settings);
                }
                configurationModel = new PlotterConfigurationModel(settings, plotterSelections, dataTable);
                break;
            }
            isFirst = false;
        }
        if (configurationModel == null) {
            configurationModel = new PlotterConfigurationModel(plotterSelections, dataTable);
            if (!steps.isEmpty()) {
                settingsHistory.put(steps.get(steps.size() - 1), configurationModel.getPlotterSettings());
            }
        }
        return configurationModel;
    }
}

