/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.settings;

import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.ListModel;

public class ListeningListSelectionModel
extends DefaultListSelectionModel
implements PlotterConfigurationModel.PlotterSettingsChangedListener {
    private static final long serialVersionUID = -3145893699784702675L;
    private String generalKey;
    private JList list;

    public ListeningListSelectionModel(String generalKey, JList list) {
        this.generalKey = generalKey.startsWith("_") ? generalKey : "_" + generalKey;
        this.list = list;
    }

    @Override
    public void settingChanged(String generalKey, String specificKey, String value) {
        if (generalKey.equals(this.generalKey)) {
            int i;
            ListModel listModel = this.list.getModel();
            String[] names = ParameterTypeEnumeration.transformString2Enumeration(value);
            boolean[] selectedDimensions = new boolean[listModel.getSize()];
            block0: for (i = 0; i < names.length; ++i) {
                String name = names[i].trim();
                for (int j = 0; j < listModel.getSize(); ++j) {
                    if (!listModel.getElementAt(j).equals(name)) continue;
                    selectedDimensions[j] = true;
                    continue block0;
                }
            }
            this.setValueIsAdjusting(true);
            for (i = 0; i < listModel.getSize(); ++i) {
                if (selectedDimensions[i]) {
                    this.addSelectionInterval(i, i);
                    continue;
                }
                this.removeSelectionInterval(i, i);
            }
            this.setValueIsAdjusting(false);
        }
    }
}

