/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.mathplot;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.mathplot.JMathPlotter2D;
import java.awt.Color;
import java.util.Iterator;
import org.math.plot.Plot2DPanel;

public class SticksPlot2D
extends JMathPlotter2D {
    private static final long serialVersionUID = -4351530035081388245L;

    public SticksPlot2D(PlotterConfigurationModel settings) {
        super(settings);
    }

    public SticksPlot2D(PlotterConfigurationModel settings, DataTable dataTable) {
        super(settings, dataTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        if (this.getAxis(0) != -1) {
            this.getPlotPanel().removeAllPlots();
            int totalNumberOfColumns = this.countColumns();
            for (int currentVariable = 0; currentVariable < totalNumberOfColumns; ++currentVariable) {
                DataTable table;
                if (!this.getPlotColumn(currentVariable)) continue;
                DataTable dataTable = table = this.getDataTable();
                synchronized (dataTable) {
                    Iterator<DataTableRow> iterator = table.iterator();
                    int i = 0;
                    double[][] data = new double[this.getDataTable().getNumberOfRows()][2];
                    while (iterator.hasNext()) {
                        DataTableRow row = iterator.next();
                        data[i][0] = row.getValue(this.getAxis(0));
                        if (Double.isNaN(data[i][0])) {
                            data[i][0] = 0.0;
                        }
                        data[i][1] = row.getValue(currentVariable);
                        if (Double.isNaN(data[i][1])) {
                            data[i][1] = 0.0;
                        }
                        ++i;
                    }
                    Color color = this.getColorProvider().getPointColor((double)(currentVariable + 1) / (double)totalNumberOfColumns);
                    ((Plot2DPanel)this.getPlotPanel()).addBarPlot(this.getDataTable().getColumnName(currentVariable), color, data);
                    continue;
                }
            }
        }
    }

    @Override
    public int getValuePlotSelectionType() {
        return 1;
    }

    @Override
    public int getNumberOfAxes() {
        return 1;
    }

    @Override
    public String getAxisName(int index) {
        switch (index) {
            case 0: {
                return "x-Axis";
            }
        }
        return "empty";
    }

    @Override
    public String getPlotName() {
        return "y-Axis";
    }

    @Override
    public String getPlotterName() {
        return "Sticks";
    }
}

