/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.mathplot;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.mathplot.JMathPlotter3D;
import java.awt.Color;
import java.util.Iterator;
import org.math.plot.Plot3DPanel;

public class ScatterPlot3D
extends JMathPlotter3D {
    private static final long serialVersionUID = -3741835931346090326L;

    public ScatterPlot3D(PlotterConfigurationModel settings) {
        super(settings);
    }

    public ScatterPlot3D(PlotterConfigurationModel settings, DataTable dataTable) {
        super(settings, dataTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        if (this.getAxis(0) != -1 && this.getAxis(1) != -1) {
            this.getPlotPanel().removeAllPlots();
            int totalNumberOfColumns = this.countColumns();
            for (int currentVariable = 0; currentVariable < totalNumberOfColumns; ++currentVariable) {
                DataTable table;
                if (!this.getPlotColumn(currentVariable)) continue;
                DataTable dataTable = table = this.getDataTable();
                synchronized (dataTable) {
                    Iterator<DataTableRow> iterator = table.iterator();
                    int i = 0;
                    double[][] data = new double[this.getDataTable().getNumberOfRows()][3];
                    while (iterator.hasNext()) {
                        DataTableRow row = iterator.next();
                        data[i][0] = row.getValue(this.getAxis(0));
                        data[i][1] = row.getValue(this.getAxis(1));
                        data[i][2] = row.getValue(currentVariable);
                        if (Double.isNaN(data[i][0]) || Double.isNaN(data[i][1]) || Double.isNaN(data[i][2])) {
                            data[i][0] = 0.0;
                            data[i][1] = 0.0;
                            data[i][2] = 0.0;
                        }
                        ++i;
                    }
                    Color color = this.getColorProvider().getPointColor((double)(currentVariable + 1) / (double)totalNumberOfColumns);
                    ((Plot3DPanel)this.getPlotPanel()).addScatterPlot(this.getDataTable().getColumnName(currentVariable), color, data);
                    continue;
                }
            }
        }
    }

    @Override
    public int getValuePlotSelectionType() {
        return 1;
    }

    @Override
    public String getPlotName() {
        return "z-Axis";
    }

    @Override
    public String getPlotterName() {
        return "Scatter 3D";
    }
}

