/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.mathplot;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.PlotterLegend;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.math.plot.PlotPanel;

public abstract class JMathPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = -7018389000051768349L;
    private static final String LEGEND_POSITION = "NORTH";
    private DataTable dataTable;
    private PlotPanel plotpanel;
    private PlotterLegend legend;
    private boolean[] columns = new boolean[0];
    private int[] axis = new int[this.getNumberOfAxes()];

    public JMathPlotter(PlotterConfigurationModel settings) {
        super(settings);
        for (int i = 0; i < this.axis.length; ++i) {
            this.axis[i] = -1;
        }
    }

    public JMathPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public JComponent getPlotter() {
        if (this.plotpanel == null) {
            this.plotpanel = this.createPlotPanel();
            if (this.hasLegend()) {
                this.plotpanel.addLegend(LEGEND_POSITION);
            }
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.gridwidth = 0;
            c.weightx = 1.0;
            if (this.hasRapidMinerValueLegend()) {
                this.legend = new PlotterLegend(this);
                c.weighty = 0.0;
                JPanel legendPanel = new JPanel(new FlowLayout(1));
                legendPanel.setBackground(Color.white);
                legendPanel.add(this.legend);
                layout.setConstraints(legendPanel, c);
                this.add(legendPanel);
            }
            c.weighty = 1.0;
            layout.setConstraints((Component)this.plotpanel, c);
            this.add((Component)this.plotpanel);
        }
        return this;
    }

    protected abstract PlotPanel createPlotPanel();

    protected abstract void update();

    protected abstract int getNumberOfOptionIcons();

    protected PlotterLegend getLegendComponent() {
        return this.legend;
    }

    protected boolean hasLegend() {
        return true;
    }

    protected boolean hasRapidMinerValueLegend() {
        return false;
    }

    protected DataTable getDataTable() {
        return this.dataTable;
    }

    protected int countColumns() {
        return this.columns.length;
    }

    protected PlotPanel getPlotPanel() {
        if (this.plotpanel == null) {
            this.getPlotter();
        }
        return this.plotpanel;
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (index >= 0 && index < this.getNumberOfAxes() && this.axis[index] != dimension) {
            this.axis[index] = dimension;
        }
        this.repaint();
    }

    @Override
    public int getAxis(int index) {
        if (index >= 0 && index < this.getNumberOfAxes()) {
            if (this.axis == null) {
                return -1;
            }
            return this.axis[index];
        }
        return -1;
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.columns = new boolean[dataTable.getNumberOfColumns()];
    }

    @Override
    public Icon getIcon(int index) {
        return null;
    }

    @Override
    public int getNumberOfAxes() {
        return 2;
    }

    @Override
    public String getAxisName(int index) {
        switch (index) {
            case 0: {
                return "x-Axis";
            }
            case 1: {
                return "y-Axis";
            }
        }
        return "none";
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        if (this.getValuePlotSelectionType() == 1) {
            if (this.columns[index] != plot && index != -1) {
                this.columns[index] = plot;
            }
        } else {
            this.columns = new boolean[this.columns.length];
            if (index != -1) {
                this.columns[index] = plot;
            }
        }
        this.repaint();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            while (this.plotpanel.plotToolBar.getComponentCount() > this.getNumberOfOptionIcons()) {
                this.plotpanel.plotToolBar.remove(this.plotpanel.plotToolBar.getComponentCount() - 1);
            }
            return this.plotpanel.plotToolBar;
        }
        return null;
    }

    @Override
    public void repaint() {
        this.update();
        super.repaint();
    }
}

