/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.mathplot;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.mathplot.JMathPlotter2D;
import java.awt.Color;
import java.util.Iterator;
import org.math.plot.Plot2DPanel;

public class BoxPlot2D
extends JMathPlotter2D {
    private static final long serialVersionUID = -3763239240861652777L;

    public BoxPlot2D(PlotterConfigurationModel settings) {
        super(settings);
    }

    public BoxPlot2D(PlotterConfigurationModel settings, DataTable dataTable) {
        super(settings, dataTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        if (this.getAxis(0) != -1 && this.getAxis(1) != -1) {
            this.getPlotPanel().removeAllPlots();
            int totalNumberOfColumns = this.countColumns();
            for (int currentVariable = 0; currentVariable < totalNumberOfColumns; ++currentVariable) {
                DataTable table;
                if (!this.getPlotColumn(currentVariable)) continue;
                DataTable dataTable = table = this.getDataTable();
                synchronized (dataTable) {
                    Iterator<DataTableRow> iterator = table.iterator();
                    int i = 0;
                    double[][] data = new double[this.getDataTable().getNumberOfRows()][2];
                    double[][] deviation = new double[this.getDataTable().getNumberOfRows()][2];
                    while (iterator.hasNext()) {
                        DataTableRow row = iterator.next();
                        data[i][0] = row.getValue(this.getAxis(0));
                        if (Double.isNaN(data[i][0])) {
                            data[i][0] = 0.0;
                        }
                        data[i][1] = row.getValue(this.getAxis(1));
                        if (Double.isNaN(data[i][1])) {
                            data[i][1] = 0.0;
                        }
                        double d = row.getValue(currentVariable);
                        deviation[i][1] = d;
                        deviation[i][0] = d;
                        if (Double.isNaN(deviation[i][0])) {
                            deviation[i][1] = 0.0;
                            deviation[i][0] = 0.0;
                        }
                        ++i;
                    }
                    Color color = this.getColorProvider().getPointColor((double)(currentVariable + 1) / (double)totalNumberOfColumns);
                    ((Plot2DPanel)this.getPlotPanel()).addBoxPlot(this.getDataTable().getColumnName(currentVariable), color, data, deviation);
                    continue;
                }
            }
        }
    }

    @Override
    public int getNumberOfAxes() {
        return 2;
    }

    @Override
    public String getAxisName(int index) {
        switch (index) {
            case 0: {
                return "x-Axis";
            }
            case 1: {
                return "y-Axis";
            }
        }
        return "empty";
    }

    @Override
    public String getPlotName() {
        return "standard deviation";
    }

    @Override
    public String getPlotterName() {
        return "Box";
    }
}

