/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.conditions;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.conditions.PlotterCondition;

public class RowsPlotterCondition
implements PlotterCondition {
    private int minRows;
    private int maxRows;

    public RowsPlotterCondition(int maxRows) {
        this(0, maxRows);
    }

    public RowsPlotterCondition(int minRows, int maxRows) {
        this.minRows = minRows;
        this.maxRows = maxRows;
    }

    @Override
    public boolean acceptDataTable(DataTable dataTable) {
        int numberOfRows = dataTable.getNumberOfRows();
        return numberOfRows >= this.minRows && numberOfRows <= this.maxRows;
    }

    @Override
    public String getRejectionReason(DataTable dataTable) {
        return "Data table must have between " + this.minRows + " and " + this.maxRows + " rows, was " + dataTable.getNumberOfRows() + ".";
    }
}

