/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.ui.RectangleEdge;

public class WeightBasedSymbolAxis
extends SymbolAxis {
    private static final long serialVersionUID = -2836199514919011137L;
    private double[] weights;
    private double maxWeight;

    public WeightBasedSymbolAxis(String name, String[] symbols, double[] weights) {
        super(name, symbols);
        this.weights = weights;
        for (double d : weights) {
            this.maxWeight = MathFunctions.robustMax(Math.abs(d), this.maxWeight);
        }
    }

    protected void drawGridBandsVertical(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea, boolean firstGridBandIsDark, List ticks) {
        double xx = plotArea.getX();
        Stroke outlineStroke = this.getPlot().getOutlineStroke();
        double outlineStrokeWidth = outlineStroke != null && outlineStroke instanceof BasicStroke ? (double)((BasicStroke)outlineStroke).getLineWidth() : 1.0;
        for (ValueTick tick : ticks) {
            int weightIndex = (int)tick.getValue();
            double yy1 = this.valueToJava2D(tick.getValue() + 0.5, plotArea, RectangleEdge.LEFT);
            double yy2 = this.valueToJava2D(tick.getValue() - 0.5, plotArea, RectangleEdge.LEFT);
            g2.setColor(PlotterAdapter.getWeightColor(this.weights[weightIndex], this.maxWeight));
            Rectangle2D.Double band = new Rectangle2D.Double(xx + outlineStrokeWidth, yy1, plotArea.getMaxX() - xx - outlineStrokeWidth, yy2 - yy1);
            g2.fill(band);
        }
        g2.setPaintMode();
    }

    protected void drawGridBandsHorizontal(Graphics2D g2, Rectangle2D plotArea, Rectangle2D dataArea, boolean firstGridBandIsDark, List ticks) {
        double yy = dataArea.getY();
        double outlineStrokeWidth = this.getPlot().getOutlineStroke() != null ? (double)((BasicStroke)this.getPlot().getOutlineStroke()).getLineWidth() : 1.0;
        for (ValueTick tick : ticks) {
            int weightIndex = (int)tick.getValue();
            double xx1 = this.valueToJava2D(tick.getValue() - 0.5, dataArea, RectangleEdge.BOTTOM);
            double xx2 = this.valueToJava2D(tick.getValue() + 0.5, dataArea, RectangleEdge.BOTTOM);
            g2.setColor(PlotterAdapter.getWeightColor(this.weights[weightIndex], this.maxWeight));
            Rectangle2D.Double band = new Rectangle2D.Double(xx1, yy + outlineStrokeWidth, xx2 - xx1, dataArea.getMaxY() - yy - outlineStrokeWidth);
            g2.fill(band);
        }
        g2.setPaintMode();
    }
}

