/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.RangeablePlotterAdapter;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class SeriesChartPlotter
extends RangeablePlotterAdapter {
    private static final long serialVersionUID = -8763693366081949249L;
    private static final String PARAMETER_MARKER = "marker_at";
    private static final String VALUEAXIS_LABEL = "value";
    private static final String SERIESINDEX_LABEL = "index";
    private JTextField limitField = new JTextField();
    private transient DataTable dataTable;
    private YIntervalSeriesCollection dataset = null;
    private boolean[] columns;
    private int[] axis = new int[]{-1, -1, -1};
    private boolean useLimit = false;
    private double limit = 0.0;
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int INDEX = 2;
    private boolean plotBounds = false;
    private int boundsSeriesIndex = 1;
    private List<Integer> plotIndexToColumnIndexMap = new ArrayList<Integer>();

    public SeriesChartPlotter(final PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
        this.limitField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Double.parseDouble(SeriesChartPlotter.this.limitField.getText());
                    settings.setParameterAsDouble(SeriesChartPlotter.PARAMETER_MARKER, value);
                }
                catch (NumberFormatException ex) {
                    SeriesChartPlotter.this.useLimit = false;
                }
            }
        });
    }

    public SeriesChartPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    private JFreeChart createChart(XYDataset dataset, boolean createLegend) {
        Range range;
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)createLegend, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        DeviationRenderer renderer = new DeviationRenderer(true, false);
        if (dataset.getSeriesCount() == 1) {
            renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.5f, 1, 1));
            renderer.setSeriesPaint(0, (Paint)this.getColorProvider().getPointColor(1.0));
        } else {
            for (int i = 0; i < dataset.getSeriesCount(); ++i) {
                renderer.setSeriesStroke(i, (Stroke)new BasicStroke(1.5f, 1, 1));
                renderer.setSeriesPaint(i, (Paint)this.getColorProvider().getPointColor(1.0 - (double)i / (double)(dataset.getSeriesCount() - 1)));
            }
        }
        if (this.plotBounds) {
            float[] dashArray = new float[]{7.0f, 14.0f};
            renderer.setSeriesStroke(this.boundsSeriesIndex, (Stroke)new BasicStroke(1.5f, 1, 1, 1.0f, dashArray, 0.0f));
            renderer.setSeriesPaint(this.boundsSeriesIndex, (Paint)Color.GRAY.brighter());
            renderer.setSeriesFillPaint(this.boundsSeriesIndex, (Paint)Color.GRAY);
        }
        renderer.setAlpha(0.25f);
        plot.setRenderer((XYItemRenderer)renderer);
        NumberAxis xAxis = (NumberAxis)plot.getDomainAxis();
        if (this.axis[2] < 0) {
            xAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits((Locale)Locale.US));
            xAxis.setLabel(SERIESINDEX_LABEL);
            range = this.getRangeForName(SERIESINDEX_LABEL);
            if (range == null) {
                xAxis.setAutoRange(true);
                xAxis.setAutoRangeStickyZero(false);
                xAxis.setAutoRangeIncludesZero(false);
            } else {
                xAxis.setRange(range, true, false);
            }
        } else {
            xAxis.setLabel(this.dataTable.getColumnName(this.axis[2]));
            range = this.getRangeForDimension(this.axis[2]);
            if (range == null) {
                xAxis.setAutoRange(true);
                xAxis.setAutoRangeStickyZero(false);
                xAxis.setAutoRangeIncludesZero(false);
            } else {
                xAxis.setRange(range, true, false);
            }
        }
        xAxis.setLabelFont(LABEL_FONT_BOLD);
        xAxis.setTickLabelFont(LABEL_FONT);
        xAxis.setVerticalTickLabels(this.isLabelRotating());
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        yAxis.setLabel(VALUEAXIS_LABEL);
        yAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits((Locale)Locale.US));
        this.setYAxisRange(yAxis);
        yAxis.setLabelFont(LABEL_FONT_BOLD);
        yAxis.setTickLabelFont(LABEL_FONT);
        return chart;
    }

    @Override
    public Icon getIcon(int index) {
        return null;
    }

    @Override
    public void dataTableSet() {
        this.dataTable = this.getDataTable();
        this.columns = new boolean[this.dataTable.getNumberOfColumns()];
        this.updatePlotter();
    }

    @Override
    public int getValuePlotSelectionType() {
        return 1;
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        if (index >= 0 && index < this.columns.length) {
            this.columns[index] = plot;
        }
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    @Override
    public String getPlotName() {
        return "Plot Series";
    }

    @Override
    public int getNumberOfAxes() {
        return this.axis.length;
    }

    @Override
    public String getAxisName(int index) {
        switch (index) {
            case 0: {
                return "Lower Bound";
            }
            case 1: {
                return "Upper Bound";
            }
            case 2: {
                return "Index Dimension";
            }
        }
        return "none";
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys(InputPort inputPort) {
        List<ParameterType> types = super.getAdditionalParameterKeys(inputPort);
        types.add(new ParameterTypeDouble(PARAMETER_MARKER, "Defines a horizontal line as a reference to the plot.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true));
        return types;
    }

    @Override
    public void setAdditionalParameter(String key, String value) {
        block4: {
            super.setAdditionalParameter(key, value);
            if (PARAMETER_MARKER.equals(key)) {
                try {
                    double newLimit = Double.parseDouble(value);
                    this.useLimit = true;
                    if (this.limit != newLimit) {
                        this.limitField.setText(this.limit + "");
                        this.limit = newLimit;
                        this.updatePlotter();
                    }
                }
                catch (NumberFormatException e) {
                    if (!this.useLimit) break block4;
                    this.useLimit = false;
                    this.updatePlotter();
                }
            }
        }
    }

    @Override
    public int getAxis(int index) {
        return this.axis[index];
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (this.axis[index] != dimension) {
            this.axis[index] = dimension;
            this.updatePlotter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepareData() {
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            this.dataset = new YIntervalSeriesCollection();
            this.plotBounds = false;
            this.plotIndexToColumnIndexMap.clear();
            int columnCount = 0;
            for (int c = 0; c < this.dataTable.getNumberOfColumns(); ++c) {
                if (!this.getPlotColumn(c) || !this.dataTable.isNumerical(c)) continue;
                YIntervalSeries series = new YIntervalSeries((Comparable)((Object)this.dataTable.getColumnName(c)));
                Iterator<DataTableRow> i = this.dataTable.iterator();
                int index = 0;
                while (i.hasNext()) {
                    DataTableRow row = i.next();
                    double value = row.getValue(c);
                    if (this.axis[2] >= 0 && !this.dataTable.isNominal(this.axis[2])) {
                        double indexValue = row.getValue(this.axis[2]);
                        series.add(indexValue, value, value, value);
                        continue;
                    }
                    series.add((double)index++, value, value, value);
                }
                this.dataset.addSeries(series);
                this.plotIndexToColumnIndexMap.add(c);
                ++columnCount;
            }
            if (this.getAxis(0) > -1 && this.getAxis(1) > -1 && this.dataTable.isNumerical(this.getAxis(0)) && this.dataTable.isNumerical(this.getAxis(1))) {
                YIntervalSeries series = new YIntervalSeries((Comparable)((Object)"Bounds"));
                Iterator<DataTableRow> i = this.dataTable.iterator();
                int index = 0;
                while (i.hasNext()) {
                    double upperValue;
                    DataTableRow row = i.next();
                    double lowerValue = row.getValue(this.getAxis(0));
                    if (lowerValue > (upperValue = row.getValue(this.getAxis(1)))) {
                        double dummy = lowerValue;
                        lowerValue = upperValue;
                        upperValue = dummy;
                    }
                    double mean = (upperValue - lowerValue) / 2.0 + lowerValue;
                    if (this.axis[2] >= 0 && !this.dataTable.isNominal(this.axis[2])) {
                        double indexValue = row.getValue(this.axis[2]);
                        series.add(indexValue, mean, lowerValue, upperValue);
                        continue;
                    }
                    series.add((double)index++, mean, lowerValue, upperValue);
                }
                this.dataset.addSeries(series);
                this.plotBounds = true;
                this.boundsSeriesIndex = this.dataset.getSeriesCount() - 1;
            }
            if (this.useLimit) {
                YIntervalSeries series = new YIntervalSeries((Comparable)((Object)"Limit"));
                int index = 0;
                for (DataTableRow row : this.dataTable) {
                    if (!this.dataTable.isNominal(this.axis[2])) {
                        double indexValue = row.getValue(this.axis[2]);
                        series.add(indexValue, this.limit, this.limit, this.limit);
                        continue;
                    }
                    series.add((double)index++, this.limit, this.limit, this.limit);
                }
                this.dataset.addSeries(series);
            }
            return columnCount;
        }
    }

    private void setYAxisRange(NumberAxis axis) {
        Range range = this.getRangeForName(VALUEAXIS_LABEL);
        if (range == null) {
            for (int c = 0; c < this.dataTable.getNumberOfColumns(); ++c) {
                if (!this.columns[c] && c != this.getAxis(0) && c != this.getAxis(1)) continue;
                if (range == null) {
                    range = this.getRangeForDimension(c);
                    continue;
                }
                Range newRange = this.getRangeForDimension(c);
                if (newRange == null) continue;
                range = new Range(MathFunctions.robustMin(range.getLowerBound(), newRange.getLowerBound()), MathFunctions.robustMax(range.getUpperBound(), newRange.getUpperBound()));
            }
        }
        if (range != null) {
            axis.setRange(range);
        } else {
            axis.setAutoRange(true);
            axis.setAutoRangeStickyZero(false);
            axis.setAutoRangeIncludesZero(false);
        }
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.limitField;
        }
        if (index == 1) {
            return this.getRotateLabelComponent();
        }
        return null;
    }

    @Override
    protected void updatePlotter() {
        AbstractChartPanel panel;
        LegendTitle legend;
        int categoryCount = this.prepareData();
        String maxClassesProperty = System.getProperty("rapidminer.gui.plotter.colors.classlimit");
        int maxClasses = 20;
        try {
            if (maxClassesProperty != null) {
                maxClasses = Integer.parseInt(maxClassesProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Series plotter: cannot parse property 'rapidminer.gui.plotter.colors.classlimit', using maximal 20 different classes.", 5);
        }
        boolean createLegend = categoryCount > 0 && categoryCount < maxClasses;
        JFreeChart chart = this.createChart((XYDataset)this.dataset, createLegend);
        chart.setBackgroundPaint((Paint)Color.white);
        if (this.axis[2] >= 0) {
            if (!this.dataTable.isNominal(this.axis[2])) {
                if (this.dataTable.isDate(this.axis[2]) || this.dataTable.isDateTime(this.axis[2])) {
                    DateAxis domainAxis = new DateAxis(this.dataTable.getColumnName(this.axis[2]));
                    domainAxis.setTimeZone(Tools.getPreferredTimeZone());
                    chart.getXYPlot().setDomainAxis((ValueAxis)domainAxis);
                    if (this.getRangeForDimension(this.axis[2]) != null) {
                        domainAxis.setRange(this.getRangeForDimension(this.axis[2]));
                    }
                    domainAxis.setLabelFont(LABEL_FONT_BOLD);
                    domainAxis.setTickLabelFont(LABEL_FONT);
                    domainAxis.setVerticalTickLabels(this.isLabelRotating());
                }
            } else {
                LinkedHashSet<String> values = new LinkedHashSet<String>();
                for (DataTableRow row : this.dataTable) {
                    String stringValue = this.dataTable.mapIndex(this.axis[2], (int)row.getValue(this.axis[2]));
                    if (stringValue.length() > 40) {
                        stringValue = stringValue.substring(0, 40);
                    }
                    values.add(stringValue);
                }
                SymbolAxis categoryAxis = new SymbolAxis(this.dataTable.getColumnName(this.axis[2]), values.toArray(new String[values.size()]));
                categoryAxis.setLabelFont(LABEL_FONT_BOLD);
                categoryAxis.setTickLabelFont(LABEL_FONT);
                categoryAxis.setVerticalTickLabels(this.isLabelRotating());
                chart.getXYPlot().setDomainAxis((ValueAxis)categoryAxis);
            }
        }
        if ((legend = chart.getLegend()) != null) {
            legend.setPosition(RectangleEdge.TOP);
            legend.setFrame((BlockFrame)BlockBorder.NONE);
            legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
            legend.setItemFont(LABEL_FONT);
        }
        if ((panel = this.getPlotterPanel()) == null) {
            panel = this.createPanel(chart);
        } else {
            panel.setChart(chart);
        }
        panel.getChartRenderingInfo().setEntityCollection(null);
    }

    @Override
    public String getPlotterName() {
        return "Series";
    }

    @Override
    public Collection<String> resolveXAxis(int axisIndex) {
        if (this.axis[2] != -1) {
            return Collections.singletonList(this.dataTable.getColumnName(this.axis[2]));
        }
        return Collections.singletonList(SERIESINDEX_LABEL);
    }

    @Override
    public Collection<String> resolveYAxis(int axisIndex) {
        LinkedList<String> names = new LinkedList<String>();
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i]) continue;
            names.add(this.dataTable.getColumnName(i));
        }
        return names;
    }
}

