/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.ColorProvider;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.charts.Abstract2DChartPlotter;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYZDataset;

public class ScatterPlotter2
extends Abstract2DChartPlotter {
    private static final long serialVersionUID = 6535057074946396896L;
    private static final int POINT_SIZE = 7;
    private static final Color DESELECTED_COLOR = new Color(Color.LIGHT_GRAY.getRed(), Color.LIGHT_GRAY.getGreen(), Color.LIGHT_GRAY.getBlue(), 75);

    public ScatterPlotter2(PlotterConfigurationModel settings) {
        super(settings);
    }

    public ScatterPlotter2(PlotterConfigurationModel settings, DataTable dataTable) {
        super(settings, dataTable);
    }

    @Override
    public AbstractXYItemRenderer getItemRenderer(boolean nominal, int size, final double minColor, final double maxColor) {
        if (nominal) {
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(false, true){
                private static final long serialVersionUID = 8435520335829606084L;

                public Paint getItemPaint(int series, int item) {
                    String id = ScatterPlotter2.this.getId(series, item);
                    if (id != null && ScatterPlotter2.this.dataTable.isDeselected(id)) {
                        return DESELECTED_COLOR;
                    }
                    return super.getItemPaint(series, item);
                }

                public Paint getItemOutlinePaint(int series, int item) {
                    String id = ScatterPlotter2.this.getId(series, item);
                    if (id != null && ScatterPlotter2.this.dataTable.isDeselected(id)) {
                        return DESELECTED_COLOR;
                    }
                    return super.getItemOutlinePaint(series, item);
                }
            };
            renderer.setBaseOutlinePaint((Paint)Color.BLACK);
            renderer.setUseOutlinePaint(true);
            renderer.setDrawOutlines(true);
            if (size > 1) {
                for (int i = 0; i < size; ++i) {
                    renderer.setSeriesPaint(i, (Paint)this.getColorProvider().getPointColor((double)i / (double)(size - 1)));
                    renderer.setSeriesShape(i, (Shape)new Ellipse2D.Double(-3.0, -3.0, 7.0, 7.0));
                }
            } else {
                renderer.setSeriesPaint(0, (Paint)this.getColorProvider().getPointColor(1.0));
                renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-3.0, -3.0, 7.0, 7.0));
            }
            return renderer;
        }
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(false, true){
            private static final long serialVersionUID = 7869118044747608622L;
            private ColorProvider colorProvider;
            {
                super(x0, x1);
                this.colorProvider = new ColorProvider();
            }

            public Paint getItemPaint(int series, int item) {
                String id = ScatterPlotter2.this.getId(series, item);
                if (id != null && ScatterPlotter2.this.dataTable.isDeselected(id)) {
                    return DESELECTED_COLOR;
                }
                double colorValue = ((XYZDataset)this.getPlot().getDataset()).getZValue(series, item);
                double normalized = (colorValue - minColor) / (maxColor - minColor);
                return this.colorProvider.getPointColor(normalized);
            }

            public Paint getItemOutlinePaint(int series, int item) {
                String id = ScatterPlotter2.this.getId(series, item);
                if (id != null && ScatterPlotter2.this.dataTable.isDeselected(id)) {
                    return DESELECTED_COLOR;
                }
                return super.getItemOutlinePaint(series, item);
            }
        };
        renderer.setBaseOutlinePaint((Paint)Color.BLACK);
        renderer.setUseOutlinePaint(true);
        renderer.setDrawOutlines(true);
        renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-3.0, -3.0, 7.0, 7.0));
        return renderer;
    }

    @Override
    public String getPlotterName() {
        return "Scatter";
    }
}

