/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class PointsAndLinesDialog
extends JDialog {
    private static final long serialVersionUID = 0L;
    private boolean ok = false;
    private DefaultTableModel model;

    public PointsAndLinesDialog(String[] names, boolean[] points, boolean[] lines) {
        super((Frame)null, "Points and Lines", true);
        Object[][] data = new Object[names.length][3];
        for (int i = 0; i < names.length; ++i) {
            data[i][0] = names[i];
            data[i][1] = points[i];
            data[i][2] = lines[i];
        }
        this.model = new DefaultTableModel(data, new String[]{"Dimension", "Points", "Lines"}){
            private static final long serialVersionUID = 8034022478180821552L;

            @Override
            public Class<?> getColumnClass(int index) {
                if (index == 0) {
                    return String.class;
                }
                return Boolean.class;
            }
        };
        JTable table = new JTable(this.model);
        this.setLayout(new BorderLayout());
        ExtendedJScrollPane tablePane = new ExtendedJScrollPane(table);
        this.add((Component)tablePane, "Center");
        JPanel mainButtonPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        mainButtonPanel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(4, 4, 4, 4);
        c.weightx = 1.0;
        c.weighty = 1.0;
        JPanel selectionButtonPanel = new JPanel(new FlowLayout(0));
        JButton pointsButton = new JButton("All Points");
        pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                int selectedCount = 0;
                int deselectedCount = 0;
                for (i = 0; i < PointsAndLinesDialog.this.model.getRowCount(); ++i) {
                    if (((Boolean)PointsAndLinesDialog.this.model.getValueAt(i, 1)).booleanValue()) {
                        ++selectedCount;
                        continue;
                    }
                    ++deselectedCount;
                }
                if (selectedCount > deselectedCount) {
                    for (i = 0; i < PointsAndLinesDialog.this.model.getRowCount(); ++i) {
                        PointsAndLinesDialog.this.model.setValueAt(false, i, 1);
                    }
                } else {
                    for (i = 0; i < PointsAndLinesDialog.this.model.getRowCount(); ++i) {
                        PointsAndLinesDialog.this.model.setValueAt(true, i, 1);
                    }
                }
            }
        });
        selectionButtonPanel.add(pointsButton);
        JButton linesButton = new JButton("All Lines");
        linesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                int selectedCount = 0;
                int deselectedCount = 0;
                for (i = 0; i < PointsAndLinesDialog.this.model.getRowCount(); ++i) {
                    if (((Boolean)PointsAndLinesDialog.this.model.getValueAt(i, 2)).booleanValue()) {
                        ++selectedCount;
                        continue;
                    }
                    ++deselectedCount;
                }
                if (selectedCount > deselectedCount) {
                    for (i = 0; i < PointsAndLinesDialog.this.model.getRowCount(); ++i) {
                        PointsAndLinesDialog.this.model.setValueAt(false, i, 2);
                    }
                } else {
                    for (i = 0; i < PointsAndLinesDialog.this.model.getRowCount(); ++i) {
                        PointsAndLinesDialog.this.model.setValueAt(true, i, 2);
                    }
                }
            }
        });
        selectionButtonPanel.add(linesButton);
        JPanel dialogButtonPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointsAndLinesDialog.this.setOk(true);
                PointsAndLinesDialog.this.dispose();
            }
        });
        dialogButtonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointsAndLinesDialog.this.setOk(false);
                PointsAndLinesDialog.this.dispose();
            }
        });
        dialogButtonPanel.add(cancelButton);
        layout.setConstraints(selectionButtonPanel, c);
        mainButtonPanel.add(selectionButtonPanel);
        layout.setConstraints(dialogButtonPanel, c);
        mainButtonPanel.add(dialogButtonPanel);
        this.add((Component)mainButtonPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public boolean isOk() {
        return this.ok;
    }

    public boolean showPoints(int index) {
        return (Boolean)this.model.getValueAt(index, 1);
    }

    public boolean showLines(int index) {
        return (Boolean)this.model.getValueAt(index, 2);
    }
}

