/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.LabelRotatingPlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.charts.ParetoChartItemLabelGenerator;
import com.rapidminer.gui.plotter.charts.RapidBarPainter;
import com.rapidminer.gui.plotter.settings.ListeningJCheckBox;
import com.rapidminer.gui.plotter.settings.ListeningJComboBox;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.ModelMetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.DataUtilities;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.SortOrder;

public class ParetoChartPlotter
extends LabelRotatingPlotterAdapter {
    public static final String PARAMETER_ROTATE_LABELS = "rotate_labels";
    public static final String PARAMETER_SHOW_CUMULATIVE_LABELS = "show_cumulative_labels";
    public static final String PARAMETER_SHOW_BAR_LABELS = "show_bar_labels";
    public static final String PARAMETER_SORTING_DIRECTION = "sorting_direction";
    public static final String PARAMETER_COUNT_VALUE = "count_value";
    private static final long serialVersionUID = -8763693366081949249L;
    private transient DataTable dataTable;
    private DefaultKeyedValues data = new DefaultKeyedValues();
    private DefaultKeyedValues totalData = new DefaultKeyedValues();
    private int groupByColumn = -1;
    private int countColumn = -1;
    private String countValue;
    private int countValueIndex = -1;
    private boolean showBarLabelsFlag = false;
    private boolean showCumulativeLabelsFlag = false;
    private int sortingDirectionIndex;
    private static final String[] SORTING_DIRECTIONS = new String[]{"Descending Keys", "Ascending Keys", "Descending Values", "Ascending Values"};
    public static final int KEYS_DESCENDING = 0;
    public static final int KEYS_ASCENDING = 1;
    public static final int VALUES_DESCENDING = 2;
    public static final int VALUES_ASCENDING = 3;
    private ListeningJComboBox countValues;
    private ListeningJComboBox sortingDirection;
    private ListeningJCheckBox showCumulativeLabels;
    private ListeningJCheckBox showBarLabels;

    public ParetoChartPlotter(final PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
        this.countValues = new ListeningJComboBox(PARAMETER_COUNT_VALUE, 200);
        this.countValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ParetoChartPlotter.this.countValues.getSelectedItem() != null) {
                    settings.setParameterAsString(ParetoChartPlotter.PARAMETER_COUNT_VALUE, ParetoChartPlotter.this.countValues.getSelectedItem().toString());
                }
            }
        });
        this.sortingDirection = new ListeningJComboBox(settings, PARAMETER_SORTING_DIRECTION, SORTING_DIRECTIONS);
        this.sortingDirection.setSelectedIndex(0);
        this.sortingDirection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.setParameterAsInt(ParetoChartPlotter.PARAMETER_SORTING_DIRECTION, ParetoChartPlotter.this.sortingDirection.getSelectedIndex());
            }
        });
        this.showBarLabels = new ListeningJCheckBox(PARAMETER_SHOW_BAR_LABELS, "Show Bar Labels", true);
        this.showBarLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.setParameterAsBoolean(ParetoChartPlotter.PARAMETER_SHOW_BAR_LABELS, ParetoChartPlotter.this.showBarLabels.isSelected());
            }
        });
        this.showCumulativeLabels = new ListeningJCheckBox(PARAMETER_SHOW_CUMULATIVE_LABELS, "Show Cumulative Labels", false);
        this.showCumulativeLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.setParameterAsBoolean(ParetoChartPlotter.PARAMETER_SHOW_CUMULATIVE_LABELS, ParetoChartPlotter.this.showCumulativeLabels.isSelected());
            }
        });
    }

    public ParetoChartPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    private JFreeChart createChart() {
        if (this.data.getItemCount() > 0) {
            KeyedValues cumulative = DataUtilities.getCumulativePercentages((KeyedValues)this.data);
            CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset((Comparable)((Object)("Count for " + this.dataTable.getColumnName(this.countColumn) + " = " + this.countValue)), (KeyedValues)this.data);
            JFreeChart chart = ChartFactory.createBarChart(null, (String)this.dataTable.getColumnName(this.groupByColumn), (String)"Count", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.WHITE);
            CategoryPlot plot = chart.getCategoryPlot();
            CategoryAxis domainAxis = plot.getDomainAxis();
            domainAxis.setLowerMargin(0.02);
            domainAxis.setUpperMargin(0.02);
            domainAxis.setLabelFont(LABEL_FONT_BOLD);
            domainAxis.setTickLabelFont(LABEL_FONT);
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits((Locale)Locale.US));
            rangeAxis.setLabelFont(LABEL_FONT_BOLD);
            rangeAxis.setTickLabelFont(LABEL_FONT);
            CategoryDataset dataset2 = DatasetUtilities.createCategoryDataset((Comparable)((Object)"Cumulative (Percent)"), (KeyedValues)cumulative);
            LineAndShapeRenderer renderer2 = new LineAndShapeRenderer();
            renderer2.setSeriesPaint(0, (Paint)SwingTools.VERY_DARK_BLUE.darker());
            NumberAxis axis2 = new NumberAxis("Percent of " + this.countValue);
            axis2.setNumberFormatOverride(NumberFormat.getPercentInstance());
            axis2.setLabelFont(LABEL_FONT_BOLD);
            axis2.setTickLabelFont(LABEL_FONT);
            plot.setRangeAxis(1, (ValueAxis)axis2);
            plot.setDataset(1, dataset2);
            plot.setRenderer(1, (CategoryItemRenderer)renderer2);
            plot.mapDatasetToRangeAxis(1, 1);
            axis2.setTickUnit(new NumberTickUnit(0.1));
            plot.setRangeGridlinesVisible(true);
            plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
            if (this.isLabelRotating()) {
                domainAxis.setTickLabelsVisible(true);
                domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.5707963267948966));
            }
            return chart;
        }
        return null;
    }

    private void updateValueBox() {
        this.countValues.removeAllItems();
        if (this.dataTable.isNominal(this.countColumn)) {
            int numberOfValues = this.dataTable.getNumberOfValues(this.countColumn);
            for (int i = 0; i < numberOfValues; ++i) {
                this.countValues.addItem(this.dataTable.mapIndex(this.countColumn, i));
            }
            if (this.countValue != null) {
                this.countValues.setSelectedItem(this.countValue);
            }
        }
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.repaint();
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.countColumn = plot ? index : -1;
        this.updateValueBox();
        this.repaint();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.countColumn == index;
    }

    @Override
    public String getPlotName() {
        return "Count Column";
    }

    @Override
    public int getNumberOfAxes() {
        return 1;
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (index == 0) {
            this.groupByColumn = dimension;
        }
        this.repaint();
    }

    @Override
    public int getAxis(int index) {
        if (index == 0) {
            return this.groupByColumn;
        }
        return -1;
    }

    @Override
    public String getAxisName(int index) {
        if (index == 0) {
            return "Group-By Column";
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareData() {
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            this.data.clear();
            if (this.groupByColumn < 0 || this.countColumn < 0 || this.countValueIndex < 0) {
                return;
            }
            if (!this.dataTable.isNominal(this.groupByColumn)) {
                return;
            }
            if (!this.dataTable.isNominal(this.countColumn)) {
                return;
            }
            HashMap<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();
            HashMap<String, AtomicInteger> totalCounters = new HashMap<String, AtomicInteger>();
            for (int v = 0; v < this.dataTable.getNumberOfValues(this.groupByColumn); ++v) {
                String groupByValue = this.dataTable.mapIndex(this.groupByColumn, v);
                counters.put(groupByValue, new AtomicInteger(0));
                totalCounters.put(groupByValue, new AtomicInteger(0));
            }
            for (DataTableRow row : this.dataTable) {
                String groupByValue = this.dataTable.getValueAsString(row, this.groupByColumn);
                String countValue = this.dataTable.getValueAsString(row, this.countColumn);
                if (countValue.equals(this.countValue)) {
                    ((AtomicInteger)counters.get(groupByValue)).getAndIncrement();
                }
                ((AtomicInteger)totalCounters.get(groupByValue)).getAndIncrement();
            }
            for (Map.Entry entry : counters.entrySet()) {
                String category = (String)entry.getKey();
                int categoryCount = ((AtomicInteger)entry.getValue()).intValue();
                int totalCount = ((AtomicInteger)totalCounters.get(category)).intValue();
                this.data.addValue((Comparable)((Object)category), (double)categoryCount);
                this.totalData.addValue((Comparable)((Object)category), (double)totalCount);
            }
            switch (this.sortingDirectionIndex) {
                case 0: {
                    this.data.sortByKeys(SortOrder.DESCENDING);
                    this.totalData.sortByKeys(SortOrder.DESCENDING);
                    break;
                }
                case 1: {
                    this.data.sortByKeys(SortOrder.ASCENDING);
                    this.totalData.sortByKeys(SortOrder.ASCENDING);
                    break;
                }
                case 2: {
                    this.data.sortByValues(SortOrder.DESCENDING);
                    this.totalData.sortByValues(SortOrder.DESCENDING);
                    break;
                }
                case 3: {
                    this.data.sortByValues(SortOrder.ASCENDING);
                    this.totalData.sortByValues(SortOrder.ASCENDING);
                }
            }
        }
    }

    @Override
    protected void updatePlotter() {
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintParetoChart(g);
    }

    public void paintParetoChart(Graphics graphics) {
        this.prepareData();
        JFreeChart chart = this.createChart();
        if (chart != null) {
            chart.setBackgroundPaint((Paint)Color.white);
            chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
            CategoryPlot plot = chart.getCategoryPlot();
            BarRenderer renderer = (BarRenderer)plot.getRenderer();
            renderer.setBarPainter((BarPainter)new RapidBarPainter());
            renderer.setSeriesPaint(0, (Paint)this.getColorProvider().getPointColor(1.0));
            HashMap<String, String> barItemLabels = new HashMap<String, String>();
            HashMap<String, String> cumulativeItemLabels = new HashMap<String, String>();
            int groupSum = 0;
            int totalSum = 0;
            for (Object key : this.totalData.getKeys()) {
                String k = (String)key;
                try {
                    Number groupValue = this.data.getValue((Comparable)((Object)k));
                    Number totalValue = this.totalData.getValue((Comparable)((Object)k));
                    barItemLabels.put(k, Tools.formatIntegerIfPossible(groupValue.doubleValue()) + " / " + Tools.formatIntegerIfPossible(totalValue.doubleValue()));
                    cumulativeItemLabels.put(k, (groupSum += groupValue.intValue()) + " / " + (totalSum += totalValue.intValue()));
                }
                catch (UnknownKeyException e) {}
            }
            renderer.setSeriesItemLabelFont(0, LABEL_FONT);
            if (this.showBarLabelsFlag) {
                renderer.setSeriesItemLabelsVisible(0, true);
                renderer.setSeriesItemLabelGenerator(0, (CategoryItemLabelGenerator)new ParetoChartItemLabelGenerator(barItemLabels));
                if (this.isLabelRotating()) {
                    renderer.setSeriesPositiveItemLabelPosition(0, new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, -1.5707963267948966));
                    renderer.setSeriesNegativeItemLabelPosition(0, new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, -1.5707963267948966));
                }
            }
            LineAndShapeRenderer renderer2 = (LineAndShapeRenderer)chart.getCategoryPlot().getRenderer(1);
            renderer2.setSeriesItemLabelFont(0, LABEL_FONT);
            renderer2.setSeriesItemLabelPaint(0, (Paint)SwingTools.VERY_DARK_BLUE.darker());
            if (this.isLabelRotating()) {
                renderer2.setSeriesPositiveItemLabelPosition(0, new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.CENTER_RIGHT, TextAnchor.CENTER_RIGHT, -1.5707963267948966));
                renderer2.setSeriesNegativeItemLabelPosition(0, new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.CENTER_RIGHT, TextAnchor.CENTER_RIGHT, -1.5707963267948966));
            } else {
                renderer2.setSeriesPositiveItemLabelPosition(0, new ItemLabelPosition(ItemLabelAnchor.OUTSIDE10, TextAnchor.BOTTOM_RIGHT));
                renderer2.setSeriesNegativeItemLabelPosition(0, new ItemLabelPosition(ItemLabelAnchor.OUTSIDE10, TextAnchor.BOTTOM_RIGHT));
            }
            if (this.showCumulativeLabelsFlag) {
                renderer2.setSeriesItemLabelsVisible(0, true);
                renderer2.setSeriesItemLabelGenerator(0, (CategoryItemLabelGenerator)new ParetoChartItemLabelGenerator(cumulativeItemLabels));
            }
            renderer.setDrawBarOutline(true);
            plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
            LegendTitle legend = chart.getLegend();
            if (legend != null) {
                legend.setPosition(RectangleEdge.TOP);
                legend.setFrame((BlockFrame)BlockBorder.NONE);
                legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
                legend.setItemFont(LABEL_FONT);
            }
            Rectangle2D.Double drawRect = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
            chart.draw((Graphics2D)graphics, (Rectangle2D)drawRect);
        }
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        switch (index) {
            case 0: {
                JLabel label = new JLabel("Count Value:");
                label.setToolTipText("Select the value which should be counted in the count dimension.");
                return label;
            }
            case 1: {
                return this.countValues;
            }
            case 2: {
                JLabel label = new JLabel("Sorting Direction:");
                label.setToolTipText("Select the sorting type and direction.");
                return label;
            }
            case 3: {
                return this.sortingDirection;
            }
            case 4: {
                return this.showBarLabels;
            }
            case 5: {
                return this.showCumulativeLabels;
            }
            case 6: {
                return this.getRotateLabelComponent();
            }
        }
        return null;
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys(InputPort inputPort) {
        MetaData metaData;
        List<ParameterType> types = super.getAdditionalParameterKeys(inputPort);
        boolean inputDeliversAttributes = false;
        if (inputPort != null && (metaData = inputPort.getMetaData()) != null && (metaData instanceof ExampleSetMetaData || metaData instanceof ModelMetaData)) {
            inputDeliversAttributes = true;
        }
        if (inputDeliversAttributes) {
            types.add(new ParameterTypeAttribute(PARAMETER_COUNT_VALUE, "The value which should be counted.", inputPort, false));
        } else {
            types.add(new ParameterTypeString(PARAMETER_COUNT_VALUE, "The value which should be counted.", false));
        }
        types.add(new ParameterTypeCategory(PARAMETER_SORTING_DIRECTION, "The direction of sorting.", SORTING_DIRECTIONS, 0));
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_BAR_LABELS, "Indicates if the bar labels should be displayed.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_CUMULATIVE_LABELS, "Indicates if the cumulative labels should be displayed.", false));
        return types;
    }

    @Override
    public List<PlotterConfigurationModel.PlotterSettingsChangedListener> getListeningObjects() {
        List<PlotterConfigurationModel.PlotterSettingsChangedListener> list = super.getListeningObjects();
        list.add(this.sortingDirection);
        list.add(this.showBarLabels);
        list.add(this.showCumulativeLabels);
        return list;
    }

    @Override
    public void setAdditionalParameter(String key, String value) {
        super.setAdditionalParameter(key, value);
        if (PARAMETER_COUNT_VALUE.equals(key)) {
            if (this.countColumn > -1) {
                this.countValue = value.toString();
                if (this.dataTable.isNominal(this.countColumn)) {
                    int numberOfValues = this.dataTable.getNumberOfValues(this.countColumn);
                    for (int i = 0; i < numberOfValues; ++i) {
                        if (!this.countValue.equals(this.dataTable.mapIndex(this.countColumn, i))) continue;
                        this.countValueIndex = i;
                        break;
                    }
                    this.repaint();
                }
            }
        } else if (PARAMETER_SORTING_DIRECTION.equals(key)) {
            for (int i = 0; i < SORTING_DIRECTIONS.length; ++i) {
                this.sortingDirectionIndex = (int)Double.parseDouble(value);
            }
            this.repaint();
        } else if (PARAMETER_SHOW_BAR_LABELS.equals(key)) {
            this.showBarLabelsFlag = Boolean.parseBoolean(value);
            this.repaint();
        } else if (PARAMETER_SHOW_CUMULATIVE_LABELS.equals(key)) {
            this.showCumulativeLabelsFlag = Boolean.parseBoolean(value);
            this.repaint();
        }
    }

    @Override
    public String getPlotterName() {
        return "Pareto";
    }
}

