/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.LocalNormalizationPlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.gui.plotter.charts.ChartPanelShiftController;
import com.rapidminer.gui.plotter.charts.ColorizedLineAndShapeRenderer;
import com.rapidminer.gui.plotter.charts.WeightBasedSymbolAxis;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.BlockResult;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public class ParallelPlotter2
extends LocalNormalizationPlotterAdapter {
    private static final long serialVersionUID = -8763693366081949249L;
    private transient DataTable dataTable;
    private XYSeriesCollection dataset = null;
    private int colorColumn = -1;
    private String[] domainAxisMap = null;
    private ChartPanel panel = new ChartPanel(null);
    private double[] colorMap = null;

    public ParallelPlotter2(PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
    }

    public ParallelPlotter2(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public JComponent getPlotter() {
        return this.panel;
    }

    private static JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        ValueAxis valueAxis = plot.getRangeAxis();
        valueAxis.setLabelFont(LABEL_FONT_BOLD);
        valueAxis.setTickLabelFont(LABEL_FONT);
        return chart;
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.updatePlotter();
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.colorColumn = plot ? index : -1;
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.colorColumn == index;
    }

    @Override
    public String getPlotName() {
        return "Color Column";
    }

    @Override
    public int getNumberOfAxes() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareData() {
        DataTable c2;
        this.dataset = new XYSeriesCollection();
        int columns = this.dataTable.getNumberOfColumns();
        double[] min = new double[columns];
        double[] max = new double[columns];
        if (this.isLocalNormalized()) {
            for (int c2 = 0; c2 < columns; ++c2) {
                min[c2] = Double.POSITIVE_INFINITY;
                max[c2] = Double.NEGATIVE_INFINITY;
            }
            c2 = this.dataTable;
            synchronized (c2) {
                for (DataTableRow row : this.dataTable) {
                    for (int c3 = 0; c3 < this.dataTable.getNumberOfColumns(); ++c3) {
                        double value = row.getValue(c3);
                        min[c3] = MathFunctions.robustMin(min[c3], value);
                        max[c3] = MathFunctions.robustMax(max[c3], value);
                    }
                }
            }
        }
        this.domainAxisMap = null;
        c2 = this.dataTable;
        synchronized (c2) {
            this.colorMap = new double[this.dataTable.getNumberOfRows()];
            Iterator<DataTableRow> i = this.dataTable.iterator();
            int idCounter = 0;
            while (i.hasNext()) {
                DataTableRow row = i.next();
                String id = row.getId();
                if (id == null) {
                    id = idCounter + 1 + "";
                }
                XYSeries series = new XYSeries((Comparable)((Object)id), false, false);
                int counter = 0;
                for (int column = 0; column < this.dataTable.getNumberOfColumns(); ++column) {
                    if (this.dataTable.isSpecial(column) || column == this.colorColumn) continue;
                    double value = row.getValue(column);
                    if (this.isLocalNormalized()) {
                        value = (value - min[column]) / (max[column] - min[column]);
                    }
                    series.add((double)counter, value);
                    ++counter;
                }
                if (this.colorColumn >= 0) {
                    this.colorMap[idCounter] = row.getValue(this.colorColumn);
                }
                this.dataset.addSeries(series);
                ++idCounter;
            }
        }
        if (this.domainAxisMap == null) {
            LinkedList<String> domainValues = new LinkedList<String>();
            int counter = 0;
            for (int column = 0; column < this.dataTable.getNumberOfColumns(); ++column) {
                if (this.dataTable.isSpecial(column) || column == this.colorColumn) continue;
                domainValues.add(this.dataTable.getColumnName(column));
                ++counter;
            }
            this.domainAxisMap = new String[domainValues.size()];
            domainValues.toArray(this.domainAxisMap);
        }
    }

    @Override
    public void updatePlotter() {
        this.prepareData();
        JFreeChart chart = ParallelPlotter2.createChart((XYDataset)this.dataset);
        chart.setAntiAlias(false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        SymbolAxis axis = null;
        if (this.dataTable.isSupportingColumnWeights()) {
            LinkedList<Double> weightList = new LinkedList<Double>();
            for (int column = 0; column < this.dataTable.getNumberOfColumns(); ++column) {
                if (this.dataTable.isSpecial(column) || column == this.colorColumn) continue;
                weightList.add(this.dataTable.getColumnWeight(column));
            }
            double[] weights = new double[weightList.size()];
            int index = 0;
            for (Double d : weightList) {
                weights[index++] = d;
            }
            axis = new WeightBasedSymbolAxis(null, this.domainAxisMap, weights);
        } else {
            axis = new SymbolAxis(null, this.domainAxisMap);
        }
        axis.setTickLabelFont(LABEL_FONT);
        axis.setLabelFont(LABEL_FONT_BOLD);
        if (this.isLabelRotating()) {
            axis.setTickLabelsVisible(true);
            axis.setVerticalTickLabels(true);
        }
        chart.getXYPlot().setDomainAxis((ValueAxis)axis);
        final ColorizedLineAndShapeRenderer renderer = new ColorizedLineAndShapeRenderer(this.colorMap);
        plot.setRenderer((XYItemRenderer)renderer);
        if (this.colorColumn >= 0 && this.dataTable.isNominal(this.colorColumn)) {
            final LegendItemCollection legendItemCollection = new LegendItemCollection();
            for (int i = 0; i < this.dataTable.getNumberOfValues(this.colorColumn); ++i) {
                legendItemCollection.add(new LegendItem(this.dataTable.mapIndex(this.colorColumn, i), null, null, null, (Shape)new Rectangle2D.Double(0.0, 0.0, 7.0, 7.0), (Paint)this.getColorProvider().getPointColor((double)i / (double)(this.dataTable.getNumberOfValues(this.colorColumn) - 1)), (Stroke)new BasicStroke(0.75f), (Paint)Color.GRAY));
            }
            chart.addLegend(new LegendTitle(new LegendItemSource(){

                public LegendItemCollection getLegendItems() {
                    return legendItemCollection;
                }
            }));
            LegendTitle legend = chart.getLegend();
            if (legend != null) {
                legend.setPosition(RectangleEdge.TOP);
                legend.setFrame((BlockFrame)BlockBorder.NONE);
                legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
                legend.setItemFont(LABEL_FONT);
            }
        } else if (this.colorColumn >= 0) {
            chart.addLegend(new LegendTitle(new LegendItemSource(){

                public LegendItemCollection getLegendItems() {
                    LegendItemCollection itemCollection = new LegendItemCollection();
                    itemCollection.add(new LegendItem("Dummy"));
                    return itemCollection;
                }
            }){
                private static final long serialVersionUID = 1288380309936848376L;

                public Object draw(Graphics2D g2, Rectangle2D area, Object params) {
                    if (ParallelPlotter2.this.dataTable.isDate(ParallelPlotter2.this.colorColumn) || ParallelPlotter2.this.dataTable.isTime(ParallelPlotter2.this.colorColumn) || ParallelPlotter2.this.dataTable.isDateTime(ParallelPlotter2.this.colorColumn)) {
                        ParallelPlotter2.this.drawSimpleDateLegend(g2, (int)(area.getCenterX() - 170.0), (int)(area.getCenterY() + 7.0), ParallelPlotter2.this.dataTable, ParallelPlotter2.this.colorColumn, renderer.getMinColorValue(), renderer.getMaxColorValue());
                        return new BlockResult();
                    }
                    String minColorString = Tools.formatNumber(renderer.getMinColorValue());
                    String maxColorString = Tools.formatNumber(renderer.getMaxColorValue());
                    ParallelPlotter2.this.drawSimpleNumericalLegend(g2, (int)(area.getCenterX() - 90.0), (int)(area.getCenterY() + 7.0), ParallelPlotter2.this.dataTable.getColumnName(ParallelPlotter2.this.colorColumn), minColorString, maxColorString);
                    return new BlockResult();
                }

                public void draw(Graphics2D g2, Rectangle2D area) {
                    this.draw(g2, area, null);
                }
            });
        }
        if (this.panel instanceof AbstractChartPanel) {
            this.panel.setChart(chart);
        } else {
            this.panel = new AbstractChartPanel(chart, this.getWidth(), this.getHeight() - 20);
            ChartPanelShiftController controller = new ChartPanelShiftController(this.panel);
            this.panel.addMouseListener((MouseListener)controller);
            this.panel.addMouseMotionListener((MouseMotionListener)controller);
        }
        this.panel.getChartRenderingInfo().setEntityCollection(null);
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.getLocalNormalizationComponent();
        }
        if (index == 1) {
            return this.getRotateLabelComponent();
        }
        return null;
    }

    @Override
    public String getPlotterName() {
        return "Parallel";
    }
}

