/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.RangeablePlotterAdapter;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.tools.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.Icon;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class MultipleSeriesChartPlotter
extends RangeablePlotterAdapter {
    private static final long serialVersionUID = -8763693366081949249L;
    private static final String SERIESINDEX_LABEL = "index";
    private transient DataTable dataTable;
    private int indexAxis = -1;
    private boolean[] columns;

    public MultipleSeriesChartPlotter(PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
    }

    public MultipleSeriesChartPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JFreeChart createChart() {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        if (this.indexAxis >= 0 && !this.dataTable.isNominal(this.indexAxis)) {
            if (this.dataTable.isDate(this.indexAxis) || this.dataTable.isDateTime(this.indexAxis)) {
                DateAxis domainAxis = new DateAxis(this.dataTable.getColumnName(this.indexAxis));
                domainAxis.setTimeZone(Tools.getPreferredTimeZone());
                chart.getXYPlot().setDomainAxis((ValueAxis)domainAxis);
            }
        } else {
            plot.getDomainAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits((Locale)Locale.US));
            ((NumberAxis)plot.getDomainAxis()).setAutoRangeStickyZero(false);
            ((NumberAxis)plot.getDomainAxis()).setAutoRangeIncludesZero(false);
        }
        ValueAxis xAxis = plot.getDomainAxis();
        if (this.indexAxis > -1) {
            xAxis.setLabel(this.getDataTable().getColumnName(this.indexAxis));
        } else {
            xAxis.setLabel(SERIESINDEX_LABEL);
        }
        xAxis.setAutoRange(true);
        xAxis.setLabelFont(LABEL_FONT_BOLD);
        xAxis.setTickLabelFont(LABEL_FONT);
        xAxis.setVerticalTickLabels(this.isLabelRotating());
        if (this.indexAxis > 0) {
            if (this.getRangeForDimension(this.indexAxis) != null) {
                xAxis.setRange(this.getRangeForDimension(this.indexAxis));
            }
        } else if (this.getRangeForName(SERIESINDEX_LABEL) != null) {
            xAxis.setRange(this.getRangeForName(SERIESINDEX_LABEL));
        }
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            int numberOfSelectedColumns = 0;
            for (int c = 0; c < this.dataTable.getNumberOfColumns(); ++c) {
                if (!this.getPlotColumn(c) || !this.dataTable.isNumerical(c)) continue;
                ++numberOfSelectedColumns;
            }
            int columnCount = 0;
            for (int c = 0; c < this.dataTable.getNumberOfColumns(); ++c) {
                if (!this.getPlotColumn(c) || !this.dataTable.isNumerical(c)) continue;
                XYSeriesCollection dataset = new XYSeriesCollection();
                XYSeries series = new XYSeries((Comparable)((Object)this.dataTable.getColumnName(c)));
                Iterator<DataTableRow> i = this.dataTable.iterator();
                int index = 1;
                while (i.hasNext()) {
                    DataTableRow row = i.next();
                    double value = row.getValue(c);
                    if (this.indexAxis >= 0 && !this.dataTable.isNominal(this.indexAxis)) {
                        double indexValue = row.getValue(this.indexAxis);
                        series.add(indexValue, value);
                        continue;
                    }
                    series.add((double)index++, value);
                }
                dataset.addSeries(series);
                XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
                Color color = this.getColorProvider().getPointColor(1.0);
                if (numberOfSelectedColumns > 1) {
                    color = this.getColorProvider().getPointColor((double)columnCount / (double)(numberOfSelectedColumns - 1));
                }
                renderer.setSeriesPaint(0, (Paint)color);
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.5f, 1, 1));
                renderer.setSeriesShapesVisible(0, false);
                NumberAxis yAxis = new NumberAxis(this.dataTable.getColumnName(c));
                if (this.getRangeForDimension(c) != null) {
                    yAxis.setRange(this.getRangeForDimension(c));
                } else {
                    yAxis.setAutoRange(true);
                    yAxis.setAutoRangeStickyZero(false);
                    yAxis.setAutoRangeIncludesZero(false);
                }
                yAxis.setLabelFont(LABEL_FONT_BOLD);
                yAxis.setTickLabelFont(LABEL_FONT);
                if (numberOfSelectedColumns > 1) {
                    yAxis.setAxisLinePaint((Paint)color);
                    yAxis.setTickMarkPaint((Paint)color);
                    yAxis.setLabelPaint((Paint)color);
                    yAxis.setTickLabelPaint((Paint)color);
                }
                plot.setRangeAxis(columnCount, (ValueAxis)yAxis);
                plot.setRangeAxisLocation(columnCount, AxisLocation.TOP_OR_LEFT);
                plot.setDataset(columnCount, (XYDataset)dataset);
                plot.setRenderer(columnCount, (XYItemRenderer)renderer);
                plot.mapDatasetToRangeAxis(columnCount, columnCount);
                ++columnCount;
            }
        }
        chart.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    @Override
    public Icon getIcon(int index) {
        return null;
    }

    @Override
    public int getValuePlotSelectionType() {
        return 1;
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        if (index >= 0 && index < this.columns.length) {
            this.columns[index] = plot;
        }
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    @Override
    public String getPlotName() {
        return "Plot Series";
    }

    @Override
    public int getNumberOfAxes() {
        return 1;
    }

    @Override
    public String getAxisName(int index) {
        if (index == 0) {
            return "Index Dimension";
        }
        return "none";
    }

    @Override
    public int getAxis(int index) {
        if (index == 0) {
            return this.indexAxis;
        }
        return -1;
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (index == 0) {
            this.indexAxis = dimension;
            this.updatePlotter();
        }
    }

    @Override
    protected void updatePlotter() {
        JFreeChart chart = this.createChart();
        AbstractChartPanel panel = this.getPlotterPanel();
        if (panel == null) {
            panel = this.createPanel(chart);
        }
        panel.setChart(chart);
        panel.getChartRenderingInfo().setEntityCollection(null);
    }

    @Override
    public String getPlotterName() {
        return "Series Multiple";
    }

    @Override
    public void dataTableSet() {
        this.dataTable = this.getDataTable();
        this.columns = new boolean[this.dataTable.getNumberOfColumns()];
        this.updatePlotter();
    }

    @Override
    public Collection<String> resolveXAxis(int axisIndex) {
        if (this.indexAxis != -1) {
            return Collections.singletonList(this.dataTable.getColumnName(this.indexAxis));
        }
        return Collections.singletonList(SERIESINDEX_LABEL);
    }

    @Override
    public Collection<String> resolveYAxis(int axisIndex) {
        LinkedList<String> names = new LinkedList<String>();
        int foundAxis = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i]) continue;
            if (axisIndex == foundAxis) {
                names.add(this.dataTable.getColumnName(i));
                break;
            }
            ++foundAxis;
        }
        return names;
    }
}

