/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.LabelRotatingPlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.gui.plotter.charts.ChartPanelShiftController;
import com.rapidminer.gui.plotter.charts.PointsAndLinesDialog;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.tools.ObjectVisualizerService;
import com.rapidminer.tools.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public class MultipleScatterPlotter
extends LabelRotatingPlotterAdapter {
    private static final long serialVersionUID = 4568273282283350833L;
    public static final String PARAMETER_POINTS_AND_LINES = "points_and_lines";
    public static final String PARAMETER_LINES = "show_lines";
    public static final String PARAMETER_POINTS = "show_points";
    private transient DataTable dataTable;
    private XYDataset dataSet = new DefaultXYDataset();
    private int xAxis = -1;
    private boolean[] plotColumns;
    private int jitterAmount = 0;
    private boolean xLogScale = false;
    private List<Integer> plotIndexToColumnIndexMap = new ArrayList<Integer>();
    private Map<SeriesAndItem, String> idMap = new HashMap<SeriesAndItem, String>();
    private ChartPanel panel = new ChartPanel(null);
    private JButton pointsAndLinesOptions = new JButton("Points and Lines...");
    private boolean[] showPoints;
    private boolean[] showLines;

    public MultipleScatterPlotter(PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
        this.pointsAndLinesOptions.setToolTipText("Opens a dialog where the draw type (points, lines, or points and lines) for each dimension can be specified.");
        this.pointsAndLinesOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleScatterPlotter.this.showPointsAndLinesOptions();
            }
        });
    }

    public MultipleScatterPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.plotColumns = new boolean[dataTable.getNumberOfColumns()];
        this.showLines = new boolean[dataTable.getNumberOfColumns()];
        this.showPoints = new boolean[dataTable.getNumberOfColumns()];
        for (int i = 0; i < this.showLines.length; ++i) {
            this.showLines[i] = false;
            this.showPoints[i] = true;
        }
        this.updatePlotter();
    }

    @Override
    public int getValuePlotSelectionType() {
        return 1;
    }

    @Override
    public Icon getIcon(int index) {
        return null;
    }

    private void showPointsAndLinesOptions() {
        String[] names = new String[this.dataTable.getNumberOfColumns()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.dataTable.getColumnName(i);
        }
        PointsAndLinesDialog dialog = new PointsAndLinesDialog(names, this.showPoints, this.showLines);
        dialog.setVisible(true);
        if (dialog.isOk()) {
            ArrayList<String[]> selectedValues = new ArrayList<String[]>(names.length);
            for (int i = 0; i < names.length; ++i) {
                String[] selected = new String[]{dialog.showPoints(i) + "", dialog.showLines(i) + ""};
                selectedValues.add(selected);
            }
            this.settings.setParameterAsString(PARAMETER_POINTS_AND_LINES, ParameterTypeList.transformList2String(selectedValues));
        }
    }

    public void setShowLines(int index, boolean show) {
        this.showLines[index] = show;
    }

    public void setShowPoints(int index, boolean show) {
        this.showPoints[index] = show;
    }

    @Override
    public boolean canHandleJitter() {
        return true;
    }

    @Override
    public void setJitter(int jitter) {
        this.jitterAmount = jitter;
        this.updatePlotter();
    }

    @Override
    public boolean isSupportingLogScale(int axis) {
        return axis == 0;
    }

    @Override
    public void setLogScale(int axis, boolean logScale) {
        if (axis == 0) {
            this.xLogScale = logScale;
            this.updatePlotter();
        }
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.plotColumns[index] = plot;
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.plotColumns[index];
    }

    @Override
    public String getPlotName() {
        return "y-Axis";
    }

    @Override
    public int getNumberOfAxes() {
        return 1;
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (index == 0) {
            this.xAxis = dimension;
            this.updatePlotter();
        }
    }

    @Override
    public int getAxis(int index) {
        if (index == 0) {
            return this.xAxis;
        }
        return -1;
    }

    @Override
    public String getAxisName(int index) {
        if (index == 0) {
            return "x-Axis";
        }
        return "None";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareData() {
        this.idMap.clear();
        this.plotIndexToColumnIndexMap.clear();
        this.dataSet = new DefaultXYDataset();
        if (this.xAxis >= 0) {
            LinkedHashMap<String, List<double[]>> dataCollection = new LinkedHashMap<String, List<double[]>>();
            LinkedHashMap<String, List<String>> idCollection = new LinkedHashMap<String, List<String>>();
            DataTable dataTable = this.dataTable;
            synchronized (dataTable) {
                for (int column = 0; column < this.plotColumns.length; ++column) {
                    if (!this.plotColumns[column]) continue;
                    this.plotIndexToColumnIndexMap.add(column);
                    String columnName = this.dataTable.getColumnName(column);
                    Iterator<DataTableRow> i = this.dataTable.iterator();
                    int index = 0;
                    while (i.hasNext()) {
                        DataTableRow row = i.next();
                        double xValue = row.getValue(this.xAxis);
                        double yValue = row.getValue(column);
                        if (!Double.isNaN(xValue) && !Double.isNaN(yValue)) {
                            this.addPoint(dataCollection, idCollection, row.getId(), xValue, yValue, columnName);
                        }
                        ++index;
                    }
                }
            }
            double minX = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            for (Map.Entry entry : dataCollection.entrySet()) {
                List dataList = (List)entry.getValue();
                for (double[] current : dataList) {
                    minX = Math.min(minX, current[0]);
                    maxX = Math.max(maxX, current[0]);
                    minY = Math.min(minY, current[1]);
                    maxY = Math.max(maxY, current[1]);
                }
            }
            Random jitterRandom = new Random(2001L);
            double oldXRange = maxX - minX;
            double oldYRange = maxY - minY;
            if (Double.isInfinite(oldXRange) || Double.isNaN(oldXRange)) {
                oldXRange = 0.0;
            }
            if (Double.isInfinite(oldYRange) || Double.isNaN(oldYRange)) {
                oldYRange = 0.0;
            }
            for (Map.Entry entry : dataCollection.entrySet()) {
                String seriesName = (String)entry.getKey();
                List dataList = (List)entry.getValue();
                double[][] data = new double[2][dataList.size()];
                int listCounter = 0;
                for (double[] current : dataList) {
                    data[0][listCounter] = current[0];
                    data[1][listCounter] = current[1];
                    if (this.jitterAmount > 0) {
                        double pertX = oldXRange * ((double)this.jitterAmount / 200.0) * jitterRandom.nextGaussian();
                        double pertY = oldYRange * ((double)this.jitterAmount / 200.0) * jitterRandom.nextGaussian();
                        double[] dArray = data[0];
                        int n = listCounter;
                        dArray[n] = dArray[n] + pertX;
                        double[] dArray2 = data[1];
                        int n2 = listCounter;
                        dArray2[n2] = dArray2[n2] + pertY;
                    }
                    ++listCounter;
                }
                ((DefaultXYDataset)this.dataSet).addSeries((Comparable)((Object)seriesName), data);
            }
            int seriesCounter = 0;
            for (List idList : idCollection.values()) {
                int itemCounter = 0;
                Iterator j = idList.iterator();
                while (j.hasNext()) {
                    this.idMap.put(new SeriesAndItem(seriesCounter, itemCounter++), (String)j.next());
                }
                ++seriesCounter;
            }
        }
    }

    private void addPoint(Map<String, List<double[]>> dataCollection, Map<String, List<String>> idCollection, String id, double x, double y, String columnName) {
        List<double[]> dataList = null;
        List<String> idList = null;
        dataList = dataCollection.get(columnName);
        if (dataList == null) {
            dataList = new LinkedList<double[]>();
            dataCollection.put(columnName, dataList);
        }
        if ((idList = idCollection.get(columnName)) == null) {
            idList = new LinkedList<String>();
            idCollection.put(columnName, idList);
        }
        dataList.add(new double[]{x, y});
        idList.add(id);
    }

    @Override
    public JComponent getPlotter() {
        return this.panel;
    }

    @Override
    public void updatePlotter() {
        int size;
        this.prepareData();
        JFreeChart chart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        if (this.xAxis >= 0) {
            size = this.dataSet.getSeriesCount();
            chart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)chart.getXYPlot().getRenderer();
            renderer.setBaseOutlinePaint((Paint)Color.BLACK);
            renderer.setUseOutlinePaint(true);
            renderer.setDrawOutlines(true);
            for (int i = 0; i < size; ++i) {
                renderer.setSeriesShapesVisible(i, this.showPoints[this.plotIndexToColumnIndexMap.get(i)]);
                renderer.setSeriesLinesVisible(i, this.showLines[this.plotIndexToColumnIndexMap.get(i)]);
            }
            renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-3.0, -3.0, 7.0, 7.0));
            LegendTitle legend = chart.getLegend();
            if (legend != null) {
                legend.setPosition(RectangleEdge.TOP);
                legend.setFrame((BlockFrame)BlockBorder.NONE);
                legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
                legend.setItemFont(LABEL_FONT);
            }
        }
        if ((size = this.dataSet.getSeriesCount()) <= 1) {
            chart.getXYPlot().getRenderer().setSeriesPaint(0, (Paint)this.getColorProvider().getPointColor(1.0));
        } else {
            for (int i = 0; i < this.dataSet.getSeriesCount(); ++i) {
                chart.getXYPlot().getRenderer().setSeriesStroke(i, (Stroke)new BasicStroke(1.5f, 1, 1));
                chart.getXYPlot().getRenderer().setSeriesPaint(i, (Paint)this.getColorProvider().getPointColor((double)i / (double)(this.dataSet.getSeriesCount() - 1)));
            }
        }
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.setAntiAlias(false);
        XYPlot plot = chart.getXYPlot();
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        if (this.xAxis >= 0) {
            DateAxis domainAxis;
            if (this.dataTable.isNominal(this.xAxis)) {
                String[] values = new String[this.dataTable.getNumberOfValues(this.xAxis)];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.dataTable.mapIndex(this.xAxis, i);
                }
                plot.setDomainAxis((ValueAxis)new SymbolAxis(this.dataTable.getColumnName(this.xAxis), values));
            } else if (this.dataTable.isDate(this.xAxis) || this.dataTable.isDateTime(this.xAxis)) {
                domainAxis = new DateAxis(this.dataTable.getColumnName(this.xAxis));
                domainAxis.setTimeZone(Tools.getPreferredTimeZone());
                plot.setDomainAxis((ValueAxis)domainAxis);
            } else if (this.xLogScale) {
                domainAxis = new LogAxis(this.dataTable.getColumnName(this.xAxis));
                domainAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits((Locale)Locale.US));
                plot.setDomainAxis((ValueAxis)domainAxis);
            } else {
                domainAxis = new NumberAxis(this.dataTable.getColumnName(this.xAxis));
                domainAxis.setAutoRangeStickyZero(false);
                domainAxis.setAutoRangeIncludesZero(false);
                plot.setDomainAxis((ValueAxis)domainAxis);
            }
        }
        plot.getDomainAxis().setLabelFont(LABEL_FONT_BOLD);
        plot.getDomainAxis().setTickLabelFont(LABEL_FONT);
        if (this.isLabelRotating()) {
            plot.getDomainAxis().setTickLabelsVisible(true);
            plot.getDomainAxis().setVerticalTickLabels(true);
        }
        plot.getRangeAxis().setLabelFont(LABEL_FONT_BOLD);
        plot.getRangeAxis().setTickLabelFont(LABEL_FONT);
        if (this.panel instanceof AbstractChartPanel) {
            this.panel.setChart(chart);
        } else {
            this.panel = new AbstractChartPanel(chart, this.getWidth(), this.getHeight() - 20);
            ChartPanelShiftController controller = new ChartPanelShiftController(this.panel);
            this.panel.addMouseListener((MouseListener)controller);
            this.panel.addMouseMotionListener((MouseMotionListener)controller);
            this.panel.addChartMouseListener(new ChartMouseListener(){

                public void chartMouseClicked(ChartMouseEvent e) {
                    String id;
                    XYItemEntity entity;
                    if (e.getTrigger().getClickCount() > 1 && (entity = (XYItemEntity)e.getEntity()) != null && (id = (String)MultipleScatterPlotter.this.idMap.get(new SeriesAndItem(entity.getSeriesIndex(), entity.getItem()))) != null) {
                        ObjectVisualizer visualizer = ObjectVisualizerService.getVisualizerForObject(MultipleScatterPlotter.this.dataTable);
                        visualizer.startVisualization(id);
                    }
                }

                public void chartMouseMoved(ChartMouseEvent e) {
                }
            });
        }
        for (int i = 0; i < this.dataSet.getSeriesCount(); ++i) {
            class CustomXYToolTipGenerator
            implements XYToolTipGenerator {
                public String generateToolTip(XYDataset dataset, int row, int column) {
                    String id = (String)MultipleScatterPlotter.this.idMap.get(new SeriesAndItem(row, column));
                    if (id != null) {
                        return "<html><b>Id: " + id + "</b> (" + dataset.getSeriesKey(row) + ", " + Tools.formatIntegerIfPossible(dataset.getXValue(row, column)) + ", " + Tools.formatIntegerIfPossible(dataset.getYValue(row, column)) + ")</html>";
                    }
                    return "<html>(" + dataset.getSeriesKey(row) + ", " + Tools.formatIntegerIfPossible(dataset.getXValue(row, column)) + ", " + Tools.formatIntegerIfPossible(dataset.getYValue(row, column)) + ")</html>";
                }
            }
            plot.getRenderer().setSeriesToolTipGenerator(i, (XYToolTipGenerator)new CustomXYToolTipGenerator());
        }
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys(InputPort inputPort) {
        List<ParameterType> types = super.getAdditionalParameterKeys(inputPort);
        types.add(new ParameterTypeList(PARAMETER_POINTS_AND_LINES, "Describes if points and lines are shown.", (ParameterType)new ParameterTypeBoolean(PARAMETER_POINTS, "If checked, points will be shown.", true), (ParameterType)new ParameterTypeBoolean(PARAMETER_LINES, "If checked, lines will be shown.", false)));
        return types;
    }

    @Override
    public void setAdditionalParameter(String key, String value) {
        super.setAdditionalParameter(key, value);
        if (key.equals(PARAMETER_POINTS_AND_LINES)) {
            List<String[]> valuePairs = ParameterTypeList.transformString2List(value);
            Iterator<String[]> iterator = valuePairs.iterator();
            for (int i = 0; iterator.hasNext() && i < this.showPoints.length; ++i) {
                String[] pair = iterator.next();
                this.showPoints[i] = "true".equals(pair[0]);
                this.showLines[i] = "true".equals(pair[1]);
            }
            this.updatePlotter();
        }
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        switch (index) {
            case 0: {
                return this.getRotateLabelComponent();
            }
            case 1: {
                return this.pointsAndLinesOptions;
            }
        }
        return null;
    }

    @Override
    public String getPlotterName() {
        return "Scatter Multiple";
    }

    public static class SeriesAndItem {
        private int series;
        private int item;

        public SeriesAndItem(int series, int item) {
            this.series = series;
            this.item = item;
        }

        public int hashCode() {
            return Integer.valueOf(this.series).hashCode() ^ Integer.valueOf(this.item).hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof SeriesAndItem)) {
                return false;
            }
            SeriesAndItem s = (SeriesAndItem)o;
            return this.series == s.series && this.item == s.item;
        }
    }
}

