/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.gui.plotter.charts.HistogramChart;
import com.rapidminer.gui.plotter.charts.RapidBarPainter;
import com.rapidminer.gui.plotter.charts.RapidHistogramDataset;
import com.rapidminer.gui.plotter.charts.RapidXYBarPainter;
import com.rapidminer.tools.LogService;
import java.awt.Color;
import java.awt.Paint;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public class HistogramColorChart
extends HistogramChart {
    private static final long serialVersionUID = 9140046811324105445L;
    public static final int MIN_BIN_NUMBER = 2;
    public static final int MAX_BIN_NUMBER = 100;
    public static final int DEFAULT_BIN_NUMBER = 40;
    private HistogramDataset histogramDataset;
    private DefaultCategoryDataset categoryDataset = new DefaultCategoryDataset();
    private boolean nominal = false;
    private int valueColumn = -1;
    private int colorColumn = -1;
    private boolean absolute = false;

    public HistogramColorChart(PlotterConfigurationModel settings) {
        super(settings);
    }

    public HistogramColorChart(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public int getNumberOfAxes() {
        return 1;
    }

    @Override
    public int getAxis(int axis) {
        return this.valueColumn;
    }

    @Override
    public String getAxisName(int index) {
        if (index == 0) {
            return "Histogram";
        }
        return "Unknown";
    }

    @Override
    public boolean isLogScale() {
        return this.logScale;
    }

    @Override
    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
        this.updatePlotter();
    }

    @Override
    public boolean isSupportingAbsoluteValues() {
        return true;
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (this.valueColumn != dimension) {
            this.valueColumn = dimension;
            this.updatePlotter();
        }
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.colorColumn = index;
        this.updatePlotter();
    }

    @Override
    public String getPlotName() {
        return "Color";
    }

    @Override
    public String getPlotterName() {
        return "Histogram Color";
    }

    @Override
    public boolean getPlotColumn(int index) {
        return index == this.colorColumn;
    }

    @Override
    public int getValuePlotSelectionType() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareData() {
        this.histogramDataset = new RapidHistogramDataset(this.isLogScale());
        this.categoryDataset.clear();
        if (this.colorColumn < 0 || this.valueColumn < 0) {
            return;
        }
        if (this.dataTable.isNominal(this.colorColumn)) {
            if (this.dataTable.isNominal(this.valueColumn)) {
                this.nominal = true;
                DataTable dataTable = this.dataTable;
                synchronized (dataTable) {
                    LinkedHashMap categoryValues = new LinkedHashMap();
                    for (int i = 0; i < this.dataTable.getNumberOfValues(this.colorColumn); ++i) {
                        String key = this.dataTable.mapIndex(this.colorColumn, i);
                        LinkedHashMap<String, AtomicInteger> innerMap = new LinkedHashMap<String, AtomicInteger>();
                        for (int j = 0; j < this.dataTable.getNumberOfValues(this.valueColumn); ++j) {
                            innerMap.put(this.dataTable.mapIndex(this.valueColumn, j), new AtomicInteger(0));
                        }
                        categoryValues.put(key, innerMap);
                    }
                    for (DataTableRow row : this.dataTable) {
                        String colorString = this.dataTable.getValueAsString(row, this.colorColumn);
                        String valueString = this.dataTable.getValueAsString(row, this.valueColumn);
                        ((AtomicInteger)((Map)categoryValues.get(colorString)).get(valueString)).incrementAndGet();
                    }
                    for (String key : categoryValues.keySet()) {
                        for (String value : ((Map)categoryValues.get(key)).keySet()) {
                            int count = ((AtomicInteger)((Map)categoryValues.get(key)).get(value)).get();
                            this.categoryDataset.addValue((double)count, (Comparable)((Object)key), (Comparable)((Object)value));
                        }
                    }
                }
            }
            this.nominal = false;
            DataTable dataTable = this.dataTable;
            synchronized (dataTable) {
                LinkedHashMap classMap = new LinkedHashMap();
                for (int i = 0; i < this.dataTable.getNumberOfValues(this.colorColumn); ++i) {
                    classMap.put(this.dataTable.mapIndex(this.colorColumn, i), new LinkedList());
                }
                for (DataTableRow row : this.dataTable) {
                    String colorValue;
                    List colorList;
                    double value = row.getValue(this.valueColumn);
                    if (this.absolute) {
                        value = Math.abs(value);
                    }
                    if ((colorList = (List)classMap.get(colorValue = this.dataTable.getValueAsString(row, this.colorColumn))) == null) continue;
                    colorList.add(value);
                }
                for (Map.Entry entry : classMap.entrySet()) {
                    List valueList = (List)entry.getValue();
                    double[] values = new double[valueList.size()];
                    int index = 0;
                    Iterator i$ = valueList.iterator();
                    while (i$.hasNext()) {
                        double v = (Double)i$.next();
                        values[index++] = v;
                    }
                    this.histogramDataset.addSeries((Comparable)entry.getKey(), values, this.binNumber);
                }
            }
        }
    }

    @Override
    protected void updatePlotter() {
        AbstractChartPanel panel;
        boolean createLegend;
        int categoryCount;
        this.prepareData();
        String maxClassesProperty = System.getProperty("rapidminer.gui.plotter.colors.classlimit");
        int maxClasses = 20;
        try {
            if (maxClassesProperty != null) {
                maxClasses = Integer.parseInt(maxClassesProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Deviation plotter: cannot parse property 'rapidminer.gui.plotter.colors.classlimit', using maximal 20 different classes.", 5);
        }
        JFreeChart chart = null;
        if (this.nominal) {
            categoryCount = this.categoryDataset.getRowCount();
            createLegend = categoryCount > 0 && categoryCount < maxClasses && this.drawLegend;
            String domainName = this.valueColumn >= 0 ? this.dataTable.getColumnName(this.valueColumn) : "Value";
            chart = ChartFactory.createBarChart(null, (String)domainName, (String)"Frequency", (CategoryDataset)this.categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)createLegend, (boolean)true, (boolean)false);
            CategoryPlot plot = chart.getCategoryPlot();
            plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
            plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setForegroundAlpha(this.opaqueness);
            BarRenderer renderer = new BarRenderer();
            if (this.categoryDataset.getRowCount() == 1) {
                renderer.setSeriesPaint(0, (Paint)Color.RED);
                renderer.setSeriesFillPaint(0, (Paint)Color.RED);
            } else {
                for (int i = 0; i < this.categoryDataset.getRowCount(); ++i) {
                    Color color = this.getColorProvider().getPointColor((double)i / (double)(this.categoryDataset.getRowCount() - 1));
                    renderer.setSeriesPaint(i, (Paint)color);
                    renderer.setSeriesFillPaint(i, (Paint)color);
                }
            }
            renderer.setBarPainter((BarPainter)new RapidBarPainter());
            renderer.setDrawBarOutline(true);
            plot.setRenderer((CategoryItemRenderer)renderer);
            plot.getRangeAxis().setLabelFont(LABEL_FONT_BOLD);
            plot.getRangeAxis().setTickLabelFont(LABEL_FONT);
            plot.getDomainAxis().setLabelFont(LABEL_FONT_BOLD);
            plot.getDomainAxis().setTickLabelFont(LABEL_FONT);
            if (this.isLabelRotating()) {
                plot.getDomainAxis().setTickLabelsVisible(true);
                plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.5707963267948966));
            }
        } else {
            String key;
            int index;
            categoryCount = this.histogramDataset.getSeriesCount();
            createLegend = categoryCount > 0 && categoryCount < maxClasses && this.drawLegend;
            String domainName = this.valueColumn >= 0 ? this.dataTable.getColumnName(this.valueColumn) : "Value";
            chart = ChartFactory.createHistogram(null, (String)domainName, (String)"Frequency", (IntervalXYDataset)this.histogramDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)createLegend, (boolean)true, (boolean)false);
            XYPlot plot = chart.getXYPlot();
            plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
            plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setForegroundAlpha(this.opaqueness);
            XYBarRenderer renderer = new XYBarRenderer();
            if (this.histogramDataset.getSeriesCount() == 1) {
                renderer.setSeriesPaint(0, (Paint)Color.RED);
                renderer.setSeriesFillPaint(0, (Paint)Color.RED);
            } else {
                for (int i = 0; i < this.histogramDataset.getSeriesCount(); ++i) {
                    Color color = this.getColorProvider().getPointColor((double)i / (double)(this.histogramDataset.getSeriesCount() - 1));
                    renderer.setSeriesPaint(i, (Paint)color);
                    renderer.setSeriesFillPaint(i, (Paint)color);
                }
            }
            renderer.setBarPainter((XYBarPainter)new RapidXYBarPainter());
            renderer.setDrawBarOutline(true);
            plot.setRenderer((XYItemRenderer)renderer);
            plot.getRangeAxis().setLabelFont(LABEL_FONT_BOLD);
            plot.getRangeAxis().setTickLabelFont(LABEL_FONT);
            plot.getDomainAxis().setLabelFont(LABEL_FONT_BOLD);
            plot.getDomainAxis().setTickLabelFont(LABEL_FONT);
            Range range = this.getRangeForDimension(this.valueColumn);
            if (range != null) {
                plot.getDomainAxis().setRange(range);
            }
            if (this.isLabelRotating()) {
                plot.getDomainAxis().setTickLabelsVisible(true);
                plot.getDomainAxis().setVerticalTickLabels(true);
            }
            if (this.histogramDataset.getSeriesCount() == 1 && (index = this.dataTable.getColumnIndex(key = this.histogramDataset.getSeriesKey(0).toString())) >= 0 && this.dataTable.isNominal(index)) {
                String[] values = new String[this.dataTable.getNumberOfValues(index)];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.dataTable.mapIndex(index, i);
                }
                plot.setDomainAxis((ValueAxis)new SymbolAxis(key, values));
                if (this.isLabelRotating()) {
                    plot.getDomainAxis().setTickLabelsVisible(true);
                    plot.getDomainAxis().setVerticalTickLabels(true);
                }
            }
        }
        chart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = chart.getLegend();
        if (legend != null) {
            legend.setPosition(RectangleEdge.TOP);
            legend.setFrame((BlockFrame)BlockBorder.NONE);
            legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
            legend.setItemFont(LABEL_FONT);
        }
        if ((panel = this.getPlotterPanel()) == null) {
            panel = this.createPanel(chart);
        } else {
            panel.setChart(chart);
        }
        panel.getChartRenderingInfo().setEntityCollection(null);
    }
}

