/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.RangeablePlotterAdapter;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.gui.plotter.charts.RapidHistogramDataset;
import com.rapidminer.gui.plotter.charts.RapidXYBarPainter;
import com.rapidminer.gui.plotter.settings.ListeningJCheckBox;
import com.rapidminer.gui.plotter.settings.ListeningJSlider;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.Range;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public class HistogramChart
extends RangeablePlotterAdapter {
    public static final String PARAMETER_OPAQUENESS = "opaqueness";
    public static final String PARAMETER_NUMBER_OF_BINS = "number_of_bins";
    public static final String PARAMETER_LOG_SCALE = "log_scale";
    private static final long serialVersionUID = 9140046811324105445L;
    public static final int MIN_BIN_NUMBER = 1;
    public static final int MAX_BIN_NUMBER = 100;
    public static final int DEFAULT_BIN_NUMBER = 40;
    protected transient DataTable dataTable;
    private HistogramDataset histogramDataset;
    private boolean[] columns = new boolean[0];
    protected int binNumber = 40;
    protected boolean logScale = false;
    private boolean absolute = false;
    protected boolean drawLegend = true;
    protected float opaqueness = 1.0f;
    private ListeningJCheckBox logScaleBox = new ListeningJCheckBox("log_scale", "Log Scale", false);
    private ListeningJSlider binNumberSlider;
    private ListeningJSlider opaquenessSlider;

    public HistogramChart(final PlotterConfigurationModel settings) {
        super(settings);
        this.logScaleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.setParameterAsBoolean(HistogramChart.PARAMETER_LOG_SCALE, HistogramChart.this.logScaleBox.isSelected());
            }
        });
        this.binNumberSlider = new ListeningJSlider(PARAMETER_NUMBER_OF_BINS, 1, 100, 40);
        this.binNumberSlider.setMajorTickSpacing(99);
        this.binNumberSlider.setMinorTickSpacing(9);
        this.binNumberSlider.setPaintTicks(true);
        this.binNumberSlider.setPaintLabels(true);
        this.binNumberSlider.setToolTipText("Set the number of bins which should be displayed.");
        this.binNumberSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!HistogramChart.this.binNumberSlider.getValueIsAdjusting()) {
                    settings.setParameterAsInt(HistogramChart.PARAMETER_NUMBER_OF_BINS, HistogramChart.this.binNumberSlider.getValue());
                }
            }
        });
        this.opaquenessSlider = new ListeningJSlider(PARAMETER_OPAQUENESS, 0, 100, (int)(this.opaqueness * 100.0f));
        this.opaquenessSlider.setPaintTicks(true);
        this.opaquenessSlider.setPaintLabels(true);
        this.opaquenessSlider.setToolTipText("Set the amount of opaqueness / transparency.");
        this.opaquenessSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!HistogramChart.this.opaquenessSlider.getValueIsAdjusting()) {
                    settings.setParameterAsInt(HistogramChart.PARAMETER_OPAQUENESS, HistogramChart.this.opaquenessSlider.getValue());
                }
            }
        });
    }

    public HistogramChart(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public void dataTableSet() {
        this.dataTable = this.getDataTable();
        this.columns = new boolean[this.dataTable.getNumberOfColumns()];
        this.updatePlotter();
    }

    @Override
    public Icon getIcon(int index) {
        return null;
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    @Override
    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
        this.updatePlotter();
    }

    @Override
    public boolean isSupportingAbsoluteValues() {
        return true;
    }

    public void setDrawLegend(boolean drawLegend) {
        this.drawLegend = drawLegend;
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.columns[index] = plot;
        this.updatePlotter();
        super.repaint();
        this.revalidate();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    @Override
    public int getValuePlotSelectionType() {
        return 1;
    }

    protected int getNumberOfPlots() {
        int counter = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i]) continue;
            ++counter;
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareData() {
        this.histogramDataset = new RapidHistogramDataset(this.isLogScale());
        if (this.getNumberOfPlots() == 0) {
            return;
        }
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            for (int c = 0; c < this.dataTable.getNumberOfColumns(); ++c) {
                if (!this.columns[c]) continue;
                double[] values = new double[this.dataTable.getSelectionCount() > 0 ? this.dataTable.getSelectionCount() : this.dataTable.getNumberOfRows()];
                int index = 0;
                int valueIndex = 0;
                for (DataTableRow row : this.dataTable) {
                    if (this.dataTable.getSelectionCount() == 0 || !this.dataTable.isDeselected(row.getId())) {
                        double value = row.getValue(c);
                        if (this.absolute) {
                            value = Math.abs(value);
                        }
                        if (!Double.isNaN(value)) {
                            values[valueIndex++] = value;
                        }
                    }
                    ++index;
                }
                if (valueIndex != values.length) {
                    double[] newValues = new double[valueIndex];
                    for (int j = 0; j < valueIndex; ++j) {
                        newValues[j] = values[j];
                    }
                    values = newValues;
                }
                if (values.length <= 0) continue;
                this.histogramDataset.addSeries((Comparable)((Object)this.dataTable.getColumnName(c)), values, this.binNumber);
            }
        }
    }

    @Override
    protected void updatePlotter() {
        AbstractChartPanel panel;
        String key;
        int index;
        this.prepareData();
        String maxClassesProperty = System.getProperty("rapidminer.gui.plotter.colors.classlimit");
        int maxClasses = 20;
        try {
            if (maxClassesProperty != null) {
                maxClasses = Integer.parseInt(maxClassesProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Deviation plotter: cannot parse property 'rapidminer.gui.plotter.colors.classlimit', using maximal 20 different classes.", 5);
        }
        int categoryCount = this.histogramDataset.getSeriesCount();
        boolean createLegend = categoryCount > 0 && categoryCount < maxClasses && this.drawLegend;
        JFreeChart chart = ChartFactory.createHistogram(null, (String)"Value", (String)"Frequency", (IntervalXYDataset)this.histogramDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)createLegend, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setForegroundAlpha(this.opaqueness);
        XYBarRenderer renderer = new XYBarRenderer();
        if (this.histogramDataset.getSeriesCount() == 1) {
            renderer.setSeriesPaint(0, (Paint)Color.RED);
            renderer.setSeriesFillPaint(0, (Paint)Color.RED);
        } else {
            for (int i = 0; i < this.histogramDataset.getSeriesCount(); ++i) {
                Color color = this.getColorProvider().getPointColor((double)i / (double)(this.histogramDataset.getSeriesCount() - 1));
                renderer.setSeriesPaint(i, (Paint)color);
                renderer.setSeriesFillPaint(i, (Paint)color);
            }
        }
        renderer.setBarPainter((XYBarPainter)new RapidXYBarPainter());
        renderer.setDrawBarOutline(true);
        renderer.setShadowVisible(false);
        plot.setRenderer((XYItemRenderer)renderer);
        plot.getRangeAxis().setLabelFont(LABEL_FONT_BOLD);
        plot.getRangeAxis().setTickLabelFont(LABEL_FONT);
        plot.getDomainAxis().setLabelFont(LABEL_FONT_BOLD);
        plot.getDomainAxis().setTickLabelFont(LABEL_FONT);
        this.setRange(plot.getDomainAxis());
        if (this.isLabelRotating()) {
            plot.getDomainAxis().setTickLabelsVisible(true);
            plot.getDomainAxis().setVerticalTickLabels(true);
        }
        if (this.histogramDataset.getSeriesCount() == 1 && (index = this.dataTable.getColumnIndex(key = this.histogramDataset.getSeriesKey(0).toString())) >= 0 && this.dataTable.isNominal(index)) {
            String[] values = new String[this.dataTable.getNumberOfValues(index)];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.dataTable.mapIndex(index, i);
            }
            plot.setDomainAxis((ValueAxis)new SymbolAxis(key, values));
        }
        chart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = chart.getLegend();
        if (legend != null) {
            legend.setPosition(RectangleEdge.TOP);
            legend.setFrame((BlockFrame)BlockBorder.NONE);
            legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
            legend.setItemFont(LABEL_FONT);
        }
        if ((panel = this.getPlotterPanel()) == null) {
            panel = this.createPanel(chart);
        } else {
            panel.setChart(chart);
        }
        panel.getChartRenderingInfo().setEntityCollection(null);
    }

    private void setRange(ValueAxis axis) {
        Range range = null;
        for (int c = 0; c < this.dataTable.getNumberOfColumns(); ++c) {
            if (!this.columns[c]) continue;
            if (range == null) {
                range = this.getRangeForDimension(c);
                continue;
            }
            Range newRange = this.getRangeForDimension(c);
            if (newRange == null) continue;
            range = new Range(MathFunctions.robustMin(range.getLowerBound(), newRange.getLowerBound()), MathFunctions.robustMax(range.getUpperBound(), newRange.getUpperBound()));
        }
        if (range != null) {
            axis.setRange(range);
        } else {
            axis.setAutoRange(true);
        }
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.logScaleBox;
        }
        if (index == 1) {
            return this.getRotateLabelComponent();
        }
        if (index == 2) {
            JLabel label = new JLabel("Number of Bins");
            label.setToolTipText("Set the number of bins which should be displayed.");
            return label;
        }
        if (index == 3) {
            return this.binNumberSlider;
        }
        if (index == 4) {
            JLabel label = new JLabel("Opaqueness");
            label.setToolTipText("Sets the amount of opaqueness / transparency.");
            return label;
        }
        if (index == 5) {
            return this.opaquenessSlider;
        }
        return null;
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys(InputPort inputPort) {
        List<ParameterType> types = super.getAdditionalParameterKeys(inputPort);
        types.add(new ParameterTypeBoolean(PARAMETER_LOG_SCALE, "Indicates if the bin heights should be transformed with logarithm base 10.", false));
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_OF_BINS, "The number of bins for each histogram.", 1, 100, 40));
        types.add(new ParameterTypeInt(PARAMETER_OPAQUENESS, "Indicates the opaqueness / transparency of the bins in percent.", 0, 100, 100));
        return types;
    }

    @Override
    public void setAdditionalParameter(String key, String value) {
        super.setAdditionalParameter(key, value);
        if (PARAMETER_LOG_SCALE.equals(key)) {
            this.logScale = Boolean.parseBoolean(value);
            this.updatePlotter();
        } else if (PARAMETER_NUMBER_OF_BINS.equals(key)) {
            this.binNumber = (int)Double.parseDouble(value);
            this.updatePlotter();
        } else if (PARAMETER_OPAQUENESS.equals(key)) {
            this.opaqueness = (float)((int)Double.parseDouble(value)) / 100.0f;
            this.updatePlotter();
        }
    }

    @Override
    public List<PlotterConfigurationModel.PlotterSettingsChangedListener> getListeningObjects() {
        List<PlotterConfigurationModel.PlotterSettingsChangedListener> list = super.getListeningObjects();
        list.add(this.opaquenessSlider);
        list.add(this.binNumberSlider);
        list.add(this.logScaleBox);
        return list;
    }

    @Override
    public String getPlotterName() {
        return "Histogram";
    }

    @Override
    public Collection<String> resolveXAxis(int axisIndex) {
        LinkedList<String> names = new LinkedList<String>();
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i]) continue;
            names.add(this.dataTable.getColumnName(i));
        }
        return names;
    }

    @Override
    public Collection<String> resolveYAxis(int axisIndex) {
        return Collections.emptyList();
    }
}

