/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableExampleSetAdapter;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.RangeablePlotterAdapter;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.gui.plotter.charts.RapidBarPainter;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.bayes.DistributionModel;
import com.rapidminer.operator.learner.bayes.NaiveBayes;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.math.distribution.ContinuousDistribution;
import com.rapidminer.tools.math.distribution.DiscreteDistribution;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public class DistributionPlotter
extends RangeablePlotterAdapter {
    public static final String RANGE_AXIS_NAME = "Density";
    public static final String MODEL_DOMAIN_AXIS_NAME = "Value";
    private static final long serialVersionUID = 2923008541302883925L;
    private static final int NUMBER_OF_STEPS = 300;
    private int plotColumn = -1;
    private int groupColumn = -1;
    private transient DistributionModel model;
    private transient HashMap<String, Integer> dataTableModelColumnMap = new HashMap();
    private transient DataTable dataTable;
    private boolean createFromModel = false;

    public DistributionPlotter(PlotterConfigurationModel settings) {
        super(settings);
    }

    public DistributionPlotter(PlotterConfigurationModel settings, DistributionModel model) {
        this(settings);
        this.model = model;
        this.createFromModel = true;
        this.plotColumn = 0;
        this.updatePlotter();
    }

    public DistributionPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public void prepareRendering() {
        super.prepareRendering();
        this.updatePlotter();
    }

    @Override
    public void finishRendering() {
        super.finishRendering();
        this.updatePlotter();
    }

    public void preparePlots() {
        ExampleSet wrappedExampleSet;
        Attribute[] attributes;
        Attribute label;
        if (!this.createFromModel && this.groupColumn >= 0 && this.plotColumn >= 0 && this.groupColumn != this.plotColumn && (label = (attributes = Tools.createRegularAttributeArray(wrappedExampleSet = DataTableExampleSetAdapter.createExampleSetFromDataTable(this.dataTable)))[this.groupColumn]).isNominal()) {
            wrappedExampleSet.getAttributes().setLabel(label);
            try {
                NaiveBayes modelLearner = OperatorService.createOperator(NaiveBayes.class);
                this.model = (DistributionModel)modelLearner.doWork(wrappedExampleSet);
                this.dataTableModelColumnMap.clear();
                int modelColumn = 0;
                for (Attribute attribute : wrappedExampleSet.getAttributes()) {
                    this.dataTableModelColumnMap.put(attribute.getName(), modelColumn);
                    ++modelColumn;
                }
            }
            catch (OperatorCreationException e) {
                LogService.getGlobal().logWarning("Cannot create distribution model generator. Skip plot...");
            }
            catch (MissingIOObjectException e) {
                LogService.getGlobal().logWarning("No distribution model was created from data. Skip plot...");
            }
            catch (OperatorException e) {
                LogService.getGlobal().logWarning("Error during creation of distribution model. Skip plot...");
            }
        }
    }

    private int translateToModelColumn(int plotColumn) {
        if (!this.createFromModel) {
            return this.dataTableModelColumnMap.get(this.dataTable.getColumnName(plotColumn));
        }
        return plotColumn;
    }

    @Override
    public void updatePlotter() {
        this.preparePlots();
        JFreeChart chart = null;
        if (!(this.createFromModel || this.groupColumn >= 0 && this.plotColumn >= 0)) {
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            chart = ChartFactory.createBarChart(null, (String)"Not defined", (String)RANGE_AXIS_NAME, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        } else {
            try {
                chart = this.model.isDiscrete(this.translateToModelColumn(this.plotColumn)) ? this.createNominalChart() : this.createNumericalChart();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (chart != null) {
            AbstractChartPanel panel;
            XYPlot plot;
            chart.setBackgroundPaint((Paint)Color.white);
            Plot commonPlot = chart.getPlot();
            commonPlot.setBackgroundPaint((Paint)Color.WHITE);
            if (commonPlot instanceof XYPlot) {
                plot = (XYPlot)commonPlot;
                plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
                plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
                if (this.dataTable != null) {
                    if (this.dataTable.isDate(this.plotColumn) || this.dataTable.isDateTime(this.plotColumn)) {
                        DateAxis domainAxis = new DateAxis(this.dataTable.getColumnName(this.plotColumn));
                        domainAxis.setTimeZone(com.rapidminer.tools.Tools.getPreferredTimeZone());
                        plot.setDomainAxis((ValueAxis)domainAxis);
                    } else {
                        NumberAxis numberAxis = new NumberAxis(this.dataTable.getColumnName(this.plotColumn));
                        plot.setDomainAxis((ValueAxis)numberAxis);
                    }
                }
                plot.getDomainAxis().setLabelFont(LABEL_FONT_BOLD);
                plot.getDomainAxis().setTickLabelFont(LABEL_FONT);
                plot.getRangeAxis().setLabelFont(LABEL_FONT_BOLD);
                plot.getRangeAxis().setTickLabelFont(LABEL_FONT);
                Range range = this.getRangeForDimension(this.plotColumn);
                if (range != null) {
                    plot.getDomainAxis().setRange(range, true, false);
                }
                if ((range = this.getRangeForName(RANGE_AXIS_NAME)) != null) {
                    plot.getRangeAxis().setRange(range, true, false);
                }
                if (this.isLabelRotating()) {
                    plot.getDomainAxis().setTickLabelsVisible(true);
                    plot.getDomainAxis().setVerticalTickLabels(true);
                }
            } else if (commonPlot instanceof CategoryPlot) {
                plot = (CategoryPlot)commonPlot;
                plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
                plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
                plot.getRangeAxis().setLabelFont(LABEL_FONT_BOLD);
                plot.getRangeAxis().setTickLabelFont(LABEL_FONT);
                plot.getDomainAxis().setLabelFont(LABEL_FONT_BOLD);
                plot.getDomainAxis().setTickLabelFont(LABEL_FONT);
            }
            LegendTitle legend = chart.getLegend();
            if (legend != null) {
                legend.setPosition(RectangleEdge.TOP);
                legend.setFrame((BlockFrame)BlockBorder.NONE);
                legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
                legend.setItemFont(LABEL_FONT);
            }
            if ((panel = this.getPlotterPanel()) == null) {
                panel = this.createPanel(chart);
            } else {
                panel.setChart(chart);
            }
            panel.getChartRenderingInfo().setEntityCollection(null);
        }
    }

    private XYDataset createNumericalDataSet() {
        XYSeriesCollection dataSet = new XYSeriesCollection();
        int translatedPlotColumn = this.translateToModelColumn(this.plotColumn);
        double start = this.model.getLowerBound(translatedPlotColumn);
        double end = this.model.getUpperBound(translatedPlotColumn);
        double stepSize = (end - start) / 299.0;
        for (int classIndex : this.model.getClassIndices()) {
            XYSeries series = new XYSeries((Comparable)((Object)this.model.getClassName(classIndex)));
            ContinuousDistribution distribution = (ContinuousDistribution)this.model.getDistribution(classIndex, translatedPlotColumn);
            for (double currentValue = start; currentValue < end; currentValue += stepSize) {
                double probability = distribution.getProbability(currentValue);
                if (Double.isNaN(probability)) continue;
                series.add(currentValue, distribution.getProbability(currentValue));
            }
            dataSet.addSeries(series);
        }
        return dataSet;
    }

    private JFreeChart createNumericalChart() {
        XYDataset dataset = this.createNumericalDataSet();
        String domainName = this.dataTable == null ? MODEL_DOMAIN_AXIS_NAME : this.dataTable.getColumnName(this.plotColumn);
        JFreeChart chart = ChartFactory.createXYLineChart(null, (String)domainName, (String)RANGE_AXIS_NAME, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        DeviationRenderer renderer = new DeviationRenderer(true, false);
        BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
        if (dataset.getSeriesCount() == 1) {
            renderer.setSeriesStroke(0, (Stroke)stroke);
            renderer.setSeriesPaint(0, (Paint)Color.RED);
            renderer.setSeriesFillPaint(0, (Paint)Color.RED);
        } else {
            for (int i = 0; i < dataset.getSeriesCount(); ++i) {
                renderer.setSeriesStroke(i, (Stroke)stroke);
                Color color = this.getColorProvider().getPointColor((double)i / (double)(dataset.getSeriesCount() - 1));
                renderer.setSeriesPaint(i, (Paint)color);
                renderer.setSeriesFillPaint(i, (Paint)color);
            }
        }
        renderer.setAlpha(0.12f);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setRenderer((XYItemRenderer)renderer);
        return chart;
    }

    private JFreeChart createNominalChart() {
        CategoryDataset dataset = this.createNominalDataSet();
        String domainName = this.dataTable == null ? MODEL_DOMAIN_AXIS_NAME : this.dataTable.getColumnName(this.plotColumn);
        JFreeChart chart = ChartFactory.createBarChart(null, (String)domainName, (String)RANGE_AXIS_NAME, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        BarRenderer renderer = new BarRenderer();
        if (dataset.getRowCount() == 1) {
            renderer.setSeriesPaint(0, (Paint)Color.RED);
            renderer.setSeriesFillPaint(0, (Paint)Color.RED);
        } else {
            for (int i = 0; i < dataset.getRowCount(); ++i) {
                Color color = this.getColorProvider().getPointColor((double)i / (double)(dataset.getRowCount() - 1));
                renderer.setSeriesPaint(i, (Paint)color);
                renderer.setSeriesFillPaint(i, (Paint)color);
            }
        }
        renderer.setBarPainter((BarPainter)new RapidBarPainter());
        renderer.setDrawBarOutline(true);
        plot.setRenderer((CategoryItemRenderer)renderer);
        if (this.isLabelRotating()) {
            plot.getDomainAxis().setTickLabelsVisible(true);
            plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.5707963267948966));
        }
        return chart;
    }

    private CategoryDataset createNominalDataSet() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Integer classIndex : this.model.getClassIndices()) {
            DiscreteDistribution distribution = (DiscreteDistribution)this.model.getDistribution(classIndex, this.translateToModelColumn(this.plotColumn));
            String labelName = this.model.getClassName(classIndex);
            TreeMap<String, Double> valueMap = new TreeMap<String, Double>();
            for (Double d : distribution.getValues()) {
                String valueName = Double.isNaN(d) ? "Unknown" : distribution.mapValue(d);
                valueMap.put(valueName, d);
            }
            for (Map.Entry entry : valueMap.entrySet()) {
                dataset.addValue(distribution.getProbability((Double)entry.getValue()), (Comparable)((Object)labelName), (Comparable)entry.getKey());
            }
        }
        return dataset;
    }

    @Override
    public void setPlotColumn(int column, boolean plot) {
        this.plotColumn = column;
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int column) {
        return column == this.plotColumn;
    }

    @Override
    public String getPlotName() {
        return "Plot Column";
    }

    @Override
    public int getNumberOfAxes() {
        return 1;
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (this.groupColumn != dimension) {
            this.groupColumn = dimension;
            this.updatePlotter();
        }
    }

    @Override
    public int getAxis(int index) {
        return this.groupColumn;
    }

    @Override
    public String getAxisName(int axis) {
        return "Class Column";
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.getRotateLabelComponent();
        }
        return null;
    }

    @Override
    public String getPlotterName() {
        return "Distribution";
    }

    @Override
    public void dataTableSet() {
        this.dataTable = this.getDataTable();
        if (!this.createFromModel) {
            this.updatePlotter();
        }
    }

    @Override
    public Collection<String> resolveXAxis(int axisIndex) {
        if (this.dataTable != null && this.plotColumn != -1) {
            return Collections.singletonList(this.dataTable.getColumnName(this.plotColumn));
        }
        if (this.createFromModel) {
            return Collections.singletonList(MODEL_DOMAIN_AXIS_NAME);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<String> resolveYAxis(int axisIndex) {
        return Collections.singletonList(RANGE_AXIS_NAME);
    }
}

