/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.LocalNormalizationPlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.gui.plotter.charts.ChartPanelShiftController;
import com.rapidminer.gui.plotter.charts.WeightBasedSymbolAxis;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class DeviationChartPlotter
extends LocalNormalizationPlotterAdapter {
    private static final long serialVersionUID = -8763693366081949249L;
    private transient DataTable dataTable;
    private YIntervalSeriesCollection dataset = null;
    private int colorColumn = -1;
    private String[] domainAxisMap = null;
    private ChartPanel panel = new ChartPanel(null);

    public DeviationChartPlotter(PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
    }

    public DeviationChartPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public JComponent getPlotter() {
        return this.panel;
    }

    private JFreeChart createChart(XYDataset dataset, boolean createLegend) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)createLegend, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        DeviationRenderer renderer = new DeviationRenderer(true, false);
        BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
        if (dataset.getSeriesCount() == 1) {
            renderer.setSeriesStroke(0, (Stroke)stroke);
            renderer.setSeriesPaint(0, (Paint)Color.RED);
            renderer.setSeriesFillPaint(0, (Paint)Color.RED);
        } else {
            for (int i = 0; i < dataset.getSeriesCount(); ++i) {
                renderer.setSeriesStroke(i, (Stroke)stroke);
                Color color = this.getColorProvider().getPointColor((double)i / (double)(dataset.getSeriesCount() - 1));
                renderer.setSeriesPaint(i, (Paint)color);
                renderer.setSeriesFillPaint(i, (Paint)color);
            }
        }
        renderer.setAlpha(0.12f);
        plot.setRenderer((XYItemRenderer)renderer);
        ValueAxis valueAxis = plot.getRangeAxis();
        valueAxis.setLabelFont(LABEL_FONT_BOLD);
        valueAxis.setTickLabelFont(LABEL_FONT);
        return chart;
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.updatePlotter();
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.colorColumn = plot ? index : -1;
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.colorColumn == index;
    }

    @Override
    public String getPlotName() {
        return "Color Column";
    }

    @Override
    public int getNumberOfAxes() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepareData() {
        int columns = this.dataTable.getNumberOfColumns();
        double[] min = new double[columns];
        double[] max = new double[columns];
        for (int c = 0; c < columns; ++c) {
            min[c] = Double.POSITIVE_INFINITY;
            max[c] = Double.NEGATIVE_INFINITY;
        }
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            for (DataTableRow row : this.dataTable) {
                for (int c = 0; c < this.dataTable.getNumberOfColumns(); ++c) {
                    double value = row.getValue(c);
                    min[c] = MathFunctions.robustMin(min[c], value);
                    max[c] = MathFunctions.robustMax(max[c], value);
                }
            }
        }
        dataTable = this.dataTable;
        synchronized (dataTable) {
            this.dataset = new YIntervalSeriesCollection();
            if (this.colorColumn >= 0 && this.dataTable.isNominal(this.colorColumn)) {
                for (int v = 0; v < this.dataTable.getNumberOfValues(this.colorColumn); ++v) {
                    String valueName = this.dataTable.mapIndex(this.colorColumn, v);
                    YIntervalSeries series = new YIntervalSeries((Comparable)((Object)valueName));
                    boolean first = true;
                    LinkedList<String> domainValues = new LinkedList<String>();
                    for (int column = 0; column < this.dataTable.getNumberOfColumns(); ++column) {
                        if (this.dataTable.isSpecial(column) || column == this.colorColumn) continue;
                        Iterator<DataTableRow> i = this.dataTable.iterator();
                        double sum = 0.0;
                        double squaredSum = 0.0;
                        int counter = 0;
                        while (i.hasNext()) {
                            DataTableRow row = i.next();
                            if (row.getValue(this.colorColumn) != (double)v) continue;
                            double value = row.getValue(column);
                            sum += value;
                            squaredSum += value * value;
                            ++counter;
                        }
                        double mean = sum / (double)counter;
                        double deviation = Math.sqrt(squaredSum / (double)counter - mean * mean);
                        if (this.isLocalNormalized()) {
                            mean = (mean - min[column]) / (max[column] - min[column]);
                            deviation = (deviation - min[column]) / (max[column] - min[column]);
                        }
                        series.add((double)column, mean, mean - deviation, mean + deviation);
                        domainValues.add(this.dataTable.getColumnName(column));
                    }
                    if (first) {
                        this.domainAxisMap = new String[domainValues.size()];
                        domainValues.toArray(this.domainAxisMap);
                    }
                    first = false;
                    this.dataset.addSeries(series);
                }
                return this.dataTable.getNumberOfValues(this.colorColumn);
            }
            YIntervalSeries series = new YIntervalSeries((Comparable)((Object)this.dataTable.getName()));
            LinkedList<String> domainValues = new LinkedList<String>();
            for (int column = 0; column < this.dataTable.getNumberOfColumns(); ++column) {
                if (this.dataTable.isSpecial(column) || column == this.colorColumn) continue;
                Iterator<DataTableRow> i = this.dataTable.iterator();
                double sum = 0.0;
                double squaredSum = 0.0;
                int counter = 0;
                while (i.hasNext()) {
                    DataTableRow row = i.next();
                    double value = row.getValue(column);
                    sum += value;
                    squaredSum += value * value;
                    ++counter;
                }
                double mean = sum / (double)counter;
                double deviation = Math.sqrt(squaredSum / (double)counter - mean * mean);
                if (this.isLocalNormalized()) {
                    mean = (mean - min[column]) / (max[column] - min[column]);
                }
                series.add((double)column, mean, mean - deviation, mean + deviation);
                domainValues.add(this.dataTable.getColumnName(column));
            }
            this.dataset.addSeries(series);
            this.domainAxisMap = new String[domainValues.size()];
            domainValues.toArray(this.domainAxisMap);
            return 0;
        }
    }

    @Override
    public void updatePlotter() {
        int categoryCount = this.prepareData();
        String maxClassesProperty = System.getProperty("rapidminer.gui.plotter.colors.classlimit");
        int maxClasses = 20;
        try {
            if (maxClassesProperty != null) {
                maxClasses = Integer.parseInt(maxClassesProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Deviation plotter: cannot parse property 'rapidminer.gui.plotter.colors.classlimit', using maximal 20 different classes.", 5);
        }
        boolean createLegend = categoryCount > 0 && categoryCount < maxClasses;
        JFreeChart chart = this.createChart((XYDataset)this.dataset, createLegend);
        chart.setBackgroundPaint((Paint)Color.white);
        SymbolAxis axis = null;
        if (this.dataTable.isSupportingColumnWeights()) {
            LinkedList<Double> weightList = new LinkedList<Double>();
            for (int column = 0; column < this.dataTable.getNumberOfColumns(); ++column) {
                if (this.dataTable.isSpecial(column) || column == this.colorColumn) continue;
                weightList.add(this.dataTable.getColumnWeight(column));
            }
            double[] weights = new double[weightList.size()];
            int index = 0;
            for (Double d : weightList) {
                weights[index++] = d;
            }
            axis = new WeightBasedSymbolAxis(null, this.domainAxisMap, weights);
        } else {
            axis = new SymbolAxis(null, this.domainAxisMap);
        }
        axis.setTickLabelFont(LABEL_FONT);
        axis.setLabelFont(LABEL_FONT_BOLD);
        if (this.isLabelRotating()) {
            axis.setTickLabelsVisible(true);
            axis.setVerticalTickLabels(true);
        }
        chart.getXYPlot().setDomainAxis((ValueAxis)axis);
        LegendTitle legend = chart.getLegend();
        if (legend != null) {
            legend.setPosition(RectangleEdge.TOP);
            legend.setFrame((BlockFrame)BlockBorder.NONE);
            legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
            legend.setItemFont(LABEL_FONT);
        }
        if (this.panel instanceof AbstractChartPanel) {
            this.panel.setChart(chart);
        } else {
            this.panel = new AbstractChartPanel(chart, this.getWidth(), this.getHeight() - 20);
            ChartPanelShiftController controller = new ChartPanelShiftController(this.panel);
            this.panel.addMouseListener((MouseListener)controller);
            this.panel.addMouseMotionListener((MouseMotionListener)controller);
        }
        this.panel.getChartRenderingInfo().setEntityCollection(null);
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.getLocalNormalizationComponent();
        }
        if (index == 1) {
            return this.getRotateLabelComponent();
        }
        return null;
    }

    @Override
    public String getPlotterName() {
        return "Deviation";
    }
}

