/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.gui.plotter.ColorProvider;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;

public class ColorizedBubbleRenderer
extends XYBubbleRenderer {
    private static final long serialVersionUID = 384459884477017759L;
    private double minColor;
    private double maxColor;
    private double[] colors;
    private ColorProvider colorProvider = new ColorProvider();

    public ColorizedBubbleRenderer(double[] colors) {
        super(2);
        this.minColor = Double.POSITIVE_INFINITY;
        this.maxColor = Double.NEGATIVE_INFINITY;
        for (double c : colors) {
            this.minColor = MathFunctions.robustMin(this.minColor, c);
            this.maxColor = MathFunctions.robustMax(this.maxColor, c);
        }
        this.colors = colors;
    }

    public Paint getItemPaint(int series, int item) {
        double normalized = (this.colors[item] - this.minColor) / (this.maxColor - this.minColor);
        return this.colorProvider.getPointColor(normalized);
    }

    public Paint getItemOutlinePaint(int series, int item) {
        return Color.DARK_GRAY;
    }
}

