/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.gui.plotter.ColorProvider;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.renderer.category.BarRenderer;

public class ColorizedBarRenderer
extends BarRenderer {
    private static final long serialVersionUID = 5262078816286731693L;
    private double[] colorValues;
    private double minColor;
    private double maxColor;
    private ColorProvider colorProvider = new ColorProvider();

    public ColorizedBarRenderer(double[] colorValues) {
        this.colorValues = colorValues;
        this.minColor = Double.POSITIVE_INFINITY;
        this.maxColor = Double.NEGATIVE_INFINITY;
        if (this.colorValues != null) {
            for (double d : this.colorValues) {
                this.minColor = MathFunctions.robustMin(this.minColor, d);
                this.maxColor = MathFunctions.robustMax(this.maxColor, d);
            }
        }
    }

    public Paint getItemPaint(int series, int item) {
        if (this.colorValues == null || this.minColor == this.maxColor) {
            return Color.RED;
        }
        double normalized = (this.colorValues[item] - this.minColor) / (this.maxColor - this.minColor);
        return this.colorProvider.getPointColor(normalized);
    }
}

