/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.RangeablePlotterAdapter;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.gui.plotter.charts.ColorizedBubbleRenderer;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.BlockResult;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public class BubbleChartPlotter
extends RangeablePlotterAdapter {
    private static final long serialVersionUID = 4568273282283350833L;
    private static final String[] axisNames = new String[]{"x-Axis", "y-Axis", "Bubble Size"};
    private static final int X_AXIS = 0;
    private static final int Y_AXIS = 1;
    private static final int BUBBLE_SIZE_AXIS = 2;
    private DefaultXYZDataset xyzDataSet = new DefaultXYZDataset();
    private int[] axis = new int[]{-1, -1, -1};
    private int colorColumn = -1;
    private double bubbleSizeMin = 0.0;
    private double bubbleSizeMax = 1.0;
    private double xAxisMin = 0.0;
    private double xAxisMax = 1.0;
    private double yAxisMin = 0.0;
    private double yAxisMax = 1.0;
    private double minColor;
    private double maxColor;
    private double[] colors;
    private boolean[] logScales = new boolean[]{false, false};
    private boolean nominal = true;

    public BubbleChartPlotter(PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
    }

    public BubbleChartPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.colorColumn = plot ? index : -1;
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.colorColumn == index;
    }

    @Override
    public String getPlotName() {
        return "Color Column";
    }

    @Override
    public int getNumberOfAxes() {
        return 3;
    }

    @Override
    public void setAxis(int index, int dimension) {
        this.axis[index] = dimension;
        this.updatePlotter();
    }

    @Override
    public int getAxis(int index) {
        return this.axis[index];
    }

    @Override
    public String getAxisName(int index) {
        return axisNames[index];
    }

    @Override
    public boolean isSupportingLogScale(int axis) {
        return axis == 0 || axis == 1;
    }

    @Override
    public void setLogScale(int axis, boolean logScale) {
        this.logScales[axis] = logScale;
        this.updatePlotter();
    }

    private void prepareData() {
        if (this.colorColumn < 0 || this.getDataTable().isNominal(this.colorColumn)) {
            this.prepareNominalData();
        } else {
            this.prepareNumericalData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNumericalData() {
        DataTable dataTable = this.getDataTable();
        this.nominal = false;
        this.xyzDataSet = new DefaultXYZDataset();
        if (this.axis[0] >= 0 && this.axis[1] >= 0 && this.axis[2] >= 0) {
            this.bubbleSizeMin = Double.POSITIVE_INFINITY;
            this.bubbleSizeMax = Double.NEGATIVE_INFINITY;
            this.xAxisMin = Double.POSITIVE_INFINITY;
            this.xAxisMax = Double.NEGATIVE_INFINITY;
            this.yAxisMin = Double.POSITIVE_INFINITY;
            this.yAxisMax = Double.NEGATIVE_INFINITY;
            this.minColor = Double.POSITIVE_INFINITY;
            this.maxColor = Double.NEGATIVE_INFINITY;
            LinkedList<double[]> dataList = new LinkedList<double[]>();
            DataTable dataTable2 = dataTable;
            synchronized (dataTable2) {
                for (DataTableRow row : dataTable) {
                    double xValue = row.getValue(this.axis[0]);
                    double yValue = row.getValue(this.axis[1]);
                    double bubbleSizeValue = row.getValue(this.axis[2]);
                    double colorValue = Double.NaN;
                    if (this.colorColumn >= 0) {
                        colorValue = row.getValue(this.colorColumn);
                    }
                    if (Double.isNaN(xValue) || Double.isNaN(yValue) || Double.isNaN(bubbleSizeValue)) continue;
                    double[] data = new double[]{xValue, yValue, bubbleSizeValue, colorValue};
                    this.bubbleSizeMin = MathFunctions.robustMin(this.bubbleSizeMin, bubbleSizeValue);
                    this.bubbleSizeMax = MathFunctions.robustMax(this.bubbleSizeMax, bubbleSizeValue);
                    this.xAxisMin = MathFunctions.robustMin(this.xAxisMin, xValue);
                    this.yAxisMin = MathFunctions.robustMin(this.yAxisMin, yValue);
                    this.xAxisMax = MathFunctions.robustMax(this.xAxisMax, xValue);
                    this.yAxisMax = MathFunctions.robustMax(this.yAxisMax, yValue);
                    this.minColor = MathFunctions.robustMin(this.minColor, colorValue);
                    this.maxColor = MathFunctions.robustMax(this.maxColor, colorValue);
                    dataList.add(data);
                }
            }
            double[][] data = new double[3][dataList.size()];
            this.colors = new double[dataList.size()];
            int index = 0;
            double scaleFactor = Math.min(this.xAxisMax - this.xAxisMin, this.yAxisMax - this.yAxisMin) / 4.0;
            for (double[] d : dataList) {
                data[0][index] = d[0];
                data[1][index] = d[1];
                data[2][index] = ((d[2] - this.bubbleSizeMin) / (this.bubbleSizeMax - this.bubbleSizeMin) + 0.1) * scaleFactor;
                this.colors[index] = d[3];
                ++index;
            }
            this.xyzDataSet.addSeries((Comparable)((Object)"All"), data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNominalData() {
        DataTable dataTable = this.getDataTable();
        this.nominal = true;
        this.xyzDataSet = new DefaultXYZDataset();
        if (this.axis[0] >= 0 && this.axis[1] >= 0 && this.axis[2] >= 0) {
            this.bubbleSizeMin = Double.POSITIVE_INFINITY;
            this.bubbleSizeMax = Double.NEGATIVE_INFINITY;
            this.xAxisMin = Double.POSITIVE_INFINITY;
            this.xAxisMax = Double.NEGATIVE_INFINITY;
            this.yAxisMin = Double.POSITIVE_INFINITY;
            this.yAxisMax = Double.NEGATIVE_INFINITY;
            this.minColor = Double.POSITIVE_INFINITY;
            this.maxColor = Double.NEGATIVE_INFINITY;
            LinkedHashMap<String, List<double[]>> dataCollection = new LinkedHashMap<String, List<double[]>>();
            DataTable dataTable2 = dataTable;
            synchronized (dataTable2) {
                for (DataTableRow row : dataTable) {
                    double xValue = row.getValue(this.axis[0]);
                    double yValue = row.getValue(this.axis[1]);
                    double bubbleSizeValue = row.getValue(this.axis[2]);
                    double colorValue = Double.NaN;
                    if (this.colorColumn >= 0) {
                        colorValue = row.getValue(this.colorColumn);
                    }
                    if (Double.isNaN(xValue) || Double.isNaN(yValue) || Double.isNaN(bubbleSizeValue)) continue;
                    this.addPoint(dataTable, dataCollection, xValue, yValue, bubbleSizeValue, colorValue);
                }
            }
            Iterator i = dataCollection.entrySet().iterator();
            double scaleFactor = Math.min(this.xAxisMax - this.xAxisMin, this.yAxisMax - this.yAxisMin) / 4.0;
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String seriesName = (String)entry.getKey();
                List dataList = (List)entry.getValue();
                double[][] data = new double[3][dataList.size()];
                int listCounter = 0;
                for (double[] current : dataList) {
                    data[0][listCounter] = current[0];
                    data[1][listCounter] = current[1];
                    data[2][listCounter] = ((current[2] - this.bubbleSizeMin) / (this.bubbleSizeMax - this.bubbleSizeMin) + 0.1) * scaleFactor;
                    ++listCounter;
                }
                this.xyzDataSet.addSeries((Comparable)((Object)seriesName), data);
            }
        }
    }

    private void addPoint(DataTable dataTable, Map<String, List<double[]>> dataCollection, double x, double y, double z, double color) {
        List<double[]> dataList = null;
        if (Double.isNaN(color)) {
            dataList = dataCollection.get("All");
            if (dataList == null) {
                dataList = new LinkedList<double[]>();
                dataCollection.put("All", dataList);
            }
        } else {
            String name = color + "";
            if (dataTable.isNominal(this.colorColumn)) {
                name = dataTable.mapIndex(this.colorColumn, (int)color);
            } else if (dataTable.isDate(this.colorColumn)) {
                name = Tools.formatDate(new Date((long)color));
            } else if (dataTable.isTime(this.colorColumn)) {
                name = Tools.formatTime(new Date((long)color));
            } else if (dataTable.isDateTime(this.colorColumn)) {
                name = Tools.formatDateTime(new Date((long)color));
            }
            dataList = dataCollection.get(name);
            if (dataList == null) {
                dataList = new LinkedList<double[]>();
                dataCollection.put(name, dataList);
            }
        }
        this.bubbleSizeMin = MathFunctions.robustMin(this.bubbleSizeMin, z);
        this.bubbleSizeMax = MathFunctions.robustMax(this.bubbleSizeMax, z);
        this.xAxisMin = MathFunctions.robustMin(this.xAxisMin, x);
        this.yAxisMin = MathFunctions.robustMin(this.yAxisMin, y);
        this.xAxisMax = MathFunctions.robustMax(this.xAxisMax, x);
        this.yAxisMax = MathFunctions.robustMax(this.yAxisMax, y);
        this.minColor = MathFunctions.robustMin(this.minColor, color);
        this.maxColor = MathFunctions.robustMax(this.maxColor, color);
        dataList.add(new double[]{x, y, z});
    }

    @Override
    public void updatePlotter() {
        Range range;
        String[] values;
        final DataTable dataTable = this.getDataTable();
        this.prepareData();
        JFreeChart chart = ChartFactory.createBubbleChart(null, null, null, (XYZDataset)this.xyzDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        if (this.axis[0] >= 0 && this.axis[1] >= 0 && this.axis[2] >= 0) {
            if (this.nominal) {
                int size = this.xyzDataSet.getSeriesCount();
                chart = ChartFactory.createBubbleChart(null, null, null, (XYZDataset)this.xyzDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (this.colorColumn >= 0 && size < 100 ? 1 : 0) != 0, (boolean)true, (boolean)false);
                XYBubbleRenderer renderer = (XYBubbleRenderer)chart.getXYPlot().getRenderer();
                renderer.setBaseOutlinePaint((Paint)Color.BLACK);
                if (size > 1) {
                    for (int i = 0; i < size; ++i) {
                        renderer.setSeriesPaint(i, (Paint)this.getColorProvider().getPointColor((double)i / (double)(size - 1)));
                        renderer.setSeriesShape(i, (Shape)new Ellipse2D.Double(-3.0, -3.0, 7.0, 7.0));
                    }
                } else {
                    renderer.setSeriesPaint(0, (Paint)this.getColorProvider().getPointColor(1.0));
                    renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-3.0, -3.0, 7.0, 7.0));
                }
                LegendTitle legend = chart.getLegend();
                if (legend != null) {
                    legend.setPosition(RectangleEdge.TOP);
                    legend.setFrame((BlockFrame)BlockBorder.NONE);
                    legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
                    legend.setItemFont(LABEL_FONT);
                }
            } else {
                chart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)this.xyzDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                ColorizedBubbleRenderer renderer = new ColorizedBubbleRenderer(this.colors);
                renderer.setBaseOutlinePaint(Color.BLACK);
                chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
                chart.addLegend(new LegendTitle((LegendItemSource)renderer){
                    private static final long serialVersionUID = 1288380309936848376L;

                    public Object draw(Graphics2D g2, Rectangle2D area, Object params) {
                        if (dataTable.isDate(BubbleChartPlotter.this.colorColumn) || dataTable.isTime(BubbleChartPlotter.this.colorColumn) || dataTable.isDateTime(BubbleChartPlotter.this.colorColumn)) {
                            BubbleChartPlotter.this.drawSimpleDateLegend(g2, (int)(area.getCenterX() - 170.0), (int)(area.getCenterY() + 7.0), dataTable, BubbleChartPlotter.this.colorColumn, BubbleChartPlotter.this.minColor, BubbleChartPlotter.this.maxColor);
                            return new BlockResult();
                        }
                        String minColorString = Tools.formatNumber(BubbleChartPlotter.this.minColor);
                        String maxColorString = Tools.formatNumber(BubbleChartPlotter.this.maxColor);
                        BubbleChartPlotter.this.drawSimpleNumericalLegend(g2, (int)(area.getCenterX() - 90.0), (int)(area.getCenterY() + 7.0), dataTable.getColumnName(BubbleChartPlotter.this.colorColumn), minColorString, maxColorString);
                        return new BlockResult();
                    }

                    public void draw(Graphics2D g2, Rectangle2D area) {
                        this.draw(g2, area, null);
                    }
                });
            }
        }
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.getPlot().setForegroundAlpha(0.7f);
        XYPlot plot = chart.getXYPlot();
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        if (this.axis[0] >= 0) {
            DateAxis domainAxis;
            if (dataTable.isNominal(this.axis[0])) {
                values = new String[dataTable.getNumberOfValues(this.axis[0])];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = dataTable.mapIndex(this.axis[0], i);
                }
                plot.setDomainAxis((ValueAxis)new SymbolAxis(dataTable.getColumnName(this.axis[0]), values));
            } else if (dataTable.isDate(this.axis[0]) || dataTable.isDateTime(this.axis[0])) {
                domainAxis = new DateAxis(dataTable.getColumnName(this.axis[0]));
                domainAxis.setTimeZone(Tools.getPreferredTimeZone());
                plot.setDomainAxis((ValueAxis)domainAxis);
            } else if (this.logScales[0]) {
                domainAxis = new LogAxis(dataTable.getColumnName(this.axis[0]));
                domainAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits((Locale)Locale.US));
                plot.setDomainAxis((ValueAxis)domainAxis);
            } else {
                plot.setDomainAxis((ValueAxis)new NumberAxis(dataTable.getColumnName(this.axis[0])));
            }
            range = this.getRangeForDimension(this.axis[0]);
            if (range != null) {
                plot.getDomainAxis().setRange(range, true, false);
            } else {
                plot.getDomainAxis().setAutoRange(true);
            }
        }
        plot.getDomainAxis().setLabelFont(LABEL_FONT_BOLD);
        plot.getDomainAxis().setTickLabelFont(LABEL_FONT);
        if (this.isLabelRotating()) {
            plot.getDomainAxis().setTickLabelsVisible(true);
            plot.getDomainAxis().setVerticalTickLabels(true);
        }
        if (this.axis[1] >= 0) {
            DateAxis rangeAxis;
            if (dataTable.isNominal(this.axis[1])) {
                values = new String[dataTable.getNumberOfValues(this.axis[1])];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = dataTable.mapIndex(this.axis[1], i);
                }
                plot.setRangeAxis((ValueAxis)new SymbolAxis(dataTable.getColumnName(this.axis[1]), values));
            } else if (dataTable.isDate(this.axis[1]) || dataTable.isDateTime(this.axis[1])) {
                rangeAxis = new DateAxis(dataTable.getColumnName(this.axis[1]));
                rangeAxis.setTimeZone(Tools.getPreferredTimeZone());
                plot.setRangeAxis((ValueAxis)rangeAxis);
            } else if (this.logScales[1]) {
                rangeAxis = new LogAxis(dataTable.getColumnName(this.axis[1]));
                rangeAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits((Locale)Locale.US));
                plot.setRangeAxis((ValueAxis)rangeAxis);
            } else {
                plot.setRangeAxis((ValueAxis)new NumberAxis(dataTable.getColumnName(this.axis[1])));
            }
            range = this.getRangeForDimension(this.axis[1]);
            if (range != null) {
                plot.getRangeAxis().setRange(range, true, false);
            } else {
                plot.getRangeAxis().setAutoRange(true);
            }
        }
        plot.getRangeAxis().setLabelFont(LABEL_FONT_BOLD);
        plot.getRangeAxis().setTickLabelFont(LABEL_FONT);
        AbstractChartPanel panel = this.getPlotterPanel();
        if (panel == null) {
            panel = this.createPanel(chart);
        } else {
            panel.setChart(chart);
        }
        panel.getChartRenderingInfo().setEntityCollection(null);
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.getRotateLabelComponent();
        }
        return null;
    }

    @Override
    public String getPlotterName() {
        return "Bubble";
    }

    @Override
    public void dataTableSet() {
        this.updatePlotter();
    }

    @Override
    public Collection<String> resolveXAxis(int axisIndex) {
        if (this.axis[0] != -1) {
            return Collections.singletonList(this.getDataTable().getColumnName(this.axis[0]));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<String> resolveYAxis(int axisIndex) {
        if (this.axis[1] != -1) {
            return Collections.singletonList(this.getDataTable().getColumnName(this.axis[1]));
        }
        return Collections.emptyList();
    }
}

