/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.ColorProvider;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.charts.Abstract2DChartPlotter;
import java.awt.Paint;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.ui.RectangleAnchor;

public class BlockChartPlotter
extends Abstract2DChartPlotter {
    private static final long serialVersionUID = -5231467872475202473L;

    public BlockChartPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        super(settings, dataTable);
    }

    public BlockChartPlotter(PlotterConfigurationModel settings) {
        super(settings);
    }

    @Override
    public AbstractXYItemRenderer getItemRenderer(boolean nominal, int size, double minColor, double maxColor) {
        XYBlockRenderer renderer = new XYBlockRenderer();
        renderer.setPaintScale((PaintScale)new BlockPaintScale(minColor, maxColor));
        renderer.setBlockAnchor(RectangleAnchor.CENTER);
        return renderer;
    }

    @Override
    public String getPlotterName() {
        return "Block";
    }

    public static class BlockPaintScale
    implements PaintScale {
        private ColorProvider colorProvider = new ColorProvider();
        private double minColor;
        private double maxColor;

        public BlockPaintScale(double minColor, double maxColor) {
            this.minColor = minColor;
            this.maxColor = maxColor;
        }

        public Paint getPaint(double z) {
            double normalized = (z - this.minColor) / (this.maxColor - this.minColor);
            return this.colorProvider.getPointColor(normalized);
        }

        public double getUpperBound() {
            return this.maxColor;
        }

        public double getLowerBound() {
            return this.minColor;
        }
    }
}

