/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.LabelRotatingPlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.gui.plotter.charts.ChartPanelShiftController;
import com.rapidminer.gui.plotter.charts.ColorizedBarRenderer;
import com.rapidminer.gui.plotter.charts.RapidBarPainter;
import com.rapidminer.gui.plotter.settings.ListeningJCheckBox;
import com.rapidminer.gui.plotter.settings.ListeningJComboBox;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AverageFunction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.SlidingCategoryDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public class BarChartPlotter
extends LabelRotatingPlotterAdapter
implements ChangeListener {
    public static final String PARAMETER_ORIENTATION = "orientation";
    public static final String PARAMETER_AGGREGATION = "aggregation";
    public static final String PARAMETER_USE_DISTINCT = "use_distinct";
    private static final long serialVersionUID = 1208210421840512091L;
    private static final int MAX_CATEGORY_VIEW_COUNT = 40;
    private static final int MAX_CATEGORIES = 200;
    private static final String[] ORIENTATION_TYPES = new String[]{"vertical", "horizontal"};
    public static final int ORIENTATION_TYPE_VERTICAL = 0;
    public static final int ORIENTATION_TYPE_HORIZONTAL = 1;
    private DataTable dataTable;
    private DefaultCategoryDataset categoryDataSet = new DefaultCategoryDataset();
    private SlidingCategoryDataset slidingCategoryDataSet = null;
    private int groupByColumn = -1;
    private int legendByColumn = -1;
    private int valueColumn = -1;
    private ListeningJComboBox orientationType;
    private ListeningJCheckBox useDistinct;
    private ListeningJComboBox aggregationFunction = null;
    private boolean absolute = false;
    private String aggregationFunctionName;
    private boolean useDistinctFlag = false;
    private int orientationIndex = 0;
    private JPanel scrollablePlotterPanel = new JPanel(new BorderLayout());
    private ChartPanel panel = null;
    private JScrollBar viewScrollBar = new JScrollBar(0, 0, 40, 0, 200);
    private boolean showScrollbar = true;

    public BarChartPlotter(final PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
        String[] allFunctions = new String[AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length + 1];
        allFunctions[0] = "none";
        System.arraycopy(AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, 0, allFunctions, 1, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length);
        this.aggregationFunction = new ListeningJComboBox(settings, PARAMETER_AGGREGATION, allFunctions);
        this.aggregationFunction.setToolTipText("Select the type of the aggregation function which should be used for grouped values.");
        this.aggregationFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.setParameterAsString(BarChartPlotter.PARAMETER_AGGREGATION, BarChartPlotter.this.aggregationFunction.getSelectedItem().toString());
            }
        });
        this.useDistinct = new ListeningJCheckBox(PARAMETER_USE_DISTINCT, "Use Only Distinct", false);
        this.useDistinct.setToolTipText("Indicates if only distinct values should be used for aggregation functions.");
        this.useDistinct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.setParameterAsBoolean(BarChartPlotter.PARAMETER_USE_DISTINCT, BarChartPlotter.this.useDistinct.isSelected());
            }
        });
        this.orientationType = new ListeningJComboBox(settings, "_orientation", ORIENTATION_TYPES);
        this.orientationType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.setParameterAsString(BarChartPlotter.PARAMETER_ORIENTATION, BarChartPlotter.this.orientationType.getSelectedItem().toString());
            }
        });
        this.viewScrollBar.getModel().addChangeListener(this);
    }

    public BarChartPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.slidingCategoryDataSet != null) {
            this.slidingCategoryDataSet.setFirstCategoryIndex(this.viewScrollBar.getValue());
        }
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.updatePlotter();
    }

    @Override
    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
        this.updatePlotter();
    }

    @Override
    public boolean isSupportingAbsoluteValues() {
        return true;
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.valueColumn = plot ? index : -1;
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.valueColumn == index;
    }

    @Override
    public String getPlotName() {
        return "Value Column";
    }

    @Override
    public int getNumberOfAxes() {
        return 2;
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (index == 0) {
            this.groupByColumn = dimension;
        } else if (index == 1) {
            this.legendByColumn = dimension;
        }
        this.updatePlotter();
    }

    @Override
    public int getAxis(int index) {
        if (index == 0) {
            return this.groupByColumn;
        }
        if (index == 1) {
            return this.legendByColumn;
        }
        return -1;
    }

    @Override
    public String getAxisName(int index) {
        if (index == 0) {
            return "Group-By Column";
        }
        if (index == 1) {
            return "Legend Column";
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepareData() {
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            AggregationFunction aggregation = null;
            if (this.aggregationFunctionName != null && !this.aggregationFunctionName.equals("none")) {
                try {
                    aggregation = AbstractAggregationFunction.createAggregationFunction(this.aggregationFunctionName);
                }
                catch (Exception e) {
                    LogService.getGlobal().logWarning("Cannot instantiate aggregation function '" + this.aggregationFunctionName + "', using 'average' as default.");
                    aggregation = new AverageFunction();
                }
            }
            Iterator<DataTableRow> i = this.dataTable.iterator();
            LinkedHashMap<String, TreeSet<Double>> categoryValues = new LinkedHashMap<String, TreeSet<Double>>();
            this.categoryDataSet.clear();
            if (this.groupByColumn >= 0 && this.dataTable.isNumerical(this.groupByColumn)) {
                return 0;
            }
            while (i.hasNext()) {
                AbstractCollection values;
                DataTableRow row = i.next();
                double value = Double.NaN;
                if (this.valueColumn >= 0) {
                    value = row.getValue(this.valueColumn);
                }
                if (Double.isNaN(value)) continue;
                if (this.absolute) {
                    value = Math.abs(value);
                }
                String valueString = null;
                valueString = this.dataTable.isDate(this.valueColumn) ? Tools.formatDate(new Date((long)value)) : (this.dataTable.isTime(this.valueColumn) ? Tools.formatTime(new Date((long)value)) : (this.dataTable.isDateTime(this.valueColumn) ? Tools.formatDateTime(new Date((long)value)) : (this.dataTable.isNominal(this.valueColumn) ? this.dataTable.mapIndex(this.valueColumn, (int)value) : Tools.formatIntegerIfPossible(value))));
                String legendName = valueString + "";
                if (this.legendByColumn >= 0) {
                    double nameValue = row.getValue(this.legendByColumn);
                    legendName = this.dataTable.isDate(this.legendByColumn) ? Tools.formatDate(new Date((long)nameValue)) : (this.dataTable.isTime(this.legendByColumn) ? Tools.formatTime(new Date((long)nameValue)) : (this.dataTable.isDateTime(this.legendByColumn) ? Tools.formatDateTime(new Date((long)nameValue)) : (this.dataTable.isNominal(this.legendByColumn) ? this.dataTable.mapIndex(this.legendByColumn, (int)nameValue) + " (" + valueString + ")" : Tools.formatIntegerIfPossible(nameValue) + " (" + valueString + ")")));
                }
                String groupByName = legendName;
                if (this.groupByColumn >= 0) {
                    double nameValue = row.getValue(this.groupByColumn);
                    groupByName = this.dataTable.isDate(this.groupByColumn) ? Tools.formatDate(new Date((long)nameValue)) : (this.dataTable.isTime(this.groupByColumn) ? Tools.formatTime(new Date((long)nameValue)) : (this.dataTable.isDateTime(this.groupByColumn) ? Tools.formatDateTime(new Date((long)nameValue)) : (this.dataTable.isNominal(this.groupByColumn) ? this.dataTable.mapIndex(this.groupByColumn, (int)nameValue) : Tools.formatIntegerIfPossible(nameValue) + "")));
                }
                if ((values = (TreeSet<Double>)categoryValues.get(groupByName)) == null) {
                    values = this.useDistinctFlag ? new TreeSet<Double>() : new LinkedList();
                    categoryValues.put(groupByName, (TreeSet<Double>)values);
                }
                values.add(value);
            }
            if (this.valueColumn >= 0) {
                Collection values;
                if (aggregation != null) {
                    for (Map.Entry entry : categoryValues.entrySet()) {
                        String name = (String)entry.getKey();
                        values = (Collection)entry.getValue();
                        double[] valueArray = new double[values.size()];
                        Iterator v = values.iterator();
                        int valueIndex = 0;
                        while (v.hasNext()) {
                            valueArray[valueIndex++] = (Double)v.next();
                        }
                        double value = aggregation.calculate(valueArray);
                        if (this.groupByColumn < 0) {
                            this.categoryDataSet.setValue(value, (Comparable)((Object)this.dataTable.getColumnName(this.valueColumn)), (Comparable)((Object)name));
                            continue;
                        }
                        this.categoryDataSet.setValue(value, (Comparable)((Object)this.dataTable.getColumnName(this.groupByColumn)), (Comparable)((Object)name));
                    }
                } else {
                    for (Map.Entry entry : categoryValues.entrySet()) {
                        String name = (String)entry.getKey();
                        values = (Collection)entry.getValue();
                        Iterator v = values.iterator();
                        while (v.hasNext()) {
                            double value = (Double)v.next();
                            if (this.groupByColumn < 0) {
                                this.categoryDataSet.setValue(value, (Comparable)((Object)this.dataTable.getColumnName(this.valueColumn)), (Comparable)((Object)name));
                                continue;
                            }
                            this.categoryDataSet.setValue(value, (Comparable)((Object)this.dataTable.getColumnName(this.groupByColumn)), (Comparable)((Object)name));
                        }
                    }
                }
            }
            return categoryValues.size();
        }
    }

    @Override
    public JComponent getPlotter() {
        return this.scrollablePlotterPanel;
    }

    @Override
    public JComponent getRenderComponent() {
        return this.panel;
    }

    @Override
    public void prepareRendering() {
        super.prepareRendering();
        this.showScrollbar = false;
        this.updatePlotter();
    }

    @Override
    public void finishRendering() {
        super.finishRendering();
        this.showScrollbar = true;
        this.updatePlotter();
    }

    @Override
    public void updatePlotter() {
        int categoryCount = this.prepareData();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BarChartPlotter.this.scrollablePlotterPanel.remove(BarChartPlotter.this.viewScrollBar);
            }
        });
        DefaultCategoryDataset usedCategoryDataSet = this.categoryDataSet;
        if (categoryCount > 40 && this.showScrollbar) {
            if (this.orientationIndex == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BarChartPlotter.this.viewScrollBar.setOrientation(0);
                        BarChartPlotter.this.scrollablePlotterPanel.add((Component)BarChartPlotter.this.viewScrollBar, "South");
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BarChartPlotter.this.viewScrollBar.setOrientation(1);
                        BarChartPlotter.this.scrollablePlotterPanel.add((Component)BarChartPlotter.this.viewScrollBar, "East");
                    }
                });
            }
            this.slidingCategoryDataSet = new SlidingCategoryDataset((CategoryDataset)this.categoryDataSet, 0, 40);
            this.viewScrollBar.setMaximum(categoryCount);
            this.viewScrollBar.setValue(0);
            usedCategoryDataSet = this.slidingCategoryDataSet;
        } else {
            this.slidingCategoryDataSet = null;
        }
        if (categoryCount <= 200) {
            JFreeChart chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)usedCategoryDataSet, (PlotOrientation)(this.orientationIndex == 0 ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL), (boolean)false, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.WHITE);
            chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
            CategoryPlot plot = chart.getCategoryPlot();
            plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
            plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
            CategoryAxis domainAxis = plot.getDomainAxis();
            domainAxis.setLabelFont(LABEL_FONT_BOLD);
            domainAxis.setTickLabelFont(LABEL_FONT);
            String domainName = this.groupByColumn >= 0 ? this.dataTable.getColumnName(this.groupByColumn) : null;
            domainAxis.setLabel(domainName);
            if (this.isLabelRotating()) {
                plot.getDomainAxis().setTickLabelsVisible(true);
                plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.5707963267948966));
            }
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            rangeAxis.setLabelFont(LABEL_FONT_BOLD);
            rangeAxis.setTickLabelFont(LABEL_FONT);
            String rangeName = this.valueColumn >= 0 ? this.dataTable.getColumnName(this.valueColumn) : null;
            rangeAxis.setLabel(rangeName);
            double[] colorValues = null;
            colorValues = this.groupByColumn >= 0 && this.dataTable.isNominal(this.groupByColumn) ? new double[this.dataTable.getNumberOfValues(this.groupByColumn)] : new double[this.categoryDataSet.getColumnCount()];
            for (int i = 0; i < colorValues.length; ++i) {
                colorValues[i] = i;
            }
            ColorizedBarRenderer renderer = new ColorizedBarRenderer(colorValues);
            renderer.setBarPainter(new RapidBarPainter());
            renderer.setDrawBarOutline(true);
            int size = this.categoryDataSet.getRowCount();
            if (size > 1) {
                for (int i = 0; i < size; ++i) {
                    renderer.setSeriesPaint(i, this.getColorProvider().getPointColor((double)i / (double)(size - 1)));
                }
            }
            plot.setRenderer((CategoryItemRenderer)renderer);
            LegendTitle legend = chart.getLegend();
            if (legend != null) {
                legend.setPosition(RectangleEdge.TOP);
                legend.setFrame((BlockFrame)BlockBorder.NONE);
                legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
                legend.setItemFont(LABEL_FONT);
            }
            if (this.panel != null) {
                this.panel.setChart(chart);
            } else {
                this.panel = new AbstractChartPanel(chart, this.getWidth(), this.getHeight() - 20);
                this.scrollablePlotterPanel.add((Component)this.panel, "Center");
                ChartPanelShiftController controller = new ChartPanelShiftController(this.panel);
                this.panel.addMouseListener((MouseListener)controller);
                this.panel.addMouseMotionListener((MouseMotionListener)controller);
            }
            this.panel.getChartRenderingInfo().setEntityCollection(null);
        } else {
            LogService.getGlobal().logNote("Too many columns (" + categoryCount + "), this chart is only able to plot up to " + 200 + " different categories.");
        }
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        switch (index) {
            case 0: {
                JLabel label = new JLabel("Aggregation:");
                label.setToolTipText("Select the type of the aggregation function which should be used for grouped values.");
                return label;
            }
            case 1: {
                return this.aggregationFunction;
            }
            case 2: {
                return this.useDistinct;
            }
            case 3: {
                return this.getRotateLabelComponent();
            }
            case 4: {
                return this.orientationType;
            }
        }
        return null;
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys(InputPort inputPort) {
        List<ParameterType> types = super.getAdditionalParameterKeys(inputPort);
        String[] allFunctions = new String[AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length + 1];
        allFunctions[0] = "none";
        System.arraycopy(AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, 0, allFunctions, 1, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length);
        types.add(new ParameterTypeCategory(PARAMETER_AGGREGATION, "The function used for aggregating the values grouped by the specified column.", allFunctions, 0));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_DISTINCT, "Indicates if only distinct values should be regarded for aggregation.", false));
        types.add(new ParameterTypeCategory(PARAMETER_ORIENTATION, "The orientation of the bars.", ORIENTATION_TYPES, 0));
        return types;
    }

    @Override
    public List<PlotterConfigurationModel.PlotterSettingsChangedListener> getListeningObjects() {
        List<PlotterConfigurationModel.PlotterSettingsChangedListener> list = super.getListeningObjects();
        list.add(this.aggregationFunction);
        list.add(this.useDistinct);
        list.add(this.orientationType);
        return list;
    }

    @Override
    public void setAdditionalParameter(String key, String value) {
        super.setAdditionalParameter(key, value);
        if (PARAMETER_AGGREGATION.equals(key)) {
            try {
                int index = Integer.valueOf(value);
                this.aggregationFunctionName = index > 0 ? AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[index - 1] : "none";
            }
            catch (NumberFormatException e) {
                this.aggregationFunctionName = value;
            }
            this.updatePlotter();
        } else if (PARAMETER_USE_DISTINCT.equals(key)) {
            this.useDistinctFlag = Boolean.parseBoolean(value);
            this.updatePlotter();
        } else if (PARAMETER_ORIENTATION.equals(key)) {
            this.orientationIndex = value.equals(ORIENTATION_TYPES[0]) ? 0 : 1;
            this.updatePlotter();
        }
    }

    @Override
    public String getPlotterName() {
        return "Bars";
    }
}

