/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.PlotterPanel;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.gui.plotter.charts.ChartPanelShiftController;
import com.rapidminer.gui.plotter.settings.ListeningJCheckBox;
import com.rapidminer.gui.plotter.settings.ListeningJComboBox;
import com.rapidminer.gui.plotter.settings.ListeningJSlider;
import com.rapidminer.gui.plotter.settings.ListeningListSelectionModel;
import com.rapidminer.gui.tools.ExtendedJList;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedListModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AverageFunction;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public abstract class AbstractPieChartPlotter
extends PlotterAdapter {
    public static final String PARAMETERS_AGGREGATION = "aggregation";
    public static final String PARAMETERS_USE_DISTINCT = "use_distinct";
    public static final String PARAMETERS_EXPLOSION_GROUPS = "explosion_groups";
    public static final String PARAMETERS_EXPLOSION_AMOUNT = "explosion_amount";
    private static final long serialVersionUID = 8750708105082707503L;
    private static final int MAX_CATEGORIES = 50;
    private DataTable dataTable;
    private DefaultPieDataset pieDataSet = new DefaultPieDataset();
    private int groupByColumn = -1;
    private int legendByColumn = -1;
    private int valueColumn = -1;
    private ListeningJCheckBox useDistinct;
    private ListeningJComboBox aggregationFunction = null;
    private boolean absoluteFlag = false;
    private String[] explodingGroups = new String[0];
    private ExtendedJList explodingGroupList;
    private ListeningListSelectionModel explodingGroupListSelectionModel;
    private ListeningJSlider explodingSlider;
    private double explodingAmount = 0.0;
    private String selectedAggregationFunction;
    private boolean useDistinctFlag = false;
    private ChartPanel panel = new ChartPanel(null);

    public AbstractPieChartPlotter(final PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
        this.useDistinct = new ListeningJCheckBox("_use_distinct", "Use Only Distinct", false);
        this.useDistinct.setToolTipText("Indicates if only distinct values should be used for aggregation functions.");
        this.useDistinct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.setParameterAsBoolean(AbstractPieChartPlotter.PARAMETERS_USE_DISTINCT, AbstractPieChartPlotter.this.useDistinct.isSelected());
            }
        });
        String[] allFunctions = new String[AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length + 1];
        allFunctions[0] = "none";
        System.arraycopy(AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, 0, allFunctions, 1, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length);
        this.aggregationFunction = new ListeningJComboBox(settings, "_aggregation", allFunctions);
        this.aggregationFunction.setToolTipText("Select the type of the aggregation function which should be used for grouped values.");
        this.aggregationFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.setParameterAsString(AbstractPieChartPlotter.PARAMETERS_AGGREGATION, AbstractPieChartPlotter.this.aggregationFunction.getSelectedItem().toString());
            }
        });
        this.explodingGroupList = new ExtendedJList(new ExtendedListModel(), 200);
        this.explodingGroupListSelectionModel = new ListeningListSelectionModel("_explosion_groups", this.explodingGroupList);
        this.explodingGroupList.setSelectionModel(this.explodingGroupListSelectionModel);
        this.explodingGroupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object[] values = AbstractPieChartPlotter.this.explodingGroupList.getSelectedValues();
                    LinkedList<String> list = new LinkedList<String>();
                    for (Object object : values) {
                        list.add((String)object);
                    }
                    String result = ParameterTypeEnumeration.transformEnumeration2String(list);
                    settings.setParameterAsString(AbstractPieChartPlotter.PARAMETERS_EXPLOSION_GROUPS, result);
                }
            }
        });
        this.explodingGroupList.setForeground(Color.BLACK);
        this.explodingGroupList.setSelectionMode(2);
        this.explodingGroupList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.explodingGroupList.setCellRenderer(new PlotterPanel.LineStyleCellRenderer(this));
        this.updateGroups();
        this.explodingSlider = new ListeningJSlider("_explosion_amount", 0, 100, 0);
        this.explodingSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                settings.setParameterAsInt(AbstractPieChartPlotter.PARAMETERS_EXPLOSION_AMOUNT, AbstractPieChartPlotter.this.explodingSlider.getValue());
            }
        });
    }

    public AbstractPieChartPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    public abstract JFreeChart createChart(PieDataset var1, boolean var2);

    public abstract boolean isSupportingExplosion();

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.groupByColumn = -1;
        this.legendByColumn = -1;
        this.valueColumn = -1;
        this.absoluteFlag = false;
        this.explodingGroups = new String[0];
        this.explodingAmount = 0.0;
        this.updatePlotter();
    }

    @Override
    public void setAbsolute(boolean absolute) {
        this.absoluteFlag = absolute;
        this.updatePlotter();
    }

    @Override
    public boolean isSupportingAbsoluteValues() {
        return true;
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.valueColumn = plot ? index : -1;
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.valueColumn == index;
    }

    @Override
    public Icon getIcon(int index) {
        return null;
    }

    @Override
    public String getPlotName() {
        return "Value Column";
    }

    @Override
    public int getNumberOfAxes() {
        return 2;
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (index == 0) {
            this.groupByColumn = dimension;
            this.updateGroups();
        } else if (index == 1) {
            this.legendByColumn = dimension;
        }
        this.updatePlotter();
    }

    @Override
    public int getAxis(int index) {
        if (index == 0) {
            return this.groupByColumn;
        }
        if (index == 1) {
            return this.legendByColumn;
        }
        return -1;
    }

    @Override
    public String getAxisName(int index) {
        if (index == 0) {
            return "Group-By Column";
        }
        if (index == 1) {
            return "Legend Column";
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGroups() {
        ExtendedListModel model;
        TreeSet<String> groups = new TreeSet<String>();
        if (this.groupByColumn >= 0) {
            DataTable dataTable = this.dataTable;
            synchronized (dataTable) {
                DataTableRow row;
                int i;
                if (this.dataTable.isDate(this.groupByColumn)) {
                    for (i = 0; i < this.dataTable.getNumberOfRows(); ++i) {
                        row = this.dataTable.getRow(i);
                        groups.add(Tools.formatDate(new Date((long)row.getValue(this.groupByColumn))));
                    }
                } else if (this.dataTable.isTime(this.groupByColumn)) {
                    for (i = 0; i < this.dataTable.getNumberOfRows(); ++i) {
                        row = this.dataTable.getRow(i);
                        groups.add(Tools.formatTime(new Date((long)row.getValue(this.groupByColumn))));
                    }
                } else if (this.dataTable.isDateTime(this.groupByColumn)) {
                    for (i = 0; i < this.dataTable.getNumberOfRows(); ++i) {
                        row = this.dataTable.getRow(i);
                        groups.add(Tools.formatDateTime(new Date((long)row.getValue(this.groupByColumn))));
                    }
                } else if (this.dataTable.isNominal(this.groupByColumn)) {
                    for (i = 0; i < this.dataTable.getNumberOfRows(); ++i) {
                        row = this.dataTable.getRow(i);
                        groups.add(this.dataTable.mapIndex(this.groupByColumn, (int)row.getValue(this.groupByColumn)));
                    }
                } else {
                    for (i = 0; i < this.dataTable.getNumberOfRows(); ++i) {
                        row = this.dataTable.getRow(i);
                        groups.add(Tools.formatIntegerIfPossible(row.getValue(this.groupByColumn)));
                    }
                }
            }
        }
        if (groups.size() > 0) {
            model = new ExtendedListModel();
            for (String group : groups) {
                model.addElement(group, "Select group '" + group + "' for explosion.");
            }
            this.explodingGroupList.setModel(model);
        } else {
            model = new ExtendedListModel();
            model.addElement("Specify 'Group By' first...");
            this.explodingGroupList.setModel(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepareData() {
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            AggregationFunction aggregation = null;
            if (this.selectedAggregationFunction != null && !this.selectedAggregationFunction.equals("none")) {
                try {
                    aggregation = AbstractAggregationFunction.createAggregationFunction(this.selectedAggregationFunction);
                }
                catch (Exception e) {
                    LogService.getGlobal().logWarning("Cannot instantiate aggregation function '" + this.selectedAggregationFunction + "', using 'average' as default.");
                    aggregation = new AverageFunction();
                }
            }
            Iterator<DataTableRow> i = this.dataTable.iterator();
            LinkedHashMap<String, TreeSet<Double>> categoryValues = new LinkedHashMap<String, TreeSet<Double>>();
            this.pieDataSet.clear();
            if (this.groupByColumn >= 0 && this.dataTable.isNumerical(this.groupByColumn)) {
                return 0;
            }
            while (i.hasNext()) {
                AbstractCollection values;
                DataTableRow row = i.next();
                double value = Double.NaN;
                if (this.valueColumn >= 0) {
                    value = row.getValue(this.valueColumn);
                }
                if (Double.isNaN(value)) continue;
                if (this.absoluteFlag) {
                    value = Math.abs(value);
                }
                String valueString = null;
                valueString = this.dataTable.isDate(this.valueColumn) ? Tools.formatDate(new Date((long)value)) : (this.dataTable.isTime(this.valueColumn) ? Tools.formatTime(new Date((long)value)) : (this.dataTable.isDateTime(this.valueColumn) ? Tools.formatDateTime(new Date((long)value)) : (this.dataTable.isNominal(this.valueColumn) ? this.dataTable.mapIndex(this.valueColumn, (int)value) : Tools.formatIntegerIfPossible(value))));
                String legendName = valueString + "";
                if (this.legendByColumn >= 0) {
                    double nameValue = row.getValue(this.legendByColumn);
                    legendName = this.dataTable.isDate(this.legendByColumn) ? Tools.formatDate(new Date((long)nameValue)) : (this.dataTable.isTime(this.legendByColumn) ? Tools.formatTime(new Date((long)nameValue)) : (this.dataTable.isDateTime(this.legendByColumn) ? Tools.formatDateTime(new Date((long)nameValue)) : (this.dataTable.isNominal(this.legendByColumn) ? this.dataTable.mapIndex(this.legendByColumn, (int)nameValue) + " (" + valueString + ")" : Tools.formatIntegerIfPossible(nameValue) + " (" + valueString + ")")));
                }
                String groupByName = legendName;
                if (this.groupByColumn >= 0) {
                    double nameValue = row.getValue(this.groupByColumn);
                    groupByName = this.dataTable.isDate(this.groupByColumn) ? Tools.formatDate(new Date((long)nameValue)) : (this.dataTable.isTime(this.groupByColumn) ? Tools.formatTime(new Date((long)nameValue)) : (this.dataTable.isDateTime(this.groupByColumn) ? Tools.formatDateTime(new Date((long)nameValue)) : (this.dataTable.isNominal(this.groupByColumn) ? this.dataTable.mapIndex(this.groupByColumn, (int)nameValue) : Tools.formatIntegerIfPossible(nameValue) + "")));
                }
                if ((values = (TreeSet<Double>)categoryValues.get(groupByName)) == null) {
                    values = this.useDistinctFlag ? new TreeSet<Double>() : new LinkedList();
                    categoryValues.put(groupByName, (TreeSet<Double>)values);
                }
                values.add(value);
            }
            if (this.valueColumn >= 0) {
                Collection values;
                if (aggregation != null) {
                    for (Map.Entry entry : categoryValues.entrySet()) {
                        String name = (String)entry.getKey();
                        values = (Collection)entry.getValue();
                        double[] valueArray = new double[values.size()];
                        Iterator v = values.iterator();
                        int valueIndex = 0;
                        while (v.hasNext()) {
                            valueArray[valueIndex++] = (Double)v.next();
                        }
                        double value = aggregation.calculate(valueArray);
                        if (this.legendByColumn >= 0) {
                            this.pieDataSet.setValue((Comparable)((Object)name), value);
                            continue;
                        }
                        this.pieDataSet.setValue((Comparable)((Object)(name + " (" + Tools.formatIntegerIfPossible(value) + ")")), value);
                    }
                } else {
                    for (Map.Entry entry : categoryValues.entrySet()) {
                        String name = (String)entry.getKey();
                        values = (Collection)entry.getValue();
                        Iterator v = values.iterator();
                        while (v.hasNext()) {
                            double value = (Double)v.next();
                            if (this.legendByColumn >= 0) {
                                this.pieDataSet.setValue((Comparable)((Object)name), value);
                                continue;
                            }
                            this.pieDataSet.setValue((Comparable)((Object)(name + " (" + Tools.formatIntegerIfPossible(value) + ")")), value);
                        }
                    }
                }
            }
            return categoryValues.size();
        }
    }

    @Override
    public JComponent getPlotter() {
        return this.panel;
    }

    public void updatePlotter() {
        boolean createLegend;
        int categoryCount = this.prepareData();
        String maxClassesProperty = System.getProperty("rapidminer.gui.plotter.legend.classlimit");
        int maxClasses = 20;
        try {
            if (maxClassesProperty != null) {
                maxClasses = Integer.parseInt(maxClassesProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Pie Chart plotter: cannot parse property 'rapidminer.gui.plotter.colors.classlimit', using maximal 20 different classes.", 5);
        }
        boolean bl = createLegend = categoryCount > 0 && categoryCount < maxClasses;
        if (categoryCount <= 50) {
            JFreeChart chart = this.createChart((PieDataset)this.pieDataSet, createLegend);
            chart.setBackgroundPaint((Paint)Color.white);
            PiePlot plot = (PiePlot)chart.getPlot();
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setSectionOutlinesVisible(true);
            plot.setShadowPaint((Paint)new Color(104, 104, 104, 100));
            int size = this.pieDataSet.getKeys().size();
            for (int i = 0; i < size; ++i) {
                Comparable key = this.pieDataSet.getKey(i);
                plot.setSectionPaint(key, (Paint)this.getColorProvider().getPointColor((double)i / (double)(size - 1)));
                boolean explode = false;
                for (String explosionGroup : this.explodingGroups) {
                    if (!key.toString().startsWith(explosionGroup) && !explosionGroup.startsWith(key.toString())) continue;
                    explode = true;
                    break;
                }
                if (!explode) continue;
                plot.setExplodePercent(key, this.explodingAmount);
            }
            plot.setLabelFont(LABEL_FONT);
            plot.setNoDataMessage("No data available");
            plot.setCircular(false);
            plot.setLabelGap(0.02);
            plot.setOutlinePaint((Paint)Color.WHITE);
            LegendTitle legend = chart.getLegend();
            if (legend != null) {
                legend.setPosition(RectangleEdge.TOP);
                legend.setFrame((BlockFrame)BlockBorder.NONE);
                legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
                legend.setItemFont(LABEL_FONT);
            }
            if (this.panel instanceof AbstractChartPanel) {
                this.panel.setChart(chart);
            } else {
                this.panel = new AbstractChartPanel(chart, this.getWidth(), this.getHeight() - 20);
                ChartPanelShiftController controller = new ChartPanelShiftController(this.panel);
                this.panel.addMouseListener((MouseListener)controller);
                this.panel.addMouseMotionListener((MouseMotionListener)controller);
            }
            this.panel.getChartRenderingInfo().setEntityCollection(null);
        } else {
            LogService.getGlobal().logNote("Too many columns (" + categoryCount + "), this chart is only able to plot up to " + 50 + " different categories.");
        }
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        switch (index) {
            case 0: {
                JLabel label = new JLabel("Aggregation");
                label.setToolTipText("Select the type of the aggregation function which should be used for grouped values.");
                return label;
            }
            case 1: {
                return this.aggregationFunction;
            }
            case 2: {
                return this.useDistinct;
            }
            case 3: {
                if (this.isSupportingExplosion()) {
                    JLabel label = new JLabel("Explosion Groups");
                    label.setToolTipText("Select the groups which should explode, i.e. which should be located outside of the chart to the specified extent.");
                    return label;
                }
                return null;
            }
            case 4: {
                if (this.isSupportingExplosion()) {
                    this.explodingGroupList.setToolTipText("Select the groups which should explode, i.e. which should be located outside of the chart to the specified extent.");
                    ExtendedJScrollPane pane = new ExtendedJScrollPane(this.explodingGroupList);
                    return pane;
                }
                return null;
            }
            case 5: {
                if (this.isSupportingExplosion()) {
                    JLabel label = new JLabel("Explosion Amount");
                    label.setToolTipText("Select the amount of explosion for the selected groups.");
                    return label;
                }
                return null;
            }
            case 6: {
                if (!this.isSupportingExplosion()) break;
                this.explodingSlider.setToolTipText("Select the amount of explosion for the selected groups.");
                return this.explodingSlider;
            }
        }
        return null;
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys(InputPort inputPort) {
        List<ParameterType> types = super.getAdditionalParameterKeys(inputPort);
        String[] allFunctions = new String[AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length + 1];
        allFunctions[0] = "none";
        System.arraycopy(AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, 0, allFunctions, 1, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length);
        types.add(new ParameterTypeCategory(PARAMETERS_AGGREGATION, "The function used for aggregating the values grouped by the specified column.", allFunctions, 0));
        types.add(new ParameterTypeBoolean(PARAMETERS_USE_DISTINCT, "Indicates if only distinct values should be regarded for aggregation.", false));
        if (this.isSupportingExplosion()) {
            types.add(new ParameterTypeString(PARAMETERS_EXPLOSION_GROUPS, "A comma separated list of groups which should be exploded, i.e. moved out from the center of the plot.", true));
            types.add(new ParameterTypeInt(PARAMETERS_EXPLOSION_AMOUNT, "The percentage of explosion for the selected groups.", 0, 100, 0));
        }
        return types;
    }

    @Override
    public void setAdditionalParameter(String key, String value) {
        super.setAdditionalParameter(key, value);
        if (key.equals(PARAMETERS_AGGREGATION)) {
            this.selectedAggregationFunction = value;
            this.updatePlotter();
        } else if (key.equals(PARAMETERS_USE_DISTINCT)) {
            this.useDistinctFlag = Boolean.parseBoolean(value);
            this.updatePlotter();
        } else if (key.equals(PARAMETERS_EXPLOSION_GROUPS)) {
            String[] newGroups = new String[]{};
            if (value != null) {
                newGroups = value.split(",");
            }
            for (int i = 0; i < newGroups.length; ++i) {
                newGroups[i] = newGroups[i].trim();
            }
            this.explodingGroups = newGroups;
            this.updatePlotter();
        } else if (key.equals(PARAMETERS_EXPLOSION_AMOUNT)) {
            this.explodingAmount = Double.parseDouble(value) / 50.0;
            this.updatePlotter();
        } else if (key.equals(PARAMETERS_USE_DISTINCT)) {
            this.useDistinctFlag = Boolean.parseBoolean(value);
            this.updatePlotter();
        }
    }

    @Override
    public List<PlotterConfigurationModel.PlotterSettingsChangedListener> getListeningObjects() {
        List<PlotterConfigurationModel.PlotterSettingsChangedListener> listeningObjects = super.getListeningObjects();
        listeningObjects.add(this.explodingGroupListSelectionModel);
        listeningObjects.add(this.useDistinct);
        listeningObjects.add(this.explodingSlider);
        listeningObjects.add(this.aggregationFunction);
        return listeningObjects;
    }
}

