/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.gui.plotter.AxisNameResolver;
import com.rapidminer.gui.plotter.CoordinateTransformation;
import com.rapidminer.gui.plotter.NullCoordinateTransformation;
import com.rapidminer.tools.container.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartTransferable;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.editor.ChartEditor;
import org.jfree.chart.editor.ChartEditorManager;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.event.OverlayChangeEvent;
import org.jfree.chart.event.OverlayChangeListener;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Pannable;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.Zoomable;
import org.jfree.data.Range;
import org.jfree.ui.ExtensionFileFilter;
import org.jfree.util.ResourceBundleWrapper;

public class AbstractChartPanel
extends ChartPanel {
    private static final long serialVersionUID = 6046366297214274674L;
    private JFreeChart chart;
    private transient CoordinateTransformation coordinateTransformation = new NullCoordinateTransformation();
    private transient EventListenerList chartMouseListeners;
    private int minimumDrawWidth;
    private int minimumDrawHeight;
    private int maximumDrawWidth;
    private int maximumDrawHeight;
    private JPopupMenu popup;
    private ChartRenderingInfo info;
    private Point2D anchor;
    private double scaleX;
    private double scaleY;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private boolean domainZoomable = false;
    private boolean rangeZoomable = false;
    private transient AxisNameResolver axisNameResolver = new AxisNameResolver(){

        @Override
        public Collection<String> resolveYAxis(int axisIndex) {
            Plot p = AbstractChartPanel.this.chart.getPlot();
            LinkedList<String> names = new LinkedList<String>();
            if (p instanceof XYPlot) {
                XYPlot plot = (XYPlot)p;
                for (int i = 0; i < plot.getRangeAxisCount(); ++i) {
                    ValueAxis domain = plot.getRangeAxis(i);
                    names.add(domain.getLabel());
                }
            }
            return names;
        }

        @Override
        public Collection<String> resolveXAxis(int axisIndex) {
            Plot p = AbstractChartPanel.this.chart.getPlot();
            LinkedList<String> names = new LinkedList<String>();
            if (p instanceof XYPlot) {
                XYPlot plot = (XYPlot)p;
                for (int i = 0; i < plot.getDomainAxisCount(); ++i) {
                    ValueAxis domain = plot.getDomainAxis(i);
                    names.add(domain.getLabel());
                }
            }
            return names;
        }
    };
    private Point2D zoomPoint = null;
    private transient Rectangle2D selectionRectangle = null;
    private boolean fillSelectionRectangle = true;
    private int zoomTriggerDistance;
    private boolean horizontalAxisTrace = false;
    private boolean verticalAxisTrace = false;
    private transient Line2D verticalTraceLine;
    private transient Line2D horizontalTraceLine;
    private JMenuItem zoomInBothMenuItem;
    private JMenuItem zoomInDomainMenuItem;
    private JMenuItem zoomInRangeMenuItem;
    private JMenuItem zoomOutBothMenuItem;
    private JMenuItem zoomOutDomainMenuItem;
    private JMenuItem zoomOutRangeMenuItem;
    private JMenuItem zoomResetBothMenuItem;
    private JMenuItem zoomResetDomainMenuItem;
    private JMenuItem zoomResetRangeMenuItem;
    private File defaultDirectoryForSaveAs;
    private boolean enforceFileExtensions;
    private boolean ownToolTipDelaysActive;
    private int originalToolTipInitialDelay;
    private int originalToolTipReshowDelay;
    private int originalToolTipDismissDelay;
    private int ownToolTipInitialDelay;
    private int ownToolTipReshowDelay;
    private int ownToolTipDismissDelay;
    private double zoomInFactor = 0.8;
    private double zoomOutFactor = 1.25;
    private boolean zoomAroundAnchor;
    private transient Paint selectionOutlinePaint;
    private transient Paint selectionFillPaint;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle((String)"org.jfree.chart.LocalizationBundle");
    private double panW;
    private double panH;
    private Point panLast;
    private int panMask = 2;
    private List<Overlay> overlays;
    private Collection<SelectionListener> selectionListeners = new LinkedList<SelectionListener>();
    private Object mouseWheelHandler;

    public AbstractChartPanel(JFreeChart chart) {
        this(chart, 680, 420, 300, 200, 1024, 768, true, true, true, true, true, true);
    }

    public AbstractChartPanel(JFreeChart chart, boolean useBuffer) {
        this(chart, 680, 420, 300, 200, 1024, 768, useBuffer, true, true, true, true, true);
    }

    public AbstractChartPanel(JFreeChart chart, int width, int height) {
        this(chart, width, height, 100, 100, Integer.MAX_VALUE, Integer.MAX_VALUE, false, false, false, false, true, true);
    }

    public AbstractChartPanel(JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        this(chart, 680, 420, 300, 200, 1024, 768, true, properties, save, print, zoom, tooltips);
    }

    public AbstractChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        this(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, true, save, print, zoom, tooltips);
    }

    public AbstractChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean copy, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, false, properties, copy, save, print, zoom, tooltips);
        this.setChart(chart);
        this.chartMouseListeners = new EventListenerList();
        this.info = new ChartRenderingInfo();
        this.setPreferredSize(new Dimension(width, height));
        this.minimumDrawWidth = minimumDrawWidth;
        this.minimumDrawHeight = minimumDrawHeight;
        this.maximumDrawWidth = maximumDrawWidth;
        this.maximumDrawHeight = maximumDrawHeight;
        this.zoomTriggerDistance = 10;
        this.popup = null;
        if (properties || copy || save || print || zoom) {
            this.popup = this.createPopupMenu(properties, copy, save, print, zoom);
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.setDisplayToolTips(tooltips);
        this.defaultDirectoryForSaveAs = null;
        this.enforceFileExtensions = true;
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        this.ownToolTipInitialDelay = ttm.getInitialDelay();
        this.ownToolTipDismissDelay = ttm.getDismissDelay();
        this.ownToolTipReshowDelay = ttm.getReshowDelay();
        this.zoomAroundAnchor = false;
        this.selectionOutlinePaint = Color.blue;
        this.selectionFillPaint = new Color(0, 0, 255, 63);
        this.panMask = 2;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("mac os x")) {
            this.panMask = 8;
        }
        this.overlays = new ArrayList<Overlay>();
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getScrollType() != 0) {
                    return;
                }
                if (e.getWheelRotation() < 0) {
                    AbstractChartPanel.this.shrinkSelectionOnCenter(e.getX(), e.getY(), e);
                } else {
                    AbstractChartPanel.this.enlargeSelectionOnCenter(e.getX(), e.getY(), e);
                }
            }
        });
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart chart) {
        if (this.chart != null) {
            this.chart.removeChangeListener((ChartChangeListener)this);
            this.chart.removeProgressListener((ChartProgressListener)this);
        }
        this.chart = chart;
        if (chart != null) {
            this.chart.addChangeListener((ChartChangeListener)this);
            this.chart.addProgressListener((ChartProgressListener)this);
            Plot plot = chart.getPlot();
            this.domainZoomable = false;
            this.rangeZoomable = false;
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)plot;
                this.domainZoomable = z.isDomainZoomable();
                this.rangeZoomable = z.isRangeZoomable();
                this.orientation = z.getOrientation();
            }
        } else {
            this.domainZoomable = false;
            this.rangeZoomable = false;
        }
        this.repaint();
    }

    public int getMinimumDrawWidth() {
        return this.minimumDrawWidth;
    }

    public void setMinimumDrawWidth(int width) {
        this.minimumDrawWidth = width;
    }

    public int getMaximumDrawWidth() {
        return this.maximumDrawWidth;
    }

    public void setMaximumDrawWidth(int width) {
        this.maximumDrawWidth = width;
    }

    public int getMinimumDrawHeight() {
        return this.minimumDrawHeight;
    }

    public void setMinimumDrawHeight(int height) {
        this.minimumDrawHeight = height;
    }

    public int getMaximumDrawHeight() {
        return this.maximumDrawHeight;
    }

    public void setMaximumDrawHeight(int height) {
        this.maximumDrawHeight = height;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public Point2D getAnchor() {
        return this.anchor;
    }

    protected void setAnchor(Point2D anchor) {
        this.anchor = anchor;
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public void setPopupMenu(JPopupMenu popup) {
        this.popup = popup;
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return this.info;
    }

    public void setMouseZoomable(boolean flag) {
        this.setMouseZoomable(flag, true);
    }

    public void setMouseZoomable(boolean flag, boolean fillRectangle) {
        this.setDomainZoomable(flag);
        this.setRangeZoomable(flag);
        this.setFillZoomRectangle(fillRectangle);
    }

    public boolean isDomainZoomable() {
        return this.domainZoomable;
    }

    public void setDomainZoomable(boolean flag) {
        if (flag) {
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)plot;
                this.domainZoomable = flag && z.isDomainZoomable();
            }
        } else {
            this.domainZoomable = false;
        }
    }

    public boolean isRangeZoomable() {
        return this.rangeZoomable;
    }

    public void setRangeZoomable(boolean flag) {
        if (flag) {
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)plot;
                this.rangeZoomable = flag && z.isRangeZoomable();
            }
        } else {
            this.rangeZoomable = false;
        }
    }

    public boolean getFillZoomRectangle() {
        return this.fillSelectionRectangle;
    }

    public void setFillZoomRectangle(boolean flag) {
        this.fillSelectionRectangle = flag;
    }

    public int getZoomTriggerDistance() {
        return this.zoomTriggerDistance;
    }

    public void setZoomTriggerDistance(int distance) {
        this.zoomTriggerDistance = distance;
    }

    public boolean getHorizontalAxisTrace() {
        return this.horizontalAxisTrace;
    }

    public void setHorizontalAxisTrace(boolean flag) {
        this.horizontalAxisTrace = flag;
    }

    protected Line2D getHorizontalTraceLine() {
        return this.horizontalTraceLine;
    }

    protected void setHorizontalTraceLine(Line2D line) {
        this.horizontalTraceLine = line;
    }

    public boolean getVerticalAxisTrace() {
        return this.verticalAxisTrace;
    }

    public void setVerticalAxisTrace(boolean flag) {
        this.verticalAxisTrace = flag;
    }

    protected Line2D getVerticalTraceLine() {
        return this.verticalTraceLine;
    }

    protected void setVerticalTraceLine(Line2D line) {
        this.verticalTraceLine = line;
    }

    public File getDefaultDirectoryForSaveAs() {
        return this.defaultDirectoryForSaveAs;
    }

    public void setDefaultDirectoryForSaveAs(File directory) {
        if (directory != null && !directory.isDirectory()) {
            throw new IllegalArgumentException("The 'directory' argument is not a directory.");
        }
        this.defaultDirectoryForSaveAs = directory;
    }

    public boolean isEnforceFileExtensions() {
        return this.enforceFileExtensions;
    }

    public void setEnforceFileExtensions(boolean enforce) {
        this.enforceFileExtensions = enforce;
    }

    public boolean getZoomAroundAnchor() {
        return this.zoomAroundAnchor;
    }

    public void setZoomAroundAnchor(boolean zoomAroundAnchor) {
        this.zoomAroundAnchor = zoomAroundAnchor;
    }

    public Paint getZoomFillPaint() {
        return this.selectionFillPaint;
    }

    public void setZoomFillPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.selectionFillPaint = paint;
    }

    public Paint getZoomOutlinePaint() {
        return this.selectionOutlinePaint;
    }

    public void setZoomOutlinePaint(Paint paint) {
        this.selectionOutlinePaint = paint;
    }

    public boolean isMouseWheelEnabled() {
        return this.mouseWheelHandler != null;
    }

    public void setMouseWheelEnabled(boolean flag) {
        if (flag && this.mouseWheelHandler == null) {
            try {
                Class<?> c = Class.forName("org.jfree.chart.MouseWheelHandler");
                Constructor<?> cc = c.getConstructor(ChartPanel.class);
                Object mwh = cc.newInstance(new Object[]{this});
                this.mouseWheelHandler = mwh;
            }
            catch (ClassNotFoundException e) {
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else if (!flag && this.mouseWheelHandler != null) {
            try {
                Class<?> mwl = Class.forName("java.awt.event.MouseWheelListener");
                Class<ChartPanel> c2 = ChartPanel.class;
                Method m = c2.getMethod("removeMouseWheelListener", mwl);
                m.invoke((Object)this, this.mouseWheelHandler);
                this.mouseWheelHandler = null;
            }
            catch (ClassNotFoundException e) {
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void addOverlay(Overlay overlay) {
        if (overlay == null) {
            throw new IllegalArgumentException("Null 'overlay' argument.");
        }
        this.overlays.add(overlay);
        overlay.addChangeListener((OverlayChangeListener)this);
        this.repaint();
    }

    public void removeOverlay(Overlay overlay) {
        if (overlay == null) {
            throw new IllegalArgumentException("Null 'overlay' argument.");
        }
        boolean removed = this.overlays.remove(overlay);
        if (removed) {
            overlay.removeChangeListener((OverlayChangeListener)this);
            this.repaint();
        }
    }

    public void overlayChanged(OverlayChangeEvent event) {
        this.repaint();
    }

    public void setDisplayToolTips(boolean flag) {
        if (flag) {
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        } else {
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)((Object)this));
        }
    }

    public String getToolTipText(MouseEvent e) {
        EntityCollection entities;
        String result = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            Insets insets = this.getInsets();
            ChartEntity entity = entities.getEntity((double)((int)((double)(e.getX() - insets.left) / this.scaleX)), (double)((int)((double)(e.getY() - insets.top) / this.scaleY)));
            if (entity != null) {
                result = entity.getToolTipText();
            }
        }
        return result;
    }

    public Point translateJava2DToScreen(Point2D java2DPoint) {
        Insets insets = this.getInsets();
        int x = (int)(java2DPoint.getX() * this.scaleX + (double)insets.left);
        int y = (int)(java2DPoint.getY() * this.scaleY + (double)insets.top);
        return new Point(x, y);
    }

    public Point2D translateScreenToJava2D(Point screenPoint) {
        Insets insets = this.getInsets();
        double x = (screenPoint.getX() - (double)insets.left) / this.scaleX;
        double y = (screenPoint.getY() - (double)insets.top) / this.scaleY;
        return new Point2D.Double(x, y);
    }

    public Rectangle2D scale(Rectangle2D rect) {
        Insets insets = this.getInsets();
        double x = rect.getX() * this.getScaleX() + (double)insets.left;
        double y = rect.getY() * this.getScaleY() + (double)insets.top;
        double w = rect.getWidth() * this.getScaleX();
        double h = rect.getHeight() * this.getScaleY();
        return new Rectangle2D.Double(x, y, w, h);
    }

    public ChartEntity getEntityForPoint(int viewX, int viewY) {
        ChartEntity result = null;
        if (this.info != null) {
            Insets insets = this.getInsets();
            double x = (double)(viewX - insets.left) / this.scaleX;
            double y = (double)(viewY - insets.top) / this.scaleY;
            EntityCollection entities = this.info.getEntityCollection();
            result = entities != null ? entities.getEntity(x, y) : null;
        }
        return result;
    }

    public void paintComponent(Graphics g) {
        if (this.chart == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        Rectangle2D.Double available = new Rectangle2D.Double(insets.left, insets.top, size.getWidth() - (double)insets.left - (double)insets.right, size.getHeight() - (double)insets.top - (double)insets.bottom);
        boolean scale = false;
        double drawWidth = ((RectangularShape)available).getWidth();
        double drawHeight = ((RectangularShape)available).getHeight();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (drawWidth < (double)this.minimumDrawWidth) {
            this.scaleX = drawWidth / (double)this.minimumDrawWidth;
            drawWidth = this.minimumDrawWidth;
            scale = true;
        } else if (drawWidth > (double)this.maximumDrawWidth) {
            this.scaleX = drawWidth / (double)this.maximumDrawWidth;
            drawWidth = this.maximumDrawWidth;
            scale = true;
        }
        if (drawHeight < (double)this.minimumDrawHeight) {
            this.scaleY = drawHeight / (double)this.minimumDrawHeight;
            drawHeight = this.minimumDrawHeight;
            scale = true;
        } else if (drawHeight > (double)this.maximumDrawHeight) {
            this.scaleY = drawHeight / (double)this.maximumDrawHeight;
            drawHeight = this.maximumDrawHeight;
            scale = true;
        }
        Rectangle2D.Double chartArea = new Rectangle2D.Double(0.0, 0.0, drawWidth, drawHeight);
        AffineTransform saved = g2.getTransform();
        g2.translate(insets.left, insets.top);
        if (scale) {
            AffineTransform st = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
            g2.transform(st);
        }
        this.chart.draw(g2, (Rectangle2D)chartArea, this.anchor, this.info);
        g2.setTransform(saved);
        for (Overlay overlay : this.overlays) {
            overlay.paintOverlay(g2, (ChartPanel)this);
        }
        this.drawSelectionRectangle(g2);
        g2.dispose();
        this.anchor = null;
        this.verticalTraceLine = null;
        this.horizontalTraceLine = null;
    }

    public void chartChanged(ChartChangeEvent event) {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable z = (Zoomable)plot;
            this.orientation = z.getOrientation();
        }
        this.repaint();
    }

    public void chartProgress(ChartProgressEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        double screenX = -1.0;
        double screenY = -1.0;
        if (this.zoomPoint != null) {
            screenX = this.zoomPoint.getX();
            screenY = this.zoomPoint.getY();
        }
        if (command.equals("PROPERTIES")) {
            this.doEditChartProperties();
        } else if (command.equals("COPY")) {
            this.doCopy();
        } else if (command.equals("SAVE")) {
            try {
                this.doSaveAs();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (command.equals("PRINT")) {
            this.createChartPrintJob();
        } else if (command.equals("ZOOM_IN_BOTH")) {
            this.zoomInBoth(screenX, screenY);
        } else if (command.equals("ZOOM_IN_DOMAIN")) {
            this.shrinkSelectionOnCenter(screenX, screenY, null);
        } else if (command.equals("ZOOM_IN_RANGE")) {
            this.shrinkSelectionOnRange(screenX, screenY, null);
        } else if (command.equals("ZOOM_OUT_BOTH")) {
            this.enlargeSelectionOnCenter(screenX, screenY, null);
        } else if (command.equals("ZOOM_DOMAIN_BOTH")) {
            this.enlargeSelectionOnDomain(screenX, screenY, null);
        } else if (command.equals("ZOOM_RANGE_BOTH")) {
            this.enlargeSelectionOnRange(screenX, screenY, null);
        } else if (command.equals("ZOOM_RESET_BOTH")) {
            this.restoreAutoBounds();
        } else if (command.equals("ZOOM_RESET_DOMAIN")) {
            this.selectCompleteDomainBounds();
        } else if (command.equals("ZOOM_RESET_RANGE")) {
            this.selectCompleteRangeBounds();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.ownToolTipDelaysActive) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            this.originalToolTipInitialDelay = ttm.getInitialDelay();
            ttm.setInitialDelay(this.ownToolTipInitialDelay);
            this.originalToolTipReshowDelay = ttm.getReshowDelay();
            ttm.setReshowDelay(this.ownToolTipReshowDelay);
            this.originalToolTipDismissDelay = ttm.getDismissDelay();
            ttm.setDismissDelay(this.ownToolTipDismissDelay);
            this.ownToolTipDelaysActive = true;
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.ownToolTipDelaysActive) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            ttm.setInitialDelay(this.originalToolTipInitialDelay);
            ttm.setReshowDelay(this.originalToolTipReshowDelay);
            ttm.setDismissDelay(this.originalToolTipDismissDelay);
            this.ownToolTipDelaysActive = false;
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.chart == null) {
            return;
        }
        Plot plot = this.chart.getPlot();
        int mods = e.getModifiers();
        if ((mods & this.panMask) == this.panMask) {
            Rectangle2D screenDataArea;
            if (plot instanceof Pannable && (screenDataArea = this.getScreenDataArea(e.getX(), e.getY())) != null && screenDataArea.contains(e.getPoint())) {
                this.panW = screenDataArea.getWidth();
                this.panH = screenDataArea.getHeight();
                this.panLast = e.getPoint();
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
        } else if (this.selectionRectangle == null) {
            Rectangle2D screenDataArea = this.getScreenDataArea(e.getX(), e.getY());
            this.zoomPoint = screenDataArea != null ? this.getPointInRectangle(e.getX(), e.getY(), screenDataArea) : null;
            if (e.isPopupTrigger() && this.popup != null) {
                this.displayPopupMenu(e.getX(), e.getY());
            }
        }
    }

    private Point2D getPointInRectangle(int x, int y, Rectangle2D area) {
        double xx = Math.max(area.getMinX(), Math.min((double)x, area.getMaxX()));
        double yy = Math.max(area.getMinY(), Math.min((double)y, area.getMaxY()));
        return new Point2D.Double(xx, yy);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.popup != null && this.popup.isShowing()) {
            return;
        }
        if (this.panLast != null) {
            double dx = (double)e.getX() - this.panLast.getX();
            double dy = (double)e.getY() - this.panLast.getY();
            if (dx == 0.0 && dy == 0.0) {
                return;
            }
            double wPercent = -dx / this.panW;
            double hPercent = dy / this.panH;
            boolean old = this.chart.getPlot().isNotify();
            this.chart.getPlot().setNotify(false);
            Pannable p = (Pannable)this.chart.getPlot();
            if (p.getOrientation() == PlotOrientation.VERTICAL) {
                this.panAxes(wPercent, hPercent, e);
            } else {
                this.panAxes(hPercent, wPercent, e);
            }
            this.panLast = e.getPoint();
            this.chart.getPlot().setNotify(old);
            return;
        }
        if (this.zoomPoint == null) {
            return;
        }
        boolean hZoom = false;
        boolean vZoom = false;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            hZoom = this.rangeZoomable;
            vZoom = this.domainZoomable;
        } else {
            hZoom = this.domainZoomable;
            vZoom = this.rangeZoomable;
        }
        Rectangle2D scaledDataArea = this.getScreenDataArea((int)this.zoomPoint.getX(), (int)this.zoomPoint.getY());
        if (hZoom && vZoom) {
            double xmax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
            double ymax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
            this.selectionRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), xmax - this.zoomPoint.getX(), ymax - this.zoomPoint.getY());
        } else if (hZoom) {
            double xmax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
            this.selectionRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), scaledDataArea.getMinY(), xmax - this.zoomPoint.getX(), scaledDataArea.getHeight());
        } else if (vZoom) {
            double ymax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
            this.selectionRectangle = new Rectangle2D.Double(scaledDataArea.getMinX(), this.zoomPoint.getY(), scaledDataArea.getWidth(), ymax - this.zoomPoint.getY());
        }
        this.repaint();
    }

    private void panAxes(double wPercent, double hPercent, MouseEvent selectionEvent) {
        Plot p = this.chart.getPlot();
        if (p instanceof XYPlot) {
            Range axisRange;
            double shift;
            double upperBound;
            double lowerBound;
            ValueAxis axis;
            int i;
            XYPlot plot = (XYPlot)p;
            Selection selectionObject = new Selection();
            for (i = 0; i < plot.getRangeAxisCount(); ++i) {
                axis = plot.getRangeAxis(i);
                lowerBound = axis.getLowerBound();
                upperBound = axis.getUpperBound();
                shift = (upperBound - lowerBound) * hPercent;
                axisRange = new Range(lowerBound += shift, upperBound += shift);
                for (String axisName : this.axisNameResolver.resolveYAxis(i)) {
                    selectionObject.addDelimiter(axisName, axisRange);
                }
            }
            for (i = 0; i < plot.getDomainAxisCount(); ++i) {
                axis = plot.getDomainAxis(i);
                lowerBound = axis.getLowerBound();
                upperBound = axis.getUpperBound();
                shift = (upperBound - lowerBound) * wPercent;
                axisRange = new Range(lowerBound += shift, upperBound += shift);
                for (String axisName : this.axisNameResolver.resolveXAxis(i)) {
                    selectionObject.addDelimiter(axisName, axisRange);
                }
            }
            this.informSelectionListener(selectionObject, selectionEvent);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.panLast != null) {
            this.panLast = null;
            this.setCursor(Cursor.getDefaultCursor());
        } else if (this.selectionRectangle != null) {
            boolean zoomTrigger2;
            boolean hZoom = false;
            boolean vZoom = false;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                hZoom = this.rangeZoomable;
                vZoom = this.domainZoomable;
            } else {
                hZoom = this.domainZoomable;
                vZoom = this.rangeZoomable;
            }
            boolean zoomTrigger1 = hZoom && Math.abs((double)e.getX() - this.zoomPoint.getX()) >= (double)this.zoomTriggerDistance;
            boolean bl = zoomTrigger2 = vZoom && Math.abs((double)e.getY() - this.zoomPoint.getY()) >= (double)this.zoomTriggerDistance;
            if (zoomTrigger1 || zoomTrigger2) {
                if (hZoom && (double)e.getX() < this.zoomPoint.getX() || vZoom && (double)e.getY() < this.zoomPoint.getY()) {
                    this.restoreAutoBounds();
                } else {
                    double h;
                    double w;
                    double y;
                    double x;
                    Rectangle2D screenDataArea = this.getScreenDataArea((int)this.zoomPoint.getX(), (int)this.zoomPoint.getY());
                    double maxX = screenDataArea.getMaxX();
                    double maxY = screenDataArea.getMaxY();
                    if (!vZoom) {
                        x = this.zoomPoint.getX();
                        y = screenDataArea.getMinY();
                        w = Math.min(this.selectionRectangle.getWidth(), maxX - this.zoomPoint.getX());
                        h = screenDataArea.getHeight();
                    } else if (!hZoom) {
                        x = screenDataArea.getMinX();
                        y = this.zoomPoint.getY();
                        w = screenDataArea.getWidth();
                        h = Math.min(this.selectionRectangle.getHeight(), maxY - this.zoomPoint.getY());
                    } else {
                        x = this.zoomPoint.getX();
                        y = this.zoomPoint.getY();
                        w = Math.min(this.selectionRectangle.getWidth(), maxX - this.zoomPoint.getX());
                        h = Math.min(this.selectionRectangle.getHeight(), maxY - this.zoomPoint.getY());
                    }
                    Rectangle2D.Double zoomArea = new Rectangle2D.Double(x, y, w, h);
                    this.selectRectangle(zoomArea, e);
                }
                this.zoomPoint = null;
                this.selectionRectangle = null;
            } else {
                this.zoomPoint = null;
                this.selectionRectangle = null;
            }
        } else if (e.isPopupTrigger() && this.popup != null) {
            this.displayPopupMenu(e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent event) {
        EntityCollection entities;
        Insets insets = this.getInsets();
        int x = (int)((double)(event.getX() - insets.left) / this.scaleX);
        int y = (int)((double)(event.getY() - insets.top) / this.scaleY);
        this.anchor = new Point2D.Double(x, y);
        if (this.chart == null) {
            return;
        }
        this.chart.setNotify(true);
        EventListener[] listeners = this.chartMouseListeners.getListeners(ChartMouseListener.class);
        if (listeners.length == 0) {
            return;
        }
        ChartEntity entity = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            entity = entities.getEntity((double)x, (double)y);
        }
        ChartMouseEvent chartEvent = new ChartMouseEvent(this.getChart(), event, entity);
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((ChartMouseListener)listeners[i]).chartMouseClicked(chartEvent);
        }
    }

    public void mouseMoved(MouseEvent e) {
        EntityCollection entities;
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        if (this.horizontalAxisTrace) {
            this.drawHorizontalAxisTrace(g2, e.getX());
        }
        if (this.verticalAxisTrace) {
            this.drawVerticalAxisTrace(g2, e.getY());
        }
        g2.dispose();
        EventListener[] listeners = this.chartMouseListeners.getListeners(ChartMouseListener.class);
        if (listeners.length == 0) {
            return;
        }
        Insets insets = this.getInsets();
        int x = (int)((double)(e.getX() - insets.left) / this.scaleX);
        int y = (int)((double)(e.getY() - insets.top) / this.scaleY);
        ChartEntity entity = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            entity = entities.getEntity((double)x, (double)y);
        }
        if (this.chart != null) {
            ChartMouseEvent event = new ChartMouseEvent(this.getChart(), e, entity);
            for (int i = listeners.length - 1; i >= 0; --i) {
                ((ChartMouseListener)listeners[i]).chartMouseMoved(event);
            }
        }
    }

    public void shrinkSelectionOnCenter(double x, double y, MouseEvent selectionEvent) {
        Plot plot = this.chart.getPlot();
        if (plot == null) {
            return;
        }
        boolean savedNotify = plot.isNotify();
        plot.setNotify(false);
        this.shrinkSelectionOnDomain(x, y, selectionEvent);
        this.shrinkSelectionOnRange(x, y, selectionEvent);
        plot.setNotify(savedNotify);
    }

    public void enlargeSelectionOnCenter(double x, double y, MouseEvent selectionEvent) {
        Plot plot = this.chart.getPlot();
        if (plot == null) {
            return;
        }
        boolean savedNotify = plot.isNotify();
        plot.setNotify(false);
        this.enlargeSelectionOnDomain(x, y, selectionEvent);
        this.enlargeSelectionOnRange(x, y, selectionEvent);
        plot.setNotify(savedNotify);
    }

    public void shrinkSelectionOnDomain(double x, double y, MouseEvent selectionEvent) {
        Plot p = this.chart.getPlot();
        if (p instanceof XYPlot) {
            XYPlot plot = (XYPlot)p;
            Selection selectionObject = new Selection();
            for (int i = 0; i < plot.getDomainAxisCount(); ++i) {
                ValueAxis domain = plot.getDomainAxis(i);
                double zoomFactor = this.getZoomInFactor();
                this.shrinkSelectionXAxis(x, y, selectionObject, domain, i, zoomFactor);
            }
            this.informSelectionListener(selectionObject, selectionEvent);
        }
    }

    public void enlargeSelectionOnDomain(double x, double y, MouseEvent selectionEvent) {
        Plot p = this.chart.getPlot();
        if (p instanceof XYPlot) {
            XYPlot plot = (XYPlot)p;
            Selection selectionObject = new Selection();
            for (int i = 0; i < plot.getDomainAxisCount(); ++i) {
                ValueAxis domain = plot.getDomainAxis(i);
                double zoomFactor = this.getZoomOutFactor();
                this.shrinkSelectionXAxis(x, y, selectionObject, domain, i, zoomFactor);
            }
            this.informSelectionListener(selectionObject, selectionEvent);
        }
    }

    private void shrinkSelectionYAxis(double x, double y, Selection selectionObject, ValueAxis axis, int axisIndex, double zoomFactor) {
        Rectangle2D scaledDataArea = this.getScreenDataArea((int)x, (int)y);
        double minY = scaledDataArea.getMinY();
        double maxY = scaledDataArea.getMaxY();
        double partToTop = (y - minY) / (maxY - minY);
        double lowerDomain = axis.getLowerBound();
        double upperDomain = axis.getUpperBound();
        double middlePointTop = lowerDomain + (upperDomain - lowerDomain) * (1.0 - partToTop);
        double width = (upperDomain - lowerDomain) * zoomFactor;
        Range axisRange = new Range(middlePointTop - width / 2.0, middlePointTop + width / 2.0);
        for (String axisName : this.axisNameResolver.resolveYAxis(axisIndex)) {
            selectionObject.addDelimiter(axisName, axisRange);
        }
    }

    public void shrinkSelectionOnRange(double x, double y, MouseEvent selectionEvent) {
        Plot p = this.chart.getPlot();
        if (p instanceof XYPlot) {
            XYPlot plot = (XYPlot)p;
            Selection selectionObject = new Selection();
            for (int i = 0; i < plot.getRangeAxisCount(); ++i) {
                ValueAxis domain = plot.getRangeAxis(i);
                double zoomFactor = this.getZoomInFactor();
                this.shrinkSelectionYAxis(x, y, selectionObject, domain, i, zoomFactor);
            }
            this.informSelectionListener(selectionObject, selectionEvent);
        }
    }

    public void enlargeSelectionOnRange(double x, double y, MouseEvent selectionEvent) {
        Plot p = this.chart.getPlot();
        if (p instanceof XYPlot) {
            XYPlot plot = (XYPlot)p;
            Selection selectionObject = new Selection();
            for (int i = 0; i < plot.getRangeAxisCount(); ++i) {
                ValueAxis domain = plot.getRangeAxis(i);
                double zoomFactor = this.getZoomOutFactor();
                this.shrinkSelectionYAxis(x, y, selectionObject, domain, i, zoomFactor);
            }
            this.informSelectionListener(selectionObject, selectionEvent);
        }
    }

    private void shrinkSelectionXAxis(double x, double y, Selection selectionObject, ValueAxis axis, int axisIndex, double zoomFactor) {
        Rectangle2D scaledDataArea = this.getScreenDataArea((int)x, (int)y);
        double minX = scaledDataArea.getMinX();
        double maxX = scaledDataArea.getMaxX();
        double partToLeft = (x - minX) / (maxX - minX);
        double lowerDomain = axis.getLowerBound();
        double upperDomain = axis.getUpperBound();
        double middlePointLeft = lowerDomain + (upperDomain - lowerDomain) * partToLeft;
        double width = (upperDomain - lowerDomain) * zoomFactor;
        Range domainRange = new Range(middlePointLeft - width / 2.0, middlePointLeft + width / 2.0);
        for (String axisName : this.axisNameResolver.resolveXAxis(axisIndex)) {
            selectionObject.addDelimiter(axisName, domainRange);
        }
    }

    public void selectRectangle(Rectangle2D selection, MouseEvent selectionEvent) {
        Rectangle2D scaledDataArea = this.getScreenDataArea((int)selection.getCenterX(), (int)selection.getCenterY());
        if (selection.getHeight() > 0.0 && selection.getWidth() > 0.0) {
            double hLower = (selection.getMinX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            double hUpper = (selection.getMaxX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            double vLower = (scaledDataArea.getMaxY() - selection.getMaxY()) / scaledDataArea.getHeight();
            double vUpper = (scaledDataArea.getMaxY() - selection.getMinY()) / scaledDataArea.getHeight();
            Plot p = this.chart.getPlot();
            if (p instanceof XYPlot) {
                Range axisRange;
                int i;
                XYPlot plot = (XYPlot)p;
                Selection selectionObject = new Selection();
                for (i = 0; i < plot.getDomainAxisCount(); ++i) {
                    ValueAxis domain = plot.getDomainAxis(i);
                    double lowerDomain = domain.getLowerBound();
                    double upperDomain = domain.getUpperBound();
                    axisRange = new Range(lowerDomain + (upperDomain - lowerDomain) * hLower, lowerDomain + (upperDomain - lowerDomain) * hUpper);
                    for (String axisName : this.axisNameResolver.resolveXAxis(i)) {
                        selectionObject.addDelimiter(axisName, axisRange);
                    }
                }
                for (i = 0; i < plot.getRangeAxisCount(); ++i) {
                    ValueAxis range = plot.getRangeAxis(i);
                    double lowerRange = range.getLowerBound();
                    double upperRange = range.getUpperBound();
                    axisRange = new Range(lowerRange + (upperRange - lowerRange) * vLower, lowerRange + (upperRange - lowerRange) * vUpper);
                    for (String axisName : this.axisNameResolver.resolveYAxis(i)) {
                        selectionObject.addDelimiter(axisName, axisRange);
                    }
                }
                this.informSelectionListener(selectionObject, selectionEvent);
            }
        }
    }

    private void informSelectionListener(Selection selectionObject, MouseEvent selectionEvent) {
        for (SelectionListener listener : this.selectionListeners) {
            listener.selected(selectionObject, selectionEvent);
        }
        if (this.selectionListeners.isEmpty()) {
            this.repaint();
        }
    }

    public void restoreAutoBounds() {
        Plot plot = this.chart.getPlot();
        if (plot == null) {
            return;
        }
        boolean savedNotify = plot.isNotify();
        plot.setNotify(false);
        this.selectCompleteDomainBounds();
        this.selectCompleteRangeBounds();
        plot.setNotify(savedNotify);
    }

    public void selectCompleteDomainBounds() {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable z = (Zoomable)plot;
            boolean savedNotify = plot.isNotify();
            plot.setNotify(false);
            Point2D zp = this.zoomPoint != null ? this.zoomPoint : new Point();
            z.zoomDomainAxes(0.0, this.info.getPlotInfo(), zp);
            plot.setNotify(savedNotify);
            if (plot instanceof XYPlot) {
                XYPlot xyPlot = (XYPlot)plot;
                Selection selectionObject = new Selection();
                for (int i = 0; i < xyPlot.getDomainAxisCount(); ++i) {
                    ValueAxis domain = xyPlot.getDomainAxis(i);
                    Range axisRange = new Range(domain.getLowerBound(), domain.getUpperBound());
                    for (String axisName : this.axisNameResolver.resolveXAxis(i)) {
                        selectionObject.addDelimiter(axisName, axisRange);
                    }
                }
                this.informSelectionListener(selectionObject, null);
            }
        }
    }

    public void selectCompleteRangeBounds() {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable z = (Zoomable)plot;
            boolean savedNotify = plot.isNotify();
            plot.setNotify(false);
            Point2D zp = this.zoomPoint != null ? this.zoomPoint : new Point();
            z.zoomRangeAxes(0.0, this.info.getPlotInfo(), zp);
            plot.setNotify(savedNotify);
            if (plot instanceof XYPlot) {
                XYPlot xyPlot = (XYPlot)plot;
                Selection selectionObject = new Selection();
                for (int i = 0; i < xyPlot.getRangeAxisCount(); ++i) {
                    ValueAxis range = xyPlot.getRangeAxis(i);
                    Range axisRange = new Range(range.getLowerBound(), range.getUpperBound());
                    for (String axisName : this.axisNameResolver.resolveYAxis(i)) {
                        selectionObject.addDelimiter(axisName, axisRange);
                    }
                }
                this.informSelectionListener(selectionObject, null);
            }
        }
    }

    public Rectangle2D getScreenDataArea() {
        Rectangle2D dataArea = this.info.getPlotInfo().getDataArea();
        Insets insets = this.getInsets();
        double x = dataArea.getX() * this.scaleX + (double)insets.left;
        double y = dataArea.getY() * this.scaleY + (double)insets.top;
        double w = dataArea.getWidth() * this.scaleX;
        double h = dataArea.getHeight() * this.scaleY;
        return new Rectangle2D.Double(x, y, w, h);
    }

    public Rectangle2D getScreenDataArea(int x, int y) {
        Rectangle2D result;
        PlotRenderingInfo plotInfo = this.info.getPlotInfo();
        if (plotInfo.getSubplotCount() == 0) {
            result = this.getScreenDataArea();
        } else {
            Point2D selectOrigin = this.translateScreenToJava2D(new Point(x, y));
            int subplotIndex = plotInfo.getSubplotIndex(selectOrigin);
            if (subplotIndex == -1) {
                return null;
            }
            result = this.scale(plotInfo.getSubplotInfo(subplotIndex).getDataArea());
        }
        return result;
    }

    public int getInitialDelay() {
        return this.ownToolTipInitialDelay;
    }

    public int getReshowDelay() {
        return this.ownToolTipReshowDelay;
    }

    public int getDismissDelay() {
        return this.ownToolTipDismissDelay;
    }

    public void setInitialDelay(int delay) {
        this.ownToolTipInitialDelay = delay;
    }

    public void setReshowDelay(int delay) {
        this.ownToolTipReshowDelay = delay;
    }

    public void setDismissDelay(int delay) {
        this.ownToolTipDismissDelay = delay;
    }

    public double getZoomInFactor() {
        return this.zoomInFactor;
    }

    public void setZoomInFactor(double factor) {
        this.zoomInFactor = factor;
    }

    public double getZoomOutFactor() {
        return this.zoomOutFactor;
    }

    public void setZoomOutFactor(double factor) {
        this.zoomOutFactor = factor;
    }

    private void drawSelectionRectangle(Graphics2D g2) {
        if (this.selectionRectangle != null) {
            if (this.fillSelectionRectangle) {
                g2.setPaint(this.selectionFillPaint);
                g2.fill(this.selectionRectangle);
            } else {
                g2.setPaint(this.selectionOutlinePaint);
                g2.draw(this.selectionRectangle);
            }
        }
    }

    private void drawHorizontalAxisTrace(Graphics2D g2, int x) {
        Rectangle2D dataArea = this.getScreenDataArea();
        g2.setXORMode(Color.orange);
        if ((int)dataArea.getMinX() < x && x < (int)dataArea.getMaxX()) {
            if (this.verticalTraceLine != null) {
                g2.draw(this.verticalTraceLine);
                this.verticalTraceLine.setLine(x, (int)dataArea.getMinY(), x, (int)dataArea.getMaxY());
            } else {
                this.verticalTraceLine = new Line2D.Float(x, (int)dataArea.getMinY(), x, (int)dataArea.getMaxY());
            }
            g2.draw(this.verticalTraceLine);
        }
        g2.setPaintMode();
    }

    private void drawVerticalAxisTrace(Graphics2D g2, int y) {
        Rectangle2D dataArea = this.getScreenDataArea();
        g2.setXORMode(Color.orange);
        if ((int)dataArea.getMinY() < y && y < (int)dataArea.getMaxY()) {
            if (this.horizontalTraceLine != null) {
                g2.draw(this.horizontalTraceLine);
                this.horizontalTraceLine.setLine((int)dataArea.getMinX(), y, (int)dataArea.getMaxX(), y);
            } else {
                this.horizontalTraceLine = new Line2D.Float((int)dataArea.getMinX(), y, (int)dataArea.getMaxX(), y);
            }
            g2.draw(this.horizontalTraceLine);
        }
        g2.setPaintMode();
    }

    public void doEditChartProperties() {
        ChartEditor editor = ChartEditorManager.getChartEditor((JFreeChart)this.chart);
        int result = JOptionPane.showConfirmDialog((Component)((Object)this), editor, localizationResources.getString("Chart_Properties"), 2, -1);
        if (result == 0) {
            editor.updateChart(this.chart);
        }
    }

    public void doCopy() {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Insets insets = this.getInsets();
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        ChartTransferable selection = new ChartTransferable(this.chart, w, h);
        systemClipboard.setContents((Transferable)selection, null);
    }

    public void doSaveAs() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(this.defaultDirectoryForSaveAs);
        ExtensionFileFilter filter = new ExtensionFileFilter(localizationResources.getString("PNG_Image_Files"), ".png");
        fileChooser.addChoosableFileFilter((FileFilter)filter);
        int option = fileChooser.showSaveDialog((Component)((Object)this));
        if (option == 0) {
            String filename = fileChooser.getSelectedFile().getPath();
            if (this.isEnforceFileExtensions() && !filename.endsWith(".png")) {
                filename = filename + ".png";
            }
            ChartUtilities.saveChartAsPNG((File)new File(filename), (JFreeChart)this.chart, (int)this.getWidth(), (int)this.getHeight());
        }
    }

    public void createChartPrintJob() {
        PageFormat pf;
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf2 = job.pageDialog(pf = job.defaultPage());
        if (pf2 != pf) {
            job.setPrintable((Printable)((Object)this), pf2);
            if (job.printDialog()) {
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    JOptionPane.showMessageDialog((Component)((Object)this), e);
                }
            }
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double x = pf.getImageableX();
        double y = pf.getImageableY();
        double w = pf.getImageableWidth();
        double h = pf.getImageableHeight();
        this.chart.draw(g2, (Rectangle2D)new Rectangle2D.Double(x, y, w, h), this.anchor, null);
        return 0;
    }

    public void addChartMouseListener(ChartMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.chartMouseListeners.add(ChartMouseListener.class, listener);
    }

    public void removeChartMouseListener(ChartMouseListener listener) {
        this.chartMouseListeners.remove(ChartMouseListener.class, listener);
    }

    protected void displayPopupMenu(int x, int y) {
        Plot plot;
        if (this.popup == null) {
            return;
        }
        boolean isDomainZoomable = false;
        boolean isRangeZoomable = false;
        Plot plot2 = plot = this.chart != null ? this.chart.getPlot() : null;
        if (plot instanceof Zoomable) {
            Zoomable z = (Zoomable)plot;
            isDomainZoomable = z.isDomainZoomable();
            isRangeZoomable = z.isRangeZoomable();
        }
        if (this.zoomInDomainMenuItem != null) {
            this.zoomInDomainMenuItem.setEnabled(isDomainZoomable);
        }
        if (this.zoomOutDomainMenuItem != null) {
            this.zoomOutDomainMenuItem.setEnabled(isDomainZoomable);
        }
        if (this.zoomResetDomainMenuItem != null) {
            this.zoomResetDomainMenuItem.setEnabled(isDomainZoomable);
        }
        if (this.zoomInRangeMenuItem != null) {
            this.zoomInRangeMenuItem.setEnabled(isRangeZoomable);
        }
        if (this.zoomOutRangeMenuItem != null) {
            this.zoomOutRangeMenuItem.setEnabled(isRangeZoomable);
        }
        if (this.zoomResetRangeMenuItem != null) {
            this.zoomResetRangeMenuItem.setEnabled(isRangeZoomable);
        }
        if (this.zoomInBothMenuItem != null) {
            this.zoomInBothMenuItem.setEnabled(isDomainZoomable && isRangeZoomable);
        }
        if (this.zoomOutBothMenuItem != null) {
            this.zoomOutBothMenuItem.setEnabled(isDomainZoomable && isRangeZoomable);
        }
        if (this.zoomResetBothMenuItem != null) {
            this.zoomResetBothMenuItem.setEnabled(isDomainZoomable && isRangeZoomable);
        }
        this.coordinateTransformation.showPopupMenu(new Point(x, y), (JComponent)((Object)this), this.popup);
    }

    public void setCoordinateTransformation(CoordinateTransformation transformation) {
        this.coordinateTransformation = transformation;
    }

    public void registerSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void clearSelectionListener() {
        this.selectionListeners.clear();
    }

    public void registerAxisNameResolver(AxisNameResolver axisNameResolver) {
        this.axisNameResolver = axisNameResolver;
    }

    public static interface SelectionListener {
        public void selected(Selection var1, MouseEvent var2);
    }

    public static class Selection {
        private Collection<Pair<String, Range>> selectedRegion = new LinkedList<Pair<String, Range>>();

        public void addDelimiter(String dimensionName, Range range) {
            this.selectedRegion.add(new Pair<String, Range>(dimensionName, range));
        }

        public Collection<Pair<String, Range>> getDelimiters() {
            return this.selectedRegion;
        }
    }
}

