/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.RangeablePlotterAdapter;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.tools.ObjectVisualizerService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.swing.JComponent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.BlockResult;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.LabelBlock;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public abstract class Abstract2DChartPlotter
extends RangeablePlotterAdapter {
    private static final long serialVersionUID = 4568273282283350833L;
    private static final String[] axisNames = new String[]{"x-Axis", "y-Axis"};
    private static final int X_AXIS = 0;
    private static final int Y_AXIS = 1;
    private static final int COLOR_AXIS = 2;
    protected transient DataTable dataTable;
    private XYDataset dataSet = new DefaultXYDataset();
    private int[] axis = new int[]{-1, -1};
    private int colorColumn = -1;
    private int jitterAmount = 0;
    private boolean[] logScales = new boolean[]{false, false};
    private boolean plotColumnsLogScale = false;
    private double minColor;
    private double maxColor;
    private boolean nominal = true;
    private Map<SeriesAndItem, String> idMap = new HashMap<SeriesAndItem, String>();

    public Abstract2DChartPlotter(PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
    }

    public Abstract2DChartPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    public abstract AbstractXYItemRenderer getItemRenderer(boolean var1, int var2, double var3, double var5);

    @Override
    public boolean canHandleJitter() {
        return true;
    }

    @Override
    public void setJitter(int jitter) {
        this.jitterAmount = jitter;
        this.updatePlotter();
    }

    @Override
    public boolean isSupportingLogScale(int axis) {
        return axis == 0 || axis == 1;
    }

    @Override
    public boolean isSupportingLogScaleForPlotColumns() {
        return true;
    }

    @Override
    public void setLogScale(int axis, boolean logScale) {
        this.logScales[axis] = logScale;
        this.updatePlotter();
    }

    @Override
    public void setLogScaleForPlotColumns(boolean logScale) {
        this.plotColumnsLogScale = logScale;
        this.updatePlotter();
    }

    @Override
    public void dataTableSet() {
        this.dataTable = this.getDataTable();
        this.updatePlotter();
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.colorColumn = plot ? index : -1;
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.colorColumn == index;
    }

    @Override
    public String getPlotName() {
        return "Color Column";
    }

    @Override
    public int getNumberOfAxes() {
        return axisNames.length;
    }

    @Override
    public void setAxis(int index, int dimension) {
        this.axis[index] = dimension;
        this.updatePlotter();
    }

    @Override
    public int getAxis(int index) {
        return this.axis[index];
    }

    @Override
    public String getAxisName(int index) {
        return axisNames[index];
    }

    private void prepareData() {
        this.idMap.clear();
        if (this.colorColumn < 0 || this.dataTable.isNominal(this.colorColumn)) {
            this.prepareNominalData();
        } else {
            this.prepareNumericalData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNumericalData() {
        this.nominal = false;
        this.dataSet = new DefaultXYZDataset();
        if (this.axis[0] >= 0 && this.axis[1] >= 0) {
            this.minColor = Double.POSITIVE_INFINITY;
            this.maxColor = Double.NEGATIVE_INFINITY;
            LinkedList<double[]> dataList = new LinkedList<double[]>();
            LinkedList<String> idList = new LinkedList<String>();
            DataTable dataTable = this.dataTable;
            synchronized (dataTable) {
                for (DataTableRow row : this.dataTable) {
                    double xValue = Double.NaN;
                    if (this.axis[0] >= 0) {
                        xValue = row.getValue(this.axis[0]);
                    }
                    double yValue = Double.NaN;
                    if (this.axis[1] >= 0) {
                        yValue = row.getValue(this.axis[1]);
                    }
                    double colorValue = Double.NaN;
                    if (this.colorColumn >= 0) {
                        colorValue = row.getValue(this.colorColumn);
                    }
                    if (this.plotColumnsLogScale) {
                        colorValue = Tools.isLessEqual(colorValue, 0.0) ? 0.0 : Math.log10(colorValue);
                    }
                    double[] data = new double[]{xValue, yValue, colorValue};
                    if (!Double.isNaN(colorValue)) {
                        this.minColor = Math.min(this.minColor, colorValue);
                        this.maxColor = Math.max(this.maxColor, colorValue);
                    }
                    dataList.add(data);
                    idList.add(row.getId());
                }
            }
            double[][] data = new double[3][dataList.size()];
            double minX = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            int index = 0;
            for (double[] d : dataList) {
                data[0][index] = d[0];
                data[1][index] = d[1];
                data[2][index] = d[2];
                minX = MathFunctions.robustMin(minX, d[0]);
                maxX = MathFunctions.robustMax(maxX, d[0]);
                minY = MathFunctions.robustMin(minY, d[1]);
                maxY = MathFunctions.robustMax(maxY, d[1]);
                ++index;
            }
            if (this.jitterAmount > 0) {
                Random jitterRandom = new Random(2001L);
                double oldXRange = maxX - minX;
                double oldYRange = maxY - minY;
                int i = 0;
                while (i < dataList.size()) {
                    if (Double.isInfinite(oldXRange) || Double.isNaN(oldXRange)) {
                        oldXRange = 0.0;
                    }
                    if (Double.isInfinite(oldYRange) || Double.isNaN(oldYRange)) {
                        oldYRange = 0.0;
                    }
                    double pertX = oldXRange * ((double)this.jitterAmount / 200.0) * jitterRandom.nextGaussian();
                    double pertY = oldYRange * ((double)this.jitterAmount / 200.0) * jitterRandom.nextGaussian();
                    double[] dArray = data[0];
                    int n = i;
                    dArray[n] = dArray[n] + pertX;
                    double[] dArray2 = data[1];
                    int n2 = i++;
                    dArray2[n2] = dArray2[n2] + pertY;
                }
            }
            ((DefaultXYZDataset)this.dataSet).addSeries((Comparable)((Object)"All"), data);
            int idCounter = 0;
            for (String id : idList) {
                this.idMap.put(new SeriesAndItem(0, idCounter++), id);
            }
        }
    }

    protected String getId(int series, int index) {
        return this.idMap.get(new SeriesAndItem(series, index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNominalData() {
        this.nominal = true;
        this.dataSet = new DefaultXYDataset();
        if (this.axis[0] >= 0 && this.axis[1] >= 0) {
            LinkedHashMap<String, List<double[]>> dataCollection = new LinkedHashMap<String, List<double[]>>();
            LinkedHashMap<String, List<String>> idCollection = new LinkedHashMap<String, List<String>>();
            DataTable dataTable = this.dataTable;
            synchronized (dataTable) {
                if (this.colorColumn >= 0) {
                    for (int v = 0; v < this.dataTable.getNumberOfValues(this.colorColumn); ++v) {
                        dataCollection.put(this.dataTable.mapIndex(this.colorColumn, v), new LinkedList());
                        idCollection.put(this.dataTable.mapIndex(this.colorColumn, v), new LinkedList());
                    }
                }
                Iterator<DataTableRow> i = this.dataTable.iterator();
                int index = 0;
                while (i.hasNext()) {
                    DataTableRow row = i.next();
                    double xValue = row.getValue(this.axis[0]);
                    double yValue = row.getValue(this.axis[1]);
                    double colorValue = Double.NaN;
                    if (this.colorColumn >= 0) {
                        colorValue = row.getValue(this.colorColumn);
                    }
                    this.addPoint(dataCollection, idCollection, row.getId(), xValue, yValue, colorValue);
                    ++index;
                }
            }
            double minX = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            for (Map.Entry entry : dataCollection.entrySet()) {
                List dataList = (List)entry.getValue();
                for (double[] current : dataList) {
                    minX = MathFunctions.robustMin(minX, current[0]);
                    maxX = MathFunctions.robustMax(maxX, current[0]);
                    minY = MathFunctions.robustMin(minY, current[1]);
                    maxY = MathFunctions.robustMax(maxY, current[1]);
                }
            }
            Random jitterRandom = new Random(2001L);
            double oldXRange = maxX - minX;
            double oldYRange = maxY - minY;
            if (Double.isInfinite(oldXRange) || Double.isNaN(oldXRange)) {
                oldXRange = 0.0;
            }
            if (Double.isInfinite(oldYRange) || Double.isNaN(oldYRange)) {
                oldYRange = 0.0;
            }
            for (Map.Entry entry : dataCollection.entrySet()) {
                String seriesName = (String)entry.getKey();
                List dataList = (List)entry.getValue();
                double[][] data = new double[2][dataList.size()];
                int listCounter = 0;
                for (double[] current : dataList) {
                    data[0][listCounter] = current[0];
                    data[1][listCounter] = current[1];
                    if (this.jitterAmount > 0) {
                        double pertX = oldXRange * ((double)this.jitterAmount / 200.0) * jitterRandom.nextGaussian();
                        double pertY = oldYRange * ((double)this.jitterAmount / 200.0) * jitterRandom.nextGaussian();
                        double[] dArray = data[0];
                        int n = listCounter;
                        dArray[n] = dArray[n] + pertX;
                        double[] dArray2 = data[1];
                        int n2 = listCounter;
                        dArray2[n2] = dArray2[n2] + pertY;
                    }
                    ++listCounter;
                }
                ((DefaultXYDataset)this.dataSet).addSeries((Comparable)((Object)seriesName), data);
            }
            int seriesCounter = 0;
            for (List idList : idCollection.values()) {
                int itemCounter = 0;
                Iterator j = idList.iterator();
                while (j.hasNext()) {
                    this.idMap.put(new SeriesAndItem(seriesCounter, itemCounter++), (String)j.next());
                }
                ++seriesCounter;
            }
        }
    }

    private void addPoint(Map<String, List<double[]>> dataCollection, Map<String, List<String>> idCollection, String id, double x, double y, double color) {
        List<double[]> dataList = null;
        List<String> idList = null;
        if (Double.isNaN(color)) {
            dataList = dataCollection.get("Unknown");
            if (dataList == null) {
                dataList = new LinkedList<double[]>();
                dataCollection.put("Unknown", dataList);
            }
            if ((idList = idCollection.get("Unknown")) == null) {
                idList = new LinkedList<String>();
                idCollection.put("Unknown", idList);
            }
        } else {
            String name = color + "";
            if (this.dataTable.isNominal(this.colorColumn)) {
                name = this.dataTable.mapIndex(this.colorColumn, (int)color);
            } else if (this.dataTable.isDate(this.colorColumn)) {
                name = Tools.formatDate(new Date((long)color));
            } else if (this.dataTable.isTime(this.colorColumn)) {
                name = Tools.formatTime(new Date((long)color));
            } else if (this.dataTable.isDateTime(this.colorColumn)) {
                name = Tools.formatDateTime(new Date((long)color));
            }
            dataList = dataCollection.get(name);
            if (dataList == null) {
                dataList = new LinkedList<double[]>();
                dataCollection.put(name, dataList);
            }
            if ((idList = idCollection.get(name)) == null) {
                idList = new LinkedList<String>();
                idCollection.put(name, idList);
            }
        }
        dataList.add(new double[]{x, y});
        idList.add(id);
    }

    @Override
    public void updatePlotter() {
        AbstractChartPanel panel;
        Range range;
        String[] values;
        JFreeChart chart;
        this.prepareData();
        if (this.axis[0] >= 0 && this.axis[1] >= 0) {
            if (this.nominal) {
                int size = this.dataSet.getSeriesCount();
                chart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (this.colorColumn >= 0 && size < 100 ? 1 : 0) != 0, (boolean)true, (boolean)false);
                try {
                    chart.getXYPlot().setRenderer((XYItemRenderer)this.getItemRenderer(this.nominal, size, this.minColor, this.maxColor));
                }
                catch (Exception e) {
                    // empty catch block
                }
                LegendTitle legend = chart.getLegend();
                if (legend != null) {
                    legend.setPosition(RectangleEdge.TOP);
                    legend.setFrame((BlockFrame)BlockBorder.NONE);
                    legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
                    legend.setItemFont(LABEL_FONT);
                    BlockContainer wrapper = new BlockContainer((Arrangement)new BorderArrangement());
                    LabelBlock title = new LabelBlock(this.getDataTable().getColumnName(this.colorColumn), new Font("SansSerif", 1, 12));
                    title.setPadding(0.0, 5.0, 5.0, 5.0);
                    wrapper.add((Block)title, (Object)RectangleEdge.LEFT);
                    BlockContainer items = legend.getItemContainer();
                    wrapper.add((Block)items, (Object)RectangleEdge.RIGHT);
                    legend.setWrapper(wrapper);
                }
            } else {
                chart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                try {
                    chart.getXYPlot().setRenderer((XYItemRenderer)this.getItemRenderer(this.nominal, -1, this.minColor, this.maxColor));
                }
                catch (Exception e) {
                    // empty catch block
                }
                LegendTitle legendTitle = new LegendTitle((LegendItemSource)chart.getXYPlot().getRenderer()){
                    private static final long serialVersionUID = 1288380309936848376L;

                    public Object draw(Graphics2D g2, Rectangle2D area, Object params) {
                        if (Abstract2DChartPlotter.this.dataTable.isDate(Abstract2DChartPlotter.this.colorColumn) || Abstract2DChartPlotter.this.dataTable.isTime(Abstract2DChartPlotter.this.colorColumn) || Abstract2DChartPlotter.this.dataTable.isDateTime(Abstract2DChartPlotter.this.colorColumn)) {
                            Abstract2DChartPlotter.this.drawSimpleDateLegend(g2, (int)(area.getCenterX() - 170.0), (int)(area.getCenterY() + 7.0), Abstract2DChartPlotter.this.dataTable, Abstract2DChartPlotter.this.colorColumn, Abstract2DChartPlotter.this.minColor, Abstract2DChartPlotter.this.maxColor);
                            return new BlockResult();
                        }
                        String minColorString = Tools.formatNumber(Abstract2DChartPlotter.this.minColor);
                        String maxColorString = Tools.formatNumber(Abstract2DChartPlotter.this.maxColor);
                        Abstract2DChartPlotter.this.drawSimpleNumericalLegend(g2, (int)(area.getCenterX() - 75.0), (int)(area.getCenterY() + 7.0), Abstract2DChartPlotter.this.getDataTable().getColumnName(Abstract2DChartPlotter.this.colorColumn), minColorString, maxColorString);
                        return new BlockResult();
                    }

                    public void draw(Graphics2D g2, Rectangle2D area) {
                        this.draw(g2, area, null);
                    }
                };
                BlockContainer wrapper = new BlockContainer((Arrangement)new BorderArrangement());
                LabelBlock title = new LabelBlock(this.getDataTable().getColumnName(this.colorColumn), new Font("SansSerif", 1, 12));
                title.setPadding(0.0, 5.0, 5.0, 5.0);
                wrapper.add((Block)title, (Object)RectangleEdge.LEFT);
                BlockContainer items = legendTitle.getItemContainer();
                wrapper.add((Block)items, (Object)RectangleEdge.RIGHT);
                legendTitle.setWrapper(wrapper);
                chart.addLegend(legendTitle);
            }
        } else {
            chart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        }
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.setAntiAlias(false);
        XYPlot plot = chart.getXYPlot();
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        if (this.axis[0] >= 0) {
            DateAxis domainAxis;
            if (this.dataTable.isNominal(this.axis[0])) {
                values = new String[this.dataTable.getNumberOfValues(this.axis[0])];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.dataTable.mapIndex(this.axis[0], i);
                }
                plot.setDomainAxis((ValueAxis)new SymbolAxis(this.dataTable.getColumnName(this.axis[0]), values));
            } else if (this.dataTable.isDate(this.axis[0]) || this.dataTable.isDateTime(this.axis[0])) {
                domainAxis = new DateAxis(this.dataTable.getColumnName(this.axis[0]));
                domainAxis.setTimeZone(Tools.getPreferredTimeZone());
                plot.setDomainAxis((ValueAxis)domainAxis);
            } else if (this.logScales[0]) {
                domainAxis = new LogAxis(this.dataTable.getColumnName(this.axis[0]));
                domainAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits((Locale)Locale.US));
                plot.setDomainAxis((ValueAxis)domainAxis);
            } else {
                domainAxis = new NumberAxis(this.dataTable.getColumnName(this.axis[0]));
                domainAxis.setAutoRangeStickyZero(false);
                domainAxis.setAutoRangeIncludesZero(false);
                plot.setDomainAxis((ValueAxis)domainAxis);
            }
        }
        if (this.axis[0] >= 0) {
            range = this.getRangeForDimension(this.axis[0]);
            if (range != null) {
                plot.getDomainAxis().setRange(range, true, false);
            } else {
                plot.getDomainAxis().setAutoRange(true);
            }
        }
        plot.getDomainAxis().setLabelFont(LABEL_FONT_BOLD);
        plot.getDomainAxis().setTickLabelFont(LABEL_FONT);
        if (this.isLabelRotating()) {
            plot.getDomainAxis().setTickLabelsVisible(true);
            plot.getDomainAxis().setVerticalTickLabels(true);
        }
        if (this.axis[1] >= 0) {
            DateAxis rangeAxis;
            if (this.dataTable.isNominal(this.axis[1])) {
                values = new String[this.dataTable.getNumberOfValues(this.axis[1])];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.dataTable.mapIndex(this.axis[1], i);
                }
                plot.setRangeAxis((ValueAxis)new SymbolAxis(this.dataTable.getColumnName(this.axis[1]), values));
            } else if (this.dataTable.isDate(this.axis[1]) || this.dataTable.isDateTime(this.axis[1])) {
                rangeAxis = new DateAxis(this.dataTable.getColumnName(this.axis[1]));
                rangeAxis.setTimeZone(Tools.getPreferredTimeZone());
                plot.setRangeAxis((ValueAxis)rangeAxis);
            } else if (this.logScales[1]) {
                rangeAxis = new LogAxis(this.dataTable.getColumnName(this.axis[1]));
                rangeAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits((Locale)Locale.US));
                plot.setRangeAxis((ValueAxis)rangeAxis);
            } else {
                rangeAxis = new NumberAxis(this.dataTable.getColumnName(this.axis[1]));
                rangeAxis.setAutoRangeStickyZero(false);
                rangeAxis.setAutoRangeIncludesZero(false);
                plot.setRangeAxis((ValueAxis)rangeAxis);
            }
        }
        plot.getRangeAxis().setLabelFont(LABEL_FONT_BOLD);
        plot.getRangeAxis().setTickLabelFont(LABEL_FONT);
        if (this.axis[1] >= 0) {
            range = this.getRangeForDimension(this.axis[1]);
            if (range != null) {
                plot.getRangeAxis().setRange(range, true, false);
            } else {
                plot.getRangeAxis().setAutoRange(true);
            }
        }
        if ((panel = this.getPlotterPanel()) == null) {
            panel = this.createPanel(chart);
            panel.addChartMouseListener(new ChartMouseListener(){

                public void chartMouseClicked(ChartMouseEvent e) {
                    String id;
                    XYItemEntity entity;
                    if (e.getTrigger().getClickCount() > 1 && e.getEntity() instanceof XYItemEntity && (entity = (XYItemEntity)e.getEntity()) != null && (id = (String)Abstract2DChartPlotter.this.idMap.get(new SeriesAndItem(entity.getSeriesIndex(), entity.getItem()))) != null) {
                        ObjectVisualizer visualizer = ObjectVisualizerService.getVisualizerForObject(Abstract2DChartPlotter.this.dataTable);
                        visualizer.startVisualization(id);
                    }
                }

                public void chartMouseMoved(ChartMouseEvent e) {
                }
            });
        } else {
            panel.setChart(chart);
        }
        for (int i = 0; i < this.dataSet.getSeriesCount(); ++i) {
            class CustomXYToolTipGenerator
            implements XYToolTipGenerator {
                private String formatValue(int axis, double value) {
                    if (Abstract2DChartPlotter.this.dataTable.isNominal(axis)) {
                        return Tools.formatIntegerIfPossible(value);
                    }
                    if (Abstract2DChartPlotter.this.dataTable.isNumerical(axis)) {
                        return Tools.formatIntegerIfPossible(value);
                    }
                    if (Abstract2DChartPlotter.this.dataTable.isDate(axis)) {
                        return Tools.formatDate(new Date((long)value));
                    }
                    if (Abstract2DChartPlotter.this.dataTable.isTime(axis)) {
                        return Tools.formatTime(new Date((long)value));
                    }
                    if (Abstract2DChartPlotter.this.dataTable.isDateTime(axis)) {
                        return Tools.formatDateTime(new Date((long)value));
                    }
                    return "?";
                }

                public String generateToolTip(XYDataset dataset, int row, int column) {
                    String id = (String)Abstract2DChartPlotter.this.idMap.get(new SeriesAndItem(row, column));
                    if (id != null) {
                        return "<html><b>Id: " + id + "</b> (" + dataset.getSeriesKey(row) + ", " + this.formatValue(Abstract2DChartPlotter.this.axis[0], dataset.getXValue(row, column)) + ", " + this.formatValue(Abstract2DChartPlotter.this.axis[1], dataset.getYValue(row, column)) + ")</html>";
                    }
                    return "<html>(" + dataset.getSeriesKey(row) + ", " + this.formatValue(Abstract2DChartPlotter.this.axis[0], dataset.getXValue(row, column)) + ", " + this.formatValue(Abstract2DChartPlotter.this.axis[1], dataset.getYValue(row, column)) + ")</html>";
                }
            }
            plot.getRenderer().setSeriesToolTipGenerator(i, (XYToolTipGenerator)new CustomXYToolTipGenerator());
        }
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.getRotateLabelComponent();
        }
        return null;
    }

    @Override
    public Collection<String> resolveXAxis(int axisIndex) {
        if (this.axis[0] != -1) {
            return Collections.singletonList(this.dataTable.getColumnName(this.axis[0]));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<String> resolveYAxis(int axisIndex) {
        if (this.axis[1] != -1) {
            return Collections.singletonList(this.dataTable.getColumnName(this.axis[1]));
        }
        return Collections.emptyList();
    }

    public static class SeriesAndItem {
        private int series;
        private int item;

        public SeriesAndItem(int series, int item) {
            this.series = series;
            this.item = item;
        }

        public int hashCode() {
            return Integer.valueOf(this.series).hashCode() ^ Integer.valueOf(this.item).hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof SeriesAndItem)) {
                return false;
            }
            SeriesAndItem s = (SeriesAndItem)o;
            return this.series == s.series && this.item == s.item;
        }
    }
}

