/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.ToolTip;
import com.rapidminer.gui.plotter.conditions.ColumnsPlotterCondition;
import com.rapidminer.gui.plotter.conditions.PlotterCondition;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SurveyPlotter
extends PlotterAdapter
implements MouseListener {
    private static final long serialVersionUID = -4510716260204035289L;
    private static final int MAX_NUMBER_OF_COLUMNS = 100;
    private static final int FIRST = 0;
    private static final int SECOND = 1;
    private static final int THIRD = 2;
    private transient DataTable dataTable;
    private double maxWeight = Double.NaN;
    private int colorColumn = -1;
    private int[] sortingDimensions = new int[]{-1, -1, -1};
    private List<SurveyRow> dataRows = new LinkedList<SurveyRow>();
    private double[] min;
    private double[] max;
    private transient ToolTip toolTip = null;

    public SurveyPlotter(PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
        this.addMouseListener(this);
    }

    public SurveyPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.repaint();
    }

    @Override
    public PlotterCondition getPlotterCondition() {
        return new ColumnsPlotterCondition(100);
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.colorColumn = plot ? index : -1;
        this.repaint();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.colorColumn == index;
    }

    @Override
    public String getPlotName() {
        return "Color";
    }

    @Override
    public int getNumberOfAxes() {
        return this.sortingDimensions.length;
    }

    @Override
    public void setAxis(int index, int dimension) {
        this.sortingDimensions[index] = dimension;
        this.repaint();
    }

    @Override
    public int getAxis(int index) {
        return this.sortingDimensions[index];
    }

    @Override
    public String getAxisName(int index) {
        switch (index) {
            case 0: {
                return "First column";
            }
            case 1: {
                return "Second column";
            }
            case 2: {
                return "Third column";
            }
        }
        return "none";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareData() {
        this.dataRows.clear();
        this.min = new double[this.dataTable.getNumberOfColumns()];
        this.max = new double[this.dataTable.getNumberOfColumns()];
        for (int d = 0; d < this.min.length; ++d) {
            this.min[d] = Double.POSITIVE_INFINITY;
            this.max[d] = Double.NEGATIVE_INFINITY;
        }
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            for (DataTableRow row : this.dataTable) {
                for (int d = 0; d < row.getNumberOfValues(); ++d) {
                    double value = row.getValue(d);
                    this.min[d] = MathFunctions.robustMin(this.min[d], value);
                    this.max[d] = MathFunctions.robustMax(this.max[d], value);
                }
            }
            for (DataTableRow row : this.dataTable) {
                double[] data = new double[row.getNumberOfValues()];
                for (int d = 0; d < data.length; ++d) {
                    data[d] = row.getValue(d);
                }
                double color = 1.0;
                if (this.colorColumn >= 0) {
                    color = this.getColorProvider().getPointColorValue(this.dataTable, row, this.colorColumn, this.min[this.colorColumn], this.max[this.colorColumn]);
                }
                this.dataRows.add(new SurveyRow(data, color));
            }
            this.maxWeight = this.getMaxWeight(this.dataTable);
        }
        Collections.sort(this.dataRows);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.dataTable.getNumberOfRows() + 60);
    }

    public void setToolTip(ToolTip toolTip) {
        this.toolTip = toolTip;
        this.repaint();
    }

    private boolean isSpecialColumn(int index, int[] differentSortingDimensions) {
        for (int i = 0; i < differentSortingDimensions.length; ++i) {
            if (index != differentSortingDimensions[i]) continue;
            return true;
        }
        return false;
    }

    private int[] getDifferentSortingDimensions() {
        LinkedList<Integer> dimensions = new LinkedList<Integer>();
        for (int i = 0; i < this.sortingDimensions.length; ++i) {
            if (dimensions.contains(this.sortingDimensions[i])) continue;
            dimensions.add(this.sortingDimensions[i]);
        }
        int[] result = new int[dimensions.size()];
        Iterator i = dimensions.iterator();
        int counter = 0;
        while (i.hasNext()) {
            result[counter++] = (Integer)i.next();
        }
        return result;
    }

    private int[] getColumnMapping() {
        int i;
        int numberOfColumns = this.dataTable.getNumberOfColumns();
        int[] mapping = new int[numberOfColumns];
        int counter = 0;
        int[] differentSortingDimensions = this.getDifferentSortingDimensions();
        for (i = 0; i < differentSortingDimensions.length; ++i) {
            if (differentSortingDimensions[i] <= -1) continue;
            mapping[counter++] = differentSortingDimensions[i];
        }
        for (i = 0; i < this.dataTable.getNumberOfColumns(); ++i) {
            if (this.isSpecialColumn(i, differentSortingDimensions)) continue;
            mapping[counter++] = i;
        }
        return mapping;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintSurveyPlot(g);
    }

    public void paintSurveyPlot(Graphics graphics) {
        this.prepareData();
        if (!(this.colorColumn < 0 || this.colorColumn >= this.min.length || Double.isInfinite(this.min[this.colorColumn]) || Double.isInfinite(this.max[this.colorColumn]) || !this.dataTable.isNominal(this.colorColumn) && this.min[this.colorColumn] == this.max[this.colorColumn] || this.dataRows.size() <= 0)) {
            this.drawLegend(graphics, this.dataTable, this.colorColumn);
        }
        Graphics2D g = (Graphics2D)graphics.create();
        g.translate(20, 20);
        int width = this.getWidth() - 40;
        Rectangle2D.Double frame = new Rectangle2D.Double(-1.0, 19.0, width + 1, this.dataTable.getNumberOfRows() + 1);
        g.setColor(GRID_COLOR);
        g.draw(frame);
        int[] mapping = this.getColumnMapping();
        float columnDistance = (float)width / (float)mapping.length;
        float currentX = 0.0f;
        for (int i = 0; i < mapping.length; ++i) {
            this.paintSurveyColumn(g, mapping[i], currentX, columnDistance);
            currentX += columnDistance;
        }
        this.drawToolTip((Graphics2D)graphics, this.toolTip);
    }

    private void paintSurveyColumn(Graphics graphics, int column, float currentX, float columnDistance) {
        Graphics2D g = (Graphics2D)graphics.create();
        g.translate(currentX, 0.0);
        if (this.dataTable.isSupportingColumnWeights()) {
            Color weightColor = SurveyPlotter.getWeightColor(this.dataTable.getColumnWeight(column), this.maxWeight);
            Rectangle2D.Double weightRect = new Rectangle2D.Double(0.0, 20.0, columnDistance, this.dataTable.getNumberOfRows());
            g.setColor(weightColor);
            g.fill(weightRect);
        }
        if (this.dataTable.getNumberOfColumns() <= 10) {
            g.drawString(this.dataTable.getColumnName(column), 0, 17);
        }
        g.translate(0, 20);
        g.setColor(GRID_COLOR);
        g.drawLine(0, 0, 0, this.dataTable.getNumberOfRows());
        g.translate(1, 0);
        columnDistance -= 1.0f;
        int counter = 0;
        for (SurveyRow row : this.dataRows) {
            double[] data = row.data;
            double length = this.norm(data, column) * (double)columnDistance;
            double color = row.color;
            g.setColor(this.getColorProvider().getPointColor(color));
            g.drawLine(0, counter, (int)length, counter);
            ++counter;
        }
    }

    private double norm(double[] data, int column) {
        return (data[column] - this.min[column]) / (this.max[column] - this.min[column]);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int xPos = e.getX();
        if (xPos > 20 && xPos < this.getWidth() - 20) {
            int[] mapping = this.getColumnMapping();
            float columnDistance = (float)(this.getWidth() - 40) / (float)mapping.length;
            int column = (int)((float)(xPos - 20) / columnDistance);
            this.setToolTip(new ToolTip(this.dataTable.getColumnName(mapping[column]), xPos, e.getY()));
        } else {
            this.setToolTip(null);
        }
    }

    @Override
    public String getPlotterName() {
        return "Survey";
    }

    private class SurveyRow
    implements Comparable<SurveyRow> {
        private double[] data;
        private double color;

        private SurveyRow(double[] data, double color) {
            this.data = data;
            this.color = color;
        }

        @Override
        public int compareTo(SurveyRow row) {
            int result = 0;
            for (int i = 0; i < SurveyPlotter.this.sortingDimensions.length; ++i) {
                if (SurveyPlotter.this.sortingDimensions[i] == -1 || (result = Double.compare(this.data[SurveyPlotter.this.sortingDimensions[i]], row.data[SurveyPlotter.this.sortingDimensions[i]])) == 0) continue;
                return result;
            }
            if (result == 0 && SurveyPlotter.this.colorColumn > -1) {
                result = Double.compare(this.data[SurveyPlotter.this.colorColumn], row.data[SurveyPlotter.this.colorColumn]);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SurveyRow)) {
                return false;
            }
            return this.data == ((SurveyRow)o).data;
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

