/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.AxisTransformation;
import com.rapidminer.gui.plotter.AxisTransformationId;
import com.rapidminer.gui.plotter.AxisTransformationLog;
import com.rapidminer.gui.plotter.ColorPlotterPoint;
import com.rapidminer.gui.plotter.ColorProvider;
import com.rapidminer.gui.plotter.Plot;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ScatterPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = -6640810053422867017L;
    private static final Font SCALED_LABEL_FONT = LABEL_FONT.deriveFont(AffineTransform.getScaleInstance(1.0, -1.0));
    public static final String[] POINT_TYPES = new String[]{"lines_and_points", "lines", "points"};
    public static final int LINES_AND_POINTS = 0;
    public static final int LINES = 1;
    public static final int POINTS = 2;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private static final int LABEL_MARGIN_X = 15;
    private static final int LABEL_MARGIN_Y = 50;
    private transient DataTable dataTable;
    protected List<Plot> plots = new LinkedList<Plot>();
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double minColor;
    private double maxColor;
    private double xTicSize;
    private double yTicSize;
    private int colorColumn = -1;
    private double drawMinX = Double.NEGATIVE_INFINITY;
    private double drawMaxX = Double.POSITIVE_INFINITY;
    private double drawMinY = Double.NEGATIVE_INFINITY;
    private double drawMaxY = Double.POSITIVE_INFINITY;
    private int[] axis = new int[]{-1, -1};
    private int currentPlotterXAxis = -1;
    private int currentPlotterYAxis = -1;
    private boolean[] columns;
    private String currentToolTip = null;
    private double toolTipX = 0.0;
    private double toolTipY = 0.0;
    private int dragX;
    private int dragY;
    private int dragWidth;
    private int dragHeight;
    private boolean drawAxes = true;
    private boolean drawLabel = true;
    private boolean draw2DLines = true;
    private boolean drawLegend = true;
    private String key = null;
    private JComboBox pointTypeSelection;
    private int pointType = 0;
    private int jitterAmount = 0;
    AffineTransform transform;
    transient AxisTransformation xTransformation = new AxisTransformationId();
    transient AxisTransformation yTransformation = new AxisTransformationId();

    public ScatterPlotter(PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
        this.pointTypeSelection = new JComboBox<String>(POINT_TYPES);
        this.pointTypeSelection.setToolTipText("Indicates which type of points should be used for plotting.");
        this.pointTypeSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScatterPlotter.this.setPointType(ScatterPlotter.this.pointTypeSelection.getSelectedIndex());
            }
        });
    }

    public ScatterPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.columns = new boolean[dataTable.getNumberOfColumns()];
    }

    public void setPointType(int pointType) {
        this.pointType = pointType;
        this.repaint();
    }

    @Override
    public String getAxisName(int index) {
        switch (index) {
            case 0: {
                return "x-Axis";
            }
            case 1: {
                return "y-Axis";
            }
        }
        return "none";
    }

    @Override
    public int getValuePlotSelectionType() {
        return 1;
    }

    @Override
    public boolean isSaveable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        JFileChooser chooser = SwingTools.createFileChooser("file_chooser.save", null, false, new FileFilter[0]);
        if (chooser.showSaveDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            PrintWriter out = null;
            try {
                out = new PrintWriter(new FileWriter(file));
                this.dataTable.write(out);
            }
            catch (Exception ex) {
                SwingTools.showSimpleErrorMessage("cannot_write_to_file_0", (Throwable)ex, file);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    @Override
    public int getNumberOfAxes() {
        return this.axis.length;
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (this.axis[index] != dimension) {
            this.axis[index] = dimension;
            this.repaint();
        }
    }

    @Override
    public int getAxis(int index) {
        return this.axis[index];
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.pointTypeSelection;
        }
        return null;
    }

    @Override
    public boolean canHandleJitter() {
        return true;
    }

    @Override
    public void setJitter(int jitter) {
        this.jitterAmount = jitter;
        this.repaint();
    }

    protected void clearPlotColumns() {
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = false;
        }
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        if (this.columns[index] != plot) {
            this.columns[index] = plot;
        }
        this.repaint();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    public void setDrawLegend(boolean drawLegend) {
        this.drawLegend = drawLegend;
    }

    public boolean getDrawLegend() {
        return this.drawLegend;
    }

    @Override
    public Point2D getPositionInDataSpace(Point point) {
        Point2D p = null;
        if (this.transform != null) {
            try {
                p = this.transform.inverseTransform(point, null);
                p = new Point2D.Double(this.xTransformation.inverseTransform(p.getX()), this.yTransformation.inverseTransform(p.getY()));
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        return p;
    }

    @Override
    public void setDrawRange(double drawMinX, double drawMaxX, double drawMinY, double drawMaxY) {
        if (drawMinX == -1.0 || drawMaxX == -1.0 || drawMinY == -1.0 || drawMaxY == -1.0) {
            this.drawMinX = Double.NEGATIVE_INFINITY;
            this.drawMaxX = Double.POSITIVE_INFINITY;
            this.drawMinY = Double.NEGATIVE_INFINITY;
            this.drawMaxY = Double.POSITIVE_INFINITY;
        } else {
            this.drawMinX = drawMinX;
            this.drawMaxX = drawMaxX;
            this.drawMinY = drawMinY;
            this.drawMaxY = drawMaxY;
        }
        this.repaint();
    }

    private int getNumberOfCurrentlySelectedPlots() {
        int counter = 0;
        for (int column = 0; column < this.columns.length; ++column) {
            if (!this.columns[column]) continue;
            ++counter;
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void prepareData() {
        List<Plot> list = this.plots;
        synchronized (list) {
            this.plots.clear();
            this.maxColor = Double.NEGATIVE_INFINITY;
            this.maxY = Double.NEGATIVE_INFINITY;
            this.maxX = Double.NEGATIVE_INFINITY;
            this.minColor = Double.POSITIVE_INFINITY;
            this.minY = Double.POSITIVE_INFINITY;
            this.minX = Double.POSITIVE_INFINITY;
            if (this.axis[0] < 0) {
                return;
            }
            this.currentPlotterXAxis = this.axis[0];
            this.currentPlotterYAxis = -1;
            for (int column = 0; column < this.columns.length; ++column) {
                if (!this.columns[column]) continue;
                String name = this.dataTable.getColumnName(column);
                Plot points = new Plot(name, column);
                DataTable dataTable = this.dataTable;
                synchronized (dataTable) {
                    Iterator<DataTableRow> i = this.dataTable.iterator();
                    if (this.axis[1] != -1 && this.getNumberOfCurrentlySelectedPlots() == 1) {
                        this.colorColumn = column;
                        while (i.hasNext()) {
                            DataTableRow row = i.next();
                            double color = row.getValue(this.colorColumn);
                            this.minColor = MathFunctions.robustMin(this.minColor, color);
                            this.maxColor = MathFunctions.robustMax(this.maxColor, color);
                        }
                        i = this.dataTable.iterator();
                    }
                    ColorProvider colorProvider = this.getColorProvider();
                    while (i.hasNext()) {
                        DataTableRow row = i.next();
                        try {
                            ColorPlotterPoint currentPoint;
                            double x = row.getValue(this.currentPlotterXAxis);
                            double y = Double.NaN;
                            double color = Double.NaN;
                            Color borderColor = Color.BLACK;
                            if (this.axis[1] != -1) {
                                this.currentPlotterYAxis = this.axis[1];
                                y = row.getValue(this.currentPlotterYAxis);
                                if (this.getNumberOfCurrentlySelectedPlots() == 1) {
                                    color = colorProvider.getPointColorValue(this.dataTable, row, this.colorColumn, this.minColor, this.maxColor);
                                    borderColor = colorProvider.getPointBorderColor(this.dataTable, row, this.colorColumn);
                                }
                            } else {
                                this.currentPlotterYAxis = column;
                                y = row.getValue(column);
                            }
                            if (!(currentPoint = new ColorPlotterPoint(this, row.getId(), x, y, color, borderColor)).isIn(this.drawMinX, this.drawMaxX, this.drawMinY, this.drawMaxY)) continue;
                            points.add(currentPoint);
                            this.minX = Math.min(x, this.minX);
                            this.maxX = Math.max(x, this.maxX);
                            this.minY = Math.min(y, this.minY);
                            this.maxY = Math.max(y, this.maxY);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Not a numerical data column: " + column);
                        }
                    }
                    if (this.jitterAmount > 0) {
                        Random jitterRandom = new Random(2001L);
                        double oldXRange = this.maxX - this.minX;
                        double oldYRange = this.maxY - this.minY;
                        for (ColorPlotterPoint point : points) {
                            if (Double.isInfinite(oldXRange) || Double.isNaN(oldXRange)) {
                                oldXRange = 0.0;
                            }
                            if (Double.isInfinite(oldYRange) || Double.isNaN(oldYRange)) {
                                oldYRange = 0.0;
                            }
                            double pertX = oldXRange * ((double)this.jitterAmount / 200.0) * jitterRandom.nextGaussian();
                            double pertY = oldYRange * ((double)this.jitterAmount / 200.0) * jitterRandom.nextGaussian();
                            double x = point.getX() + pertX;
                            double y = point.getY() + pertY;
                            this.minX = Math.min(x, this.minX);
                            this.maxX = Math.max(x, this.maxX);
                            this.minY = Math.min(y, this.minY);
                            this.maxY = Math.max(y, this.maxY);
                            point.setX(x);
                            point.setY(y);
                        }
                    }
                    this.plots.add(points);
                    continue;
                }
            }
        }
        if (!Double.isInfinite(this.drawMinX)) {
            this.minX = this.drawMinX;
        }
        if (!Double.isInfinite(this.drawMaxX)) {
            this.maxX = this.drawMaxX;
        }
        if (!Double.isInfinite(this.drawMinY)) {
            this.minY = this.drawMinY;
        }
        if (!Double.isInfinite(this.drawMaxY)) {
            this.maxY = this.drawMaxY;
        }
        if (this.dataTable.getNumberOfRows() == 0) {
            this.minY = 0.0;
            this.minX = 0.0;
            this.maxY = 1.0;
            this.maxX = 1.0;
        }
        if (this.minX == this.maxX) {
            this.minX -= 0.5;
            this.maxX += 0.5;
        }
        if (this.minY == this.maxY) {
            this.minY -= 0.5;
            this.maxY += 0.5;
        }
        this.xTicSize = this.getTicSize(this.dataTable, this.currentPlotterXAxis, this.minX, this.maxX);
        this.yTicSize = this.getTicSize(this.dataTable, this.currentPlotterYAxis, this.minY, this.maxY);
        this.minX = this.xTransformation.adaptTicsMin(this.minX, this.xTicSize);
        this.maxX = this.xTransformation.adaptTicsMax(this.maxX, this.xTicSize);
        this.minY = this.yTransformation.adaptTicsMin(this.minY, this.yTicSize);
        this.maxY = this.yTransformation.adaptTicsMax(this.maxY, this.yTicSize);
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public void setDrawAxes(boolean drawAxes) {
        this.drawAxes = drawAxes;
        this.repaint();
    }

    public void setDrawLabel(boolean drawLabel) {
        this.drawLabel = drawLabel;
        this.repaint();
    }

    @Override
    public void setMousePosInDataSpace(int x, int y) {
        ColorPlotterPoint point = this.getPlotterPointForPos(x, y);
        if (point != null) {
            String id = point.getId();
            if (id != null) {
                this.setToolTip(id, this.xTransformation.transform(point.getX()), this.yTransformation.transform(point.getY()));
            } else {
                this.setToolTip(null, 0.0, 0.0);
            }
        } else {
            this.setToolTip(null, 0.0, 0.0);
        }
    }

    @Override
    public String getIdForPos(int x, int y) {
        ColorPlotterPoint point = this.getPlotterPointForPos(x, y);
        if (point != null) {
            return point.getId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ColorPlotterPoint getPlotterPointForPos(int x, int y) {
        List<Plot> list = this.plots;
        synchronized (list) {
            for (Collection collection : this.plots) {
                for (ColorPlotterPoint current : collection) {
                    try {
                        if (!current.contains(x, y)) continue;
                        return current;
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public void setDragBounds(int dragX, int dragY, int dragWidth, int dragHeight) {
        this.dragX = dragX;
        this.dragY = dragY;
        this.dragWidth = dragWidth;
        this.dragHeight = dragHeight;
        this.repaint();
    }

    private void setToolTip(String toolTip, double x, double y) {
        this.currentToolTip = toolTip;
        this.toolTipX = x;
        this.toolTipY = y;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void drawPoints(Graphics2D g, double dx, double dy, double sx, double sy) {
        List<Plot> list = this.plots;
        synchronized (list) {
            if (this.plots.size() == 0) {
                return;
            }
            int c = 0;
            for (Plot plot : this.plots) {
                if (plot.size() <= 0) continue;
                Iterator i = plot.iterator();
                if (this.pointType != 2 && this.axis[1] < 0 && this.draw2DLines) {
                    GeneralPath path = new GeneralPath();
                    boolean first = true;
                    while (i.hasNext()) {
                        ColorPlotterPoint plotterPoint = (ColorPlotterPoint)i.next();
                        float gSpaceX = (float)((this.xTransformation.transform(plotterPoint.getX()) + dx) * sx);
                        float gSpaceY = (float)((this.yTransformation.transform(plotterPoint.getY()) + dy) * sy);
                        if (first) {
                            path.moveTo(gSpaceX, gSpaceY);
                        } else {
                            path.lineTo(gSpaceX, gSpaceY);
                        }
                        first = false;
                    }
                    plot.getLineStyle().set(g);
                    g.draw(path);
                }
                if (this.pointType == 0 || this.pointType == 2) {
                    g.setStroke(new BasicStroke());
                    i = plot.iterator();
                    ColorProvider colorProvider = this.getColorProvider();
                    while (i.hasNext()) {
                        ColorPlotterPoint plotterPoint = (ColorPlotterPoint)i.next();
                        Color pointColor = plot.getLineStyle().getColor();
                        PlotterAdapter.PointStyle pointStyle = plot.getPointStyle();
                        if (this.axis[1] >= 0) {
                            pointColor = colorProvider.getPointColor(plotterPoint.getColor());
                            if (this.plots.size() <= 1) {
                                pointStyle = ELLIPSOID_POINT_STYLE;
                            }
                        }
                        Color pointBorderColor = plotterPoint.getBorderColor();
                        try {
                            float gSpaceX = (float)((this.xTransformation.transform(plotterPoint.getX()) + dx) * sx);
                            float gSpaceY = (float)((this.yTransformation.transform(plotterPoint.getY()) + dy) * sy);
                            this.drawPoint(g, pointStyle, gSpaceX, gSpaceY, pointColor, pointBorderColor);
                        }
                        catch (IllegalArgumentException e) {
                            LogService.getGlobal().log("Cannot apply axis scale transformation to point (" + plotterPoint.getX() + "," + plotterPoint.getY() + "), skipping...", 5);
                        }
                    }
                }
                c = (c + 1) % LINE_STYLES.length;
            }
        }
    }

    private void drawToolTip(Graphics2D g, double dx, double dy, double sx, double sy) {
        if (this.currentToolTip != null) {
            g.setFont(SCALED_LABEL_FONT);
            Rectangle2D stringBounds = SCALED_LABEL_FONT.getStringBounds(this.currentToolTip, g.getFontRenderContext());
            g.setColor(TOOLTIP_COLOR);
            Rectangle2D.Double bg = new Rectangle2D.Double((this.toolTipX + dx) * sx - stringBounds.getWidth() / 2.0 - 4.0, (this.toolTipY + dy) * sy + 3.0, stringBounds.getWidth() + 5.0, Math.abs(stringBounds.getHeight()) + 3.0);
            g.fill(bg);
            g.setColor(Color.black);
            g.draw(bg);
            g.drawString(this.currentToolTip, (float)((this.toolTipX + dx) * sx - stringBounds.getWidth() / 2.0) - 2.0f, (float)((this.toolTipY + dy) * sy) + 6.0f);
        }
    }

    protected void drawGrid(Graphics2D g, double dx, double dy, double sx, double sy) {
        g.setFont(SCALED_LABEL_FONT);
        int numberOfXTics = (int)Math.ceil((this.maxX - this.minX) / this.xTicSize) + 1;
        for (int i = 0; i < numberOfXTics; ++i) {
            this.drawVerticalTic(g, i, dx, dy, sx, sy);
        }
        int numberOfYTics = (int)Math.ceil((this.maxY - this.minY) / this.yTicSize) + 1;
        for (int i = 0; i < numberOfYTics; ++i) {
            this.drawHorizontalTic(g, i, dx, dy, sx, sy);
        }
    }

    private void drawVerticalTic(Graphics2D g, int ticNumber, double dx, double dy, double sx, double sy) {
        double xValue = (double)ticNumber * this.xTicSize + this.minX;
        double x = this.xTransformation.transform(xValue);
        g.setColor(GRID_COLOR);
        g.draw(new Line2D.Double((x + dx) * sx, (this.yTransformation.transform(this.minY) + dy) * sy, (x + dx) * sx, (this.yTransformation.transform(this.maxY) + dy) * sy));
        g.setColor(Color.black);
        if (this.drawAxes) {
            String label = null;
            if (this.getNumberOfPlots(this.dataTable) == 1 && this.dataTable.isNominal(this.currentPlotterXAxis)) {
                int index = (int)Math.round(xValue);
                if (index >= 0 && index < this.dataTable.getNumberOfValues(this.currentPlotterXAxis)) {
                    label = this.dataTable.mapIndex(this.currentPlotterXAxis, index);
                }
            } else if (this.getNumberOfPlots(this.dataTable) == 1 && this.dataTable.isDate(this.currentPlotterXAxis)) {
                long index = Math.round(xValue);
                label = Tools.formatDate(new Date(index));
            } else if (this.getNumberOfPlots(this.dataTable) == 1 && this.dataTable.isTime(this.currentPlotterXAxis)) {
                long index = Math.round(xValue);
                label = Tools.formatTime(new Date(index));
            } else if (this.getNumberOfPlots(this.dataTable) == 1 && this.dataTable.isDateTime(this.currentPlotterXAxis)) {
                long index = Math.round(xValue);
                label = Tools.formatDateTime(new Date(index));
            } else {
                label = this.xTransformation.format(xValue, ticNumber);
            }
            if (label != null) {
                Rectangle2D stringBounds = SCALED_LABEL_FONT.getStringBounds(label, g.getFontRenderContext());
                g.drawString(label, (float)((x + dx) * sx - stringBounds.getWidth() / 2.0), (float)((this.yTransformation.transform(this.minY) + dy) * sy + stringBounds.getHeight()));
            }
        }
    }

    private void drawHorizontalTic(Graphics2D g, int ticNumber, double dx, double dy, double sx, double sy) {
        double yValue = (double)ticNumber * this.yTicSize + this.minY;
        double y = this.yTransformation.transform(yValue);
        g.setColor(GRID_COLOR);
        g.draw(new Line2D.Double((this.xTransformation.transform(this.minX) + dx) * sx, (y + dy) * sy, (this.xTransformation.transform(this.maxX) + dx) * sx, (y + dy) * sy));
        g.setColor(Color.black);
        if (this.drawAxes) {
            String label = null;
            if (this.getNumberOfPlots(this.dataTable) == 1 && this.dataTable.isNominal(this.currentPlotterYAxis)) {
                int index = (int)Math.round(yValue);
                if (index >= 0 && index < this.dataTable.getNumberOfValues(this.currentPlotterYAxis)) {
                    label = this.dataTable.mapIndex(this.currentPlotterYAxis, index);
                }
            } else if (this.getNumberOfPlots(this.dataTable) == 1 && this.dataTable.isDate(this.currentPlotterYAxis)) {
                long index = Math.round(yValue);
                label = Tools.formatDate(new Date(index));
            } else if (this.getNumberOfPlots(this.dataTable) == 1 && this.dataTable.isTime(this.currentPlotterYAxis)) {
                long index = Math.round(yValue);
                label = Tools.formatTime(new Date(index));
            } else if (this.getNumberOfPlots(this.dataTable) == 1 && this.dataTable.isDateTime(this.currentPlotterYAxis)) {
                long index = Math.round(yValue);
                label = Tools.formatDateTime(new Date(index));
            } else {
                String formattedValue = this.yTransformation.format(yValue, ticNumber);
                if (formattedValue != null) {
                    label = formattedValue + " ";
                }
            }
            if (label != null) {
                Rectangle2D stringBounds = SCALED_LABEL_FONT.getStringBounds(label, g.getFontRenderContext());
                g.drawString(label, (float)((this.xTransformation.transform(this.minX) + dx) * sx - stringBounds.getWidth()), (float)((y + dy) * sy - stringBounds.getHeight() / 2.0 - stringBounds.getY()));
            }
        }
    }

    private void draw(Graphics2D g, int pixWidth, int pixHeight) {
        double sx = 0.0;
        double sy = 0.0;
        try {
            if (this.drawAxes) {
                sx = ((double)pixWidth - 50.0) / (this.xTransformation.transform(this.maxX) - this.xTransformation.transform(this.minX));
                sy = ((double)pixHeight - 15.0) / (this.yTransformation.transform(this.maxY) - this.yTransformation.transform(this.minY));
            } else {
                sx = (double)pixWidth / (this.xTransformation.transform(this.maxX) - this.xTransformation.transform(this.minX));
                sy = (double)pixHeight / (this.yTransformation.transform(this.maxY) - this.yTransformation.transform(this.minY));
            }
        }
        catch (IllegalArgumentException e) {
            g.scale(1.0, -1.0);
            g.drawString("Cannot apply axis transformation. Please make sure that the value range", 0, -60);
            g.drawString("can be transformed by the selected axis transformation, for example", 0, -40);
            g.drawString("negative values or zero cannot be transformed by a log scale transformation", 0, -20);
            g.drawString("(applying a normalization operator to the desired range might help). ", 0, 0);
            return;
        }
        Graphics2D coordinateSpace = (Graphics2D)g.create();
        if (this.drawAxes) {
            coordinateSpace.translate(50, 15);
        }
        if (Double.isNaN(sx) || Double.isNaN(sy)) {
            coordinateSpace.scale(1.0, -1.0);
            coordinateSpace.drawString("No data points available (yet).", 0, -20);
            coordinateSpace.drawString("Zooming out with a right click might help.", 0, 0);
        } else {
            if (this.drawAxes) {
                this.transform.translate(50.0, 15.0);
            }
            this.transform.scale(sx, sy);
            this.transform.translate(-this.xTransformation.transform(this.minX), -this.yTransformation.transform(this.minY));
            this.drawGrid(coordinateSpace, -this.xTransformation.transform(this.minX), -this.yTransformation.transform(this.minY), sx, sy);
            this.drawPoints(coordinateSpace, -this.xTransformation.transform(this.minX), -this.yTransformation.transform(this.minY), sx, sy);
            this.drawToolTip(coordinateSpace, -this.xTransformation.transform(this.minX), -this.yTransformation.transform(this.minY), sx, sy);
        }
        coordinateSpace.dispose();
    }

    private void drawDragRectangle(Graphics2D g) {
        if (this.dragX != -1 && this.dragY != -1 && this.dragWidth != -1 && this.dragHeight != -1) {
            g.setColor(Color.gray);
            Rectangle2D.Double dragBounds = new Rectangle2D.Double(this.dragX, this.dragY, this.dragWidth, this.dragHeight);
            g.draw(dragBounds);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paint2DPlots((Graphics2D)graphics);
    }

    public void paint2DPlots(Graphics2D g) {
        int pixWidth = this.getWidth() - 40;
        int pixHeight = this.getHeight() - 40;
        Graphics2D scaled = (Graphics2D)g.create();
        scaled.translate(20, 20);
        scaled.translate(0, pixHeight + 1);
        this.prepareData();
        if (this.plots.size() == 0) {
            scaled.drawString("No plots selected.", 0, 0);
        } else {
            scaled.scale(1.0, -1.0);
            g.setColor(Color.black);
            this.transform = new AffineTransform();
            this.transform.translate(20.0, 20.0);
            this.transform.translate(0.0, pixHeight + 1);
            this.transform.scale(1.0, -1.0);
            this.draw(scaled, pixWidth, pixHeight);
        }
        scaled.dispose();
        if (this.drawLabel && this.axis[0] >= 0) {
            String xAxisLabel = this.dataTable.getColumnName(this.axis[0]);
            Rectangle2D stringBounds = SCALED_LABEL_FONT.getStringBounds(xAxisLabel, g.getFontRenderContext());
            g.drawString(xAxisLabel, 20 + (int)((double)pixWidth / 2.0 - stringBounds.getWidth() / 2.0), 20 + (int)((double)pixHeight + stringBounds.getY()) + 3);
        }
        if (this.drawLegend && this.axis[1] == -1 && this.plots.size() > 1) {
            String[] names = new String[this.plots.size()];
            PlotterAdapter.PointStyle[] pointStyles = new PlotterAdapter.PointStyle[this.plots.size()];
            Color[] colors = new Color[this.plots.size()];
            Iterator<Plot> p = this.plots.iterator();
            int counter = 0;
            while (p.hasNext()) {
                Plot plot = p.next();
                names[counter] = plot.getName();
                colors[counter] = plot.getLineStyle().getColor();
                pointStyles[counter] = plot.getPointStyle();
                ++counter;
            }
            this.drawGenericNominalLegend(g, names, pointStyles, colors, 0, 255);
        } else {
            int xOffset = 0;
            if (this.drawLabel) {
                StringBuffer yAxisLabel = new StringBuffer();
                if (this.axis[1] >= 0) {
                    yAxisLabel.append(this.dataTable.getColumnName(this.axis[1]));
                } else {
                    boolean first = true;
                    for (int column = 0; column < this.columns.length; ++column) {
                        if (!this.columns[column]) continue;
                        if (!first) {
                            yAxisLabel.append(", ");
                        }
                        yAxisLabel.append(this.dataTable.getColumnName(column));
                        first = false;
                    }
                }
                if (yAxisLabel.length() == 0) {
                    yAxisLabel.append("unknown");
                }
                Rectangle2D stringBounds = LABEL_FONT.getStringBounds(yAxisLabel.toString(), g.getFontRenderContext());
                xOffset = (int)((double)xOffset + (stringBounds.getWidth() + 20.0));
                g.drawString(yAxisLabel.toString(), 14, 14);
            }
            if (this.drawLegend && this.axis[1] != -1 && this.plots.size() == 1) {
                this.drawLegend(g, this.dataTable, this.colorColumn, xOffset, 255);
            }
        }
        if (this.key != null) {
            Rectangle2D stringBounds = SCALED_LABEL_FONT.getStringBounds(this.key, g.getFontRenderContext());
            int keyX = 20 + (int)((double)pixWidth / 2.0 - stringBounds.getWidth() / 2.0);
            int keyY = (int)(10.0 - stringBounds.getHeight() / 2.0) + 25;
            Rectangle2D.Double bg = new Rectangle2D.Double(keyX - 2, (double)(keyY - 2) - Math.abs(stringBounds.getHeight()), stringBounds.getWidth() + 11.0, Math.abs(stringBounds.getHeight()) + 9.0);
            g.setColor(TOOLTIP_COLOR);
            g.fill(bg);
            g.setColor(Color.black);
            g.draw(bg);
            g.drawString(this.key, keyX, keyY);
        }
        this.drawDragRectangle(g);
    }

    public void setDraw2DLines(boolean v) {
        this.draw2DLines = v;
    }

    public boolean getDraw2DLines() {
        return this.draw2DLines;
    }

    @Override
    public boolean isProvidingCoordinates() {
        return true;
    }

    @Override
    public boolean isSupportingLogScale(int axis) {
        if (axis == 0 || axis == 1) {
            return true;
        }
        return super.isSupportingLogScale(axis);
    }

    @Override
    public void setLogScale(int axis, boolean logScale) {
        if (axis == 0) {
            this.xTransformation = logScale ? new AxisTransformationLog() : new AxisTransformationId();
        } else if (axis == 1) {
            this.yTransformation = logScale ? new AxisTransformationLog() : new AxisTransformationId();
        }
        this.repaint();
    }

    @Override
    public String getPlotterName() {
        return "Lines";
    }
}

