/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.AxisNameResolver;
import com.rapidminer.gui.plotter.CoordinateTransformation;
import com.rapidminer.gui.plotter.LabelRotatingPlotterAdapter;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.gui.plotter.charts.ChartPanelShiftController;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.ModelMetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.tools.container.Pair;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jfree.chart.JFreeChart;
import org.jfree.data.Range;

public abstract class RangeablePlotterAdapter
extends LabelRotatingPlotterAdapter
implements AxisNameResolver {
    private static final long serialVersionUID = 1L;
    public static final String PARAMETER_PREFIX_RANGE_LIST = "range_list";
    public static final String PARAMETER_PREFIX_RANGE = "range_";
    public static final String PARAMETER_DIMENSION_NAME = "dimension";
    public static final String PARAMETER_PREFIX_RANGE_MIN = "range_min";
    public static final String PARAMETER_PREFIX_RANGE_MAX = "range_max";
    private Map<String, Range> nameRangeMap = new HashMap<String, Range>();
    private DataTable dataTable;
    private CoordinateTransformation coordinateTransformation;
    private AbstractChartPanel panel = null;
    private List<AbstractChartPanel.SelectionListener> plotterSelectionListener = new LinkedList<AbstractChartPanel.SelectionListener>();

    public RangeablePlotterAdapter(PlotterConfigurationModel settings) {
        super(settings);
        this.plotterSelectionListener.add(new AbstractChartPanel.SelectionListener(){

            @Override
            public void selected(AbstractChartPanel.Selection selection, MouseEvent selectionEvent) {
                for (Pair<String, Range> delimiter : selection.getDelimiters()) {
                    RangeablePlotterAdapter.this.setRange(delimiter.getFirst(), delimiter.getSecond());
                }
            }
        });
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys(InputPort inputPort) {
        MetaData metaData;
        List<ParameterType> types = super.getAdditionalParameterKeys(inputPort);
        boolean inputDeliversAttributes = false;
        if (inputPort != null && (metaData = inputPort.getMetaData()) != null && (metaData instanceof ExampleSetMetaData || metaData instanceof ModelMetaData)) {
            inputDeliversAttributes = true;
        }
        if (inputDeliversAttributes) {
            types.add(new ParameterTypeList(PARAMETER_PREFIX_RANGE_LIST, "Defines the ranges for the given attribute", (ParameterType)new ParameterTypeAttribute(PARAMETER_DIMENSION_NAME, "This is the name of the dimension, the range should be applied onto.", inputPort), (ParameterType)new ParameterTypeTupel(PARAMETER_PREFIX_RANGE, "Defines the range of the corresponding axis.", new ParameterTypeDouble(PARAMETER_PREFIX_RANGE_MIN, "Defines the lower bound of the axis.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), new ParameterTypeDouble(PARAMETER_PREFIX_RANGE_MAX, "Defines the upper bound of the axis.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY))));
        } else {
            types.add(new ParameterTypeList(PARAMETER_PREFIX_RANGE_LIST, "Defines the ranges for the given attribute", (ParameterType)new ParameterTypeString(PARAMETER_DIMENSION_NAME, "This is the name of the dimension, the range should be applied onto."), (ParameterType)new ParameterTypeTupel(PARAMETER_PREFIX_RANGE, "Defines the range of the corresponding axis.", new ParameterTypeDouble(PARAMETER_PREFIX_RANGE_MIN, "Defines the lower bound of the axis.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), new ParameterTypeDouble(PARAMETER_PREFIX_RANGE_MAX, "Defines the upper bound of the axis.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY))));
        }
        return types;
    }

    public Range getRangeForDimension(int dimension) {
        if (dimension >= 0 && dimension < this.dataTable.getNumberOfColumns()) {
            return this.nameRangeMap.get(PlotterAdapter.transformParameterName(this.dataTable.getColumnName(dimension)));
        }
        return null;
    }

    public Range getRangeForName(String columnName) {
        return this.nameRangeMap.get(PlotterAdapter.transformParameterName(columnName));
    }

    @Override
    public final void setDataTable(DataTable dataTable) {
        this.dataTable = dataTable;
        this.dataTableSet();
    }

    public abstract void dataTableSet();

    protected DataTable getDataTable() {
        return this.dataTable;
    }

    public void setRange(int dimension, Range range) {
        this.setRange(this.dataTable.getColumnName(dimension), range);
    }

    public void setRange(String columnName, Range range) {
        this.nameRangeMap.put(PlotterAdapter.transformParameterName(columnName), range);
        LinkedList<String[]> entryList = new LinkedList<String[]>();
        for (String dimensionName : this.nameRangeMap.keySet()) {
            Range currentRange = this.nameRangeMap.get(dimensionName);
            String[] entry = new String[]{dimensionName, ParameterTypeTupel.transformTupel2String(new Pair<String, String>(currentRange.getLowerBound() + "", currentRange.getUpperBound() + ""))};
            entryList.add(entry);
        }
        this.settings.setParameterAsString(PARAMETER_PREFIX_RANGE_LIST, ParameterTypeList.transformList2String(entryList));
    }

    @Override
    public void setAdditionalParameter(String key, String value) {
        super.setAdditionalParameter(key, value);
        if (key.startsWith(PARAMETER_PREFIX_RANGE_LIST)) {
            List<String[]> dimensionRangePairs = ParameterTypeList.transformString2List(value);
            for (String[] dimensionRangePair : dimensionRangePairs) {
                String[] rangeTupel = ParameterTypeTupel.transformString2Tupel(dimensionRangePair[1]);
                if (rangeTupel.length != 2) continue;
                try {
                    Range range = new Range(Double.parseDouble(rangeTupel[0]), Double.parseDouble(rangeTupel[1]));
                    this.nameRangeMap.put(PlotterAdapter.transformParameterName(dimensionRangePair[0]), range);
                    this.updatePlotter();
                }
                catch (NumberFormatException e) {}
            }
            return;
        }
    }

    protected AbstractChartPanel createPanel(JFreeChart chart) {
        this.panel = new AbstractChartPanel(chart, this.getWidth(), this.getHeight() - 20);
        this.panel.registerAxisNameResolver(this);
        if (this.coordinateTransformation != null) {
            this.panel.setCoordinateTransformation(this.coordinateTransformation);
        }
        for (AbstractChartPanel.SelectionListener listener : this.plotterSelectionListener) {
            this.panel.registerSelectionListener(listener);
        }
        this.panel.registerSelectionListener(new AbstractChartPanel.SelectionListener(){

            @Override
            public void selected(AbstractChartPanel.Selection selection, MouseEvent selectionEvent) {
                for (Pair<String, Range> delimiter : selection.getDelimiters()) {
                    RangeablePlotterAdapter.this.setRange(delimiter.getFirst(), delimiter.getSecond());
                }
                RangeablePlotterAdapter.this.dataTable.setSelection(selection);
            }
        });
        ChartPanelShiftController controller = new ChartPanelShiftController(this.panel);
        this.panel.addMouseListener(controller);
        this.panel.addMouseMotionListener(controller);
        return this.panel;
    }

    public void registerPlotterSelectionListener(AbstractChartPanel.SelectionListener listener) {
        this.plotterSelectionListener.add(listener);
        if (this.panel != null) {
            this.panel.registerSelectionListener(listener);
        }
    }

    public void clearPlotterSelectionListener() {
        this.plotterSelectionListener.clear();
        if (this.panel != null) {
            this.panel.clearSelectionListener();
        }
    }

    @Override
    public void setCoordinateTransformation(CoordinateTransformation transformation) {
        this.coordinateTransformation = transformation;
        if (this.panel != null) {
            this.panel.setCoordinateTransformation(transformation);
        }
    }

    @Override
    public final JComponent getPlotter() {
        if (this.panel == null) {
            this.updatePlotter();
        }
        return this.panel;
    }

    public AbstractChartPanel getPlotterPanel() {
        return this.panel;
    }
}

