/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.ColorQuartilePlotter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.Quartile;
import com.rapidminer.tools.math.MathFunctions;
import javax.swing.Icon;

public class QuartilePlotter
extends ColorQuartilePlotter {
    private static final long serialVersionUID = -5115095967846809152L;
    private boolean[] columns = null;

    public QuartilePlotter(PlotterConfigurationModel settings) {
        super(settings);
    }

    public QuartilePlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        super(settings, dataTable);
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        this.columns = new boolean[dataTable.getNumberOfColumns()];
        super.setDataTable(dataTable);
    }

    @Override
    public int getNumberOfAxes() {
        return 0;
    }

    @Override
    public String getPlotName() {
        return "Dimensions";
    }

    @Override
    public int getValuePlotSelectionType() {
        return 1;
    }

    @Override
    public String getPlotterName() {
        return "Quartile";
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.columns[index] = plot;
        this.repaint();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    @Override
    public Icon getIcon(int index) {
        return null;
    }

    @Override
    protected void prepareData() {
        this.allQuartiles.clear();
        this.globalMin = Double.POSITIVE_INFINITY;
        this.globalMax = Double.NEGATIVE_INFINITY;
        if (this.columns != null) {
            int i;
            int totalCount = 0;
            for (i = 0; i < this.dataTable.getNumberOfColumns(); ++i) {
                if (!this.columns[i]) continue;
                ++totalCount;
            }
            for (i = 0; i < this.dataTable.getNumberOfColumns(); ++i) {
                if (!this.columns[i]) continue;
                Quartile quartile = Quartile.calculateQuartile(this.dataTable, i);
                quartile.setColor(this.getColorProvider().getPointColor((double)i / (double)totalCount));
                this.allQuartiles.add(quartile);
                this.globalMin = MathFunctions.robustMin(this.globalMin, quartile.getMin());
                this.globalMax = MathFunctions.robustMax(this.globalMax, quartile.getMax());
            }
        }
    }
}

