/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.PlotterControlPanel;
import com.rapidminer.gui.plotter.charts.RapidBarPainter;
import com.rapidminer.gui.plotter.charts.RapidXYBarPainter;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;

public class PlotterPanel
extends JPanel {
    private static final long serialVersionUID = -8724351470349745191L;
    public static final int DEFAULT_MAX_NUMBER_OF_DATA_POINTS = 5000;
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    private final PlotterControlPanel controlPanel;
    private Component oldPlotterComponent = null;
    private PlotterConfigurationModel settings;

    public PlotterPanel(DataTable dataTable) {
        this(dataTable, PlotterConfigurationModel.DATA_SET_PLOTTER_SELECTION);
    }

    public PlotterPanel(DataTable dataTable, LinkedHashMap<String, Class<? extends Plotter>> availablePlotters) {
        this(new PlotterConfigurationModel(availablePlotters, dataTable));
    }

    public PlotterPanel(final PlotterConfigurationModel settings) {
        super(new BorderLayout());
        this.controlPanel = new PlotterControlPanel(settings);
        this.settings = settings;
        settings.registerPlotterListener(new PlotterConfigurationModel.PlotterChangedListener(){

            @Override
            public void plotterChanged(String plotterName) {
                JComponent plotterComponent;
                if (PlotterPanel.this.oldPlotterComponent != null) {
                    PlotterPanel.this.mainPanel.remove(PlotterPanel.this.oldPlotterComponent);
                }
                if ((plotterComponent = settings.getPlotter().getPlotter()) != null) {
                    PlotterPanel.this.mainPanel.add((Component)plotterComponent, "Center");
                    PlotterPanel.this.oldPlotterComponent = plotterComponent;
                }
                PlotterPanel.this.repaint();
                PlotterPanel.this.revalidate();
            }

            @Override
            public List<PlotterConfigurationModel.PlotterSettingsChangedListener> getListeningObjects() {
                return new ArrayList<PlotterConfigurationModel.PlotterSettingsChangedListener>(0);
            }
        });
        ExtendedJScrollPane plotterScrollPane = new ExtendedJScrollPane(this.mainPanel);
        settings.registerPlotterListener(this.controlPanel);
        this.mainPanel.add((Component)this.controlPanel, "West");
        plotterScrollPane.setBorder(null);
        this.add((Component)plotterScrollPane, "Center");
        JComponent plotterComponent = settings.getPlotter().getPlotter();
        if (plotterComponent != null) {
            this.mainPanel.add((Component)plotterComponent, "Center");
            this.oldPlotterComponent = plotterComponent;
        }
        this.repaint();
        this.revalidate();
    }

    public PlotterConfigurationModel getPlotterSettings() {
        return this.settings;
    }

    static {
        BarRenderer.setDefaultBarPainter((BarPainter)new RapidBarPainter());
        XYBarRenderer.setDefaultBarPainter((XYBarPainter)new RapidXYBarPainter());
    }

    public static class LineStyleCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -7039142638209143602L;
        Plotter plotter;

        public LineStyleCellRenderer(Plotter plotter) {
            this.plotter = plotter;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            Icon icon = this.plotter.getIcon(index);
            if (icon != null) {
                this.setIcon(icon);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

