/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.CoordinatesHandler;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.tools.ObjectVisualizerService;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public class PlotterMouseHandler
implements MouseListener,
MouseMotionListener {
    private Plotter plotter;
    private DataTable dataTable;
    private CoordinatesHandler coordinatesHandler;
    private Point pressStart = null;

    public PlotterMouseHandler(Plotter plotter, DataTable dataTable, CoordinatesHandler coordinatesHandler) {
        this.plotter = plotter;
        this.dataTable = dataTable;
        this.coordinatesHandler = coordinatesHandler;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point2D p = this.plotter.getPositionInDataSpace(e.getPoint());
        if (this.coordinatesHandler != null && p != null) {
            DecimalFormat format = new DecimalFormat(" 0.000E0;-0.000E0");
            this.coordinatesHandler.updateCoordinates(format.format(p.getX()) + " , " + format.format(p.getY()));
        }
        this.plotter.setMousePosInDataSpace(e.getX(), e.getY());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.pressStart != null && Math.abs((double)e.getX() - this.pressStart.getX()) > 5.0 && Math.abs((double)e.getY() - this.pressStart.getY()) > 5.0) {
            this.plotter.setDragBounds((int)Math.min(this.pressStart.getX(), (double)e.getX()), (int)Math.min(this.pressStart.getY(), (double)e.getY()), (int)Math.abs(this.pressStart.getX() - (double)e.getX()), (int)Math.abs(this.pressStart.getY() - (double)e.getY()));
        } else {
            this.plotter.setDragBounds(-1, -1, -1, -1);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            String id;
            if (e.getClickCount() > 1 && (id = this.plotter.getIdForPos(e.getX(), e.getY())) != null) {
                ObjectVisualizer visualizer = ObjectVisualizerService.getVisualizerForObject(this.dataTable);
                visualizer.startVisualization(id);
            }
        } else if (e.getButton() == 3) {
            this.plotter.setDrawRange(-1.0, -1.0, -1.0, -1.0);
            this.pressStart = null;
            this.plotter.setDragBounds(-1, -1, -1, -1);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && this.pressStart != null && Math.abs((double)e.getX() - this.pressStart.getX()) > 5.0 && Math.abs((double)e.getY() - this.pressStart.getY()) > 5.0) {
            Point2D pressPoint = this.plotter.getPositionInDataSpace(this.pressStart);
            Point2D releasePoint = this.plotter.getPositionInDataSpace(e.getPoint());
            if (pressPoint != null) {
                this.plotter.setDrawRange(Math.min(pressPoint.getX(), releasePoint.getX()), Math.max(pressPoint.getX(), releasePoint.getX()), Math.min(pressPoint.getY(), releasePoint.getY()), Math.max(pressPoint.getY(), releasePoint.getY()));
            }
        }
        this.plotter.setDragBounds(-1, -1, -1, -1);
        this.pressStart = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.pressStart = e.getPoint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }
}

