/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.plotter.CoordinatesHandler;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.PlotterMouseHandler;
import com.rapidminer.gui.plotter.PlotterPanel;
import com.rapidminer.gui.plotter.settings.ListeningJCheckBox;
import com.rapidminer.gui.plotter.settings.ListeningJComboBox;
import com.rapidminer.gui.plotter.settings.ListeningJSlider;
import com.rapidminer.gui.plotter.settings.ListeningListSelectionModel;
import com.rapidminer.gui.tools.ExtendedJList;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedListModel;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.tools.LogService;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.freehep.util.export.ExportDialog;

public class PlotterControlPanel
extends JPanel
implements PlotterConfigurationModel.PlotterChangedListener {
    private static final long serialVersionUID = 1L;
    private PlotterConfigurationModel plotterSettings;
    private final JComboBox plotterCombo = new JComboBox();
    private List<PlotterConfigurationModel.PlotterSettingsChangedListener> changeListenerElements = new LinkedList<PlotterConfigurationModel.PlotterSettingsChangedListener>();
    private final transient ItemListener plotterComboListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            PlotterControlPanel.this.plotterSettings.setPlotter(PlotterControlPanel.this.plotterCombo.getSelectedItem().toString());
        }
    };

    public PlotterControlPanel(PlotterConfigurationModel plotterSettings) {
        this.plotterSettings = plotterSettings;
        this.setLayout(new GridBagLayout());
        this.updatePlotterCombo();
        this.updateControls();
    }

    private void updateControls() {
        final Plotter plotter = this.plotterSettings.getPlotter();
        DataTable dataTable = this.plotterSettings.getDataTable();
        this.changeListenerElements = new LinkedList<PlotterConfigurationModel.PlotterSettingsChangedListener>();
        this.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        final JLabel coordinatesLabel = new JLabel("                      ");
        PlotterMouseHandler mouseHandler = new PlotterMouseHandler(plotter, this.plotterSettings.getDataTable(), new CoordinatesHandler(){

            @Override
            public void updateCoordinates(String coordinateInfo) {
                coordinatesLabel.setText(coordinateInfo);
            }
        });
        plotter.addMouseMotionListener(mouseHandler);
        plotter.addMouseListener(mouseHandler);
        JLabel label = null;
        String toolTip = null;
        if (this.plotterSettings.getAvailablePlotters().size() > 1) {
            toolTip = "The plotter which should be used for displaying data.";
            label = new JLabel("Plotter");
            label.setToolTipText(toolTip);
            this.add((Component)label, c);
            this.add((Component)this.plotterCombo, c);
        }
        LinkedList<Integer> plottedDimensionList = new LinkedList<Integer>();
        if (plotter != null) {
            for (int i = 0; i < dataTable.getNumberOfColumns(); ++i) {
                if (!plotter.getPlotColumn(i)) continue;
                plottedDimensionList.add(i);
            }
        }
        LinkedList<3> axisCombos = new LinkedList<3>();
        for (int axisIndex = 0; axisIndex < plotter.getNumberOfAxes(); ++axisIndex) {
            toolTip = "Select a column for " + plotter.getAxisName(axisIndex);
            label = new JLabel(plotter.getAxisName(axisIndex));
            label.setToolTipText(toolTip);
            this.add((Component)label, c);
            final int finalAxisIndex = axisIndex;
            final ListeningJComboBox axisCombo = new ListeningJComboBox("_axis_" + PlotterAdapter.transformParameterName(plotter.getAxisName(finalAxisIndex)), 200){
                private static final long serialVersionUID = 1L;

                @Override
                public void settingChanged(String generalKey, String specificKey, String value) {
                    super.settingChanged(generalKey, specificKey, value);
                }
            };
            axisCombo.setToolTipText(toolTip);
            axisCombo.addItem("None");
            for (int j = 0; j < dataTable.getNumberOfColumns(); ++j) {
                axisCombo.addItem(dataTable.getColumnName(j));
            }
            this.changeListenerElements.add(axisCombo);
            axisCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PlotterControlPanel.this.plotterSettings.setParameterAsString("_axis_" + PlotterAdapter.transformParameterName(plotter.getAxisName(finalAxisIndex)), axisCombo.getSelectedItem().toString());
                }
            });
            this.add((Component)axisCombo, c);
            axisCombos.add(axisCombo);
            if (!plotter.isSupportingLogScale(axisIndex)) continue;
            final ListeningJCheckBox logScaleBox = new ListeningJCheckBox("_axis_" + PlotterAdapter.transformParameterName(plotter.getAxisName(finalAxisIndex)) + "_log_scale", "Log Scale", false);
            this.changeListenerElements.add(logScaleBox);
            logScaleBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotterControlPanel.this.plotterSettings.setParameterAsBoolean("_axis_" + PlotterAdapter.transformParameterName(plotter.getAxisName(finalAxisIndex)) + "_log_scale", logScaleBox.isSelected());
                }
            });
            this.add((Component)logScaleBox, c);
        }
        if (plotter.getValuePlotSelectionType() != -1) {
            JLabel plotLabel;
            if (plotter.getPlotName() == null) {
                plotLabel = new JLabel("Plots");
                toolTip = "Select the column which should be plotted.";
            } else {
                plotLabel = new JLabel(plotter.getPlotName());
                toolTip = "Select a column for " + plotter.getPlotName();
            }
            plotLabel.setToolTipText(toolTip);
            this.add((Component)plotLabel, c);
        }
        switch (plotter.getValuePlotSelectionType()) {
            case 1: {
                final ExtendedListModel model = new ExtendedListModel();
                for (String name : dataTable.getColumnNames()) {
                    model.addElement(name, "Select column '" + name + "' for plotting.");
                }
                final ExtendedJList plotList = new ExtendedJList(model, 200);
                ListeningListSelectionModel selectionModel = new ListeningListSelectionModel("_plot_columns", plotList);
                this.changeListenerElements.add(selectionModel);
                plotList.setSelectionModel(selectionModel);
                plotList.setToolTipText(toolTip);
                plotList.setBorder(BorderFactory.createLoweredBevelBorder());
                plotList.setCellRenderer(new PlotterPanel.LineStyleCellRenderer(plotter));
                plotList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting()) {
                            LinkedList<String> list = new LinkedList<String>();
                            for (int i = 0; i < plotList.getModel().getSize(); ++i) {
                                if (!plotList.isSelectedIndex(i)) continue;
                                list.add(model.get(i).toString());
                            }
                            String result = ParameterTypeEnumeration.transformEnumeration2String(list);
                            PlotterControlPanel.this.plotterSettings.setParameterAsString("_plot_columns", result);
                        }
                    }
                });
                plotList.setSelectionMode(2);
                ExtendedJScrollPane listScrollPane = new ExtendedJScrollPane(plotList);
                listScrollPane.setHorizontalScrollBarPolicy(30);
                c.weighty = 1.0;
                this.add((Component)listScrollPane, c);
                c.weighty = 0.0;
                break;
            }
            case 0: {
                final ListeningJComboBox plotCombo = new ListeningJComboBox("_plot_column", 200);
                plotCombo.setToolTipText(toolTip);
                plotCombo.addItem("None");
                this.changeListenerElements.add(plotCombo);
                for (int j = 0; j < dataTable.getNumberOfColumns(); ++j) {
                    plotCombo.addItem(dataTable.getColumnName(j));
                }
                plotCombo.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        PlotterControlPanel.this.plotterSettings.setParameterAsString("_plot_column", plotCombo.getSelectedItem().toString());
                    }
                });
                this.add((Component)plotCombo, c);
                break;
            }
        }
        if (plotter.isSupportingLogScaleForPlotColumns()) {
            final ListeningJCheckBox logScaleBox = new ListeningJCheckBox("_plot_columns_log_scale", "Log Scale", false);
            this.changeListenerElements.add(logScaleBox);
            logScaleBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotterControlPanel.this.plotterSettings.setParameterAsBoolean("_plot_columns_log_scale", logScaleBox.isSelected());
                }
            });
            this.add((Component)logScaleBox, c);
        }
        if (plotter.isSupportingSorting()) {
            final ListeningJCheckBox sortingBox = new ListeningJCheckBox("_sorting", "Sorting", false);
            this.changeListenerElements.add(sortingBox);
            sortingBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotterControlPanel.this.plotterSettings.setParameterAsBoolean("_sorting", sortingBox.isSelected());
                }
            });
            this.add((Component)sortingBox, c);
        }
        if (plotter.isSupportingAbsoluteValues()) {
            final ListeningJCheckBox absoluteBox = new ListeningJCheckBox("_absolute_values", "Absolute Values", false);
            this.changeListenerElements.add(absoluteBox);
            absoluteBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotterControlPanel.this.plotterSettings.setParameterAsBoolean("_absolute_values", absoluteBox.isSelected());
                }
            });
            this.add((Component)absoluteBox, c);
        }
        if (plotter.canHandleZooming()) {
            label = new JLabel("Zooming");
            toolTip = "Set a new zooming factor.";
            label.setToolTipText(toolTip);
            this.add((Component)label, c);
            final ListeningJSlider zoomingSlider = new ListeningJSlider("_zoom_factor", 1, 100, plotter.getInitialZoomFactor());
            this.changeListenerElements.add(zoomingSlider);
            zoomingSlider.setToolTipText(toolTip);
            this.add((Component)zoomingSlider, c);
            zoomingSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PlotterControlPanel.this.plotterSettings.setParameterAsInt("_zoom_factor", zoomingSlider.getValue());
                }
            });
        }
        if (plotter.canHandleJitter()) {
            label = new JLabel("Jitter");
            toolTip = "Select the amount of jittering (small perturbation of data points).";
            label.setToolTipText(toolTip);
            this.add((Component)label, c);
            final ListeningJSlider jitterSlider = new ListeningJSlider("_jitter_amount", 0, 100, 0);
            this.changeListenerElements.add(jitterSlider);
            jitterSlider.setToolTipText(toolTip);
            this.add((Component)jitterSlider, c);
            jitterSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PlotterControlPanel.this.plotterSettings.setParameterAsInt("_jitter_amount", jitterSlider.getValue());
                }
            });
        }
        if (plotter.hasOptionsDialog()) {
            toolTip = "Opens a dialog with further options for this plotter.";
            JButton optionsButton = new JButton("Options");
            optionsButton.setToolTipText(toolTip);
            this.add((Component)optionsButton, c);
            optionsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    plotter.showOptionsDialog();
                }
            });
        }
        int componentCounter = 0;
        while (plotter.getOptionsComponent(componentCounter) != null) {
            JComponent options = plotter.getOptionsComponent(componentCounter);
            this.add((Component)options, c);
            ++componentCounter;
        }
        if (!plotter.hasSaveImageButton()) {
            JButton imageButton = new JButton(new ResourceAction(true, "save_image", new Object[0]){
                private static final long serialVersionUID = -6568814929011124484L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComponent tosave = plotter.getPlotter();
                    ExportDialog exportDialog = new ExportDialog("RapidMiner");
                    exportDialog.showExportDialog((Component)ApplicationFrame.getApplicationFrame(), "Save Image...", (Component)tosave, "plot");
                }
            });
            this.add((Component)imageButton, c);
        }
        if (plotter.isSaveable()) {
            toolTip = "Saves the data underlying this plot into a file.";
            JButton saveButton = new JButton(new ResourceAction("save_result", new Object[0]){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    plotter.save();
                }
            });
            saveButton.setToolTipText(toolTip);
            this.add((Component)saveButton, c);
        }
        if (plotter.isProvidingCoordinates()) {
            toolTip = "The current coordinates of the mouese cursor with respect to the data dimensions.";
            coordinatesLabel.setToolTipText(toolTip);
            coordinatesLabel.setBorder(BorderFactory.createEtchedBorder());
            coordinatesLabel.setFont(new Font("Monospaced", 0, coordinatesLabel.getFont().getSize()));
            this.add((Component)coordinatesLabel, c);
        }
        if (plotter.getValuePlotSelectionType() != 1) {
            c.weighty = 1.0;
            JPanel fillPanel = new JPanel();
            this.add((Component)fillPanel, c);
            c.weighty = 0.0;
        }
        this.setAlignmentX(0.0f);
        this.revalidate();
        this.repaint();
    }

    public void updatePlotterCombo() {
        this.plotterCombo.removeItemListener(this.plotterComboListener);
        this.plotterCombo.removeAllItems();
        for (String plotterName : this.plotterSettings.getAvailablePlotters().keySet()) {
            try {
                Class<? extends Plotter> plotterClass = this.plotterSettings.getAvailablePlotters().get(plotterName);
                if (plotterClass == null) continue;
                this.plotterCombo.addItem(plotterName);
            }
            catch (IllegalArgumentException e) {
                LogService.getGlobal().log("Plotter control panel: cannot instantiate plotter '" + plotterName + "'. Skipping...", 5);
            }
            catch (SecurityException e) {
                LogService.getGlobal().log("Plotter control panel: cannot instantiate plotter '" + plotterName + "'. Skipping...", 5);
            }
        }
        this.plotterCombo.setToolTipText("The plotter which should be used for displaying data.");
        this.plotterCombo.addItemListener(this.plotterComboListener);
    }

    @Override
    public List<PlotterConfigurationModel.PlotterSettingsChangedListener> getListeningObjects() {
        return this.changeListenerElements;
    }

    @Override
    public void plotterChanged(String plotterName) {
        this.plotterCombo.setSelectedItem(plotterName);
        this.updateControls();
    }
}

