/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.AndrewsCurves;
import com.rapidminer.gui.plotter.BoundDiagram;
import com.rapidminer.gui.plotter.ColorQuartileMatrixPlotter;
import com.rapidminer.gui.plotter.ColorQuartilePlotter;
import com.rapidminer.gui.plotter.DensityPlotter;
import com.rapidminer.gui.plotter.HintonDiagram;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationSettings;
import com.rapidminer.gui.plotter.QuartilePlotter;
import com.rapidminer.gui.plotter.ScatterMatrixPlotter;
import com.rapidminer.gui.plotter.ScatterPlotter;
import com.rapidminer.gui.plotter.SurveyPlotter;
import com.rapidminer.gui.plotter.charts.BarChartPlotter;
import com.rapidminer.gui.plotter.charts.BlockChartPlotter;
import com.rapidminer.gui.plotter.charts.BubbleChartPlotter;
import com.rapidminer.gui.plotter.charts.DeviationChartPlotter;
import com.rapidminer.gui.plotter.charts.DistributionPlotter;
import com.rapidminer.gui.plotter.charts.HistogramChart;
import com.rapidminer.gui.plotter.charts.HistogramColorChart;
import com.rapidminer.gui.plotter.charts.MultipleScatterPlotter;
import com.rapidminer.gui.plotter.charts.MultipleSeriesChartPlotter;
import com.rapidminer.gui.plotter.charts.ParallelPlotter2;
import com.rapidminer.gui.plotter.charts.ParetoChartPlotter;
import com.rapidminer.gui.plotter.charts.PieChart2DPlotter;
import com.rapidminer.gui.plotter.charts.PieChart3DPlotter;
import com.rapidminer.gui.plotter.charts.RingChartPlotter;
import com.rapidminer.gui.plotter.charts.ScatterPlotter2;
import com.rapidminer.gui.plotter.charts.SeriesChartPlotter;
import com.rapidminer.gui.plotter.charts.StackedBarChartPlotter;
import com.rapidminer.gui.plotter.mathplot.BoxPlot2D;
import com.rapidminer.gui.plotter.mathplot.BoxPlot3D;
import com.rapidminer.gui.plotter.mathplot.ScatterPlot3D;
import com.rapidminer.gui.plotter.mathplot.ScatterPlot3DColor;
import com.rapidminer.gui.plotter.mathplot.SticksPlot2D;
import com.rapidminer.gui.plotter.mathplot.SticksPlot3D;
import com.rapidminer.gui.plotter.mathplot.SurfacePlot3D;
import com.rapidminer.gui.plotter.som.SOMPlotter;
import com.rapidminer.operator.visualization.SOMModelPlotter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlotterConfigurationModel
implements Cloneable {
    public static final String LINES_PLOT = "Lines";
    public static final String BOUND_PLOT = "Bound";
    public static final String HINTON_PLOT = "Hinton";
    public static final String SURFACE_PLOT_3D = "Surface 3D";
    public static final String BOX_CHART_3D = "Box 3D";
    public static final String BOX_CHART = "Box";
    public static final String STICK_CHART_3D = "Sticks 3D";
    public static final String STICK_CHART = "Sticks";
    public static final String QUARTILE_PLOT_COLOR_MATRIX = "Quartile Color Matrix";
    public static final String QUARTILE_PLOT_COLOR = "Quartile Color";
    public static final String QUARTILE_PLOT = "Quartile";
    public static final String HISTOGRAM_PLOT_COLOR = "Histogram Color";
    public static final String HISTOGRAM_PLOT = "Histogram";
    public static final String DISTRIBUTION_PLOT = "Distribution";
    public static final String ANDREWS_CURVES = "Andrews Curves";
    public static final String PARETO_PLOT = "Pareto";
    public static final String BAR_CHART = "Bars";
    public static final String BAR_CHART_STACKED = "Bars Stacked";
    public static final String RING_CHART = "Ring";
    public static final String PIE_CHART_3D = "Pie 3D";
    public static final String PIE_CHART = "Pie";
    public static final String DENSITY_PLOT = "Density";
    public static final String BLOCK_PLOT = "Block";
    public static final String SOM_PLOT = "SOM";
    public static final String SURVEY_PLOT = "Survey";
    public static final String MULTIPLE_SERIES_PLOT = "Series Multiple";
    public static final String SERIES_PLOT = "Series";
    public static final String DEVIATION_PLOT = "Deviation";
    public static final String PARALLEL_PLOT = "Parallel";
    public static final String BUBBLE_PLOT = "Bubble";
    public static final String SCATTER_PLOT_3D_COLOR = "Scatter 3D Color";
    public static final String SCATTER_PLOT_3D = "Scatter 3D";
    public static final String SCATTER_PLOT_MATRIX = "Scatter Matrix";
    public static final String MULTIPLE_SELECTION_SCATTER_PLOT = "Scatter Multiple";
    public static final String SCATTER_PLOT = "Scatter";
    public static final String RADVIZ_PLOT = "RadViz";
    public static final LinkedHashMap<String, Class<? extends Plotter>> COMPLETE_PLOTTER_SELECTION = new LinkedHashMap();
    public static final LinkedHashMap<String, Class<? extends Plotter>> WEIGHT_PLOTTER_SELECTION = new LinkedHashMap();
    public static final LinkedHashMap<String, Class<? extends Plotter>> DATA_SET_PLOTTER_SELECTION = new LinkedHashMap();
    public static final LinkedHashMap<String, Class<? extends Plotter>> MODEL_PLOTTER_SELECTION = new LinkedHashMap();
    public static final LinkedHashMap<String, Class<? extends Plotter>> COLOR_HISTOGRAM_PLOTTER_SELECTION = new LinkedHashMap();
    private PlotterConfigurationSettings settings = new PlotterConfigurationSettings();
    private Plotter plotter;
    private DataTable dataTable;
    private List<PlotterSettingsChangedListener> settingsListeners = new LinkedList<PlotterSettingsChangedListener>();
    private List<PlotterChangedListener> plotterListeners = new LinkedList<PlotterChangedListener>();
    private boolean isInitialPlotter = true;

    public PlotterConfigurationModel(String plotterName, DataTable dataTable) {
        this(COMPLETE_PLOTTER_SELECTION, plotterName, dataTable);
        this.isInitialPlotter = false;
    }

    public PlotterConfigurationModel(HashMap<String, Class<? extends Plotter>> availablePlotters, DataTable dataTable) {
        this(availablePlotters, availablePlotters.keySet().iterator().next(), dataTable);
    }

    public PlotterConfigurationModel(HashMap<String, Class<? extends Plotter>> availablePlotters, String defaultPlotter, DataTable dataTable) {
        this.settings.setAvailablePlotters(availablePlotters);
        this.setDataTable(dataTable);
        this.setPlotter(defaultPlotter);
    }

    public PlotterConfigurationModel(PlotterConfigurationSettings settings, HashMap<String, Class<? extends Plotter>> availablePlotters, DataTable dataTable) {
        this.settings = settings;
        this.setDataTable(dataTable);
        this.setPlotter(settings.getPlotterName());
    }

    protected Object clone() throws CloneNotSupportedException {
        return new PlotterConfigurationModel(this.settings.clone(), this.settings.getAvailablePlotters(), this.dataTable);
    }

    public void setParameterAsBoolean(String key, boolean value) {
        String name = PlotterAdapter.transformParameterName(this.plotter.getPlotterName());
        if (key.startsWith("_")) {
            this.setParameterValue(name + key, Boolean.toString(value));
        } else {
            this.setParameterValue(name + "_" + key, Boolean.toString(value));
        }
    }

    public void setParameterAsDouble(String key, double value) {
        String name = PlotterAdapter.transformParameterName(this.plotter.getPlotterName());
        if (key.startsWith("_")) {
            this.setParameterValue(name + key, Double.toString(value));
        } else {
            this.setParameterValue(name + "_" + key, Double.toString(value));
        }
    }

    public void setParameterAsInt(String key, int value) {
        String name = PlotterAdapter.transformParameterName(this.plotter.getPlotterName());
        if (key.startsWith("_")) {
            this.setParameterValue(name + key, Integer.toString(value));
        } else {
            this.setParameterValue(name + "_" + key, Integer.toString(value));
        }
    }

    public void setParameterAsString(String key, String value) {
        if (!key.startsWith("_")) {
            key = "_" + key;
        }
        if (this.plotter == null) {
            this.settings.setParameterValue(key, value);
        } else {
            String name = this.transformPlotterName(this.plotter.getPlotterName());
            this.setParameterValue(name + key, value);
        }
    }

    public void setParameterValue(String key, String value) {
        String generalizedKey = this.generalizeKeyName(key);
        String knownSetting = this.settings.getParameterValue(generalizedKey);
        if (knownSetting == null || !knownSetting.equals(value)) {
            this.settings.setParameterValue(generalizedKey, value);
            for (PlotterSettingsChangedListener listener : this.settingsListeners) {
                listener.settingChanged(generalizedKey, key, value);
            }
        }
    }

    public String getParameter(String key) {
        return this.settings.getParameterValue(key);
    }

    public void setPlotter(String name) {
        Class<? extends Plotter> plotterClass;
        if (!(this.settings.getPlotterName() != null && this.settings.getPlotterName().equals(name) && !this.isInitialPlotter || (plotterClass = this.settings.getAvailablePlotters().get(name)) == null || !this.isInitialPlotter && this.plotter != null && plotterClass.isAssignableFrom(this.plotter.getClass()) && this.plotter.getClass().isAssignableFrom(plotterClass))) {
            this.isInitialPlotter = this.plotter == null;
            try {
                Plotter plotter = this.settings.getAvailablePlotters().get(name).getConstructor(PlotterConfigurationModel.class).newInstance(this);
                this.setPlotter(plotter);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (SecurityException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }

    public void setPlotter(Plotter plotter) {
        this.settings.setPlotterName(plotter.getPlotterName());
        this.removeSettingsListener(this.plotter);
        for (PlotterChangedListener plotterListener : this.plotterListeners) {
            for (PlotterSettingsChangedListener listener : plotterListener.getListeningObjects()) {
                this.removeSettingsListener(listener);
            }
        }
        this.removePlotterListener(this.plotter);
        this.plotter = plotter;
        plotter.setDataTable(this.getDataTable());
        this.registerPlotterListener(plotter);
        this.informAllPlotterListener(plotter);
        this.registerSettingsListener(plotter);
        for (PlotterChangedListener plotterListener : this.plotterListeners) {
            for (PlotterSettingsChangedListener listener : plotterListener.getListeningObjects()) {
                this.registerSettingsListener(listener);
            }
        }
        List<ParameterType> parameters = plotter.getParameterTypes(null);
        for (ParameterType type : parameters) {
            String generalizedKeyName = this.generalizeKeyName(type.getKey());
            if (this.settings.isParameterSet(generalizedKeyName) || type.getDefaultValueAsString() == null) continue;
            this.settings.setParameterValue(generalizedKeyName, type.getDefaultValueAsString());
        }
        this.informAllSettingsListener();
    }

    private void informAllPlotterListener(Plotter plotter) {
        ArrayList<PlotterChangedListener> copyPlotterListener = new ArrayList<PlotterChangedListener>(this.plotterListeners.size());
        copyPlotterListener.addAll(this.plotterListeners);
        for (PlotterChangedListener listener : copyPlotterListener) {
            listener.plotterChanged(plotter.getPlotterName());
        }
    }

    private void informAllSettingsListener() {
        try {
            ArrayList<PlotterSettingsChangedListener> copySettingsChangedListener = new ArrayList<PlotterSettingsChangedListener>(this.settingsListeners.size());
            copySettingsChangedListener.addAll(this.settingsListeners);
            for (PlotterSettingsChangedListener listener : copySettingsChangedListener) {
                this.informSettingsListener(listener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void informSettingsListener(PlotterSettingsChangedListener listener) {
        HashSet<String> copiedSet = new HashSet<String>();
        copiedSet.addAll(this.settings.getParameterSettings().keySet());
        for (String generalizedKey : copiedSet) {
            String specifiedKey = this.specifyKeyName(generalizedKey);
            String value = this.settings.getParameterValue(generalizedKey);
            listener.settingChanged(generalizedKey, specifiedKey, value);
        }
    }

    public void removeSettingsListener(PlotterSettingsChangedListener listener) {
        this.settingsListeners.remove(listener);
    }

    public void removePlotterListener(PlotterChangedListener listener) {
        this.plotterListeners.remove(listener);
    }

    public HashMap<String, Class<? extends Plotter>> getAvailablePlotters() {
        return this.settings.getAvailablePlotters();
    }

    public DataTable getDataTable() {
        return this.dataTable;
    }

    public void registerSettingsListener(PlotterSettingsChangedListener listener) {
        this.settingsListeners.add(listener);
        this.informSettingsListener(listener);
    }

    public void registerPlotterListener(PlotterChangedListener listener) {
        this.plotterListeners.add(listener);
        if (this.plotter != null) {
            listener.plotterChanged(this.plotter.getPlotterName());
        }
        this.settingsListeners.addAll(listener.getListeningObjects());
        for (PlotterSettingsChangedListener settingsListener : listener.getListeningObjects()) {
            this.informSettingsListener(settingsListener);
        }
    }

    private String specifyKeyName(String generalizedKey) {
        return this.transformPlotterName(this.settings.getPlotterName()) + generalizedKey;
    }

    private String generalizeKeyName(String key) {
        return key.substring(this.transformPlotterName(this.settings.getPlotterName()).length());
    }

    private String transformPlotterName(String name) {
        String result = name.toLowerCase();
        result = result.replaceAll("\\W", "_");
        return result;
    }

    public void setDataTable(DataTable dataTable) {
        this.dataTable = dataTable;
        if (this.plotter != null) {
            this.plotter.setDataTable(dataTable);
        }
        this.informAllSettingsListener();
    }

    public Plotter getPlotter() {
        return this.plotter;
    }

    public Set<String> getParameterSet() {
        return this.settings.getParameterSettings().keySet();
    }

    public void setAxis(int axis, int dimension) {
        this.setAxis(axis, this.dataTable.getColumnName(dimension));
    }

    public void setAxis(int axis, String column) {
        this.setParameterAsString("_axis_" + PlotterAdapter.transformParameterName(this.plotter.getAxisName(axis)), column);
    }

    public void enablePlotColumn(int dimension) {
        this.enablePlotColumn(this.dataTable.getColumnName(dimension));
    }

    public void enablePlotColumn(String column) {
        String key = "_plot_columns";
        String[] oldColumns = ParameterTypeEnumeration.transformString2Enumeration(this.getParameter(key));
        LinkedList<String> columns = new LinkedList<String>();
        columns.addAll(Arrays.asList(oldColumns));
        columns.add(column);
        this.setParameterAsString(key, ParameterTypeEnumeration.transformEnumeration2String(columns));
    }

    public PlotterConfigurationSettings getPlotterSettings() {
        return this.settings;
    }

    public static Element writeToXML(Document document, PlotterConfigurationModel model) {
        Element parameters = document.createElement("plottersettings");
        parameters.setAttribute("plotter", model.getPlotter().getPlotterName());
        for (String key : model.settings.getParameterSettings().keySet()) {
            Element parameter = document.createElement("setting");
            parameter.setAttribute("key", key);
            parameter.setAttribute("value", model.settings.getParameterSettings().get(key).toString());
            parameters.appendChild(parameter);
        }
        return parameters;
    }

    public static PlotterConfigurationModel loadFromXML(Node node, DataTable table) {
        return PlotterConfigurationModel.loadFromXML(node, table, COMPLETE_PLOTTER_SELECTION);
    }

    public static PlotterConfigurationModel loadFromXML(Node node, DataTable table, HashMap<String, Class<? extends Plotter>> availablePlotters) {
        Element parameters;
        if (node instanceof Element && (parameters = (Element)node).getNodeName().equals("plottersettings")) {
            String plotterName = parameters.getAttribute("plotter");
            PlotterConfigurationModel settings = new PlotterConfigurationModel(availablePlotters, plotterName, table);
            NodeList list = parameters.getElementsByTagName("setting");
            for (int i = 0; i < list.getLength(); ++i) {
                Node settingsNode = list.item(i);
                if (!(settingsNode instanceof Element)) continue;
                Element parameter = (Element)settingsNode;
                settings.setParameterAsString(parameter.getAttribute("key"), parameter.getAttribute("value"));
            }
            return settings;
        }
        return null;
    }

    static {
        COMPLETE_PLOTTER_SELECTION.put(SCATTER_PLOT, ScatterPlotter2.class);
        COMPLETE_PLOTTER_SELECTION.put(MULTIPLE_SELECTION_SCATTER_PLOT, MultipleScatterPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(SCATTER_PLOT_MATRIX, ScatterMatrixPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(SCATTER_PLOT_3D, ScatterPlot3D.class);
        COMPLETE_PLOTTER_SELECTION.put(SCATTER_PLOT_3D_COLOR, ScatterPlot3DColor.class);
        COMPLETE_PLOTTER_SELECTION.put(BUBBLE_PLOT, BubbleChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(PARALLEL_PLOT, ParallelPlotter2.class);
        COMPLETE_PLOTTER_SELECTION.put(DEVIATION_PLOT, DeviationChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(SERIES_PLOT, SeriesChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(MULTIPLE_SERIES_PLOT, MultipleSeriesChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(SURVEY_PLOT, SurveyPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(SOM_PLOT, SOMPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(BLOCK_PLOT, BlockChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(DENSITY_PLOT, DensityPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(PIE_CHART, PieChart2DPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(PIE_CHART_3D, PieChart3DPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(RING_CHART, RingChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(BAR_CHART, BarChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(BAR_CHART_STACKED, StackedBarChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(PARETO_PLOT, ParetoChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(ANDREWS_CURVES, AndrewsCurves.class);
        COMPLETE_PLOTTER_SELECTION.put(DISTRIBUTION_PLOT, DistributionPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(HISTOGRAM_PLOT, HistogramChart.class);
        COMPLETE_PLOTTER_SELECTION.put(HISTOGRAM_PLOT_COLOR, HistogramColorChart.class);
        COMPLETE_PLOTTER_SELECTION.put(QUARTILE_PLOT, QuartilePlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(QUARTILE_PLOT_COLOR, ColorQuartilePlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(QUARTILE_PLOT_COLOR_MATRIX, ColorQuartileMatrixPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put(STICK_CHART, SticksPlot2D.class);
        COMPLETE_PLOTTER_SELECTION.put(STICK_CHART_3D, SticksPlot3D.class);
        COMPLETE_PLOTTER_SELECTION.put(BOX_CHART, BoxPlot2D.class);
        COMPLETE_PLOTTER_SELECTION.put(BOX_CHART_3D, BoxPlot3D.class);
        COMPLETE_PLOTTER_SELECTION.put(SURFACE_PLOT_3D, SurfacePlot3D.class);
        COMPLETE_PLOTTER_SELECTION.put(HINTON_PLOT, HintonDiagram.class);
        COMPLETE_PLOTTER_SELECTION.put(BOUND_PLOT, BoundDiagram.class);
        WEIGHT_PLOTTER_SELECTION.put(LINES_PLOT, ScatterPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put(HISTOGRAM_PLOT, HistogramChart.class);
        WEIGHT_PLOTTER_SELECTION.put(HINTON_PLOT, HintonDiagram.class);
        WEIGHT_PLOTTER_SELECTION.put(BOUND_PLOT, BoundDiagram.class);
        WEIGHT_PLOTTER_SELECTION.put(PIE_CHART, PieChart2DPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put(PIE_CHART_3D, PieChart3DPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put(RING_CHART, RingChartPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put(BAR_CHART, BarChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(SCATTER_PLOT, ScatterPlotter2.class);
        DATA_SET_PLOTTER_SELECTION.put(MULTIPLE_SELECTION_SCATTER_PLOT, MultipleScatterPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(SCATTER_PLOT_MATRIX, ScatterMatrixPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(SCATTER_PLOT_3D, ScatterPlot3D.class);
        DATA_SET_PLOTTER_SELECTION.put(SCATTER_PLOT_3D_COLOR, ScatterPlot3DColor.class);
        DATA_SET_PLOTTER_SELECTION.put(BUBBLE_PLOT, BubbleChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(PARALLEL_PLOT, ParallelPlotter2.class);
        DATA_SET_PLOTTER_SELECTION.put(DEVIATION_PLOT, DeviationChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(SERIES_PLOT, SeriesChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(MULTIPLE_SERIES_PLOT, MultipleSeriesChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(SURVEY_PLOT, SurveyPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(SOM_PLOT, SOMPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(BLOCK_PLOT, BlockChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(DENSITY_PLOT, DensityPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(PIE_CHART, PieChart2DPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(PIE_CHART_3D, PieChart3DPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(RING_CHART, RingChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(BAR_CHART, BarChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(BAR_CHART_STACKED, StackedBarChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(PARETO_PLOT, ParetoChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(ANDREWS_CURVES, AndrewsCurves.class);
        DATA_SET_PLOTTER_SELECTION.put(DISTRIBUTION_PLOT, DistributionPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(HISTOGRAM_PLOT, HistogramChart.class);
        DATA_SET_PLOTTER_SELECTION.put(HISTOGRAM_PLOT_COLOR, HistogramColorChart.class);
        DATA_SET_PLOTTER_SELECTION.put(QUARTILE_PLOT, QuartilePlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(QUARTILE_PLOT_COLOR, ColorQuartilePlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(QUARTILE_PLOT_COLOR_MATRIX, ColorQuartileMatrixPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put(STICK_CHART, SticksPlot2D.class);
        DATA_SET_PLOTTER_SELECTION.put(STICK_CHART_3D, SticksPlot3D.class);
        DATA_SET_PLOTTER_SELECTION.put(BOX_CHART, BoxPlot2D.class);
        DATA_SET_PLOTTER_SELECTION.put(BOX_CHART_3D, BoxPlot3D.class);
        DATA_SET_PLOTTER_SELECTION.put(SURFACE_PLOT_3D, SurfacePlot3D.class);
        MODEL_PLOTTER_SELECTION.put(SOM_PLOT, SOMModelPlotter.class);
        COLOR_HISTOGRAM_PLOTTER_SELECTION.put(HISTOGRAM_PLOT_COLOR, HistogramColorChart.class);
    }

    public static interface PlotterChangedListener {
        public List<PlotterSettingsChangedListener> getListeningObjects();

        public void plotterChanged(String var1);
    }

    public static interface PlotterSettingsChangedListener {
        public void settingChanged(String var1, String var2, String var3);
    }
}

