/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.ColorProvider;
import com.rapidminer.gui.plotter.CoordinateTransformation;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.ToolTip;
import com.rapidminer.gui.plotter.conditions.BasicPlotterCondition;
import com.rapidminer.gui.plotter.conditions.PlotterCondition;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.ModelMetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class PlotterAdapter
extends JPanel
implements Plotter {
    public static final String PARAMETER_SUFFIX_LOG_SCALE = "_log_scale";
    public static final String PARAMETER_SUFFIX_ABSOLUTE_VALUES = "_absolute_values";
    public static final String PARAMETER_SUFFIX_AXIS = "_axis_";
    public static final String PARAMETER_PLOT_COLUMNS = "_plot_columns";
    public static final String PARAMETER_PLOT_COLUMN = "_plot_column";
    public static final String PARAMETER_SUFFIX_ZOOM_FACTOR = "_zoom_factor";
    public static final String PARAMETER_JITTER_AMOUNT = "_jitter_amount";
    public static final String PARAMETER_SUFFIX_SORTING = "_sorting";
    private static final long serialVersionUID = -8994113034200480325L;
    public static final double POINTSIZE = 7.0;
    private static final int[] TICS;
    public static final int MARGIN = 20;
    public static final int WEIGHT_BORDER_WIDTH = 5;
    public static final Font LABEL_FONT_BOLD;
    public static final Font LABEL_FONT;
    protected static final Color GRID_COLOR;
    protected static final Color TOOLTIP_COLOR;
    protected static final PointStyle ELLIPSOID_POINT_STYLE;
    protected static final PointStyle RECTANGLE_POINT_STYLE;
    protected static final PointStyle TRIANGUALAR_POINT_STYLE;
    protected static final PointStyle TURNED_TRIANGUALAR_POINT_STYLE;
    protected static final PointStyle STAR_POINT_STYLE;
    protected static final Color[] LINE_COLORS;
    protected static final PointStyle[] KNOWN_POINT_STYLES;
    protected static final Stroke[] LINE_STROKES;
    protected static final LineStyle[] LINE_STYLES;
    protected static final PointStyle[] POINT_STYLES;
    protected static final Icon[] LINE_STYLE_ICONS;
    protected PlotterConfigurationModel settings;

    public PlotterAdapter(PlotterConfigurationModel settings) {
        this.settings = settings;
    }

    @Override
    public void forcePlotGeneration() {
    }

    @Override
    public void stopUpdates(boolean value) {
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public boolean canHandleJitter() {
        return false;
    }

    @Override
    public boolean canHandleContinousJittering() {
        return true;
    }

    @Override
    public boolean canHandleZooming() {
        return false;
    }

    @Override
    public int getAxis(int axis) {
        return -1;
    }

    @Override
    public String getAxisName(int index) {
        return null;
    }

    @Override
    public Icon getIcon(int index) {
        return LINE_STYLE_ICONS[index % LINE_STYLE_ICONS.length];
    }

    @Override
    public String getIdForPos(int x, int y) {
        return null;
    }

    @Override
    public int getInitialZoomFactor() {
        return 1;
    }

    @Override
    public int getNumberOfAxes() {
        return 0;
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        return null;
    }

    @Override
    public boolean getPlotColumn(int dimension) {
        return false;
    }

    @Override
    public String getPlotName() {
        return null;
    }

    @Override
    public JComponent getPlotter() {
        return this;
    }

    @Override
    public JComponent getRenderComponent() {
        return this.getPlotter();
    }

    @Override
    public PlotterCondition getPlotterCondition() {
        return new BasicPlotterCondition();
    }

    @Override
    public Point2D getPositionInDataSpace(Point p) {
        return null;
    }

    @Override
    public int getValuePlotSelectionType() {
        return 0;
    }

    @Override
    public boolean hasOptionsDialog() {
        return false;
    }

    @Override
    public boolean hasSaveImageButton() {
        return false;
    }

    @Override
    public boolean isProvidingCoordinates() {
        return false;
    }

    @Override
    public boolean isSaveable() {
        return false;
    }

    @Override
    public void save() {
    }

    @Override
    public void setAxis(int plotterAxis, int dimension) {
    }

    @Override
    public void setDragBounds(int x, int y, int w, int h) {
    }

    @Override
    public void setDrawRange(double x, double y, double w, double h) {
    }

    @Override
    public void setJitter(int jitter) {
    }

    @Override
    public void setKey(String key) {
    }

    @Override
    public void setMousePosInDataSpace(int mouseX, int mouseY) {
    }

    @Override
    public void setPlotColumn(int dimension, boolean plot) {
    }

    @Override
    public void setDataTable(DataTable dataTable) {
    }

    @Override
    public void setZooming(int zooming) {
    }

    @Override
    public void showOptionsDialog() {
    }

    @Override
    public boolean isSupportingLogScale(int axis) {
        return false;
    }

    @Override
    public boolean isSupportingLogScaleForPlotColumns() {
        return false;
    }

    @Override
    public void setLogScale(int axis, boolean logScale) {
    }

    @Override
    public void setLogScaleForPlotColumns(boolean logScale) {
    }

    @Override
    public boolean isSupportingAbsoluteValues() {
        return false;
    }

    @Override
    public boolean isSupportingSorting() {
        return false;
    }

    @Override
    public void setAbsolute(boolean absolute) {
    }

    @Override
    public void setSorting(boolean sorting) {
    }

    public final void dataTableUpdated(DataTable source) {
        int maxRowNumber = 5000;
        String maxRowNumberString = System.getProperty("rapidminer.gui.plotter.rows.maximum");
        if (maxRowNumberString != null && maxRowNumberString.trim().length() > 0) {
            try {
                int newMaxRows;
                maxRowNumber = newMaxRows = Integer.parseInt(maxRowNumberString);
            }
            catch (NumberFormatException e) {
                LogService.getGlobal().logWarning("Plotter: cannot read maximum number of plotter points (was '" + maxRowNumberString + "').");
            }
        }
        if (source.getNumberOfRows() > maxRowNumber) {
            DataTable sampledDataTable = source.sample(maxRowNumber);
            LogService.getGlobal().logWarning("Cannot plot all data points, using only a sample of " + maxRowNumber + " rows.");
            this.setDataTable(sampledDataTable);
        } else {
            this.setDataTable(source);
        }
        this.repaint();
    }

    public ColorProvider getColorProvider() {
        return new ColorProvider();
    }

    protected PointStyle getPointStyle(int styleIndex) {
        return POINT_STYLES[styleIndex % POINT_STYLES.length];
    }

    protected void drawPoint(Graphics2D g, double x, double y, Color color, Color borderColor) {
        this.drawPoint(g, ELLIPSOID_POINT_STYLE, x, y, color, borderColor);
    }

    protected void drawPoint(Graphics2D g, PointStyle pointStyle, double x, double y, Color color, Color borderColor) {
        Shape pointShape = pointStyle.createShape(x, y);
        g.setColor(color);
        g.fill(pointShape);
        g.setColor(borderColor);
        g.draw(pointShape);
    }

    protected void drawLegend(Graphics graphics, DataTable table, int legendColumn) {
        this.drawLegend(graphics, table, legendColumn, 0, 255);
    }

    protected void drawLegend(Graphics graphics, DataTable table, int legendColumn, int xOffset, int alpha) {
        if (legendColumn < 0 || legendColumn > table.getNumberOfColumns() - 1) {
            return;
        }
        if (table.isNominal(legendColumn)) {
            String maxNominalValuesString = System.getProperty("rapidminer.gui.plotter.legend.classlimit");
            int maxNumberOfNominalValues = 10;
            try {
                if (maxNominalValuesString != null) {
                    maxNumberOfNominalValues = Integer.parseInt(maxNominalValuesString);
                }
            }
            catch (NumberFormatException e) {
                LogService.getGlobal().logWarning("Plotter: cannot parse maximal number of nominal values for legend (" + maxNominalValuesString + ")! Using 10...");
            }
            if (maxNumberOfNominalValues == -1 || table.getNumberOfValues(legendColumn) <= maxNumberOfNominalValues) {
                this.drawNominalLegend(graphics, table, legendColumn, xOffset, alpha);
            } else {
                LogService.getGlobal().logWarning("Plotter: cannot draw nominal legend since number of different values is too high (more than " + maxNominalValuesString + ")! Using numerical legend instead.");
                this.drawNumericalLegend(graphics, table, legendColumn, alpha);
            }
        } else if (table.isDate(legendColumn) || table.isTime(legendColumn) || table.isDateTime(legendColumn)) {
            this.drawDateLegend(graphics, table, legendColumn, alpha);
        } else {
            this.drawNumericalLegend(graphics, table, legendColumn, alpha);
        }
    }

    private void drawNominalLegend(Graphics graphics, DataTable table, int legendColumn, int xOffset, int alpha) {
        Graphics2D g = (Graphics2D)graphics.create();
        g.translate(xOffset, 0);
        String legendName = table.getColumnName(legendColumn);
        g.drawString(legendName, 20, 15);
        Rectangle2D legendNameBounds = LABEL_FONT.getStringBounds(legendName, g.getFontRenderContext());
        g.translate(legendNameBounds.getWidth(), 0.0);
        int numberOfValues = table.getNumberOfValues(legendColumn);
        int currentX = 20;
        for (int i = 0; i < numberOfValues && currentX <= this.getWidth(); ++i) {
            String nominalValue = table.mapIndex(legendColumn, i);
            if (nominalValue.length() > 16) {
                nominalValue = nominalValue.substring(0, 16) + "...";
            }
            Ellipse2D.Double colorBullet = new Ellipse2D.Double(currentX, 7.0, 7.0, 7.0);
            Color color = this.getColorProvider().getPointColor((double)i / (double)(numberOfValues - 1), alpha);
            g.setColor(color);
            g.fill(colorBullet);
            g.setColor(Color.black);
            g.draw(colorBullet);
            g.drawString(nominalValue, currentX += 12, 15);
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(nominalValue, g.getFontRenderContext());
            currentX = (int)((double)currentX + (stringBounds.getWidth() + 15.0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawDateLegend(Graphics graphics, DataTable table, int legendColumn, int alpha) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        DataTable dataTable = table;
        synchronized (dataTable) {
            for (DataTableRow row : table) {
                double colorValue = row.getValue(legendColumn);
                min = MathFunctions.robustMin(min, colorValue);
                max = MathFunctions.robustMax(max, colorValue);
            }
        }
        String minColorString = null;
        String maxColorString = null;
        if (table.isDate(legendColumn)) {
            minColorString = Tools.formatDate(new Date((long)min));
            maxColorString = Tools.formatDate(new Date((long)max));
        } else if (table.isTime(legendColumn)) {
            minColorString = Tools.formatTime(new Date((long)min));
            maxColorString = Tools.formatTime(new Date((long)max));
        } else if (table.isDateTime(legendColumn)) {
            minColorString = Tools.formatDateTime(new Date((long)min));
            maxColorString = Tools.formatDateTime(new Date((long)max));
        } else {
            minColorString = Tools.formatNumber(min);
            maxColorString = Tools.formatNumber(max);
        }
        this.drawNumericalLegend(graphics, this.getWidth(), minColorString, maxColorString, table.getColumnName(legendColumn), alpha);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawNumericalLegend(Graphics graphics, DataTable table, int legendColumn, int alpha) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        DataTable dataTable = table;
        synchronized (dataTable) {
            for (DataTableRow row : table) {
                double colorValue = row.getValue(legendColumn);
                min = MathFunctions.robustMin(min, colorValue);
                max = MathFunctions.robustMax(max, colorValue);
            }
        }
        this.drawNumericalLegend(graphics, table.getColumnName(legendColumn), min, max, alpha);
    }

    private void drawNumericalLegend(Graphics graphics, String legendColumnName, double minColor, double maxColor, int alpha) {
        String minColorString = Tools.formatNumber(minColor);
        String maxColorString = Tools.formatNumber(maxColor);
        this.drawNumericalLegend(graphics, this.getWidth(), minColorString, maxColorString, legendColumnName, alpha);
    }

    public void drawNumericalLegend(Graphics graphics, int width, String minColorString, String maxColorString, String legendColumnName, int alpha) {
        Graphics2D g = (Graphics2D)graphics.create();
        g.drawString(legendColumnName, 20, 15);
        Rectangle2D legendNameBounds = LABEL_FONT.getStringBounds(legendColumnName, g.getFontRenderContext());
        g.translate(legendNameBounds.getWidth(), 0.0);
        Rectangle2D minStringBounds = LABEL_FONT.getStringBounds(minColorString, g.getFontRenderContext());
        Rectangle2D maxStringBounds = LABEL_FONT.getStringBounds(maxColorString, g.getFontRenderContext());
        int legendWidth = (int)(minStringBounds.getWidth() + 114.0 + maxStringBounds.getWidth());
        int keyX = 20 + width / 2 - legendWidth / 2;
        int keyY = (int)(22.0 - minStringBounds.getHeight() / 2.0);
        g.setColor(Color.black);
        g.drawString(minColorString, keyX, keyY);
        keyX = (int)((double)keyX + (minStringBounds.getWidth() + 10.0));
        for (int i = 0; i < 100; ++i) {
            double scaledColor = (double)i / 100.0;
            Color lineColor = this.getColorProvider().getPointColor(scaledColor, alpha);
            g.setColor(lineColor);
            g.drawLine(keyX, keyY, keyX, keyY - 10);
            ++keyX;
        }
        g.setColor(Color.black);
        Rectangle2D.Double frame = new Rectangle2D.Double(keyX - 101, keyY - 11, 101.0, 11.0);
        g.draw(frame);
        g.drawString(maxColorString, keyX += 4, keyY);
    }

    public void drawSimpleNumericalLegend(Graphics graphics, int x, int y, String legendColumnName, String minColorString, String maxColorString) {
        Graphics2D g = (Graphics2D)graphics.create();
        g.setFont(LABEL_FONT_BOLD);
        g.setColor(Color.black);
        g.drawString(legendColumnName, x, y + 1);
        Rectangle2D legendNameBounds = LABEL_FONT.getStringBounds(legendColumnName, g.getFontRenderContext());
        g.translate(legendNameBounds.getWidth() + 5.0, 0.0);
        g.setFont(LABEL_FONT);
        g.setColor(Color.black);
        Rectangle2D minStringBounds = LABEL_FONT.getStringBounds(minColorString, g.getFontRenderContext());
        int keyX = x;
        int keyY = y;
        g.drawString(minColorString, keyX, keyY + 1);
        keyX = (int)((double)keyX + (minStringBounds.getWidth() + 5.0));
        for (int i = 0; i < 100; ++i) {
            double scaledColor = (double)i / 100.0;
            Color lineColor = this.getColorProvider().getPointColor(scaledColor, 255);
            g.setColor(lineColor);
            g.drawLine(keyX, keyY, keyX, keyY - 8);
            ++keyX;
        }
        g.setColor(Color.black);
        Rectangle2D.Double frame = new Rectangle2D.Double(keyX - 101, keyY - 8, 101.0, 8.0);
        g.draw(frame);
        g.drawString(maxColorString, keyX += 4, keyY + 1);
    }

    public void drawSimpleDateLegend(Graphics graphics, int x, int y, DataTable table, int legendColumn, double min, double max) {
        String minColorString = null;
        String maxColorString = null;
        if (table.isDate(legendColumn)) {
            minColorString = Tools.formatDate(new Date((long)min));
            maxColorString = Tools.formatDate(new Date((long)max));
        } else if (table.isTime(legendColumn)) {
            minColorString = Tools.formatTime(new Date((long)min));
            maxColorString = Tools.formatTime(new Date((long)max));
        } else if (table.isDateTime(legendColumn)) {
            minColorString = Tools.formatDateTime(new Date((long)min));
            maxColorString = Tools.formatDateTime(new Date((long)max));
        } else {
            minColorString = Tools.formatNumber(min);
            maxColorString = Tools.formatNumber(max);
        }
        this.drawSimpleNumericalLegend(graphics, x, y, table.getColumnName(legendColumn), minColorString, maxColorString);
    }

    protected void drawGenericNominalLegend(Graphics graphics, String[] names, PointStyle[] pointStyles, Color[] colors, int xOffset, int alpha) {
        Graphics2D g = (Graphics2D)graphics.create();
        g.translate(xOffset, 0);
        int numberOfValues = names.length;
        int currentX = 20;
        for (int i = 0; i < numberOfValues && currentX <= this.getWidth(); ++i) {
            String nominalValue = names[i];
            if (nominalValue.length() > 16) {
                nominalValue = nominalValue.substring(0, 16) + "...";
            }
            Shape shape = pointStyles[i].createShape(currentX, 11.0);
            Color color = colors[i];
            g.setColor(color);
            g.fill(shape);
            g.setColor(Color.black);
            g.draw(shape);
            g.drawString(nominalValue, currentX += 8, 15);
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(nominalValue, g.getFontRenderContext());
            currentX = (int)((double)currentX + (stringBounds.getWidth() + 15.0));
        }
    }

    protected void drawToolTip(Graphics2D g, ToolTip toolTip) {
        if (toolTip != null) {
            g.setFont(LABEL_FONT);
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(toolTip.getText(), g.getFontRenderContext());
            g.setColor(TOOLTIP_COLOR);
            Rectangle2D.Double bg = new Rectangle2D.Double((double)toolTip.getX() - stringBounds.getWidth() / 2.0 - 4.0, (double)toolTip.getY() - stringBounds.getHeight() / 2.0, stringBounds.getWidth() + 5.0, stringBounds.getHeight() + 3.0);
            g.fill(bg);
            g.setColor(Color.black);
            g.draw(bg);
            g.drawString(toolTip.getText(), (int)((double)toolTip.getX() - stringBounds.getWidth() / 2.0 - 2.0), toolTip.getY() + 6);
        }
    }

    protected int getNumberOfPlots(DataTable table) {
        int counter = 0;
        for (int i = 0; i < table.getNumberOfColumns(); ++i) {
            if (!this.getPlotColumn(i)) continue;
            ++counter;
        }
        return counter;
    }

    protected double getTicSize(DataTable dataTable, int column, double min, double max) {
        if (column < 0) {
            return Double.NaN;
        }
        if (this.getNumberOfPlots(dataTable) == 1 && dataTable.isNominal(column)) {
            if (dataTable.getNumberOfValues(column) <= 10) {
                return 1.0;
            }
            return this.getNumericalTicSize(min, max);
        }
        return this.getNumericalTicSize(min, max);
    }

    protected double getNumericalTicSize(double min, double max) {
        double delta = (max - min) / 5.0;
        double e = Math.floor(Math.log(delta) / Math.log(10.0));
        double factor = Math.pow(10.0, e);
        for (int i = TICS.length - 1; i >= 0; --i) {
            if (!((double)TICS[i] * factor <= delta)) continue;
            return (double)TICS[i] * factor;
        }
        return factor;
    }

    protected double getMaxWeight(DataTable dataTable) {
        double maxWeight = Double.NaN;
        if (dataTable.isSupportingColumnWeights()) {
            maxWeight = Double.NEGATIVE_INFINITY;
            for (int c = 0; c < dataTable.getNumberOfColumns(); ++c) {
                double weight = dataTable.getColumnWeight(c);
                if (Double.isNaN(weight)) continue;
                maxWeight = Math.max(Math.abs(weight), maxWeight);
            }
        }
        return maxWeight;
    }

    public static Color getWeightColor(double weight, double maxWeight) {
        Color weightColor = Color.white;
        if (!Double.isNaN(weight) && !Double.isNaN(maxWeight)) {
            weightColor = new Color(255, 255, 0, (int)(Math.abs(weight) / maxWeight * 100.0));
        }
        return weightColor;
    }

    protected void drawWeightRectangle(Graphics2D newSpace, DataTable dataTable, int column, double maxWeight, int plotterSize) {
        if (dataTable.isSupportingColumnWeights()) {
            newSpace.setColor(PlotterAdapter.getWeightColor(dataTable.getColumnWeight(column), maxWeight));
            Rectangle2D.Double weightRect = new Rectangle2D.Double(1.0, 1.0, plotterSize - 2, plotterSize - 2);
            newSpace.fill(weightRect);
            newSpace.setColor(Color.WHITE);
            int weightBorder = 6;
            weightRect = new Rectangle2D.Double(weightBorder, weightBorder, plotterSize - 2 * weightBorder, plotterSize - 2 * weightBorder);
            newSpace.fill(weightRect);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }

    @Override
    public void prepareRendering() {
        this.forcePlotGeneration();
    }

    @Override
    public void finishRendering() {
    }

    @Override
    public int getRenderHeight(int preferredHeight) {
        if (preferredHeight < 0) {
            return this.getPreferredSize().height;
        }
        return preferredHeight;
    }

    @Override
    public int getRenderWidth(int preferredWidth) {
        if (preferredWidth < 0) {
            return this.getPreferredSize().width;
        }
        return preferredWidth;
    }

    @Override
    public void render(Graphics graphics, int width, int height) {
        JComponent renderComponent = this.getRenderComponent();
        renderComponent.setSize(width, height);
        renderComponent.setDoubleBuffered(false);
        renderComponent.paint(graphics);
        renderComponent.setDoubleBuffered(true);
    }

    public PlotterConfigurationModel getPlotterSettings() {
        return this.settings;
    }

    public static String transformParameterName(String name) {
        if (name == null) {
            return "default";
        }
        String result = name.toLowerCase();
        result = result.replaceAll("\\W", "_");
        return result;
    }

    @Override
    public void applyParameterSetting(DataTable dataTable, String key, String value) {
        String compareKey = null;
        for (int i = 0; i < this.getNumberOfAxes(); ++i) {
            String axisName = this.getAxisName(i);
            compareKey = PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_SUFFIX_AXIS + PlotterAdapter.transformParameterName(axisName);
            if (compareKey.equals(key)) {
                int columnIndex;
                if (value != null && (columnIndex = dataTable.getColumnIndex(value)) >= 0) {
                    this.setAxis(i, columnIndex);
                }
                return;
            }
            if (!this.isSupportingLogScale(i) || !(compareKey = PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_SUFFIX_AXIS + PlotterAdapter.transformParameterName(axisName) + PARAMETER_SUFFIX_LOG_SCALE).equals(key)) continue;
            this.setLogScale(i, Boolean.parseBoolean(value));
            return;
        }
        switch (this.getValuePlotSelectionType()) {
            case 1: {
                int i;
                compareKey = PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_PLOT_COLUMNS;
                if (!compareKey.equals(key)) break;
                String[] names = ParameterTypeEnumeration.transformString2Enumeration(value);
                boolean[] selectedDimensions = new boolean[dataTable.getNumberOfColumns()];
                for (i = 0; i < names.length; ++i) {
                    String name = names[i].trim();
                    int columnIndex = dataTable.getColumnIndex(name);
                    if (columnIndex <= -1) continue;
                    selectedDimensions[columnIndex] = true;
                }
                for (i = 0; i < dataTable.getNumberOfColumns(); ++i) {
                    if (this.getPlotColumn(i) == selectedDimensions[i]) continue;
                    this.setPlotColumn(i, selectedDimensions[i]);
                }
                return;
            }
            case 0: {
                int columnIndex;
                compareKey = PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_PLOT_COLUMN;
                if (!compareKey.equals(key)) break;
                if (dataTable != null && (columnIndex = dataTable.getColumnIndex(value)) >= 0) {
                    this.setPlotColumn(columnIndex, true);
                }
                return;
            }
        }
        if (this.isSupportingLogScaleForPlotColumns() && (compareKey = PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_PLOT_COLUMNS + PARAMETER_SUFFIX_LOG_SCALE).equals(key)) {
            this.setLogScaleForPlotColumns("true".equals(value));
        }
        if (this.canHandleZooming() && (compareKey = PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_SUFFIX_ZOOM_FACTOR).equals(key)) {
            int zoomFactor = Integer.valueOf(value);
            this.setZooming(zoomFactor);
            return;
        }
        if (this.canHandleJitter() && (compareKey = PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_JITTER_AMOUNT).equals(key)) {
            int jitterAmount = Integer.valueOf(value);
            this.setJitter(jitterAmount);
            return;
        }
        if (this.isSupportingSorting() && (compareKey = PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_SUFFIX_SORTING).equals(key)) {
            boolean sorting = Tools.booleanValue(value, false);
            this.setSorting(sorting);
            return;
        }
        if (this.isSupportingAbsoluteValues() && (compareKey = PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_SUFFIX_ABSOLUTE_VALUES).equals(key)) {
            boolean absoluteValues = Tools.booleanValue(value, false);
            this.setAbsolute(absoluteValues);
            return;
        }
        String plotterName = PlotterAdapter.transformParameterName(this.getPlotterName()) + "_";
        if (key.startsWith(plotterName)) {
            String actualKey = key.substring(plotterName.length());
            this.setAdditionalParameter(actualKey, value);
        }
    }

    public List<ParameterType> getAdditionalParameterKeys(InputPort inputPort) {
        return new LinkedList<ParameterType>();
    }

    public void setAdditionalParameter(String key, String value) {
    }

    @Override
    public List<ParameterType> getParameterTypes(InputPort inputPort) {
        MetaData metaData;
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        boolean inputDeliversAttributes = false;
        if (inputPort != null && (metaData = inputPort.getMetaData()) != null && (metaData instanceof ExampleSetMetaData || metaData instanceof ModelMetaData)) {
            inputDeliversAttributes = true;
        }
        for (int i = 0; i < this.getNumberOfAxes(); ++i) {
            String axisName = this.getAxisName(i);
            if (inputDeliversAttributes) {
                types.add(new ParameterTypeAttribute(PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_SUFFIX_AXIS + PlotterAdapter.transformParameterName(axisName), "The name of the column which should be used for this axis", inputPort, true));
            } else {
                types.add(new ParameterTypeString(PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_SUFFIX_AXIS + PlotterAdapter.transformParameterName(axisName), "The name of the column which should be used for this axis", true));
            }
            if (!this.isSupportingLogScale(i)) continue;
            types.add(new ParameterTypeBoolean(PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_SUFFIX_AXIS + PlotterAdapter.transformParameterName(axisName) + PARAMETER_SUFFIX_LOG_SCALE, "Indicates if this axis should be plotter with a log scale.", false));
        }
        switch (this.getValuePlotSelectionType()) {
            case 1: {
                types.add(new ParameterTypeString(PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_PLOT_COLUMNS, "A comma separated list of the names of the columns which should be used for plotting.", true));
                break;
            }
            case 0: {
                if (inputDeliversAttributes) {
                    types.add(new ParameterTypeAttribute(PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_PLOT_COLUMN, "The name of the column which should be used for plotting.", inputPort, true));
                    break;
                }
                types.add(new ParameterTypeString(PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_PLOT_COLUMN, "The name of the column which should be used for plotting.", true));
                break;
            }
        }
        if (this.canHandleZooming()) {
            types.add(new ParameterTypeInt(PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_SUFFIX_ZOOM_FACTOR, "The zoom factor for this plotter.", 1, 100, this.getInitialZoomFactor()));
        }
        if (this.canHandleJitter()) {
            types.add(new ParameterTypeInt(PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_JITTER_AMOUNT, "The jittering amount for this plotter.", 0, 100, 0));
        }
        if (this.isSupportingSorting()) {
            types.add(new ParameterTypeBoolean(PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_SUFFIX_SORTING, "Indicates if the plotter should sort the values according to the selected column.", false));
        }
        if (this.isSupportingAbsoluteValues()) {
            types.add(new ParameterTypeBoolean(PlotterAdapter.transformParameterName(this.getPlotterName()) + PARAMETER_SUFFIX_ABSOLUTE_VALUES, "Indicates if the plotter should use absolute values.", false));
        }
        List<ParameterType> additionalTypes = this.getAdditionalParameterKeys(inputPort);
        for (ParameterType type : additionalTypes) {
            type.setKey(PlotterAdapter.transformParameterName(this.getPlotterName()) + "_" + type.getKey());
            types.add(type);
        }
        return types;
    }

    @Override
    public void plotterChanged(String plotterName) {
    }

    @Override
    public List<PlotterConfigurationModel.PlotterSettingsChangedListener> getListeningObjects() {
        LinkedList<PlotterConfigurationModel.PlotterSettingsChangedListener> listeningObjects = new LinkedList<PlotterConfigurationModel.PlotterSettingsChangedListener>();
        return listeningObjects;
    }

    @Override
    public void settingChanged(String generalKey, String specificKey, String value) {
        if (this.settings.getDataTable() != null) {
            this.applyParameterSetting(this.settings.getDataTable(), specificKey, value);
        }
    }

    @Override
    public void setCoordinateTransformation(CoordinateTransformation transformation) {
    }

    static {
        int j;
        int i;
        TICS = new int[]{1, 2, 5};
        LABEL_FONT_BOLD = new Font("Lucida Sans", 1, 11);
        LABEL_FONT = new Font("Lucida Sans", 0, 11);
        GRID_COLOR = Color.lightGray;
        TOOLTIP_COLOR = new Color(170, 150, 240, 210);
        ELLIPSOID_POINT_STYLE = new EllipsoidPointStyle();
        RECTANGLE_POINT_STYLE = new RectanglePointStyle();
        TRIANGUALAR_POINT_STYLE = new TriangularPointStyle();
        TURNED_TRIANGUALAR_POINT_STYLE = new TurnedTriangularPointStyle();
        STAR_POINT_STYLE = new StarPointStyle();
        LINE_COLORS = new Color[]{new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255), new Color(255, 0, 255), Color.ORANGE, new Color(255, 255, 0), new Color(0, 255, 255), new Color(200, 100, 0), new Color(100, 200, 0), new Color(0, 100, 200)};
        KNOWN_POINT_STYLES = new PointStyle[]{ELLIPSOID_POINT_STYLE, RECTANGLE_POINT_STYLE, TRIANGUALAR_POINT_STYLE, TURNED_TRIANGUALAR_POINT_STYLE, STAR_POINT_STYLE, ELLIPSOID_POINT_STYLE, RECTANGLE_POINT_STYLE, TRIANGUALAR_POINT_STYLE, TURNED_TRIANGUALAR_POINT_STYLE, STAR_POINT_STYLE};
        LINE_STROKES = new Stroke[]{new BasicStroke(2.0f)};
        LINE_STYLES = new LineStyle[LINE_COLORS.length * LINE_STROKES.length];
        POINT_STYLES = new PointStyle[LINE_COLORS.length * LINE_STROKES.length];
        LINE_STYLE_ICONS = new LineStyleIcon[LINE_STYLES.length];
        for (i = 0; i < LINE_STROKES.length; ++i) {
            for (j = 0; j < LINE_COLORS.length; ++j) {
                PlotterAdapter.LINE_STYLES[i * PlotterAdapter.LINE_COLORS.length + j] = new LineStyle(LINE_COLORS[j], LINE_STROKES[i]);
            }
        }
        for (i = 0; i < LINE_STYLE_ICONS.length; ++i) {
            PlotterAdapter.LINE_STYLE_ICONS[i] = new LineStyleIcon(i);
        }
        for (i = 0; i < LINE_STROKES.length; ++i) {
            for (j = 0; j < LINE_COLORS.length; ++j) {
                PlotterAdapter.POINT_STYLES[i * PlotterAdapter.LINE_COLORS.length + j] = KNOWN_POINT_STYLES[j];
            }
        }
    }

    protected static class StarPointStyle
    implements PointStyle {
        protected StarPointStyle() {
        }

        @Override
        public Shape createShape(double x, double y) {
            double pointSize = 6.0;
            int[] xPoints = new int[]{(int)Math.ceil(x - pointSize / 6.0), (int)Math.ceil(x + pointSize / 6.0), (int)Math.ceil(x + pointSize / 6.0), (int)Math.ceil(x + pointSize / 2.0), (int)Math.ceil(x + pointSize / 2.0), (int)Math.ceil(x + pointSize / 6.0), (int)Math.ceil(x + pointSize / 6.0), (int)Math.ceil(x - pointSize / 6.0), (int)Math.ceil(x - pointSize / 6.0), (int)Math.ceil(x - pointSize / 2.0), (int)Math.ceil(x - pointSize / 2.0), (int)Math.ceil(x - pointSize / 6.0)};
            int[] yPoints = new int[]{(int)Math.ceil(y - pointSize / 2.0), (int)Math.ceil(y - pointSize / 2.0), (int)Math.ceil(y - pointSize / 6.0), (int)Math.ceil(y - pointSize / 6.0), (int)Math.ceil(y + pointSize / 6.0), (int)Math.ceil(y + pointSize / 6.0), (int)Math.ceil(y + pointSize / 2.0), (int)Math.ceil(y + pointSize / 2.0), (int)Math.ceil(y + pointSize / 6.0), (int)Math.ceil(y + pointSize / 6.0), (int)Math.ceil(y - pointSize / 6.0), (int)Math.ceil(y - pointSize / 6.0)};
            return new Polygon(xPoints, yPoints, xPoints.length);
        }
    }

    protected static class TurnedTriangularPointStyle
    implements PointStyle {
        protected TurnedTriangularPointStyle() {
        }

        @Override
        public Shape createShape(double x, double y) {
            int[] xPoints = new int[]{(int)Math.ceil(x - 3.5), (int)Math.ceil(x), (int)Math.ceil(x + 3.5)};
            int[] yPoints = new int[]{(int)Math.ceil(y - 3.5), (int)Math.ceil(y + 3.5), (int)Math.ceil(y - 3.5)};
            return new Polygon(xPoints, yPoints, xPoints.length);
        }
    }

    protected static class TriangularPointStyle
    implements PointStyle {
        protected TriangularPointStyle() {
        }

        @Override
        public Shape createShape(double x, double y) {
            int[] xPoints = new int[]{(int)Math.ceil(x - 3.5), (int)Math.ceil(x), (int)Math.ceil(x + 3.5)};
            int[] yPoints = new int[]{(int)Math.ceil(y + 3.5), (int)Math.ceil(y - 3.5), (int)Math.ceil(y + 3.5)};
            return new Polygon(xPoints, yPoints, xPoints.length);
        }
    }

    protected static class RectanglePointStyle
    implements PointStyle {
        protected RectanglePointStyle() {
        }

        @Override
        public Shape createShape(double x, double y) {
            return new Rectangle2D.Double(x - 3.5, y - 3.5, 6.0, 6.0);
        }
    }

    protected static class EllipsoidPointStyle
    implements PointStyle {
        protected EllipsoidPointStyle() {
        }

        @Override
        public Shape createShape(double x, double y) {
            return new Ellipse2D.Double(x - 3.5, y - 3.5, 7.0, 7.0);
        }
    }

    protected static interface PointStyle {
        public Shape createShape(double var1, double var3);
    }

    protected static class LineStyle {
        private Color color;
        private Stroke stroke;

        private LineStyle(Color color, Stroke stroke) {
            this.color = color;
            this.stroke = stroke;
        }

        public void set(Graphics2D g) {
            g.setColor(this.color);
            g.setStroke(this.stroke);
        }

        public Color getColor() {
            return this.color;
        }

        public Stroke getStroke() {
            return this.stroke;
        }
    }

    protected static class LineColorIcon
    implements Icon {
        private Color color;

        public LineColorIcon(Color color) {
            this.color = color;
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public int getIconHeight() {
            return 2;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.drawLine(x, y, x + 20, y);
        }
    }

    protected static class LineStyleIcon
    implements Icon {
        private int index;

        private LineStyleIcon(int index) {
            this.index = index;
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public int getIconHeight() {
            return 2;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            LINE_STYLES[this.index].set((Graphics2D)g);
            g.drawLine(x, y, x + 20, y);
        }
    }
}

