/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.ToolTip;
import com.rapidminer.gui.plotter.WeightIndex;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParallelPlotter
extends PlotterAdapter
implements MouseListener {
    private static final long serialVersionUID = -175572158812122874L;
    private static final String[] COLUMN_MAPPING_TYPES = new String[]{"ordered", "weights", "random"};
    private static final int ORDERED = 0;
    private static final int WEIGHTS = 1;
    private static final int RANDOM = 2;
    private transient DataTable dataTable;
    private double[] min = new double[0];
    private double[] max = new double[0];
    private double maxWeight;
    private double globalMin = Double.NEGATIVE_INFINITY;
    private double globalMax = Double.POSITIVE_INFINITY;
    private int colorColumn = -1;
    private transient ToolTip toolTip = null;
    private JCheckBox localNormalizationBox;
    private JComboBox columnMappingSelection;
    private boolean localNormalization = false;
    private int columnMappingType = 0;
    private long orderRandomSeed = 2001L;
    private Random randomSeedRandom = new Random();

    public ParallelPlotter(PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.localNormalizationBox = new JCheckBox("local normalization", this.localNormalization);
        this.localNormalizationBox.setToolTipText("Indicates if a local normalization for each dimension should be performed or not.");
        this.localNormalizationBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ParallelPlotter.this.setLocalNormalization(ParallelPlotter.this.localNormalizationBox.isSelected());
            }
        });
        this.columnMappingSelection = new JComboBox<String>(COLUMN_MAPPING_TYPES);
        this.columnMappingSelection.setToolTipText("Indicates the type of column mapping (reordering).");
        this.columnMappingSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParallelPlotter.this.setColumnMapping(ParallelPlotter.this.columnMappingSelection.getSelectedIndex());
            }
        });
    }

    public ParallelPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.repaint();
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.localNormalizationBox;
        }
        if (index == 1) {
            JLabel label = new JLabel("Column mapping:");
            label.setToolTipText("Indicates the type of column mapping (reordering).");
            return label;
        }
        if (index == 2) {
            return this.columnMappingSelection;
        }
        return null;
    }

    private void setColumnMapping(int mapping) {
        this.columnMappingType = mapping;
        if (mapping == 2) {
            this.orderRandomSeed = this.randomSeedRandom.nextLong();
        }
        this.repaint();
    }

    public void setLocalNormalization(boolean localNormalization) {
        this.localNormalization = localNormalization;
        this.repaint();
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.colorColumn = plot ? index : -1;
        this.repaint();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.colorColumn == index;
    }

    @Override
    public String getPlotName() {
        return "Color";
    }

    public void setToolTip(ToolTip toolTip) {
        this.toolTip = toolTip;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareData() {
        int columns = this.dataTable.getNumberOfColumns();
        this.min = new double[columns];
        this.max = new double[columns];
        for (int c = 0; c < columns; ++c) {
            this.min[c] = Double.POSITIVE_INFINITY;
            this.max[c] = Double.NEGATIVE_INFINITY;
        }
        this.globalMin = Double.POSITIVE_INFINITY;
        this.globalMax = Double.NEGATIVE_INFINITY;
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            for (DataTableRow row : this.dataTable) {
                for (int c = 0; c < this.dataTable.getNumberOfColumns(); ++c) {
                    double value = row.getValue(c);
                    this.min[c] = MathFunctions.robustMin(this.min[c], value);
                    this.max[c] = MathFunctions.robustMax(this.max[c], value);
                    if (c == this.colorColumn) continue;
                    this.globalMin = MathFunctions.robustMin(this.globalMin, this.min[c]);
                    this.globalMax = MathFunctions.robustMax(this.globalMax, this.max[c]);
                }
            }
        }
        this.maxWeight = this.getMaxWeight(this.dataTable);
    }

    private int[] getColumnMapping() {
        int numberOfColumns = this.dataTable.getNumberOfColumns();
        if (this.colorColumn >= 0) {
            --numberOfColumns;
        }
        int[] mapping = new int[numberOfColumns];
        int counter = 0;
        for (int i = 0; i < this.dataTable.getNumberOfColumns(); ++i) {
            if (i == this.colorColumn) continue;
            mapping[counter++] = i;
        }
        switch (this.columnMappingType) {
            case 1: {
                if (this.dataTable.isSupportingColumnWeights()) {
                    LinkedList<WeightIndex> indices = new LinkedList<WeightIndex>();
                    for (int i = 0; i < this.dataTable.getNumberOfColumns(); ++i) {
                        if (this.colorColumn == i) continue;
                        indices.add(new WeightIndex(i, Math.abs(this.dataTable.getColumnWeight(i))));
                    }
                    Collections.sort(indices);
                    Iterator w = indices.iterator();
                    counter = 0;
                    while (w.hasNext()) {
                        mapping[counter++] = ((WeightIndex)w.next()).getIndex();
                    }
                    break;
                }
                LogService.getGlobal().log("Cannot use weight based ordering since no column weights are given.", 5);
                break;
            }
            case 2: {
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i = 0; i < mapping.length; ++i) {
                    mapping[i] = i;
                    if (this.colorColumn == i) continue;
                    indices.add(i);
                }
                Random random = new Random(this.orderRandomSeed);
                for (int i = 0; i < mapping.length; ++i) {
                    if (this.colorColumn == i) continue;
                    int other = (Integer)indices.get(random.nextInt(indices.size()));
                    int dummy = mapping[i];
                    mapping[i] = mapping[other];
                    mapping[other] = dummy;
                }
                break;
            }
        }
        return mapping;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintParallelPlot(g);
    }

    public void paintParallelPlot(Graphics g) {
        int pixWidth = this.getWidth() - 40;
        int pixHeight = this.getHeight() - 40;
        Graphics2D translated = (Graphics2D)g.create();
        translated.translate(20, 20);
        this.prepareData();
        if (!(this.colorColumn < 0 || this.colorColumn >= this.min.length || Double.isInfinite(this.min[this.colorColumn]) || Double.isInfinite(this.max[this.colorColumn]) || !this.dataTable.isNominal(this.colorColumn) && this.min[this.colorColumn] == this.max[this.colorColumn] || this.dataTable.getNumberOfRows() <= 0)) {
            this.drawLegend(g, this.dataTable, this.colorColumn);
        }
        g.setColor(Color.black);
        this.draw(translated, pixWidth, pixHeight);
        translated.dispose();
        this.drawToolTip((Graphics2D)g, this.toolTip);
    }

    private void draw(Graphics g, int pixWidth, int pixHeight) {
        if (this.dataTable.isSupportingColumnWeights()) {
            this.drawWeights(g, pixWidth, pixHeight);
        }
        this.drawGrid(g, pixWidth, pixHeight);
        this.drawLines(g, pixWidth, pixHeight);
    }

    private void drawWeights(Graphics graphics, int pixWidth, int pixHeight) {
        double currentX = 0.0;
        Graphics2D g = (Graphics2D)graphics;
        int[] columnMapping = this.getColumnMapping();
        double columnDistance = (double)pixWidth / (double)(columnMapping.length - 1);
        for (int i = 0; i < columnMapping.length; ++i) {
            g.setColor(ParallelPlotter.getWeightColor(this.dataTable.getColumnWeight(columnMapping[i]), this.maxWeight));
            Rectangle2D.Double weightRect = null;
            weightRect = i == 0 ? new Rectangle2D.Double(currentX, 0.0, columnDistance / 2.0, pixHeight) : (i == columnMapping.length - 1 ? new Rectangle2D.Double(currentX - columnDistance / 2.0, 0.0, columnDistance / 2.0, pixHeight) : new Rectangle2D.Double(currentX - columnDistance / 2.0, 0.0, columnDistance, pixHeight));
            g.fill(weightRect);
            currentX += columnDistance;
        }
    }

    private void drawGrid(Graphics graphics, int pixWidth, int pixHeight) {
        double currentX = 0.0;
        Graphics2D g = (Graphics2D)graphics;
        int[] columnMapping = this.getColumnMapping();
        double columnDistance = (double)pixWidth / (double)(columnMapping.length - 1);
        for (int i = 0; i < columnMapping.length; ++i) {
            g.setColor(GRID_COLOR);
            if (i == 0 || i == columnMapping.length - 1 || columnMapping.length < 100) {
                g.drawLine((int)currentX, 0, (int)currentX, pixHeight);
            }
            if (columnMapping.length <= 10) {
                g.setColor(Color.BLACK);
                g.setFont(LABEL_FONT);
                Rectangle2D stringBounds = LABEL_FONT.getStringBounds(this.dataTable.getColumnName(columnMapping[i]), g.getFontRenderContext());
                double xPos = currentX;
                if (i == columnMapping.length - 1) {
                    xPos -= stringBounds.getWidth();
                }
                g.drawString(this.dataTable.getColumnName(columnMapping[i]), (int)xPos, (int)((double)(pixHeight + 2) + stringBounds.getHeight()));
            }
            currentX += columnDistance;
        }
        g.setColor(GRID_COLOR);
        g.drawLine(0, 0, (int)((double)(columnMapping.length - 1) * columnDistance), 0);
        g.drawLine(0, pixHeight, (int)((double)(columnMapping.length - 1) * columnDistance), pixHeight);
    }

    private void drawLines(Graphics g, int pixWidth, int pixHeight) {
        int[] columnMapping = this.getColumnMapping();
        double columnDistance = (double)pixWidth / (double)(columnMapping.length - 1);
        for (DataTableRow row : this.dataTable) {
            GeneralPath path = new GeneralPath();
            boolean first = true;
            float currentX = 0.0f;
            for (int k = 0; k < columnMapping.length; ++k) {
                int d = columnMapping[k];
                float yPos = 0.0f;
                yPos = this.localNormalization ? (float)((double)pixHeight - (row.getValue(d) - this.min[d]) / (this.max[d] - this.min[d]) * (double)pixHeight) : (float)((double)pixHeight - (row.getValue(d) - this.globalMin) / (this.globalMax - this.globalMin) * (double)pixHeight);
                if (first) {
                    path.moveTo(currentX, yPos);
                } else {
                    path.lineTo(currentX, yPos);
                }
                currentX = (float)((double)currentX + columnDistance);
                first = false;
            }
            Color color = Color.RED;
            if (this.colorColumn != -1) {
                double colorValue = this.getColorProvider().getPointColorValue(this.dataTable, row, this.colorColumn, this.min[this.colorColumn], this.max[this.colorColumn]);
                color = this.getColorProvider().getPointColor(colorValue);
            }
            g.setColor(color);
            ((Graphics2D)g).draw(path);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int xPos = e.getX();
        int yPos = e.getY();
        if (xPos > 20 && xPos < this.getWidth() - 20) {
            int[] mapping = this.getColumnMapping();
            float columnDistance = (float)(this.getWidth() - 40) / (float)mapping.length;
            int column = (int)((float)(xPos - 20) / columnDistance);
            this.setToolTip(new ToolTip(this.dataTable.getColumnName(mapping[column]), xPos, yPos));
        } else {
            this.setToolTip(null);
        }
    }

    @Override
    public String getPlotterName() {
        return "Parallel";
    }
}

